/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.forge;

import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftClient;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftMeta;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;

public final class ForgeInstance {
    private final String MINECRAFT_VERSION;
    private final String FORGE_VERSION;
    private final URL INSTALLER_URL;
    private final MinecraftMeta MINECRAFT_META;

    public ForgeInstance(String minecraftVersion, String forgeVersion, MinecraftMeta minecraftMeta) throws MalformedURLException {
        this.MINECRAFT_VERSION = minecraftVersion;
        this.FORGE_VERSION = forgeVersion;
        this.INSTALLER_URL = new URL(String.format("https://files.minecraftforge.net/maven/net/minecraftforge/forge/%s-%s/forge-%s-%s-installer.jar", minecraftVersion, forgeVersion, minecraftVersion, forgeVersion));
        this.MINECRAFT_META = minecraftMeta;
    }

    public String minecraftVersion() {
        return this.MINECRAFT_VERSION;
    }

    public String forgeVersion() {
        return this.FORGE_VERSION;
    }

    public URL installerUrl() {
        return this.INSTALLER_URL;
    }

    public Optional<MinecraftClient> minecraftClient() {
        return this.MINECRAFT_META.getClient(this.MINECRAFT_VERSION);
    }
}

