/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.fabric;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import de.griefed.serverpackcreator.versionmeta.Manifests;
import de.griefed.serverpackcreator.versionmeta.Meta;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricDetails;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricInstaller;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricIntermediaries;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricLoader;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricLoaderDetails;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class FabricMeta
extends Manifests
implements Meta {
    private final File FABRIC_MANIFEST;
    private final File FABRIC_INSTALLER_MANIFEST;
    private final FabricLoader FABRIC_LOADER;
    private final FabricLoaderDetails FABRIC_LOADER_DETAILS;
    private final FabricInstaller FABRIC_INSTALLER;
    private final FabricIntermediaries FABRIC_INTERMEDIARIES;
    private final HashMap<String, FabricDetails> LOADER_DETAILS = new HashMap();

    public FabricMeta(File fabricManifest, File fabricInstallerManifest, FabricIntermediaries injectedFabricIntermediaries, ObjectMapper objectMapper) throws IOException, ParserConfigurationException, SAXException {
        this.FABRIC_LOADER_DETAILS = new FabricLoaderDetails(objectMapper);
        this.FABRIC_MANIFEST = fabricManifest;
        this.FABRIC_INSTALLER_MANIFEST = fabricInstallerManifest;
        this.FABRIC_LOADER = new FabricLoader(this.getXml(this.FABRIC_MANIFEST));
        this.FABRIC_INTERMEDIARIES = injectedFabricIntermediaries;
        this.FABRIC_INSTALLER = new FabricInstaller(this.getXml(this.FABRIC_INSTALLER_MANIFEST));
    }

    @Override
    public void update() throws ParserConfigurationException, IOException, SAXException {
        this.FABRIC_LOADER.update(this.getXml(this.FABRIC_MANIFEST));
        this.FABRIC_INSTALLER.update(this.getXml(this.FABRIC_INSTALLER_MANIFEST));
    }

    @Override
    public String latestLoader() {
        return this.FABRIC_LOADER.latestLoaderVersion();
    }

    @Override
    public String releaseLoader() {
        return this.FABRIC_LOADER.releaseLoaderVersion();
    }

    @Override
    public List<String> loaderVersionsListAscending() {
        return this.FABRIC_LOADER.loaders();
    }

    @Override
    public List<String> loaderVersionsListDescending() {
        return Lists.reverse(this.FABRIC_LOADER.loaders());
    }

    @Override
    public String[] loaderVersionsArrayAscending() {
        return this.FABRIC_LOADER.loaders().toArray(new String[0]);
    }

    @Override
    public String[] loaderVersionsArrayDescending() {
        return Lists.reverse(this.FABRIC_LOADER.loaders()).toArray(new String[0]);
    }

    @Override
    public String latestInstaller() {
        return this.FABRIC_INSTALLER.latestInstallerVersion();
    }

    @Override
    public String releaseInstaller() {
        return this.FABRIC_INSTALLER.releaseInstallerVersion();
    }

    @Override
    public List<String> installerVersionsListAscending() {
        return this.FABRIC_INSTALLER.installers();
    }

    @Override
    public List<String> installerVersionsListDescending() {
        return Lists.reverse(this.FABRIC_INSTALLER.installers());
    }

    @Override
    public String[] installerVersionsArrayAscending() {
        return this.FABRIC_INSTALLER.installers().toArray(new String[0]);
    }

    @Override
    public String[] installerVersionsArrayDescending() {
        return Lists.reverse(this.FABRIC_INSTALLER.installers()).toArray(new String[0]);
    }

    @Override
    public URL latestInstallerUrl() {
        return this.FABRIC_INSTALLER.latestInstallerUrl();
    }

    @Override
    public URL releaseInstallerUrl() {
        return this.FABRIC_INSTALLER.releaseInstallerUrl();
    }

    @Override
    public boolean isInstallerUrlAvailable(String fabricVersion) {
        return Optional.ofNullable(this.FABRIC_INSTALLER.meta().get(fabricVersion)).isPresent();
    }

    @Override
    public Optional<URL> getInstallerUrl(String fabricVersion) {
        return Optional.ofNullable(this.FABRIC_INSTALLER.meta().get(fabricVersion));
    }

    public Optional<URL> improvedLauncherUrl(String minecraftVersion, String fabricVersion) {
        return this.FABRIC_INSTALLER.improvedLauncherUrl(minecraftVersion, fabricVersion);
    }

    @Override
    public boolean isVersionValid(String fabricVersion) {
        return this.FABRIC_LOADER.loaders().contains(fabricVersion);
    }

    public Optional<FabricDetails> getLoaderDetails(String minecraftVersion, String fabricVersion) {
        String key = minecraftVersion + "-" + fabricVersion;
        if (this.LOADER_DETAILS.containsKey(key)) {
            return Optional.of(this.LOADER_DETAILS.get(key));
        }
        if (this.FABRIC_LOADER_DETAILS.getDetails(minecraftVersion, fabricVersion).isPresent()) {
            this.LOADER_DETAILS.put(key, this.FABRIC_LOADER_DETAILS.getDetails(minecraftVersion, fabricVersion).get());
            return Optional.of(this.LOADER_DETAILS.get(key));
        }
        return Optional.empty();
    }

    @Override
    public boolean isMinecraftSupported(String minecraftVersion) {
        return this.FABRIC_INTERMEDIARIES.getIntermediary(minecraftVersion).isPresent();
    }
}

