/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.versionmeta.InvalidTypeException;
import de.griefed.serverpackcreator.versionmeta.Manifests;
import de.griefed.serverpackcreator.versionmeta.Type;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricIntermediaries;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricMeta;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeMeta;
import de.griefed.serverpackcreator.versionmeta.legacyfabric.LegacyFabricMeta;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftMeta;
import de.griefed.serverpackcreator.versionmeta.quilt.QuiltMeta;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Service
public final class VersionMeta
extends Manifests {
    private static final Logger LOG = LogManager.getLogger(VersionMeta.class);
    private final ObjectMapper OBJECT_MAPPER;
    private final File MINECRAFT_MANIFEST;
    private final File FORGE_MANIFEST;
    private final File FABRIC_MANIFEST;
    private final File FABRIC_INTERMEDIARIES_MANIFEST;
    private final File FABRIC_INSTALLER_MANIFEST;
    private final File QUILT_MANIFEST;
    private final File QUILT_INSTALLER_MANIFEST;
    private final File LEGACY_FABRIC_GAME_MANIFEST;
    private final File LEGACY_FABRIC_LOADER_MANIFEST;
    private final File LEGACY_FABRIC_INSTALLER_MANIFEST;
    private final String FABRIC_LEGACY_BASE_URL = "https://meta.legacyfabric.net/";
    private final URL LEGACY_FABRIC_GAME_MANIFEST_URL = new URL("https://meta.legacyfabric.net/v2/versions/game");
    private final URL LEGACY_FABRIC_LOADER_MANIFEST_URL = new URL("https://meta.legacyfabric.net/v2/versions/loader");
    private final URL LEGACY_FABRIC_INSTALLER_MANIFEST_URL = new URL("https://maven.legacyfabric.net/net/legacyfabric/fabric-installer/maven-metadata.xml");
    private final URL MINECRAFT_MANIFEST_URL = new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json");
    private final URL FORGE_MANIFEST_URL = new URL("https://files.minecraftforge.net/net/minecraftforge/forge/maven-metadata.json");
    private final URL FABRIC_MANIFEST_URL = new URL("https://maven.fabricmc.net/net/fabricmc/fabric-loader/maven-metadata.xml");
    private final URL FABRIC_INTERMEDIARIES_MANIFEST_URL = new URL("https://meta.fabricmc.net/v2/versions/intermediary");
    private final URL FABRIC_INSTALLER_MANIFEST_URL = new URL("https://maven.fabricmc.net/net/fabricmc/fabric-installer/maven-metadata.xml");
    private final URL QUILT_MANIFEST_URL = new URL("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-loader/maven-metadata.xml");
    private final URL QUILT_INSTALLER_MANIFEST_URL = new URL("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/maven-metadata.xml");
    private final MinecraftMeta MINECRAFT_META;
    private final FabricMeta FABRIC_META;
    private final ForgeMeta FORGE_META;
    private final QuiltMeta QUIL_META;
    private final FabricIntermediaries FABRIC_INTERMEDIARIES;
    private final LegacyFabricMeta LEGACY_FABRIC_META;

    @Autowired
    public VersionMeta(File minecraftManifest, File forgeManifest, File fabricManifest, File fabricInstallerManifest, File fabricIntermediariesManifest, File quiltManifest, File quiltInstallerManifest, File legacyFabricGameManifest, File legacyFabricLoaderManifest, File legacyFabricInstallerManifest, ObjectMapper injectedObjectMapper) throws IOException, ParserConfigurationException, SAXException {
        this.MINECRAFT_MANIFEST = minecraftManifest;
        this.FORGE_MANIFEST = forgeManifest;
        this.FABRIC_MANIFEST = fabricManifest;
        this.LEGACY_FABRIC_GAME_MANIFEST = legacyFabricGameManifest;
        this.LEGACY_FABRIC_LOADER_MANIFEST = legacyFabricLoaderManifest;
        this.LEGACY_FABRIC_INSTALLER_MANIFEST = legacyFabricInstallerManifest;
        this.FABRIC_INTERMEDIARIES_MANIFEST = fabricIntermediariesManifest;
        this.FABRIC_INSTALLER_MANIFEST = fabricInstallerManifest;
        this.QUILT_MANIFEST = quiltManifest;
        this.QUILT_INSTALLER_MANIFEST = quiltInstallerManifest;
        this.OBJECT_MAPPER = injectedObjectMapper;
        this.checkManifests();
        this.FORGE_META = new ForgeMeta(this.FORGE_MANIFEST, this.OBJECT_MAPPER);
        this.MINECRAFT_META = new MinecraftMeta(this.MINECRAFT_MANIFEST, this.FORGE_META, this.OBJECT_MAPPER);
        this.FABRIC_INTERMEDIARIES = new FabricIntermediaries(this.FABRIC_INTERMEDIARIES_MANIFEST, this.OBJECT_MAPPER);
        this.LEGACY_FABRIC_META = new LegacyFabricMeta(this.LEGACY_FABRIC_GAME_MANIFEST, this.LEGACY_FABRIC_LOADER_MANIFEST, this.LEGACY_FABRIC_INSTALLER_MANIFEST, this.OBJECT_MAPPER);
        this.FABRIC_META = new FabricMeta(this.FABRIC_MANIFEST, this.FABRIC_INSTALLER_MANIFEST, this.FABRIC_INTERMEDIARIES, this.OBJECT_MAPPER);
        this.FORGE_META.initialize(this.MINECRAFT_META);
        this.QUIL_META = new QuiltMeta(this.QUILT_MANIFEST, this.QUILT_INSTALLER_MANIFEST, this.FABRIC_INTERMEDIARIES);
        this.MINECRAFT_META.update();
        this.FABRIC_INTERMEDIARIES.update();
        this.FABRIC_META.update();
        this.LEGACY_FABRIC_META.update();
        this.FORGE_META.update();
        this.QUIL_META.update();
    }

    private void checkManifests() {
        this.checkManifest(this.MINECRAFT_MANIFEST, this.MINECRAFT_MANIFEST_URL, Type.MINECRAFT);
        this.checkManifest(this.FORGE_MANIFEST, this.FORGE_MANIFEST_URL, Type.FORGE);
        this.checkManifest(this.FABRIC_INTERMEDIARIES_MANIFEST, this.FABRIC_INTERMEDIARIES_MANIFEST_URL, Type.FABRIC_INTERMEDIARIES);
        this.checkManifest(this.LEGACY_FABRIC_GAME_MANIFEST, this.LEGACY_FABRIC_GAME_MANIFEST_URL, Type.LEGACY_FABRIC);
        this.checkManifest(this.LEGACY_FABRIC_LOADER_MANIFEST, this.LEGACY_FABRIC_LOADER_MANIFEST_URL, Type.LEGACY_FABRIC);
        this.checkManifest(this.LEGACY_FABRIC_INSTALLER_MANIFEST, this.LEGACY_FABRIC_INSTALLER_MANIFEST_URL, Type.LEGACY_FABRIC);
        this.checkManifest(this.FABRIC_MANIFEST, this.FABRIC_MANIFEST_URL, Type.FABRIC);
        this.checkManifest(this.FABRIC_INSTALLER_MANIFEST, this.FABRIC_INSTALLER_MANIFEST_URL, Type.FABRIC_INSTALLER);
        this.checkManifest(this.QUILT_MANIFEST, this.QUILT_MANIFEST_URL, Type.QUILT);
        this.checkManifest(this.QUILT_INSTALLER_MANIFEST, this.QUILT_INSTALLER_MANIFEST_URL, Type.QUILT_INSTALLER);
    }

    private void checkManifest(File manifestToCheck, URL urlToManifest, Type manifestType) {
        if (manifestToCheck.exists()) {
            try (InputStream existing = Files.newInputStream(manifestToCheck.toPath(), new OpenOption[0]);
                 InputStream newManifest = urlToManifest.openStream();){
                int countOldFile = 0;
                int countNewFile = 0;
                switch (manifestType) {
                    case MINECRAFT: {
                        countOldFile = this.getJson(existing, this.OBJECT_MAPPER).get("versions").size();
                        countNewFile = this.getJson(newManifest, this.OBJECT_MAPPER).get("versions").size();
                        break;
                    }
                    case FORGE: {
                        for (JsonNode mcVer : this.getJson(existing, this.OBJECT_MAPPER)) {
                            countOldFile += mcVer.size();
                        }
                        for (JsonNode mcVer : this.getJson(newManifest, this.OBJECT_MAPPER)) {
                            countNewFile += mcVer.size();
                        }
                        break;
                    }
                    case FABRIC_INTERMEDIARIES: {
                        countOldFile = this.getJson(existing, this.OBJECT_MAPPER).size();
                        countNewFile = this.getJson(newManifest, this.OBJECT_MAPPER).size();
                        break;
                    }
                    case FABRIC: 
                    case FABRIC_INSTALLER: 
                    case QUILT: 
                    case QUILT_INSTALLER: {
                        countOldFile = this.getXml(existing).getElementsByTagName("version").getLength();
                        countNewFile = this.getXml(newManifest).getElementsByTagName("version").getLength();
                        break;
                    }
                    case LEGACY_FABRIC: {
                        if (manifestToCheck.getName().endsWith(".json")) {
                            countOldFile = this.getJson(existing, this.OBJECT_MAPPER).size();
                            countNewFile = this.getJson(newManifest, this.OBJECT_MAPPER).size();
                            break;
                        }
                        Document oldXML = this.getXml(existing);
                        Document newXML = this.getXml(newManifest);
                        countOldFile = oldXML.getElementsByTagName("version").getLength();
                        if (countOldFile != (countNewFile = newXML.getElementsByTagName("version").getLength()) || oldXML.getElementsByTagName("version").item(0).getChildNodes().item(0).getNodeValue().equals(newXML.getElementsByTagName("version").item(0).getChildNodes().item(0).getNodeValue())) break;
                        ++countNewFile;
                        break;
                    }
                    default: {
                        throw new InvalidTypeException("Manifest type must be either Type.MINECRAFT, Type.FORGE, Type.FABRIC or Type.FABRIC_INSTALLER. Specified: " + (Object)((Object)manifestType));
                    }
                }
                LOG.debug("Nodes/Versions/Size in/of old " + manifestToCheck + ": " + countOldFile);
                LOG.debug("Nodes/Versions/Size in/of new " + manifestToCheck + ": " + countNewFile);
                if (countNewFile > countOldFile) {
                    LOG.info("Refreshing " + manifestToCheck + ".");
                    this.updateManifest(manifestToCheck, urlToManifest);
                } else {
                    LOG.info("Manifest " + manifestToCheck + " does not need to be refreshed.");
                }
            }
            catch (InvalidTypeException | IOException | ParserConfigurationException | SAXException ex) {
                LOG.error("Couldn't refresh manifest " + manifestToCheck, (Throwable)ex);
            }
        } else {
            this.updateManifest(manifestToCheck, urlToManifest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateManifest(File manifestToRefresh, URL urlToManifest) {
        FileUtils.deleteQuietly(manifestToRefresh);
        try {
            FileUtils.createParentDirectories(manifestToRefresh);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ReadableByteChannel readableByteChannel = null;
        OutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        try {
            readableByteChannel = Channels.newChannel(urlToManifest.openStream());
            fileOutputStream = new FileOutputStream(manifestToRefresh);
            fileChannel = ((FileOutputStream)fileOutputStream).getChannel();
            ((FileOutputStream)fileOutputStream).getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException ex) {
            LOG.error("An error occurred downloading " + manifestToRefresh + ".", (Throwable)ex);
            FileUtils.deleteQuietly(manifestToRefresh);
        }
        finally {
            try {
                fileOutputStream.flush();
            }
            catch (Exception exception) {}
            try {
                ((FileOutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {}
            try {
                readableByteChannel.close();
            }
            catch (Exception exception) {}
            try {
                fileChannel.close();
            }
            catch (Exception exception) {}
        }
    }

    public VersionMeta update() throws IOException, ParserConfigurationException, SAXException {
        this.checkManifests();
        this.MINECRAFT_META.update();
        this.FABRIC_META.update();
        this.FORGE_META.update();
        this.LEGACY_FABRIC_META.update();
        return this;
    }

    public MinecraftMeta minecraft() {
        return this.MINECRAFT_META;
    }

    public FabricMeta fabric() {
        return this.FABRIC_META;
    }

    public ForgeMeta forge() {
        return this.FORGE_META;
    }

    public QuiltMeta quilt() {
        return this.QUIL_META;
    }

    public LegacyFabricMeta legacyFabric() {
        return this.LEGACY_FABRIC_META;
    }
}

