/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities.common;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.stereotype.Component;

@Component
public final class JarUtilities {
    private static final Logger LOG = LogManager.getLogger(JarUtilities.class);

    public void copyFileFromJar(String fileToCopy, boolean replaceIfExists, Class<?> classToCopyFrom) {
        if (replaceIfExists) {
            FileUtils.deleteQuietly(new File(fileToCopy));
        }
        this.copyFileFromJar(fileToCopy, classToCopyFrom);
    }

    public boolean copyFileFromJar(String fileToCopy, Class<?> identifierClass) {
        if (!new File(fileToCopy).exists()) {
            try {
                FileUtils.copyInputStreamToFile(Objects.requireNonNull(identifierClass.getResourceAsStream("/" + fileToCopy)), new File(fileToCopy));
                return true;
            }
            catch (IOException ex) {
                LOG.error("Error creating file: " + fileToCopy, (Throwable)ex);
                return false;
            }
        }
        LOG.info("File " + fileToCopy + " already exists.");
        return false;
    }

    public void copyFileFromJar(String fileToCopy, File destinationFile, boolean replaceIfExists, Class<?> identifierClass) {
        if (replaceIfExists) {
            FileUtils.deleteQuietly(destinationFile);
        }
        this.copyFileFromJar(fileToCopy, destinationFile, identifierClass);
    }

    public boolean copyFileFromJar(String fileToCopy, File destinationFile, Class<?> identifierClass) {
        if (!destinationFile.exists()) {
            try {
                FileUtils.copyInputStreamToFile(Objects.requireNonNull(identifierClass.getResourceAsStream("/" + fileToCopy)), destinationFile);
                return true;
            }
            catch (IOException ex) {
                LOG.error("Error creating file: " + destinationFile, (Throwable)ex);
                return false;
            }
        }
        LOG.info("File " + destinationFile + " already exists.");
        return false;
    }

    public ApplicationHome getApplicationHomeForClass(Class<?> classToRetrieveHomeFor) {
        return new ApplicationHome(classToRetrieveHomeFor);
    }

    public HashMap<String, String> systemInformation(ApplicationHome applicationHome) {
        HashMap<String, String> sysInfo = new HashMap<String, String>();
        try {
            sysInfo.put("jarPath", applicationHome.getSource().toString().replace("\\", "/"));
        }
        catch (Exception ex) {
            sysInfo.put("jarPath", applicationHome.getDir().toString().replace("\\", "/"));
        }
        try {
            sysInfo.put("jarName", applicationHome.getSource().toString().replace("\\", "/").substring(applicationHome.getSource().toString().replace("\\", "/").lastIndexOf("/") + 1));
        }
        catch (Exception ex) {
            sysInfo.put("jarName", applicationHome.getDir().toString().replace("\\", "/").substring(applicationHome.getDir().toString().replace("\\", "/").lastIndexOf("/") + 1));
        }
        sysInfo.put("javaVersion", System.getProperty("java.version"));
        sysInfo.put("osArch", System.getProperty("os.arch"));
        sysInfo.put("osName", System.getProperty("os.name"));
        sysInfo.put("osVersion", System.getProperty("os.version"));
        return sysInfo;
    }

    private JarFile retrieveJarFromClass(Class<?> classToRetrieveJarFor) throws IOException {
        return new JarFile(new File(new ApplicationHome(classToRetrieveJarFor).getSource().toString().replace("\\", "/")));
    }

    public void copyFolderFromJar(Class<?> classToRetrieveHomeFor, String directoryToCopy, String destinationDirectory, String jarDirectoryPrefix, String fileEnding) throws IOException {
        HashMap<String, String> systemInformation = this.systemInformation(this.getApplicationHomeForClass(classToRetrieveHomeFor));
        if (!new File(systemInformation.get("jarName")).isFile()) {
            this.copyFolderFromJar(classToRetrieveHomeFor, directoryToCopy, destinationDirectory, fileEnding);
        } else {
            this.copyFolderFromJar(this.retrieveJarFromClass(classToRetrieveHomeFor), directoryToCopy, destinationDirectory, jarDirectoryPrefix, fileEnding);
        }
    }

    private void copyFolderFromJar(JarFile jarToCopyFrom, String directoryToCopy, String destinationDirectory, String jarDirectoryPrefix, String fileEnding) throws IOException {
        Enumeration<JarEntry> entries = jarToCopyFrom.entries();
        while (entries.hasMoreElements()) {
            File destination;
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.replace(jarDirectoryPrefix, "").startsWith(directoryToCopy + "/") || entry.isDirectory() || !entryName.endsWith(fileEnding) || (destination = new File(destinationDirectory + "/" + entryName.substring(entryName.replace("\\", "/").lastIndexOf("/") + 1))).exists()) continue;
            File parent = destination.getParentFile();
            if (parent != null && parent.mkdirs()) {
                LOG.debug("Created directory " + parent + ".");
            }
            FileOutputStream fileOutputStream = null;
            InputStream inputStream = null;
            try {
                fileOutputStream = new FileOutputStream(destination);
            }
            catch (FileNotFoundException ex) {
                LOG.error("File " + destination + " not found.", (Throwable)ex);
            }
            try {
                inputStream = jarToCopyFrom.getInputStream(entry);
            }
            catch (IOException ex) {
                LOG.error("Couldn't acquire input stream for entry " + entryName + ".", (Throwable)ex);
            }
            try {
                byte[] bytes = new byte[8192];
                if (inputStream != null) {
                    int length;
                    while ((length = inputStream.read(bytes)) > 0) {
                        if (fileOutputStream != null) {
                            fileOutputStream.write(bytes, 0, length);
                            continue;
                        }
                        LOG.error("FileOutputStream is null for " + destination + ".");
                    }
                    continue;
                }
                LOG.error("InputStream is null for " + destination + ".");
            }
            catch (IOException ex) {
                throw new IOException("Couldn't copy asset " + entryName + " from JAR-file.", ex);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {}
                LOG.debug("Copied from JAR:" + entryName + ".");
            }
        }
    }

    private void copyFolderFromJar(Class<?> classToCopyFrom, String source, String destination, String fileEnding) {
        ArrayList<String> filesFromJar;
        block6: {
            FileFilter fileFilter = pathname -> pathname.toString().endsWith(fileEnding);
            filesFromJar = new ArrayList<String>(1000);
            try {
                File[] files = new File(Objects.requireNonNull(classToCopyFrom.getResource(source)).toURI()).listFiles(fileFilter);
                assert (files != null);
                for (File value : files) {
                    String file2 = value.toString().replace("\\", "/");
                    filesFromJar.add(file2.substring(file2.lastIndexOf("/") + 1));
                }
            }
            catch (URISyntaxException ex) {
                LOG.error("Error retrieving file list from JAR.", (Throwable)ex);
            }
            try {
                Files.createDirectory(Paths.get(destination, new String[0]), new FileAttribute[0]);
            }
            catch (IOException ex) {
                if (ex.toString().startsWith("java.nio.file.FileAlreadyExistsException")) break block6;
                LOG.error("Error creating language directory.", (Throwable)ex);
            }
        }
        filesFromJar.forEach(file -> {
            if (!new File(destination + "/" + file).exists()) {
                try (InputStream inputStream = classToCopyFrom.getResourceAsStream(source + "/" + file);){
                    assert (inputStream != null);
                    FileUtils.copyInputStreamToFile(inputStream, new File(destination + "/" + file));
                    LOG.debug("Copying from JAR: " + file);
                }
                catch (IOException ex) {
                    LOG.error("Error extracting files.", (Throwable)ex);
                }
            }
        });
    }
}

