/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.task;

import de.griefed.serverpackcreator.spring.task.Task;
import de.griefed.serverpackcreator.spring.zip.GenerateZip;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Service;

@Service
public class TaskSubmitter {
    private static final Logger LOG = LogManager.getLogger(TaskSubmitter.class);
    private final JmsTemplate jmsTemplate;

    @Autowired
    public TaskSubmitter(JmsTemplate injectedJmsTemplate) {
        this.jmsTemplate = injectedJmsTemplate;
    }

    public void generateZip(String zipGenerationProperties) {
        LOG.debug("Sending ZIP generate task: " + zipGenerationProperties);
        this.submitGeneration(new GenerateZip(zipGenerationProperties));
    }

    private void submitScan(Task task) {
        LOG.info("Submitting scan " + task);
        LOG.debug("UniqueID is: " + task.uniqueId());
        this.jmsTemplate.convertAndSend("tasks.background", (Object)task, message -> {
            message.setStringProperty("type", "scan");
            message.setStringProperty("unique_id", task.uniqueId());
            return message;
        });
    }

    private void submitGeneration(Task task) {
        LOG.info("Submitting generation " + task);
        LOG.debug("UniqueID is: " + task.uniqueId());
        this.jmsTemplate.convertAndSend("tasks.background", (Object)task, message -> {
            message.setStringProperty("type", "generation");
            message.setStringProperty("unique_id", task.uniqueId());
            return message;
        });
    }
}

