/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.task;

import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ServerPackHandler;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackService;
import de.griefed.serverpackcreator.spring.task.Task;
import de.griefed.serverpackcreator.spring.zip.GenerateZip;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
public class TaskHandler {
    private static final Logger LOG = LogManager.getLogger(TaskHandler.class);
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final ServerPackHandler SERVERPACKHANDLER;
    private final ServerPackService SERVERPACKSERVICE;
    private final StopWatch STOPWATCH_SCANS;

    @Autowired
    public TaskHandler(ConfigurationHandler injectedConfigurationHandler, ServerPackHandler injectedServerPackHandler, ServerPackService injectedServerPackService) {
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler;
        this.SERVERPACKHANDLER = injectedServerPackHandler;
        this.SERVERPACKSERVICE = injectedServerPackService;
        this.STOPWATCH_SCANS = new StopWatch();
    }

    @JmsListener(destination="tasks.background", selector="type = 'scan'")
    public void handleScan(Task task) {
        LOG.info("Executing task: " + task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JmsListener(destination="tasks.background", selector="type = 'generation'")
    public void handleGeneration(Task task) {
        LOG.info("Executing task: " + task);
        if (task instanceof GenerateZip) {
            LOG.info("Instance of GenerateZip: " + task.uniqueId());
            String[] parameters = ((GenerateZip)task).getZipGenerationProperties().split("&");
            ServerPackModel serverPackModel = new ServerPackModel();
            serverPackModel.setStatus("Generating");
            serverPackModel.setDownloads(0);
            serverPackModel.setConfirmedWorking(0);
            serverPackModel.setFileDiskName(parameters[0]);
            serverPackModel.setModpackDir("./work/modpacks/" + parameters[0]);
            serverPackModel.setMinecraftVersion(parameters[2]);
            serverPackModel.setModLoader(parameters[3]);
            serverPackModel.setModLoaderVersion(parameters[4]);
            serverPackModel.setClientMods(Arrays.asList(parameters[1].split(",")));
            serverPackModel.setJavaPath("");
            serverPackModel.setIncludeServerInstallation(false);
            this.STOPWATCH_SCANS.reset();
            this.STOPWATCH_SCANS.start();
            ArrayList<String> encounteredErrors = new ArrayList<String>(100);
            try {
                if (!this.CONFIGURATIONHANDLER.checkConfiguration(serverPackModel, encounteredErrors, false)) {
                    serverPackModel.setFileName(serverPackModel.getModpackDir().substring(serverPackModel.getModpackDir().lastIndexOf("/") + 1));
                    this.SERVERPACKSERVICE.insert(serverPackModel);
                    ServerPackModel pack = this.SERVERPACKHANDLER.run(serverPackModel);
                    this.SERVERPACKSERVICE.updateServerPackByID(serverPackModel.getId(), pack);
                    return;
                }
                LOG.error("Configuration check for ZIP-archive " + parameters[0] + " failed.");
                if (encounteredErrors.isEmpty()) return;
                LOG.error("Encountered errors: ");
                for (String error : encounteredErrors) {
                    LOG.error(error);
                }
                return;
            }
            catch (Exception ex) {
                LOG.error("An error occurred generating the server pack for ZIP-archive: " + parameters[0], (Throwable)ex);
                this.SERVERPACKSERVICE.deleteServerPack(serverPackModel.getId());
                if (encounteredErrors.isEmpty()) return;
                LOG.error("Encountered errors: ");
                for (String error : encounteredErrors) {
                    LOG.error(error);
                }
                return;
            }
            finally {
                FileUtils.deleteQuietly(new File("./work/modpacks/" + parameters[0]));
                this.STOPWATCH_SCANS.stop();
                LOG.info("Generation took " + this.STOPWATCH_SCANS);
                this.STOPWATCH_SCANS.reset();
            }
        } else {
            LOG.info("This is not the queue you are looking for: " + task.uniqueId());
        }
    }
}

