/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.serverpack;

import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v1/packs"})
public class ServerPackController {
    private final ServerPackService SERVERPACKSERVICE;

    @Autowired
    public ServerPackController(ServerPackService injectedServerPackService) {
        this.SERVERPACKSERVICE = injectedServerPackService;
    }

    @GetMapping(value={"/download/{id}"}, produces={"application/zip"})
    public ResponseEntity<Resource> downloadServerPack(@PathVariable int id) {
        return this.SERVERPACKSERVICE.downloadServerPackById(id);
    }

    @GetMapping(value={"all"})
    public ResponseEntity<List<ServerPackModel>> getAllServerPacks() {
        if (this.SERVERPACKSERVICE.getServerPacks().isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body(this.SERVERPACKSERVICE.getServerPacks());
    }

    @GetMapping(value={"vote/{voting}"})
    public ResponseEntity<Object> voteForServerPack(@PathVariable(value="voting") String voting) {
        return this.SERVERPACKSERVICE.voteForServerPack(voting);
    }
}

