/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.modscanning;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class JsonBasedScanner {
    private static final Logger LOG = LogManager.getLogger(JsonBasedScanner.class);

    JsonBasedScanner() {
    }

    JsonNode getJarJson(File file, String entryInJar, ObjectMapper objectMapper) throws NullPointerException, IOException, SecurityException, IllegalStateException {
        JarFile jarFile = new JarFile(file);
        JarEntry jarEntry = jarFile.getJarEntry(entryInJar);
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        JsonNode jsonNode = objectMapper.readTree(inputStream);
        jarFile.close();
        inputStream.close();
        return jsonNode;
    }

    void cleanupClientMods(TreeSet<String> modDependencies, TreeSet<String> clientMods) {
        for (String dependency : modDependencies) {
            clientMods.removeIf(mod -> {
                if (mod.equals(dependency)) {
                    LOG.debug("Removing " + dependency + " from list of clientmods as it is a dependency for another mod.");
                    return true;
                }
                return false;
            });
        }
    }

    abstract void checkForClientModsAndDeps(Collection<File> var1, TreeSet<String> var2, TreeSet<String> var3);

    abstract TreeSet<File> getModsDelta(Collection<File> var1, TreeSet<String> var2);
}

