/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import de.griefed.serverpackcreator.ApplicationPlugins;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.modscanning.ModScanner;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ExcludeFileFilter;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ServerPackHandler {
    private static final Logger LOG = LogManager.getLogger(ServerPackHandler.class);
    private static final Logger LOG_ADDONS = LogManager.getLogger("AddonsLogger");
    private static final Logger LOG_INSTALLER = LogManager.getLogger("InstallerLogger");
    private final VersionMeta VERSIONMETA;
    private final ModScanner MODSCANNER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final Utilities UTILITIES;
    private final ApplicationPlugins APPLICATIONPLUGINS;
    private final StopWatch STOPWATCH_SCANS = new StopWatch();
    private final String[] MOD_FILE_ENDINGS = new String[]{"jar", "disabled"};

    @Autowired
    public ServerPackHandler(ApplicationProperties injectedApplicationProperties, VersionMeta injectedVersionMeta, Utilities injectedUtilities, ApplicationPlugins injectedApplicationPlugins, ModScanner injectedModScanner) throws IOException {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.VERSIONMETA = injectedVersionMeta;
        this.UTILITIES = injectedUtilities;
        this.APPLICATIONPLUGINS = injectedApplicationPlugins;
        this.MODSCANNER = injectedModScanner;
    }

    public synchronized ServerPackModel run(@NotNull ServerPackModel serverPackModel) {
        String destination = this.getServerPackDestination(serverPackModel);
        this.run((ConfigurationModel)serverPackModel);
        this.cleanupEnvironment(false, destination);
        serverPackModel.setStatus("Available");
        serverPackModel.setSize(Double.parseDouble(String.valueOf(FileUtils.sizeOfAsBigInteger(new File(destination + "_server_pack.zip")).divide(BigInteger.valueOf(0x100000L)))));
        serverPackModel.setPath(destination + "_server_pack.zip");
        return serverPackModel;
    }

    public String getServerPackDestination(ConfigurationModel configurationModel) {
        String serverPackToBe = configurationModel.getModpackDir().substring(configurationModel.getModpackDir().lastIndexOf("/") + 1) + configurationModel.getServerPackSuffix();
        serverPackToBe = serverPackToBe.replace(" ", "_");
        return new File(String.format("%s/%s", this.APPLICATIONPROPERTIES.getDirectoryServerPacks(), serverPackToBe)).getAbsolutePath().replace("\\", "/");
    }

    public synchronized boolean run(@NotNull ConfigurationModel configurationModel) {
        String destination = this.getServerPackDestination(configurationModel);
        if (!this.APPLICATIONPROPERTIES.isServerPacksOverwriteEnabled() && new File(destination).exists()) {
            LOG.info("Server pack already exists and overwrite disabled.");
        } else {
            this.cleanupEnvironment(true, destination);
            try {
                Files.createDirectories(Paths.get(destination, new String[0]), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.APPLICATIONPLUGINS.pluginsPreGenExtension().isEmpty()) {
                LOG_ADDONS.info("Executing PreGenExtension addons.");
                this.APPLICATIONPLUGINS.pluginsPreGenExtension().forEach(plugin -> {
                    LOG_ADDONS.info("Executing addon " + plugin.getName());
                    try {
                        plugin.run(this.APPLICATIONPROPERTIES, configurationModel, destination);
                    }
                    catch (Error | Exception ex) {
                        LOG_ADDONS.error("Addon " + plugin.getName() + " encountered an error.", ex);
                    }
                });
            } else {
                LOG.info("No PreGenExtension addons to execute.");
            }
            this.copyFiles(configurationModel);
            this.createStartScripts(configurationModel);
            if (configurationModel.getModLoader().equalsIgnoreCase("Fabric")) {
                this.provideImprovedFabricServerLauncher(configurationModel);
            }
            if (configurationModel.getIncludeServerIcon()) {
                this.copyIcon(configurationModel);
            } else {
                LOG.info("Not including servericon.");
            }
            if (configurationModel.getIncludeServerProperties()) {
                this.copyProperties(configurationModel);
            } else {
                LOG.info("Not including server.properties.");
            }
            if (!this.APPLICATIONPLUGINS.pluginsPreZipExtension().isEmpty()) {
                LOG_ADDONS.info("Executing PreZipExtension addons.");
                this.APPLICATIONPLUGINS.pluginsPreZipExtension().forEach(plugin -> {
                    LOG_ADDONS.info("Executing addon " + plugin.getName());
                    try {
                        plugin.run(this.APPLICATIONPROPERTIES, configurationModel, destination);
                    }
                    catch (Error | Exception ex) {
                        LOG_ADDONS.error("Addon " + plugin.getName() + " encountered an error.", ex);
                    }
                });
            } else {
                LOG.info("No PreZipExtension addons to execute.");
            }
            if (configurationModel.getIncludeZipCreation()) {
                this.zipBuilder(configurationModel);
            } else {
                LOG.info("Not creating zip archive of serverpack.");
            }
            if (configurationModel.getIncludeServerInstallation()) {
                this.installServer(configurationModel);
            } else {
                LOG.info("Not installing modded server.");
            }
            LOG.info("Server pack available at: " + destination);
            LOG.info("Server pack archive available at: " + destination + "_server_pack.zip");
            LOG.info("Done!");
            if (!this.APPLICATIONPLUGINS.pluginsPostGenExtension().isEmpty()) {
                LOG_ADDONS.info("Executing PostGenExtension addons.");
                this.APPLICATIONPLUGINS.pluginsPostGenExtension().forEach(plugin -> {
                    LOG_ADDONS.info("Executing addon " + plugin.getName());
                    try {
                        plugin.run(this.APPLICATIONPROPERTIES, configurationModel, destination);
                    }
                    catch (Error | Exception ex) {
                        LOG_ADDONS.error("Addon " + plugin.getName() + " encountered an error.", ex);
                    }
                });
            } else {
                LOG.info("No PostGenExtension addons to execute.");
            }
        }
        return true;
    }

    public void provideImprovedFabricServerLauncher(ConfigurationModel configurationModel) {
        this.provideImprovedFabricServerLauncher(configurationModel.getMinecraftVersion(), configurationModel.getModLoaderVersion(), this.getServerPackDestination(configurationModel));
    }

    public void provideImprovedFabricServerLauncher(String minecraftVersion, String fabricVersion, String destination) {
        String fileDestination = String.format("%s/fabric-server-launcher.jar", destination);
        if (this.VERSIONMETA.fabric().improvedLauncherUrl(minecraftVersion, fabricVersion).isPresent() && this.UTILITIES.WebUtils().downloadFile(fileDestination, this.VERSIONMETA.fabric().improvedLauncherUrl(minecraftVersion, fabricVersion).get())) {
            LOG.info("Successfully provided improved Fabric Server Launcher.");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(Paths.get(String.format("%s/SERVER_PACK_INFO.txt", destination), new String[0]))));){
                writer.write("If you are using this server pack on a managed server, meaning you can not execute scripts, please use the fabric-server-launcher.jar instead of the fabric-server-launch.jar. Note the extra \"er\" at the end of \"launcher\".\n");
                writer.write("This is the improved Fabric Server Launcher, which will take care of downloading and installing the Minecraft server and any and all libraries needed for running the Fabric server.\n");
                writer.write("\n");
                writer.write("The downside of this method is the occasional incompatibility of mods with the Fabric version, as the new Fabric Server Launcher always uses the latest available Fabric version.\n");
                writer.write("If a mod is incompatible with said latest Fabric version, contact the mod-author and ask them to remedy the situation.\n");
                writer.write("The official Fabric Discord had the following to add to this:\n");
                writer.write("    Fabric loader however is cross version, so unless there is a mod incompatibility (which usually involves the mod being broken / using non-api internals)\n");
                writer.write("    there is no good reason to use anything but the latest. I.e. the latest loader on any Minecraft version works with the new server launcher.");
            }
            catch (Exception ex) {
                LOG.error("Error downloading the improved Fabric server launcher. Maybe it doesn't exist for the specified Minecraft and Fabric version?", (Throwable)ex);
            }
        }
    }

    private void cleanupEnvironment(boolean deleteZip, ConfigurationModel configurationModel) {
        this.cleanupEnvironment(deleteZip, this.getServerPackDestination(configurationModel));
    }

    private void cleanupEnvironment(boolean deleteZip, String destination) {
        LOG.info("Found old server_pack. Cleaning up...");
        FileUtils.deleteQuietly(new File(destination));
        if (deleteZip) {
            LOG.info("Found old server_pack.zip. Cleaning up...");
            FileUtils.deleteQuietly(new File(String.format("%s_server_pack.zip", destination)));
        }
    }

    public void createStartScripts(ConfigurationModel configurationModel) {
        this.createStartScripts(configurationModel.getScriptSettings(), this.getServerPackDestination(configurationModel));
    }

    public void createStartScripts(HashMap<String, String> scriptSettings, String destination) {
        for (File template : this.APPLICATIONPROPERTIES.scriptTemplates()) {
            try {
                String fileEnding = template.toString().substring(template.toString().lastIndexOf(".") + 1);
                File destinationScript = new File(destination + "/start." + fileEnding);
                String scriptContent = FileUtils.readFileToString(template, StandardCharsets.UTF_8);
                for (Map.Entry<String, String> entry : scriptSettings.entrySet()) {
                    scriptContent = scriptContent.replace(entry.getKey(), entry.getValue());
                }
                FileUtils.writeStringToFile(destinationScript, scriptContent, StandardCharsets.ISO_8859_1);
            }
            catch (Exception ex) {
                LOG.error("File not accessible: " + template + ".", (Throwable)ex);
            }
        }
    }

    private void copyFiles(ConfigurationModel configurationModel) {
        this.copyFiles(configurationModel.getModpackDir(), configurationModel.getCopyDirs(), configurationModel.getClientMods(), configurationModel.getMinecraftVersion(), this.getServerPackDestination(configurationModel), configurationModel.getModLoader());
    }

    private void copyFiles(String modpackDir, List<String> directoriesToCopy, List<String> clientMods, String minecraftVersion, String destination, String modloader) {
        try {
            Files.createDirectories(Paths.get(destination, new String[0]), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.error(String.format("Failed to create directory %s", destination));
        }
        if (directoriesToCopy.size() == 1 && directoriesToCopy.get(0).equals("lazy_mode")) {
            LOG.warn("!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!");
            LOG.warn("Lazy mode specified. This will copy the WHOLE modpack to the server pack. No exceptions.");
            LOG.warn("You will not receive any support for a server pack generated this way.");
            LOG.warn("Do not open an issue on GitHub if this configuration errors or results in a broken server pack.");
            LOG.warn("!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!");
            try {
                FileUtils.copyDirectory(new File(modpackDir), new File(destination));
            }
            catch (IOException ex) {
                LOG.error("An error occurred copying the modpack to the server pack in lazy mode.", (Throwable)ex);
            }
        } else {
            TreeSet<String> exclusions = new TreeSet<String>(this.APPLICATIONPROPERTIES.getDirectoriesToExclude());
            directoriesToCopy.removeIf(exclude -> {
                if (exclude.startsWith("!")) {
                    exclusions.add(exclude.substring(1).replace("\\", "/"));
                    return true;
                }
                return false;
            });
            ArrayList<ServerPackFile> serverPackFiles = new ArrayList<ServerPackFile>(100000);
            for (String directory : directoriesToCopy) {
                String clientDir = String.format("%s/%s", modpackDir, directory).replace("\\", "/");
                String serverDir = String.format("%s/%s", destination, directory).replace("\\", "/");
                LOG.info("Gathering " + directory + " file(s) and folder(s).");
                if (directory.contains(";")) {
                    serverPackFiles.addAll(this.getExplicitFiles(directory.split(";"), modpackDir, destination));
                    continue;
                }
                if (directory.startsWith("saves/")) {
                    serverPackFiles.addAll(this.getSaveFiles(clientDir, directory, destination));
                    continue;
                }
                if (directory.startsWith("mods")) {
                    try {
                        Files.createDirectories(Paths.get(serverDir, new String[0]), new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    for (File mod : this.getModsToInclude(clientDir, clientMods, minecraftVersion, modloader)) {
                        serverPackFiles.add(new ServerPackFile(mod.getAbsolutePath(), String.format("%s/%s", serverDir, mod.getName())));
                    }
                    continue;
                }
                if (new File(directory).isFile()) {
                    serverPackFiles.add(new ServerPackFile(directory, String.format("%s/%s", destination, new File(directory).getName())));
                    continue;
                }
                if (new File(directory).isDirectory()) {
                    serverPackFiles.addAll(this.getDirectoryFiles(directory, destination));
                    continue;
                }
                serverPackFiles.addAll(this.getDirectoryFiles(clientDir, destination));
            }
            LOG.info("Ensuring files and/or directories are properly excluded.");
            serverPackFiles.removeIf(serverPackFile -> {
                if (this.excludeFileOrDirectory(((ServerPackFile)serverPackFile).SOURCE_PATH.toString().replace("\\", "/"), exclusions)) {
                    LOG.debug("Excluding file/directory: " + ((ServerPackFile)serverPackFile).SOURCE_PATH);
                    return true;
                }
                return false;
            });
            LOG.info("Copying files to the server pack. This may take a while...");
            serverPackFiles.forEach(serverPackFile -> {
                try {
                    serverPackFile.copy();
                }
                catch (IOException ex) {
                    LOG.error("An error occurred trying to copy " + serverPackFile.source() + " to " + serverPackFile.destination() + ".", (Throwable)ex);
                }
            });
        }
    }

    private List<ServerPackFile> getExplicitFiles(String[] combination, ConfigurationModel configurationModel) {
        return this.getExplicitFiles(combination, configurationModel.getModpackDir(), this.getServerPackDestination(configurationModel));
    }

    private List<ServerPackFile> getExplicitFiles(String[] combination, String modpackDir, String destination) {
        ArrayList<ServerPackFile> serverPackFiles = new ArrayList<ServerPackFile>();
        if (new File(String.format("%s/%s", modpackDir, combination[0])).isFile()) {
            serverPackFiles.add(new ServerPackFile(String.format("%s/%s", modpackDir, combination[0]), String.format("%s/%s", destination, combination[1])));
        } else if (new File(String.format("%s/%s", modpackDir, combination[0])).isDirectory()) {
            serverPackFiles.addAll(this.getDirectoryFiles(String.format("%s/%s", modpackDir, combination[0]), destination));
        } else if (new File(combination[0]).isFile()) {
            serverPackFiles.add(new ServerPackFile(combination[0], String.format("%s/%s", destination, combination[1])));
        } else if (new File(combination[0]).isDirectory()) {
            serverPackFiles.addAll(this.getDirectoryFiles(combination[0], destination));
        }
        return serverPackFiles;
    }

    private List<ServerPackFile> getDirectoryFiles(String source, String destination) {
        ArrayList<ServerPackFile> serverPackFiles = new ArrayList<ServerPackFile>();
        try (Stream<Path> files = Files.walk(Paths.get(source, new String[0]), new FileVisitOption[0]);){
            files.forEach(file -> {
                try {
                    serverPackFiles.add(new ServerPackFile((Path)file, Paths.get(String.format("%s/%s", destination, new File(source).getName()), new String[0]).resolve(Paths.get(source, new String[0]).relativize((Path)file))));
                }
                catch (UnsupportedOperationException ex) {
                    LOG.error("Couldn't gather file " + file + " from directory " + source + ".", (Throwable)ex);
                }
            });
        }
        catch (IOException ex) {
            LOG.error("An error occurred gathering files to copy to the server pack.", (Throwable)ex);
        }
        return serverPackFiles;
    }

    private List<ServerPackFile> getSaveFiles(String clientDir, String directory, String destination) {
        ArrayList<ServerPackFile> serverPackFiles = new ArrayList<ServerPackFile>();
        try (Stream<Path> files = Files.walk(Paths.get(clientDir, new String[0]), new FileVisitOption[0]);){
            files.forEach(file -> {
                try {
                    serverPackFiles.add(new ServerPackFile((Path)file, Paths.get(String.format("%s/%s", destination, directory.substring(6)), new String[0]).resolve(Paths.get(clientDir, new String[0]).relativize((Path)file))));
                }
                catch (UnsupportedOperationException ex) {
                    LOG.error("Couldn't gather file " + file + " from directory " + clientDir + ".", (Throwable)ex);
                }
            });
        }
        catch (IOException ex) {
            LOG.error("An error occurred during the copy-procedure to the server pack.", (Throwable)ex);
        }
        return serverPackFiles;
    }

    public List<File> getModsToInclude(ConfigurationModel configurationModel) {
        return this.getModsToInclude(configurationModel.getModpackDir() + "/mods", configurationModel.getClientMods(), configurationModel.getMinecraftVersion(), configurationModel.getModLoader());
    }

    public List<File> getModsToInclude(String modsDir, List<String> userSpecifiedClientMods, String minecraftVersion, String modloader) {
        LOG.info("Preparing a list of mods to include in server pack...");
        ArrayList<File> filesInModsDir = new ArrayList<File>(FileUtils.listFiles(new File(modsDir), this.MOD_FILE_ENDINGS, true));
        TreeSet<File> modsInModpack = new TreeSet<File>(filesInModsDir);
        ArrayList<File> autodiscoveredClientMods = new ArrayList<File>();
        if (this.APPLICATIONPROPERTIES.isAutoExcludingModsEnabled()) {
            this.STOPWATCH_SCANS.start();
            switch (modloader) {
                case "LegacyFabric": 
                case "Fabric": {
                    autodiscoveredClientMods.addAll(this.MODSCANNER.fabric().scan((Collection<File>)filesInModsDir));
                    break;
                }
                case "Forge": {
                    if (Integer.parseInt(minecraftVersion.split("\\.")[1]) > 12) {
                        autodiscoveredClientMods.addAll(this.MODSCANNER.tomls().scan((Collection<File>)filesInModsDir));
                        break;
                    }
                    autodiscoveredClientMods.addAll(this.MODSCANNER.annotations().scan((Collection<File>)filesInModsDir));
                    break;
                }
                case "Quilt": {
                    TreeSet<File> discoMods = new TreeSet<File>();
                    discoMods.addAll(this.MODSCANNER.fabric().scan((Collection<File>)filesInModsDir));
                    discoMods.addAll(this.MODSCANNER.quilt().scan((Collection<File>)filesInModsDir));
                    autodiscoveredClientMods.addAll(discoMods);
                    discoMods.clear();
                }
            }
            this.excludeMods(autodiscoveredClientMods, modsInModpack);
            this.STOPWATCH_SCANS.stop();
            LOG.debug("Scanning and excluding of " + filesInModsDir.size() + " mods took " + this.STOPWATCH_SCANS);
            this.STOPWATCH_SCANS.reset();
        } else {
            LOG.info("Automatic clientside-only mod detection disabled.");
        }
        this.excludeUserSpecifiedMod(userSpecifiedClientMods, modsInModpack);
        return new ArrayList<File>(modsInModpack);
    }

    private void excludeMods(List<File> autodiscoveredClientMods, TreeSet<File> modsInModpack) {
        if (autodiscoveredClientMods.size() > 0) {
            LOG.info("Automatically detected mods: " + autodiscoveredClientMods.size());
            for (File discoveredMod : autodiscoveredClientMods) {
                modsInModpack.removeIf(mod -> {
                    if (mod.getName().contains(discoveredMod.getName())) {
                        LOG.warn("Automatically excluding mod: " + discoveredMod.getName());
                        return true;
                    }
                    return false;
                });
            }
        } else {
            LOG.info("No clientside-only mods detected.");
        }
    }

    private void excludeUserSpecifiedMod(List<String> userSpecifiedExclusions, TreeSet<File> modsInModpack) {
        if (userSpecifiedExclusions.size() > 0) {
            LOG.info("Performing " + (Object)((Object)this.APPLICATIONPROPERTIES.exclusionFilter()) + "-type checks for user-specified clientside-only mod exclusion.");
            for (String userSpecifiedExclusion : userSpecifiedExclusions) {
                this.exclude(userSpecifiedExclusion, modsInModpack);
            }
        } else {
            LOG.warn("User specified no clientside-only mods.");
        }
    }

    private void exclude(String userSpecifiedExclusion, TreeSet<File> modsInModpack) {
        modsInModpack.removeIf(mod -> {
            boolean excluded;
            String check = mod.getName();
            switch (this.APPLICATIONPROPERTIES.exclusionFilter()) {
                case END: {
                    excluded = check.endsWith(userSpecifiedExclusion);
                    break;
                }
                case CONTAIN: {
                    excluded = check.contains(userSpecifiedExclusion);
                    break;
                }
                case REGEX: {
                    excluded = check.matches(userSpecifiedExclusion);
                    break;
                }
                case EITHER: {
                    excluded = check.startsWith(userSpecifiedExclusion) || check.endsWith(userSpecifiedExclusion) || check.contains(userSpecifiedExclusion) || check.matches(userSpecifiedExclusion);
                    break;
                }
                default: {
                    excluded = check.startsWith(userSpecifiedExclusion);
                }
            }
            if (excluded) {
                LOG.debug("Removed " + mod.getName() + " as per user-specified check: " + userSpecifiedExclusion);
            }
            return excluded;
        });
    }

    private boolean excludeFileOrDirectory(String fileToCheckFor, TreeSet<String> exclusions) {
        boolean isPresentInList = false;
        for (String entry : exclusions) {
            if (!fileToCheckFor.replace("\\", "/").contains(entry)) continue;
            isPresentInList = true;
            break;
        }
        return isPresentInList;
    }

    private void copyIcon(ConfigurationModel configurationModel) {
        this.copyIcon(this.getServerPackDestination(configurationModel), configurationModel.getServerIconPath());
    }

    private void copyIcon(String destination, String pathToServerIcon) {
        block13: {
            LOG.info("Copying server-icon.png...");
            File iconFile = new File(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON()));
            if (new File(pathToServerIcon).exists()) {
                Image scaledImage = null;
                try {
                    BufferedImage originalImage = ImageIO.read(new File(pathToServerIcon));
                    if (originalImage.getHeight() == 64 && originalImage.getWidth() == 64) {
                        try {
                            FileUtils.copyFile(new File(pathToServerIcon), iconFile);
                        }
                        catch (IOException e) {
                            LOG.error("An error occurred trying to copy the server-icon.", (Throwable)e);
                        }
                        break block13;
                    }
                    scaledImage = originalImage.getScaledInstance(64, 64, 4);
                    BufferedImage outputImage = new BufferedImage(scaledImage.getWidth(null), scaledImage.getHeight(null), 2);
                    outputImage.getGraphics().drawImage(scaledImage, 0, 0, null);
                    try {
                        ImageIO.write((RenderedImage)outputImage, "png", iconFile);
                    }
                    catch (IOException ex) {
                        LOG.error("Error scaling image.", (Throwable)ex);
                    }
                }
                catch (Exception ex) {
                    LOG.error("Error reading server-icon image.", (Throwable)ex);
                }
            } else if (pathToServerIcon.length() == 0) {
                LOG.info("No custom icon specified or the file doesn't exist.");
                try {
                    FileUtils.copyFile(new File(String.format("server_files/%s", this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON())), iconFile);
                }
                catch (IOException ex) {
                    LOG.error("An error occurred trying to copy the server-icon.", (Throwable)ex);
                }
            } else {
                LOG.error("The specified server-icon does not exist: " + pathToServerIcon);
            }
        }
    }

    private void copyProperties(ConfigurationModel configurationModel) {
        this.copyProperties(this.getServerPackDestination(configurationModel), configurationModel.getServerPropertiesPath());
    }

    private void copyProperties(String destination, String pathToServerProperties) {
        LOG.info("Copying server.properties...");
        File defaultProperties = new File(String.format("%s/%s", destination, this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES()));
        if (new File(pathToServerProperties).exists()) {
            try {
                FileUtils.copyFile(new File(pathToServerProperties), defaultProperties);
            }
            catch (IOException ex) {
                LOG.error("An error occurred trying to copy the server.properties-file.", (Throwable)ex);
            }
        } else if (pathToServerProperties.length() == 0) {
            LOG.info("No custom properties specified or the file doesn't exist.");
            try {
                FileUtils.copyFile(new File(String.format("server_files/%s", this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES())), defaultProperties);
            }
            catch (IOException ex) {
                LOG.error("An error occurred trying to copy the server.properties-file.", (Throwable)ex);
            }
        } else {
            LOG.error("The specified server.properties does not exist: " + pathToServerProperties);
        }
    }

    public void installServer(ConfigurationModel configurationModel) {
        this.installServer(configurationModel.getModLoader(), configurationModel.getMinecraftVersion(), configurationModel.getModLoaderVersion(), configurationModel.getJavaPath(), this.getServerPackDestination(configurationModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installServer(String modLoader, String minecraftVersion, String modLoaderVersion, String javaPath, String destination) {
        ArrayList<String> commandArguments = new ArrayList<String>();
        Process process = null;
        BufferedReader bufferedReader = null;
        switch (modLoader) {
            case "Fabric": {
                LOG_INSTALLER.info("Starting Fabric installation.");
                if (this.UTILITIES.WebUtils().downloadFile(String.format("%s/fabric-installer.jar", destination), this.VERSIONMETA.fabric().releaseInstallerUrl())) {
                    LOG.info("Fabric installer successfully downloaded.");
                    commandArguments.add(javaPath);
                    commandArguments.add("-jar");
                    commandArguments.add("fabric-installer.jar");
                    commandArguments.add("server");
                    commandArguments.add("-mcversion");
                    commandArguments.add(minecraftVersion);
                    commandArguments.add("-loader");
                    commandArguments.add(modLoaderVersion);
                    commandArguments.add("-downloadMinecraft");
                    break;
                }
                LOG.error("Something went wrong during the installation of Fabric. Maybe the Fabric servers are down or unreachable? Skipping...");
                break;
            }
            case "Forge": {
                LOG_INSTALLER.info("Starting Forge installation.");
                if (this.VERSIONMETA.forge().getForgeInstance(minecraftVersion, modLoaderVersion).isPresent() && this.UTILITIES.WebUtils().downloadFile(String.format("%s/forge-installer.jar", destination), this.VERSIONMETA.forge().getForgeInstance(minecraftVersion, modLoaderVersion).get().installerUrl())) {
                    LOG.info("Forge installer successfully downloaded.");
                    commandArguments.add(javaPath);
                    commandArguments.add("-jar");
                    commandArguments.add("forge-installer.jar");
                    commandArguments.add("--installServer");
                    break;
                }
                LOG.error("Something went wrong during the installation of Forge. Maybe the Forge servers are down or unreachable? Skipping...");
                break;
            }
            case "Quilt": {
                LOG_INSTALLER.info("Starting Quilt installation.");
                if (this.UTILITIES.WebUtils().downloadFile(String.format("%s/quilt-installer.jar", destination), this.VERSIONMETA.quilt().releaseInstallerUrl())) {
                    LOG.info("Quilt installer successfully downloaded.");
                    commandArguments.add(javaPath);
                    commandArguments.add("-jar");
                    commandArguments.add("quilt-installer.jar");
                    commandArguments.add("install");
                    commandArguments.add("server");
                    commandArguments.add(minecraftVersion);
                    commandArguments.add("--download-server");
                    commandArguments.add("--install-dir=.");
                    break;
                }
                LOG.error("Something went wrong during the installation of Quilt. Maybe the Quilt servers are down or unreachable? Skipping...");
                break;
            }
            case "LegacyFabric": {
                LOG_INSTALLER.info("Starting Legacy Fabric installation.");
                try {
                    if (this.UTILITIES.WebUtils().downloadFile(String.format("%s/legacyfabric-installer.jar", destination), this.VERSIONMETA.legacyFabric().releaseInstallerUrl())) {
                        LOG.info("LegacyFabric installer successfully downloaded.");
                        commandArguments.add(javaPath);
                        commandArguments.add("-jar");
                        commandArguments.add("legacyfabric-installer.jar");
                        commandArguments.add("server");
                        commandArguments.add("-mcversion");
                        commandArguments.add(minecraftVersion);
                        commandArguments.add("-loader");
                        commandArguments.add(modLoaderVersion);
                        commandArguments.add("-downloadMinecraft");
                        break;
                    }
                    LOG.error("Something went wrong during the installation of LegacyFabric. Maybe the LegacyFabric servers are down or unreachable? Skipping...");
                }
                catch (MalformedURLException ex) {
                    LOG.error("Couldn't acquire LegacyFabric installer URL.", (Throwable)ex);
                }
                break;
            }
            default: {
                LOG.error("Invalid modloader specified. Modloader must be either Forge, Fabric or Quilt. Specified: " + modLoader);
            }
        }
        try {
            String line;
            LOG.info("Starting server installation for Minecraft " + minecraftVersion + ", " + modLoader + " " + modLoaderVersion + ".");
            ProcessBuilder processBuilder = new ProcessBuilder(commandArguments).directory(new File(destination));
            LOG.debug("ProcessBuilder command: " + processBuilder.command());
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                LOG_INSTALLER.info(line);
            }
            LOG_INSTALLER.info("Server for Minecraft " + minecraftVersion + ", " + modLoader + " " + modLoaderVersion + " installed.");
            LOG.info("Server for Minecraft " + minecraftVersion + ", " + modLoader + " " + modLoaderVersion + " installed.");
            LOG.info("For details regarding the installation of this modloader server, see logs/modloader_installer.log.");
        }
        catch (IOException ex) {
            LOG.error("Something went wrong during the installation of Forge. Maybe the Forge servers are down or unreachable? Skipping...", (Throwable)ex);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
            try {
                process.destroy();
            }
            catch (Exception exception) {}
            commandArguments.clear();
        }
        if (this.APPLICATIONPROPERTIES.isServerPackCleanupEnabled()) {
            this.cleanUpServerPack(minecraftVersion, modLoaderVersion, destination);
        } else {
            LOG.info("Server pack cleanup disabled.");
        }
    }

    public void zipBuilder(ConfigurationModel configurationModel) {
        this.zipBuilder(configurationModel.getMinecraftVersion(), configurationModel.getIncludeServerInstallation(), this.getServerPackDestination(configurationModel), configurationModel.getModLoader(), configurationModel.getModLoaderVersion());
    }

    public void zipBuilder(String minecraftVersion, boolean includeServerInstallation, String destination, String modloader, String modloaderVersion) {
        LOG.info("Creating zip archive of serverpack...");
        ZipParameters zipParameters = new ZipParameters();
        ArrayList filesToExclude = new ArrayList(100);
        if (this.APPLICATIONPROPERTIES.isZipFileExclusionEnabled()) {
            this.APPLICATIONPROPERTIES.getFilesToExcludeFromZipArchive().forEach(entry -> filesToExclude.add(new File(destination + "/" + entry.replace("MINECRAFT_VERSION", minecraftVersion).replace("MODLOADER", modloader).replace("MODLOADER_VERSION", modloaderVersion))));
            ExcludeFileFilter excludeFileFilter = filesToExclude::contains;
            zipParameters.setExcludeFileFilter(excludeFileFilter);
        } else {
            LOG.info("File exclusion from ZIP-archives deactivated.");
        }
        String comment = "Server pack made with ServerPackCreator " + this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION() + " by Griefed.";
        zipParameters.setIncludeRootFolder(false);
        zipParameters.setFileComment(comment);
        try (ZipFile zip = new ZipFile(String.format("%s_server_pack.zip", destination));){
            zip.addFolder(new File(destination), zipParameters);
            zip.setComment(comment);
        }
        catch (IOException ex) {
            LOG.error("There was an error during zip creation.", (Throwable)ex);
        }
        if (includeServerInstallation) {
            LOG.warn("!!!-------NOTE: The minecraft_server.jar will not be included in the zip-archive.-------!!!");
            LOG.warn("!!!-Mojang strictly prohibits the distribution of their software through third parties.-!!!");
            LOG.warn("!!!---Tell your users to execute the download scripts to get the Minecraft server jar.--!!!");
        }
        LOG.info("Finished creation of zip archive.");
    }

    private void cleanUpServerPack(ConfigurationModel configurationModel) {
        this.cleanUpServerPack(configurationModel.getMinecraftVersion(), configurationModel.getModLoaderVersion(), this.getServerPackDestination(configurationModel));
    }

    private void cleanUpServerPack(String minecraftVersion, String modLoaderVersion, String destination) {
        LOG.info("Cleanup after modloader server installation.");
        FileUtils.deleteQuietly(new File(destination + "/fabric-installer.jar"));
        FileUtils.deleteQuietly(new File(destination + "/forge-installer.jar"));
        FileUtils.deleteQuietly(new File(destination + "/quilt-installer.jar"));
        FileUtils.deleteQuietly(new File(destination + "/installer.log"));
        FileUtils.deleteQuietly(new File(destination + "/forge-installer.jar.log"));
        FileUtils.deleteQuietly(new File(destination + "/legacyfabric-installer.jar"));
        FileUtils.deleteQuietly(Paths.get(destination + "/run.bat", new String[0]).toFile());
        FileUtils.deleteQuietly(Paths.get(destination + "/run.sh", new String[0]).toFile());
        FileUtils.deleteQuietly(Paths.get(destination + "/user_jvm_args.txt", new String[0]).toFile());
        try {
            Path path = Paths.get(String.format(destination + "/forge-%s-%s.jar", minecraftVersion, modLoaderVersion), new String[0]);
            if (new File(String.format(destination + "/forge-%s-%s.jar", minecraftVersion, modLoaderVersion)).exists()) {
                Files.copy(path, Paths.get(destination + "/forge.jar", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                FileUtils.deleteQuietly(path.toFile());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ServerPackFile {
        private final File SOURCE_FILE;
        private final Path SOURCE_PATH;
        private final File DESTINATION_FILE;
        private final Path DESTINATION_PATH;

        public ServerPackFile(File sourceFile, File destinationFile) throws InvalidPathException {
            this.SOURCE_FILE = sourceFile;
            this.SOURCE_PATH = sourceFile.toPath();
            this.DESTINATION_FILE = destinationFile;
            this.DESTINATION_PATH = destinationFile.toPath();
        }

        public ServerPackFile(String sourceFile, String destinationFile) throws NullPointerException, InvalidPathException {
            this.SOURCE_FILE = new File(sourceFile);
            this.SOURCE_PATH = this.SOURCE_FILE.toPath();
            this.DESTINATION_FILE = new File(destinationFile);
            this.DESTINATION_PATH = this.DESTINATION_FILE.toPath();
        }

        public ServerPackFile(Path sourcePath, Path destinationPath) throws UnsupportedOperationException {
            this.SOURCE_FILE = sourcePath.toFile();
            this.SOURCE_PATH = sourcePath;
            this.DESTINATION_FILE = destinationPath.toFile();
            this.DESTINATION_PATH = destinationPath;
        }

        public File source() {
            return this.SOURCE_FILE;
        }

        public File destination() {
            return this.DESTINATION_FILE;
        }

        public Path sourcePath() {
            return this.SOURCE_PATH;
        }

        public Path destinationPath() {
            return this.DESTINATION_PATH;
        }

        public void copy() throws SecurityException, UnsupportedOperationException, IOException {
            try {
                if (!this.SOURCE_FILE.isDirectory()) {
                    FileUtils.copyFile(this.SOURCE_FILE, this.DESTINATION_FILE, true, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(this.SOURCE_PATH, this.DESTINATION_PATH, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
                LOG.debug("Successfully copied ServerPackFile");
                LOG.debug("    Source: " + this.SOURCE_PATH);
                LOG.debug("    Destination: " + this.DESTINATION_PATH);
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.SOURCE_PATH + ";" + this.DESTINATION_PATH;
        }
    }
}

