/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import de.griefed.serverpackcreator.plugins.serverpackhandler.PostGenExtension;
import de.griefed.serverpackcreator.plugins.serverpackhandler.PreGenExtension;
import de.griefed.serverpackcreator.plugins.serverpackhandler.PreZipExtension;
import de.griefed.serverpackcreator.plugins.swinggui.TabExtension;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pf4j.JarPluginManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ApplicationPlugins
extends JarPluginManager {
    private static final Logger LOG = LogManager.getLogger(ApplicationPlugins.class);
    private final List<PreGenExtension> PLUGINS_PreGenExtension;
    private final List<PreZipExtension> PLUGINS_PreZipExtension;
    private final List<PostGenExtension> PLUGINS_PostGenExtension;
    private final List<TabExtension> PLUGINS_TabExtension;

    @Autowired
    public ApplicationPlugins() {
        LOG.info("Plugins directory: " + new File(System.getProperty("pf4j.pluginsDir", "plugins")).getAbsolutePath());
        this.loadPlugins();
        this.startPlugins();
        this.PLUGINS_PreGenExtension = this.getExtensions(PreGenExtension.class);
        this.PLUGINS_PreZipExtension = this.getExtensions(PreZipExtension.class);
        this.PLUGINS_PostGenExtension = this.getExtensions(PostGenExtension.class);
        this.PLUGINS_TabExtension = this.getExtensions(TabExtension.class);
        this.availablePluginsAndExtensions();
    }

    private void availablePluginsAndExtensions() {
        if (this.PLUGINS_PreGenExtension.isEmpty() && this.PLUGINS_PreZipExtension.isEmpty() && this.PLUGINS_PostGenExtension.isEmpty() && this.PLUGINS_TabExtension.isEmpty()) {
            LOG.info("No plugins installed.");
            return;
        }
        if (!this.PLUGINS_PreGenExtension.isEmpty()) {
            LOG.info("Available PreGenExtension plugins:");
            this.PLUGINS_PreGenExtension.forEach(plugin -> {
                LOG.info("  Name:       " + plugin.getName());
                LOG.info("    Description:" + plugin.getDescription());
                LOG.info("    Version:    " + plugin.getVersion());
                LOG.info("    Author:     " + plugin.getAuthor());
            });
        } else {
            LOG.info("No PreGenExtensions installed.");
        }
        if (!this.PLUGINS_PreZipExtension.isEmpty()) {
            LOG.info("Available PreZipExtension plugins:");
            this.PLUGINS_PreZipExtension.forEach(plugin -> {
                LOG.info("  Name:       " + plugin.getName());
                LOG.info("    Description:" + plugin.getDescription());
                LOG.info("    Version:    " + plugin.getVersion());
                LOG.info("    Author:     " + plugin.getAuthor());
            });
        } else {
            LOG.info("No PreZipExtension installed.");
        }
        if (!this.PLUGINS_PostGenExtension.isEmpty()) {
            LOG.info("Available PostGenExtension plugins:");
            this.PLUGINS_PostGenExtension.forEach(plugin -> {
                LOG.info("  Name:       " + plugin.getName());
                LOG.info("    Description:" + plugin.getDescription());
                LOG.info("    Version:    " + plugin.getVersion());
                LOG.info("    Author:     " + plugin.getAuthor());
            });
        } else {
            LOG.info("No PostGenExtension installed.");
        }
        if (!this.PLUGINS_TabExtension.isEmpty()) {
            LOG.info("Available TabExtension plugins:");
            this.PLUGINS_TabExtension.forEach(plugin -> {
                LOG.info("  Name:       " + plugin.getName());
                LOG.info("    Description:" + plugin.getDescription());
                LOG.info("    Version:    " + plugin.getVersion());
                LOG.info("    Author:     " + plugin.getAuthor());
            });
        } else {
            LOG.info("No TabExtension installed.");
        }
    }

    public List<PreGenExtension> pluginsPreGenExtension() {
        return this.PLUGINS_PreGenExtension;
    }

    public List<PreZipExtension> pluginsPreZipExtension() {
        return this.PLUGINS_PreZipExtension;
    }

    public List<PostGenExtension> pluginsPostGenExtension() {
        return this.PLUGINS_PostGenExtension;
    }

    public List<TabExtension> pluginsTabExtension() {
        return this.PLUGINS_TabExtension;
    }
}

