/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.NamedStoredProcedureQueries;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.jpa.repository.query.ProcedureParameter;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

enum StoredProcedureAttributeSource {
    INSTANCE;


    public StoredProcedureAttributes createFrom(Method method, JpaEntityMetadata<?> entityMetadata) {
        Assert.notNull((Object)method, "Method must not be null!");
        Assert.notNull(entityMetadata, "EntityMetadata must not be null!");
        Procedure procedure = AnnotatedElementUtils.findMergedAnnotation(method, Procedure.class);
        Assert.notNull((Object)procedure, "Method must have an @Procedure annotation!");
        NamedStoredProcedureQuery namedStoredProc = this.tryFindAnnotatedNamedStoredProcedureQuery(method, entityMetadata, procedure);
        if (namedStoredProc != null) {
            return this.newProcedureAttributesFrom(method, namedStoredProc, procedure);
        }
        String procedureName = this.deriveProcedureNameFrom(method, procedure);
        if (ObjectUtils.isEmpty(procedureName)) {
            throw new IllegalArgumentException("Could not determine name of procedure for @Procedure annotated method: " + method);
        }
        return new StoredProcedureAttributes(procedureName, this.createOutputProcedureParameterFrom(method, procedure));
    }

    private String deriveProcedureNameFrom(Method method, Procedure procedure) {
        if (StringUtils.hasText(procedure.value())) {
            return procedure.value();
        }
        String procedureName = procedure.procedureName();
        return StringUtils.hasText(procedureName) ? procedureName : method.getName();
    }

    private StoredProcedureAttributes newProcedureAttributesFrom(Method method, NamedStoredProcedureQuery namedStoredProc, Procedure procedure) {
        List<ProcedureParameter> outputParameters = !procedure.outputParameterName().isEmpty() ? Collections.singletonList(this.createOutputProcedureParameterFrom(method, procedure)) : this.extractOutputParametersFrom(namedStoredProc).stream().map(namedParameter -> new ProcedureParameter(namedParameter.name(), namedParameter.mode(), namedParameter.type())).collect(Collectors.toList());
        return new StoredProcedureAttributes(namedStoredProc.name(), outputParameters, true);
    }

    private ProcedureParameter createOutputProcedureParameterFrom(Method method, Procedure procedure) {
        return new ProcedureParameter(procedure.outputParameterName(), procedure.refCursor() ? ParameterMode.REF_CURSOR : ParameterMode.OUT, method.getReturnType());
    }

    private List<StoredProcedureParameter> extractOutputParametersFrom(NamedStoredProcedureQuery namedStoredProc) {
        ArrayList<StoredProcedureParameter> outputParameters = new ArrayList<StoredProcedureParameter>();
        block3: for (StoredProcedureParameter param : namedStoredProc.parameters()) {
            switch (param.mode()) {
                case OUT: 
                case INOUT: 
                case REF_CURSOR: {
                    outputParameters.add(param);
                    continue block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        return outputParameters;
    }

    @Nullable
    private NamedStoredProcedureQuery tryFindAnnotatedNamedStoredProcedureQuery(Method method, JpaEntityMetadata<?> entityMetadata, Procedure procedure) {
        Assert.notNull((Object)method, "Method must not be null!");
        Assert.notNull(entityMetadata, "EntityMetadata must not be null!");
        Assert.notNull((Object)procedure, "Procedure must not be null!");
        Class entityType = entityMetadata.getJavaType();
        List<NamedStoredProcedureQuery> queries = this.collectNamedStoredProcedureQueriesFrom(entityType);
        if (queries.isEmpty()) {
            return null;
        }
        String namedProcedureName = this.derivedNamedProcedureNameFrom(method, entityMetadata, procedure);
        for (NamedStoredProcedureQuery query2 : queries) {
            if (!query2.name().equals(namedProcedureName)) continue;
            return query2;
        }
        return null;
    }

    private String derivedNamedProcedureNameFrom(Method method, JpaEntityMetadata<?> entityMetadata, Procedure procedure) {
        return StringUtils.hasText(procedure.name()) ? procedure.name() : entityMetadata.getEntityName() + "." + method.getName();
    }

    private List<NamedStoredProcedureQuery> collectNamedStoredProcedureQueriesFrom(Class<?> entityType) {
        NamedStoredProcedureQuery namedQueryAnnotation;
        ArrayList<NamedStoredProcedureQuery> queries = new ArrayList<NamedStoredProcedureQuery>();
        NamedStoredProcedureQueries namedQueriesAnnotation = AnnotatedElementUtils.findMergedAnnotation(entityType, NamedStoredProcedureQueries.class);
        if (namedQueriesAnnotation != null) {
            queries.addAll(Arrays.asList(namedQueriesAnnotation.value()));
        }
        if ((namedQueryAnnotation = AnnotatedElementUtils.findMergedAnnotation(entityType, NamedStoredProcedureQuery.class)) != null) {
            queries.add(namedQueryAnnotation);
        }
        return queries;
    }
}

