/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.rt.transports;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.tests.rt.RtReceiver;
import org.jgroups.tests.rt.RtTransport;
import org.jgroups.util.Util;

public class UdpTransport
implements RtTransport {
    protected DatagramSocket sock;
    protected Receiver receiver_thread;
    protected RtReceiver receiver;
    protected InetAddress host;
    protected int port = 7800;
    protected boolean server;
    protected final Log log = LogFactory.getLog(UdpTransport.class);
    protected List<SocketAddress> members = new ArrayList<SocketAddress>();

    @Override
    public String[] options() {
        return new String[]{"-host <host>", "-port <port>", "-server"};
    }

    @Override
    public void options(String ... options) throws Exception {
        if (options == null) {
            return;
        }
        for (int i2 = 0; i2 < options.length; ++i2) {
            if (options[i2].equals("-server")) {
                this.server = true;
                continue;
            }
            if (options[i2].equals("-host")) {
                this.host = InetAddress.getByName(options[++i2]);
                continue;
            }
            if (!options[i2].equals("-port")) continue;
            this.port = Integer.parseInt(options[++i2]);
        }
        if (this.host == null) {
            this.host = InetAddress.getLocalHost();
        }
    }

    @Override
    public void receiver(RtReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public Object localAddress() {
        return this.members != null ? this.members.get(0) : null;
    }

    @Override
    public List<? extends Object> clusterMembers() {
        return this.members;
    }

    @Override
    public void start(String ... options) throws Exception {
        this.options(options);
        if (this.server) {
            this.sock = new DatagramSocket(this.port, this.host);
            System.out.println("server started (ctrl-c to kill)");
        } else {
            this.sock = new DatagramSocket();
            this.members.add(this.sock.getLocalSocketAddress());
            this.members.add(new InetSocketAddress(this.host, this.port));
        }
        this.receiver_thread = new Receiver();
        this.receiver_thread.start();
    }

    @Override
    public void stop() {
        Util.close((Closeable)this.sock);
    }

    @Override
    public void send(Object dest, byte[] buf, int offset, int length) throws Exception {
        DatagramPacket packet = new DatagramPacket(buf, offset, length, (SocketAddress)dest);
        this.sock.send(packet);
    }

    protected class Receiver
    extends Thread {
        protected Receiver() {
        }

        @Override
        public void run() {
            byte[] buf = new byte[11];
            DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
            while (true) {
                try {
                    while (true) {
                        UdpTransport.this.sock.receive(packet);
                        if (packet.getLength() != 11) {
                            throw new IllegalStateException("expected 11 bytes, but got only " + packet.getLength());
                        }
                        if (UdpTransport.this.receiver == null) continue;
                        UdpTransport.this.receiver.receive(packet.getSocketAddress(), buf, packet.getOffset(), packet.getLength());
                    }
                }
                catch (IOException ex) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

