/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.filters;

import java.util.Iterator;
import java.util.logging.Filter;
import java.util.logging.LogRecord;

public final class AnyFilter
implements Filter {
    private final Filter[] filters;

    public AnyFilter(Filter[] filters) {
        this.filters = (Filter[])filters.clone();
    }

    public AnyFilter(Iterable<Filter> filters) {
        this(filters.iterator());
    }

    public AnyFilter(Iterator<Filter> filters) {
        this.filters = AnyFilter.unroll(filters, 0);
    }

    private static Filter[] unroll(Iterator<Filter> iter2, int cnt) {
        if (iter2.hasNext()) {
            Filter filter2 = iter2.next();
            if (filter2 == null) {
                throw new NullPointerException("filter at index " + cnt + " is null");
            }
            Filter[] filters = AnyFilter.unroll(iter2, cnt + 1);
            filters[cnt] = filter2;
            return filters;
        }
        return new Filter[cnt];
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        for (Filter filter2 : this.filters) {
            if (!filter2.isLoggable(record)) continue;
            return true;
        }
        return false;
    }
}

