/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.AuditLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.jboss.logging.Logger;

public class GuestLoginModule
implements AuditLoginModule {
    private static final Logger logger = Logger.getLogger(GuestLoginModule.class);
    private static final String GUEST_USER = "org.apache.activemq.jaas.guest.user";
    private static final String GUEST_ROLE = "org.apache.activemq.jaas.guest.role";
    private String userName = "guest";
    private String roleName = "guests";
    private Subject subject;
    private boolean debug;
    private boolean credentialsInvalidate;
    private final Set<Principal> principals = new HashSet<Principal>();
    private CallbackHandler callbackHandler;
    private boolean loginSucceeded;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.credentialsInvalidate = "true".equalsIgnoreCase((String)options.get("credentialsInvalidate"));
        if (options.get(GUEST_USER) != null) {
            this.userName = (String)options.get(GUEST_USER);
        }
        if (options.get(GUEST_ROLE) != null) {
            this.roleName = (String)options.get(GUEST_ROLE);
        }
        this.principals.add(new UserPrincipal(this.userName));
        this.principals.add(new RolePrincipal(this.roleName));
        if (this.debug) {
            logger.debug("Initialized debug=" + this.debug + " guestUser=" + this.userName + " guestGroup=" + this.roleName);
        }
    }

    @Override
    public boolean login() throws LoginException {
        this.loginSucceeded = true;
        if (this.credentialsInvalidate) {
            PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
            try {
                this.callbackHandler.handle(new Callback[]{passwordCallback});
                if (passwordCallback.getPassword() != null) {
                    if (this.debug) {
                        logger.debug("Guest login failing (credentialsInvalidate=true) on presence of a password");
                    }
                    this.loginSucceeded = false;
                    passwordCallback.clearPassword();
                }
            }
            catch (IOException | UnsupportedCallbackException exception) {
                // empty catch block
            }
        }
        if (this.debug) {
            logger.debug("Guest login " + this.loginSucceeded);
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSucceeded) {
            this.subject.getPrincipals().addAll(this.principals);
        }
        if (this.debug) {
            logger.debug("commit: " + this.loginSucceeded);
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean abort() throws LoginException {
        this.registerFailureForAudit(GUEST_USER);
        if (this.debug) {
            logger.debug("abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        if (this.debug) {
            logger.debug("logout");
        }
        return true;
    }
}

