/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jndi;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jndi.LazyCreateContext;
import org.apache.activemq.artemis.jndi.ReadOnlyContext;
import org.apache.activemq.artemis.uri.ConnectionFactoryParser;
import org.apache.activemq.artemis.uri.JMSConnectionOptions;
import org.apache.activemq.artemis.utils.uri.URISchema;

public class ActiveMQInitialContextFactory
implements InitialContextFactory {
    public static final String REFRESH_TIMEOUT = "refreshTimeout";
    public static final String DISCOVERY_INITIAL_WAIT_TIMEOUT = "discoveryInitialWaitTimeout";
    public static final String DYNAMIC_QUEUE_CONTEXT = "dynamicQueues";
    public static final String DYNAMIC_TOPIC_CONTEXT = "dynamicTopics";
    private String connectionFactoryPrefix = "connectionFactory.";
    private String queuePrefix = "queue.";
    private String topicPrefix = "topic.";

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment2) throws NamingException {
        ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
        String providerUrl = (String)environment2.get("java.naming.provider.url");
        if (providerUrl != null && !providerUrl.isEmpty()) {
            try {
                JMSFactoryType providedFactoryType = this.getFactoryType(providerUrl);
                if (providedFactoryType == null) {
                    for (JMSFactoryType factoryType : JMSFactoryType.values()) {
                        String factoryName = factoryType.connectionFactoryInterface().getSimpleName();
                        data.put(factoryName, this.createConnectionFactory(providerUrl, Collections.singletonMap("type", factoryType.toString()), factoryName));
                    }
                } else {
                    String factoryName = providedFactoryType.connectionFactoryInterface().getSimpleName();
                    data.put(factoryName, this.createConnectionFactory(providerUrl, factoryName));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NamingException("Invalid broker URL");
            }
        }
        for (Map.Entry<?, ?> entry : environment2.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.connectionFactoryPrefix)) continue;
            String jndiName = key.substring(this.connectionFactoryPrefix.length());
            try {
                data.put(jndiName, this.createConnectionFactory((String)environment2.get(key), jndiName));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NamingException("Invalid broker URL");
            }
        }
        this.createQueues(data, environment2);
        this.createTopics(data, environment2);
        data.put(DYNAMIC_QUEUE_CONTEXT, new LazyCreateContext(){
            private static final long serialVersionUID = 6503881346214855588L;

            @Override
            protected Object createEntry(String name) {
                return ActiveMQJMSClient.createQueue(name);
            }
        });
        data.put(DYNAMIC_TOPIC_CONTEXT, new LazyCreateContext(){
            private static final long serialVersionUID = 2019166796234979615L;

            @Override
            protected Object createEntry(String name) {
                return ActiveMQJMSClient.createTopic(name);
            }
        });
        return this.createContext(environment2, data);
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    protected ReadOnlyContext createContext(Hashtable<?, ?> environment2, Map<String, Object> data) {
        return new ReadOnlyContext(environment2, data);
    }

    protected void createQueues(Map<String, Object> data, Hashtable<?, ?> environment2) {
        for (Map.Entry<?, ?> entry : environment2.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.queuePrefix)) continue;
            String jndiName = key.substring(this.queuePrefix.length());
            data.put(jndiName, this.createQueue(entry.getValue().toString()));
        }
    }

    protected void createTopics(Map<String, Object> data, Hashtable<?, ?> environment2) {
        for (Map.Entry<?, ?> entry : environment2.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.topicPrefix)) continue;
            String jndiName = key.substring(this.topicPrefix.length());
            data.put(jndiName, this.createTopic(entry.getValue().toString()));
        }
    }

    protected Queue createQueue(String name) {
        return ActiveMQJMSClient.createQueue(name);
    }

    protected Topic createTopic(String name) {
        return ActiveMQJMSClient.createTopic(name);
    }

    protected ConnectionFactory createConnectionFactory(String uri, String name) throws Exception {
        ConnectionFactoryParser parser = new ConnectionFactoryParser();
        return (ConnectionFactory)parser.newObject(parser.expandURI(uri), name);
    }

    protected ConnectionFactory createConnectionFactory(String uri, Map<String, String> overrides, String name) throws Exception {
        ConnectionFactoryParser parser = new ConnectionFactoryParser();
        return (ConnectionFactory)parser.newObject(parser.expandURI(uri), overrides, name);
    }

    public JMSFactoryType getFactoryType(String uri) throws Exception {
        ConnectionFactoryParser parser = new ConnectionFactoryParser();
        Map<String, String> queryParams = URISchema.parseQuery(parser.expandURI(uri).getQuery(), null);
        String type = queryParams.get("type");
        return type == null ? null : JMSConnectionOptions.convertCFType(type);
    }
}

