/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.management.BaseBroadcastGroupControl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.logs.AuditLogger;

public class BaseBroadcastGroupControlImpl
extends AbstractControl
implements BaseBroadcastGroupControl {
    private Class broadcastGroupControlClass;
    private final BroadcastGroup broadcastGroup;
    private final BroadcastGroupConfiguration configuration;

    public BaseBroadcastGroupControlImpl(BroadcastGroup broadcastGroup, StorageManager storageManager, BroadcastGroupConfiguration configuration) throws Exception {
        this(BaseBroadcastGroupControl.class, broadcastGroup, storageManager, configuration);
    }

    public BaseBroadcastGroupControlImpl(Class broadcastGroupControlClass, BroadcastGroup broadcastGroup, StorageManager storageManager, BroadcastGroupConfiguration configuration) throws Exception {
        super(broadcastGroupControlClass, storageManager);
        this.broadcastGroupControlClass = broadcastGroupControlClass;
        this.broadcastGroup = broadcastGroup;
        this.configuration = configuration;
    }

    @Override
    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName(this.broadcastGroup);
        }
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getBroadcastPeriod() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getBroadcastPeriod(this.broadcastGroup);
        }
        this.clearIO();
        try {
            long l = this.configuration.getBroadcastPeriod();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getConnectorPairs() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getConnectorPairs(this.broadcastGroup);
        }
        this.clearIO();
        try {
            Object[] ret = new Object[this.configuration.getConnectorInfos().size()];
            int i2 = 0;
            for (String connector : this.configuration.getConnectorInfos()) {
                ret[i2++] = connector;
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String getConnectorPairsAsJSON() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getConnectorPairsAsJSON(this.broadcastGroup);
        }
        this.clearIO();
        try {
            String string = JsonUtil.toJsonArray(this.configuration.getConnectorInfos()).toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isStarted() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isStarted(this.broadcastGroup);
        }
        this.clearIO();
        try {
            boolean bl = this.broadcastGroup.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void start() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.startBroadcastGroup(this.broadcastGroup);
        }
        this.clearIO();
        try {
            this.broadcastGroup.start();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void stop() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.stopBroadcastGroup(this.broadcastGroup);
        }
        this.clearIO();
        try {
            this.broadcastGroup.stop();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(this.broadcastGroupControlClass);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(this.broadcastGroupControlClass);
    }

    protected BroadcastGroup getBroadcastGroup() {
        return this.broadcastGroup;
    }
}

