/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.nio;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.activemq.artemis.core.io.AbstractSequentialFileFactory;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFile;
import org.apache.activemq.artemis.core.io.util.ByteBufferPool;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.PowerOf2Util;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;

public class NIOSequentialFileFactory
extends AbstractSequentialFileFactory {
    private static final int DEFAULT_CAPACITY_ALIGNMENT = Env.osPageSize();
    private boolean bufferPooling = true;
    private final ByteBufferPool bytesPool = ByteBufferPool.threadLocal(true);

    public NIOSequentialFileFactory(File journalDir, int maxIO) {
        this(journalDir, null, maxIO);
    }

    public NIOSequentialFileFactory(File journalDir, IOCriticalErrorListener listener, int maxIO) {
        this(journalDir, false, 501760, 3333333, maxIO, false, listener, null);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, int maxIO) {
        this(journalDir, buffered, null, maxIO);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, IOCriticalErrorListener listener, int maxIO) {
        this(journalDir, buffered, 501760, 3333333, maxIO, false, listener, null);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, int bufferSize, int bufferTimeout, int maxIO, boolean logRates) {
        this(journalDir, buffered, bufferSize, bufferTimeout, maxIO, logRates, null, null);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, int bufferSize, int bufferTimeout, int maxIO, boolean logRates, IOCriticalErrorListener listener, CriticalAnalyzer analyzer) {
        super(journalDir, buffered, bufferSize, bufferTimeout, maxIO, logRates, listener, analyzer);
    }

    public static ByteBuffer allocateDirectByteBuffer(int size) {
        ByteBuffer buffer2 = null;
        try {
            buffer2 = ByteBuffer.allocateDirect(size);
        }
        catch (OutOfMemoryError error) {
            WeakReference<Object> obj = new WeakReference<Object>(new Object());
            try {
                long timeout = System.currentTimeMillis() + 5000L;
                while (System.currentTimeMillis() > timeout && obj.get() != null) {
                    System.gc();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            buffer2 = ByteBuffer.allocateDirect(size);
        }
        return buffer2;
    }

    public void enableBufferReuse() {
        this.bufferPooling = true;
    }

    public void disableBufferReuse() {
        this.bufferPooling = false;
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        return new NIOSequentialFile(this, this.journalDir, fileName, this.maxIO, this.writeExecutor);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return this.timedBuffer != null;
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        int requiredCapacity = PowerOf2Util.align(size, DEFAULT_CAPACITY_ALIGNMENT);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(requiredCapacity);
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer(buffer);
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        return this.newBuffer(size, true);
    }

    @Override
    public ByteBuffer newBuffer(int size, boolean zeroed) {
        if (!this.bufferPooling) {
            return this.allocateDirectBuffer(size);
        }
        return this.bytesPool.borrow(size, zeroed);
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        if (this.bufferPooling) {
            this.bytesPool.release(buffer);
        }
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            PlatformDependent.setMemory(PlatformDependent.directBufferAddress(buffer), buffer.limit(), (byte)0);
        } else {
            Arrays.fill(buffer.array(), buffer.arrayOffset(), buffer.limit(), (byte)0);
        }
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }
}

