/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import io.ByteWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.UnsupportedCLSIDException;
import mslinks.data.ItemID;

public class LinkTargetIDList
extends LinkedList<ItemID>
implements Serializable {
    private static final long serialVersionUID = 3619823553066465595L;

    public LinkTargetIDList() {
    }

    public LinkTargetIDList(ByteReader data) throws IOException, ShellLinkException {
        int size = (int)data.read2bytes();
        int pos = data.getPosition();
        boolean binary = false;
        int s2 = (int)data.read2bytes();
        while (s2 != 0) {
            s2 -= 2;
            if (binary) {
                byte[] b = new byte[s2];
                for (int i2 = 0; i2 < s2; ++i2) {
                    b[i2] = (byte)data.read();
                }
                this.add(new ItemID(b));
            } else {
                try {
                    this.add(new ItemID(data, s2));
                }
                catch (UnsupportedCLSIDException e) {
                    System.err.println("unsupported CLSID");
                    binary = true;
                }
            }
            s2 = (int)data.read2bytes();
        }
        pos = data.getPosition() - pos;
        if (pos != size) {
            throw new ShellLinkException();
        }
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        int size = 2;
        byte[][] b = new byte[this.size()][];
        int i2 = 0;
        for (ItemID j : this) {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ByteWriter w = new ByteWriter(ba);
            j.serialize(w);
            b[i2++] = ba.toByteArray();
        }
        for (Object j : (Object)b) {
            size += ((Object)j).length + 2;
        }
        bw.write2bytes(size);
        for (Object j : (Object)b) {
            bw.write2bytes(((Object)j).length + 2);
            bw.writeBytes((byte[])j);
        }
        bw.write2bytes(0L);
    }

    public boolean isCorrect() {
        for (ItemID i2 : this) {
            if (i2.getType() != 0) continue;
            return false;
        }
        return true;
    }
}

