/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.utils;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.plaf.IconUIResource;
import jiconfont.IconCode;
import jiconfont.swing.IconFontSwing;
import mdlaf.utils.MaterialColors;
import mdlaf.utils.icons.IMaterialIconCode;
import mdlaf.utils.icons.MaterialIconFont;

public class MaterialImageFactory {
    private static MaterialImageFactory SINGLETON;
    private static final String PATH_RESOURCES = "/imgs/";
    public static final String BLANK = "blank";
    @Deprecated
    public static final String RIGHT_ARROW = "right_arrow";
    @Deprecated
    public static final String LEFT_ARROW = "left_arrow";
    @Deprecated
    public static final String DOWN_ARROW = "down_arrow";
    @Deprecated
    public static final String UP_ARROW = "up_arrow";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String QUESTION = "question";
    public static final String INFORMATION = "information";
    private Map<String, IconUIResource> cacheImage = new HashMap<String, IconUIResource>();

    public static void registerIcons(IconCode iconCode) {
        if (iconCode == null) {
            String errorMessage = "\n- Icon code null you can found the name icon here: https://jiconfont.github.io/\nAn example can be this IconFontSwing.register(GoogleMaterialDesignIcons.getIconFont());";
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static MaterialImageFactory getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new MaterialImageFactory();
        }
        return SINGLETON;
    }

    private MaterialImageFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IconUIResource getImage(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument null");
        }
        String path = PATH_RESOURCES.trim() + key.trim() + ".png".trim();
        if (this.cacheImage.containsKey(path)) {
            return this.cacheImage.get(path);
        }
        try (InputStream inputStream = MaterialImageFactory.class.getResourceAsStream(path);){
            BufferedImage image = ImageIO.read(inputStream);
            this.cacheImage.put(path, new IconUIResource(new ImageIcon(image)));
            IconUIResource iconUIResource = this.cacheImage.get(path);
            return iconUIResource;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Image " + path + " wasn't loaded");
        }
    }

    public IconUIResource getImage(IMaterialIconCode iconCode, int dimension, Color color) {
        String key;
        if (iconCode == null || dimension <= 0) {
            String errorMessage = "Don't know motivation this exceptions";
            if (iconCode == null) {
                if (errorMessage.contains("Don't know motivation this exceptions")) {
                    errorMessage = "";
                }
                errorMessage = errorMessage + "\n- Icon code null, you can found the name icon color here: https://material.io/resources/icons/?style=baseline\nan valid code can be this: MaterialImageFactory.getInstance().getImage(GoogleMaterialDesignIcons.KEYBOARD_ARROW_RIGHT, Color.BLUE);";
            }
            if (dimension <= 0) {
                if (errorMessage.contains("Don't know motivation this exceptions")) {
                    errorMessage = "";
                }
                errorMessage = errorMessage + "\n- Dimension of icon doesn't valid, you should insert the dimension > 0";
            }
            errorMessage = errorMessage + "\n\n";
            throw new IllegalArgumentException(errorMessage);
        }
        if (color == null) {
            color = MaterialColors.BLACK;
        }
        if (this.cacheImage.containsKey(key = iconCode.name() + dimension + color.toString())) {
            return this.cacheImage.get(key);
        }
        IconUIResource icon = new IconUIResource(new ImageIcon(IconFontSwing.buildImage(iconCode, dimension, color)));
        this.cacheImage.put(key, icon);
        return icon;
    }

    public IconUIResource getImage(IMaterialIconCode iconCode, int dimension) {
        return this.getImage(iconCode, dimension, null);
    }

    public IconUIResource getImage(IMaterialIconCode iconCode) {
        return this.getImage(iconCode, 20, null);
    }

    public IconUIResource getImage(IMaterialIconCode iconCode, Color color) {
        return this.getImage(iconCode, 20, color);
    }

    static {
        IconFontSwing.register(MaterialIconFont.getIconFont());
    }
}

