/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities.common;

import com.fasterxml.jackson.databind.JsonNode;
import de.griefed.serverpackcreator.utilities.common.JsonException;
import java.util.Iterator;
import org.springframework.stereotype.Component;

@Component
public final class JsonUtilities {
    public boolean nestedTextMatches(JsonNode jsonNode, String matches, String ... childNodes) throws NullPointerException {
        return this.getNestedText(jsonNode, childNodes).matches(matches);
    }

    public boolean nestedTextEqualsIgnoreCase(JsonNode jsonNode, String equalsIgnoreCase, String ... childNodes) throws NullPointerException {
        return this.getNestedText(jsonNode, childNodes).equalsIgnoreCase(equalsIgnoreCase);
    }

    public boolean nestedTextIsEmpty(JsonNode jsonNode, String ... childNodes) throws NullPointerException {
        return this.getNestedText(jsonNode, childNodes).isEmpty();
    }

    public boolean getNestedBoolean(JsonNode jsonNode, String ... childNodes) throws NullPointerException, JsonException {
        String bool = this.getNestedText(jsonNode, childNodes);
        if (bool.equalsIgnoreCase("true")) {
            return true;
        }
        if (bool.equalsIgnoreCase("false")) {
            return false;
        }
        throw new JsonException("Invalid boolean " + bool);
    }

    public String[] getNestedTexts(JsonNode jsonNode, String split, String ... childNodes) throws NullPointerException {
        return this.getNestedText(jsonNode, childNodes).split(split);
    }

    public boolean nestedTextContains(JsonNode jsonNode, String contains, String ... childNodes) throws NullPointerException {
        return this.getNestedText(jsonNode, childNodes).contains(contains);
    }

    public String getNestedText(JsonNode jsonNode, String ... childNodes) throws NullPointerException {
        return this.getNestedElement(jsonNode, childNodes).asText();
    }

    public Iterator<String> getFieldNames(JsonNode jsonNode, String ... childNodes) throws NullPointerException {
        return this.getNestedElement(jsonNode, childNodes).fieldNames();
    }

    public JsonNode getNestedElement(JsonNode jsonNode, String ... childNodes) throws NullPointerException {
        JsonNode child = jsonNode;
        for (String nested : childNodes) {
            child = child.get(nested);
        }
        return child;
    }
}

