/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ConfigUtilities {
    private static final Logger LOG = LogManager.getLogger(ConfigUtilities.class);
    private final Utilities UTILITIES;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ObjectMapper OBJECT_MAPPER;

    @Autowired
    public ConfigUtilities(Utilities injectedUtilities, ApplicationProperties injectedApplicationProperties, ObjectMapper objectMapper) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.UTILITIES = injectedUtilities;
        this.OBJECT_MAPPER = objectMapper;
    }

    public String getModLoaderCase(String modloader) {
        if (modloader.equalsIgnoreCase("Forge")) {
            return "Forge";
        }
        if (modloader.equalsIgnoreCase("Fabric")) {
            return "Fabric";
        }
        if (modloader.toLowerCase().contains("forge")) {
            return "Forge";
        }
        if (modloader.toLowerCase().contains("fabric")) {
            return "Fabric";
        }
        return "Forge";
    }

    public boolean writeConfigToFile(ConfigurationModel configurationModel, File fileName) {
        return this.writeConfigToFile(configurationModel.getModpackDir(), configurationModel.getClientMods(), configurationModel.getCopyDirs(), configurationModel.getServerIconPath(), configurationModel.getServerPropertiesPath(), configurationModel.getIncludeServerInstallation(), configurationModel.getJavaPath(), configurationModel.getMinecraftVersion(), configurationModel.getModLoader(), configurationModel.getModLoaderVersion(), configurationModel.getIncludeServerIcon(), configurationModel.getIncludeServerProperties(), configurationModel.getIncludeZipCreation(), configurationModel.getJavaArgs(), configurationModel.getServerPackSuffix(), fileName);
    }

    public boolean writeConfigToFile(String modpackDir, List<String> clientMods, List<String> copyDirs, String serverIconPath, String serverPropertiesPath, boolean includeServer, String javaPath, String minecraftVersion, String modLoader, String modLoaderVersion, boolean includeIcon, boolean includeProperties, boolean includeZip, String javaArgs, String serverPackSuffix, File fileName) {
        boolean configWritten = false;
        String configString = String.format("%s\nmodpackDir = \"%s\"\n\n%s\nclientMods = %s\n\n%s\ncopyDirs = %s\n\n%s\nserverIconPath = \"%s\"\n\n%s\nserverPropertiesPath = \"%s\"\n\n%s\nincludeServerInstallation = %b\n\n%s\njavaPath = \"%s\"\n\n%s\nminecraftVersion = \"%s\"\n\n%s\nmodLoader = \"%s\"\n\n%s\nmodLoaderVersion = \"%s\"\n\n%s\nincludeServerIcon = %b\n\n%s\nincludeServerProperties = %b\n\n%s\nincludeZipCreation = %b\n\n%s\njavaArgs = \"%s\"\n\n%s\nserverPackSuffix = \"%s\"", "# Path to your modpack. Can be either relative or absolute.\n# Example: \"./Some Modpack\" or \"C:/Minecraft/Some Modpack\"", modpackDir.replace("\\", "/"), "# List of client-only mods to delete from serverpack.\n# No need to include version specifics. Must be the filenames of the mods, not their project names on CurseForge!\n# Example: [AmbientSounds-,ClientTweaks-,PackMenu-,BetterAdvancement-,jeiintegration-]", this.UTILITIES.ListUtils().encapsulateListElements(this.UTILITIES.ListUtils().cleanList(clientMods)), "# Name of directories or files to include in serverpack.\n# When specifying \"saves/world_name\", \"world_name\" will be copied to the base directory of the serverpack\n# for immediate use with the server. Automatically set when projectID,fileID for modpackDir has been specified.\n# Example: [config,mods,scripts]", this.UTILITIES.ListUtils().encapsulateListElements(this.UTILITIES.ListUtils().cleanList(copyDirs)), "# Path to a custom server-icon.png-file to include in the server pack.", serverIconPath, "# Path to a custom server.properties-file to include in the server pack.", serverPropertiesPath, "# Whether to install a Forge/Fabric/Quilt server for the serverpack. Must be true or false.\n# Default value is true.", includeServer, "# Path to the Java executable. On Linux systems it would be something like \"/usr/bin/java\".\n# Only needed if includeServerInstallation is true.", javaPath.replace("\\", "/"), "# Which Minecraft version to use. Example: \"1.16.5\".\n# Automatically set when projectID,fileID for modpackDir has been specified.\n# Only needed if includeServerInstallation is true.", minecraftVersion, "# Which modloader to install. Must be either \"Forge\", \"Fabric\", \"Quilt\" or \"LegacyFabric\".\n# Automatically set when projectID,fileID for modpackDir has been specified.\n# Only needed if includeServerInstallation is true.", modLoader, "# The version of the modloader you want to install. Example for Fabric=\"0.7.3\", example for Forge=\"36.0.15\".\n# Automatically set when projectID,fileID for modpackDir has been specified.\n# Only needed if includeServerInstallation is true.", modLoaderVersion, "# Include a server-icon.png in your serverpack. Must be true or false.\n# Customize server-icon.png in ./server_files.\n# Dimensions must be 64x64!\n# Default value is true.", includeIcon, "# Include a server.properties in your serverpack. Must be true or false.\n# Customize server.properties in ./server_files.\n# If no server.properties is provided but is set to true, a default one will be provided.\n# Default value is true.", includeProperties, "# Create zip-archive of serverpack. Must be true or false.\n# Default value is true.", includeZip, "# Java arguments to set in the start-scripts for the generated server pack. Default value is \"empty\".\n# Leave as \"empty\" to not have Java arguments in your start-scripts.", javaArgs, "# Suffix to append to the server pack to be generated. Can be left blank/empty.", serverPackSuffix);
        if (fileName.exists()) {
            FileUtils.deleteQuietly(fileName);
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(configString);
            writer.close();
            configWritten = true;
            LOG.info("Successfully written new configuration file.");
        }
        catch (IOException ex) {
            LOG.error("Couldn't write serverpackcreator.conf.", (Throwable)ex);
        }
        return configWritten;
    }

    public void printConfigurationModel(ConfigurationModel configurationModel) {
        this.printConfigurationModel(configurationModel.getModpackDir(), configurationModel.getClientMods(), configurationModel.getCopyDirs(), configurationModel.getIncludeServerInstallation(), configurationModel.getJavaPath(), configurationModel.getMinecraftVersion(), configurationModel.getModLoader(), configurationModel.getModLoaderVersion(), configurationModel.getIncludeServerIcon(), configurationModel.getIncludeServerProperties(), configurationModel.getIncludeZipCreation(), configurationModel.getJavaArgs(), configurationModel.getServerPackSuffix(), configurationModel.getServerIconPath(), configurationModel.getServerPropertiesPath());
    }

    public void printConfigurationModel(String modpackDirectory, List<String> clientsideMods, List<String> copyDirectories, boolean installServer, String javaInstallPath, String minecraftVer, String modloader, String modloaderVersion, boolean includeIcon, boolean includeProperties, boolean includeZip, String javaArgs, String serverPackSuffix, String serverIconPath, String serverPropertiesPath) {
        LOG.info("Your configuration is:");
        LOG.info("Modpack directory: " + modpackDirectory);
        if (clientsideMods.isEmpty()) {
            LOG.warn("No client mods specified.");
        } else {
            LOG.info("Client mods specified. Client mods are:");
            this.UTILITIES.ListUtils().printListToLogChunked(clientsideMods, 5, "    ", true);
        }
        LOG.info("Directories to copy:");
        if (copyDirectories != null) {
            for (String directory : copyDirectories) {
                LOG.info(String.format("    %s", directory));
            }
        } else {
            LOG.error("List of directories to copy is empty.");
        }
        LOG.info("Include server installation:      " + installServer);
        LOG.info("Java Installation path:           " + javaInstallPath);
        LOG.info("Minecraft version:                " + minecraftVer);
        LOG.info("Modloader:                        " + modloader);
        LOG.info("Modloader Version:                " + modloaderVersion);
        LOG.info("Include server icon:              " + includeIcon);
        LOG.info("Include server properties:        " + includeProperties);
        LOG.info("Create zip-archive of serverpack: " + includeZip);
        LOG.info("Java arguments for start-scripts: " + javaArgs);
        LOG.info("Server pack suffix:               " + serverPackSuffix);
        LOG.info("Path to custom server-icon:       " + serverIconPath);
        LOG.info("Path to custom server.properties: " + serverPropertiesPath);
    }

    public void updateConfigModelFromATLauncherInstance(ConfigurationModel configurationModel, File manifest) throws IOException {
        configurationModel.setModpackJson(this.getJson(manifest));
        configurationModel.setMinecraftVersion(configurationModel.getModpackJson().get("id").asText());
        configurationModel.setModLoader(configurationModel.getModpackJson().get("launcher").get("loaderVersion").get("type").asText());
        configurationModel.setModLoaderVersion(configurationModel.getModpackJson().get("launcher").get("loaderVersion").get("version").asText());
    }

    public void updateConfigModelFromModrinthManifest(ConfigurationModel configurationModel, File manifest) throws IOException {
        configurationModel.setModpackJson(this.getJson(manifest));
        configurationModel.setMinecraftVersion(configurationModel.getModpackJson().get("dependencies").get("minecraft").asText());
        Iterator<Map.Entry<String, JsonNode>> it = configurationModel.getModpackJson().get("dependencies").fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> dependencyEntry = it.next();
            switch (dependencyEntry.getKey()) {
                case "fabric-loader": {
                    configurationModel.setModLoader("Fabric");
                    configurationModel.setModLoaderVersion(dependencyEntry.getValue().asText());
                    break;
                }
                case "quilt-loader": {
                    configurationModel.setModLoader("Quilt");
                    configurationModel.setModLoaderVersion(dependencyEntry.getValue().asText());
                    break;
                }
                case "forge": {
                    configurationModel.setModLoader("Forge");
                    configurationModel.setModLoaderVersion(dependencyEntry.getValue().asText());
                }
            }
        }
    }

    public void updateConfigModelFromCurseManifest(ConfigurationModel configurationModel, File manifest) throws IOException {
        configurationModel.setModpackJson(this.getJson(manifest));
        String[] modloaderAndVersion = configurationModel.getModpackJson().get("minecraft").get("modLoaders").get(0).get("id").asText().split("-");
        configurationModel.setMinecraftVersion(configurationModel.getModpackJson().get("minecraft").get("version").asText());
        configurationModel.setModLoader(modloaderAndVersion[0]);
        configurationModel.setModLoaderVersion(modloaderAndVersion[1]);
    }

    public void updateConfigModelFromMinecraftInstance(ConfigurationModel configurationModel, File minecraftInstance) throws IOException {
        configurationModel.setModpackJson(this.getJson(minecraftInstance));
        configurationModel.setModLoader(this.getModLoaderCase(configurationModel.getModpackJson().get("baseModLoader").get("name").asText().split("-")[0]));
        configurationModel.setModLoaderVersion(configurationModel.getModpackJson().get("baseModLoader").get("forgeVersion").asText());
        configurationModel.setMinecraftVersion(configurationModel.getModpackJson().get("baseModLoader").get("minecraftVersion").asText());
    }

    public void updateConfigModelFromConfigJson(ConfigurationModel configurationModel, File config) throws IOException {
        configurationModel.setModpackJson(this.getJson(config));
        configurationModel.setModLoader(this.getModLoaderCase(configurationModel.getModpackJson().get("loader").get("loaderType").asText()));
        configurationModel.setMinecraftVersion(configurationModel.getModpackJson().get("loader").get("mcVersion").asText());
        configurationModel.setModLoaderVersion(configurationModel.getModpackJson().get("loader").get("loaderVersion").asText().replace(configurationModel.getMinecraftVersion() + "-", ""));
    }

    public void updateConfigModelFromMMCPack(ConfigurationModel configurationModel, File mmcPack) throws IOException {
        configurationModel.setModpackJson(this.getJson(mmcPack));
        for (JsonNode jsonNode : configurationModel.getModpackJson().get("components")) {
            switch (jsonNode.get("uid").asText()) {
                case "net.minecraft": {
                    configurationModel.setMinecraftVersion(jsonNode.get("version").asText());
                    break;
                }
                case "net.minecraftforge": {
                    configurationModel.setModLoader("Forge");
                    configurationModel.setModLoaderVersion(jsonNode.get("version").asText());
                    break;
                }
                case "net.fabricmc.fabric-loader": {
                    configurationModel.setModLoader("Fabric");
                    configurationModel.setModLoaderVersion(jsonNode.get("version").asText());
                    break;
                }
                case "org.quiltmc.quilt-loader": {
                    configurationModel.setModLoader("Quilt");
                    configurationModel.setModLoaderVersion(jsonNode.get("version").asText());
                }
            }
        }
    }

    public String updateDestinationFromInstanceCfg(File instanceCfg) throws IOException {
        String name;
        try (InputStream inputStream = Files.newInputStream(instanceCfg.toPath(), new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(inputStream);
            name = properties.getProperty("name", null);
        }
        return name;
    }

    private JsonNode getJson(File jsonFile) throws IOException {
        return this.OBJECT_MAPPER.readTree(Files.readAllBytes(Paths.get(jsonFile.getAbsolutePath().replace("\\", "/"), new String[0])));
    }

    public List<String> suggestCopyDirs(String modpackDir) {
        LOG.info("Preparing a list of directories to include in server pack...");
        File[] listDirectoriesInModpack = new File(modpackDir).listFiles();
        ArrayList<String> dirsInModpack = new ArrayList<String>(100);
        try {
            assert (listDirectoriesInModpack != null);
            for (File dir : listDirectoriesInModpack) {
                if (!dir.isDirectory()) continue;
                dirsInModpack.add(dir.getName());
            }
        }
        catch (NullPointerException np) {
            LOG.error("Error: Something went wrong during the setup of the modpack. Copy dirs should never be empty. Please check the logs for errors and open an issue on https://github.com/Griefed/ServerPackCreator/issues.", (Throwable)np);
        }
        int idirs = 0;
        while (idirs < this.APPLICATIONPROPERTIES.getDirectoriesToExclude().size()) {
            int i2 = idirs++;
            dirsInModpack.removeIf(n -> n.contains(this.APPLICATIONPROPERTIES.getDirectoriesToExclude().get(i2)));
        }
        LOG.info("Modpack directory checked. Suggested directories for copyDirs-setting are: " + dirsInModpack);
        return dirsInModpack;
    }

    @Deprecated
    public boolean checkCurseForgeJsonForFabric(JsonNode modpackJson) {
        for (int i2 = 0; i2 < modpackJson.get("files").size(); ++i2) {
            LOG.debug(String.format("Mod ID: %s", modpackJson.get("files").get(i2).get("projectID").asText()));
            LOG.debug(String.format("File ID: %s", modpackJson.get("files").get(i2).get("fileID").asText()));
            if (!modpackJson.get("files").get(i2).get("projectID").asText().equalsIgnoreCase("361988") && !modpackJson.get("files").get(i2).get("fileID").asText().equalsIgnoreCase("306612")) continue;
            LOG.info("Fabric detected. Setting modloader to \"Fabric\".");
            return true;
        }
        String[] modloaderAndVersion = modpackJson.get("minecraft").get("modLoaders").get(0).get("id").asText().split("-");
        return modloaderAndVersion[0].equalsIgnoreCase("fabric");
    }

    public List<String> getDirectoriesInModpackZipBaseDirectory(ZipFile zipFile) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        ArrayList<String> baseDirectories = new ArrayList<String>(100);
        zipFile.getFileHeaders().forEach(fileHeader -> {
            if (fileHeader.getFileName().matches("^\\w+[/\\\\]$")) {
                baseDirectories.add(fileHeader.getFileName());
            }
        });
        return baseDirectories;
    }

    public List<String> getFilesInModpackZip(ZipFile zipFile) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        ArrayList<String> files = new ArrayList<String>(100);
        zipFile.getFileHeaders().forEach(fileHeader -> {
            if (!fileHeader.isDirectory()) {
                files.add(fileHeader.getFileName());
            }
        });
        return files;
    }

    public List<String> getDirectoriesInModpackZip(ZipFile zipFile) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        ArrayList<String> directories = new ArrayList<String>(100);
        zipFile.getFileHeaders().forEach(fileHeader -> {
            if (fileHeader.isDirectory()) {
                directories.add(fileHeader.getFileName());
            }
        });
        return directories;
    }

    public List<String> getAllFilesAndDirectoriesInModpackZip(ZipFile zipFile) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        ArrayList<String> filesAndDirectories = new ArrayList<String>(100);
        zipFile.getFileHeaders().forEach(fileHeader -> {
            try {
                filesAndDirectories.addAll(this.getDirectoriesInModpackZip(zipFile));
            }
            catch (IOException ex) {
                LOG.error("Could not acquire file or directory from ZIP-archive.", (Throwable)ex);
            }
            try {
                filesAndDirectories.addAll(this.getFilesInModpackZip(zipFile));
            }
            catch (IOException ex) {
                LOG.error("Could not acquire file or directory from ZIP-archive.", (Throwable)ex);
            }
        });
        return filesAndDirectories;
    }
}

