/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import com.electronwill.nightconfig.core.file.FileConfig;
import com.typesafe.config.ConfigException;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.i18n.I18n;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.common.FileUtilities;
import de.griefed.serverpackcreator.utilities.common.InvalidFileTypeException;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ConfigurationHandler {
    private static final Logger LOG = LogManager.getLogger(ConfigurationHandler.class);
    private final I18n I18N;
    private final VersionMeta VERSIONMETA;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final Utilities UTILITIES;
    private final ConfigUtilities CONFIGUTILITIES;

    @Autowired
    public ConfigurationHandler(I18n injectedI18n, VersionMeta injectedVersionMeta, ApplicationProperties injectedApplicationProperties, Utilities injectedUtilities, ConfigUtilities injectedConfigUtilities) throws IOException {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.I18N = injectedI18n;
        this.VERSIONMETA = injectedVersionMeta;
        this.UTILITIES = injectedUtilities;
        this.CONFIGUTILITIES = injectedConfigUtilities;
    }

    public boolean checkConfiguration(@NotNull File configFile, @NotNull List<String> encounteredErrors, boolean quietCheck) {
        ConfigurationModel configurationModel = new ConfigurationModel();
        return this.checkConfiguration(configFile, configurationModel, encounteredErrors, quietCheck);
    }

    public boolean checkConfiguration(@NotNull File configFile, boolean quietCheck) {
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        ConfigurationModel configurationModel = new ConfigurationModel();
        return this.checkConfiguration(configFile, configurationModel, encounteredErrors, quietCheck);
    }

    public boolean checkConfiguration(@NotNull File configFile, @NotNull ConfigurationModel configurationModel, boolean quietCheck) {
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        return this.checkConfiguration(configFile, configurationModel, encounteredErrors, quietCheck);
    }

    public boolean checkConfiguration(@NotNull ConfigurationModel configurationModel, boolean quietCheck) {
        ArrayList<String> encounteredErrors = new ArrayList<String>(100);
        return this.checkConfiguration(configurationModel, encounteredErrors, quietCheck);
    }

    public boolean checkConfiguration(@NotNull File configFile, @NotNull ConfigurationModel configurationModel, @NotNull List<String> encounteredErrors, boolean quietCheck) {
        FileConfig config = null;
        try {
            config = FileConfig.of(configFile);
        }
        catch (ConfigException ex) {
            LOG.error("Couldn't parse config file. Consider checking your config file and fixing empty values. If the value needs to be an empty string, leave its value to \"\".");
            encounteredErrors.add(this.I18N.getMessage("configuration.log.error.checkconfig.start"));
        }
        if (config != null) {
            try {
                config.load();
            }
            catch (ConfigException ex) {
                LOG.error("Couldn't parse config file. Consider checking your config file and fixing empty values. If the value needs to be an empty string, leave its value to \"\".");
                encounteredErrors.add(this.I18N.getMessage("configuration.log.error.checkconfig.start"));
            }
            configurationModel.setClientMods(config.getOrElse("clientMods", Collections.singletonList("")));
            configurationModel.setCopyDirs(config.getOrElse("copyDirs", Collections.singletonList("")));
            configurationModel.setModpackDir(config.getOrElse("modpackDir", "").replace("\\", "/"));
            configurationModel.setJavaPath(config.getOrElse("javaPath", "").replace("\\", "/"));
            configurationModel.setMinecraftVersion(config.getOrElse("minecraftVersion", ""));
            configurationModel.setModLoader(config.getOrElse("modLoader", ""));
            configurationModel.setModLoaderVersion(config.getOrElse("modLoaderVersion", ""));
            configurationModel.setJavaArgs(config.getOrElse("javaArgs", ""));
            configurationModel.setServerPackSuffix(this.UTILITIES.StringUtils().pathSecureText(config.getOrElse("serverPackSuffix", "")));
            configurationModel.setServerIconPath(config.getOrElse("serverIconPath", "").replace("\\", "/"));
            configurationModel.setServerPropertiesPath(config.getOrElse("serverPropertiesPath", "").replace("\\", "/"));
            configurationModel.setIncludeServerInstallation(this.UTILITIES.BooleanUtils().convert(String.valueOf(config.getOrElse("includeServerInstallation", "False"))));
            configurationModel.setIncludeServerIcon(this.UTILITIES.BooleanUtils().convert(String.valueOf(config.getOrElse("includeServerIcon", "False"))));
            configurationModel.setIncludeServerProperties(this.UTILITIES.BooleanUtils().convert(String.valueOf(config.getOrElse("includeServerProperties", "False"))));
            configurationModel.setIncludeZipCreation(this.UTILITIES.BooleanUtils().convert(String.valueOf(config.getOrElse("includeZipCreation", "False"))));
        } else {
            LOG.error("Couldn't parse config file. Consider checking your config file and fixing empty values. If the value needs to be an empty string, leave its value to \"\".");
            encounteredErrors.add(this.I18N.getMessage("configuration.log.error.checkconfig.start"));
        }
        return this.checkConfiguration(configurationModel, encounteredErrors, quietCheck);
    }

    public boolean checkConfiguration(@NotNull ConfigurationModel configurationModel, @NotNull List<String> encounteredErrors, boolean quietCheck) {
        boolean configHasError;
        this.sanitizeLinks(configurationModel);
        LOG.info("Checking configuration...");
        if (configurationModel.getClientMods().isEmpty()) {
            LOG.warn("No clientside-only mods specified. Using fallback list.");
            configurationModel.setClientMods(this.APPLICATIONPROPERTIES.getListFallbackMods());
        }
        configurationModel.setJavaPath(this.getJavaPath(configurationModel.getJavaPath().replace("\\", "/")));
        if (!this.checkIconAndProperties(configurationModel.getServerIconPath())) {
            configHasError = true;
            LOG.error("The specified server-icon does not exist: " + configurationModel.getServerIconPath());
            encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.servericon"), configurationModel.getServerIconPath()));
        } else if (configurationModel.getServerIconPath().length() > 0 && new File(configurationModel.getServerIconPath()).exists() && !this.UTILITIES.FileUtils().checkReadPermission(configurationModel.getServerIconPath())) {
            configHasError = true;
            LOG.error("No read-permission for " + configurationModel.getServerIconPath());
            encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), configurationModel.getServerIconPath()));
        }
        if (!this.checkIconAndProperties(configurationModel.getServerPropertiesPath())) {
            configHasError = true;
            LOG.error("The specified server.properties does not exist: " + configurationModel.getServerPropertiesPath());
            encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.serverproperties"), configurationModel.getServerPropertiesPath()));
        } else if (configurationModel.getServerPropertiesPath().length() > 0 && new File(configurationModel.getServerPropertiesPath()).exists() && !this.UTILITIES.FileUtils().checkReadPermission(configurationModel.getServerPropertiesPath())) {
            configHasError = true;
            LOG.error("No read-permission for " + configurationModel.getServerPropertiesPath());
            encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), configurationModel.getServerPropertiesPath()));
        }
        File modpack = new File(configurationModel.getModpackDir());
        if (modpack.isDirectory()) {
            configHasError = this.isDir(configurationModel, encounteredErrors);
        } else if (modpack.isFile() && modpack.getName().endsWith("zip")) {
            try {
                configHasError = this.isZip(configurationModel, encounteredErrors);
            }
            catch (IOException ex) {
                configHasError = true;
                LOG.error("An error occurred whilst working with the ZIP-archive.", (Throwable)ex);
            }
        } else {
            configHasError = true;
            LOG.error("Modpack directory not specified. Please specify an existing directory.");
            encounteredErrors.add(this.I18N.getMessage("configuration.log.error.checkmodpackdir"));
        }
        if (this.checkModloader(configurationModel.getModLoader())) {
            if (this.VERSIONMETA.minecraft().checkMinecraftVersion(configurationModel.getMinecraftVersion())) {
                LOG.debug("minecraftVersion setting check passed.");
                LOG.debug("modLoader setting check passed.");
                if (this.checkModloaderVersion(configurationModel.getModLoader(), configurationModel.getModLoaderVersion(), configurationModel.getMinecraftVersion(), encounteredErrors)) {
                    LOG.debug("modLoaderVersion setting check passed.");
                } else {
                    configHasError = true;
                    LOG.error("There's something wrong with your Modloader version setting.");
                    encounteredErrors.add(this.I18N.getMessage("configuration.log.error.checkmodloaderversion"));
                }
            } else {
                configHasError = true;
                LOG.error("There's something wrong with your Minecraft version setting.");
                encounteredErrors.add(this.I18N.getMessage("configuration.log.error.minecraft"));
            }
        } else {
            configHasError = true;
            LOG.error("There's something wrong with your Modloader or Modloader version setting.");
            encounteredErrors.add(this.I18N.getMessage("configuration.log.error.checkmodloader"));
        }
        if (quietCheck) {
            this.CONFIGUTILITIES.printConfigurationModel(configurationModel);
        }
        if (!configHasError) {
            LOG.info("Config check successful. No errors encountered.");
        } else {
            LOG.error("Config check not successful. Check your config for errors.");
            this.printEncounteredErrors(encounteredErrors);
        }
        this.ensureScriptSettingsDefaults(configurationModel);
        return configHasError;
    }

    private boolean isDir(ConfigurationModel configurationModel, List<String> encounteredErrors) {
        boolean configHasError = false;
        if (this.checkCopyDirs(configurationModel.getCopyDirs(), configurationModel.getModpackDir(), encounteredErrors)) {
            LOG.debug("copyDirs setting check passed.");
        } else {
            configHasError = true;
            LOG.error("There's something wrong with your setting of directories to include in your server pack.");
            encounteredErrors.add(this.I18N.getMessage("configuration.log.error.isdir.copydir"));
        }
        return configHasError;
    }

    private boolean isZip(ConfigurationModel configurationModel, List<String> encounteredErrors) throws IOException {
        boolean configHasError = false;
        String destination = String.format("./work/modpacks/%s", configurationModel.getModpackDir().substring(configurationModel.getModpackDir().lastIndexOf("/") + 1).substring(0, configurationModel.getModpackDir().substring(configurationModel.getModpackDir().lastIndexOf("/") + 1).length() - 4));
        if (this.checkZipArchive(Paths.get(configurationModel.getModpackDir(), new String[0]), encounteredErrors)) {
            return true;
        }
        destination = this.acquireDestination(destination);
        this.UTILITIES.FileUtils().unzipArchive(configurationModel.getModpackDir(), destination);
        List<String> newCopyDirs = this.CONFIGUTILITIES.suggestCopyDirs(destination);
        for (String entry : configurationModel.getCopyDirs()) {
            if (newCopyDirs.contains(entry)) continue;
            newCopyDirs.add(entry);
        }
        configurationModel.setCopyDirs(newCopyDirs);
        int amountOfErrors = encounteredErrors.size();
        String packName = this.checkManifests(destination, configurationModel, encounteredErrors);
        if (encounteredErrors.size() > amountOfErrors) {
            configHasError = true;
        }
        if (packName == null) {
            packName = destination;
        }
        packName = this.UTILITIES.StringUtils().pathSecureTextAlternative(packName.replace("\\", "/"));
        String wouldBeServerPack = new File(String.format("%s/%s", this.APPLICATIONPROPERTIES.getDirectoryServerPacks(), packName.substring(packName.lastIndexOf("/") + 1) + configurationModel.getServerPackSuffix())).getAbsolutePath().replace("\\", "/");
        packName = packName + "_" + this.getIncrementation(packName, wouldBeServerPack);
        FileUtils.moveDirectory(new File(destination), new File(packName));
        configurationModel.setModpackDir(packName);
        if (new File(packName + "/server-icon.png").exists()) {
            configurationModel.setServerIconPath(packName + "/server-icon.png");
        }
        if (new File(packName + "/server.properties").exists()) {
            configurationModel.setServerPropertiesPath(packName + "/server.properties");
        }
        return configHasError;
    }

    private String acquireDestination(String destination) {
        if (new File(destination).isDirectory()) {
            int incrementation = 0;
            if (destination.matches(".*_\\d")) {
                incrementation = Integer.parseInt(destination.substring(destination.length() - 1));
                while (new File(destination.substring(0, destination.length() - 1) + "_" + incrementation).isDirectory()) {
                    ++incrementation;
                }
                destination = destination.substring(0, destination.length() - 1) + "_" + incrementation;
            } else {
                while (new File(destination + "_" + incrementation).isDirectory()) {
                    ++incrementation;
                }
                destination = destination + "_" + incrementation;
            }
        }
        return destination;
    }

    private String checkManifests(String destination, ConfigurationModel configurationModel, List<String> encounteredErrors) {
        String packName;
        block27: {
            packName = null;
            if (new File(String.format("%s/manifest.json", destination)).exists()) {
                try {
                    this.CONFIGUTILITIES.updateConfigModelFromCurseManifest(configurationModel, new File(String.format("%s/manifest.json", destination)));
                    packName = this.updatePackName(configurationModel, "name");
                }
                catch (IOException ex) {
                    LOG.error("Error parsing CurseForge manifest.json from ZIP-file.", (Throwable)ex);
                    encounteredErrors.add(this.I18N.getMessage("configuration.log.error.zip.manifest"));
                }
            } else if (new File(String.format("%s/minecraftinstance.json", destination)).exists()) {
                try {
                    this.CONFIGUTILITIES.updateConfigModelFromMinecraftInstance(configurationModel, new File(String.format("%s/minecraftinstance.json", destination)));
                    packName = this.updatePackName(configurationModel, "name");
                }
                catch (IOException ex) {
                    LOG.error("Error parsing minecraftinstance.json from ZIP-file.", (Throwable)ex);
                    encounteredErrors.add(this.I18N.getMessage("configuration.log.error.zip.instance"));
                }
            } else if (new File(String.format("%s/modrinth.index.json", destination)).exists()) {
                try {
                    this.CONFIGUTILITIES.updateConfigModelFromModrinthManifest(configurationModel, new File(String.format("%s/modrinth.index.json", destination)));
                    packName = this.updatePackName(configurationModel, "name");
                }
                catch (IOException ex) {
                    LOG.error("Error parsing modrinth.index.json from ZIP-file.", (Throwable)ex);
                    encounteredErrors.add(this.I18N.getMessage("configuration.log.error.zip.config"));
                }
            } else if (new File(String.format("%s/instance.json", destination)).exists()) {
                try {
                    this.CONFIGUTILITIES.updateConfigModelFromATLauncherInstance(configurationModel, new File(String.format("%s/instance.json", destination)));
                    if (this.UTILITIES.JsonUtilities().getNestedText(configurationModel.getModpackJson(), "launcher", "name") == null) {
                        packName = this.UTILITIES.JsonUtilities().getNestedText(configurationModel.getModpackJson(), "launcher", "pack");
                        break block27;
                    }
                    packName = this.UTILITIES.JsonUtilities().getNestedText(configurationModel.getModpackJson(), "launcher", "name");
                }
                catch (IOException ex) {
                    LOG.error("Error parsing config.json from ZIP-file.", (Throwable)ex);
                    encounteredErrors.add(this.I18N.getMessage("configuration.log.error.zip.config"));
                }
            } else if (new File(String.format("%s/config.json", destination)).exists()) {
                try {
                    this.CONFIGUTILITIES.updateConfigModelFromConfigJson(configurationModel, new File(String.format("%s/config.json", destination)));
                    packName = this.UTILITIES.JsonUtilities().getNestedText(configurationModel.getModpackJson(), "loader", "sourceName");
                }
                catch (IOException ex) {
                    LOG.error("Error parsing config.json from ZIP-file.", (Throwable)ex);
                    encounteredErrors.add(this.I18N.getMessage("configuration.log.error.zip.config"));
                }
            } else if (new File(String.format("%s/mmc-pack.json", destination)).exists()) {
                try {
                    this.CONFIGUTILITIES.updateConfigModelFromMMCPack(configurationModel, new File(String.format("%s/mmc-pack.json", destination)));
                }
                catch (IOException ex) {
                    LOG.error("Error parsing mmc-pack.json from ZIP-file.", (Throwable)ex);
                    encounteredErrors.add(this.I18N.getMessage("configuration.log.error.zip.mmcpack"));
                }
                try {
                    String name;
                    if (new File(String.format("%s/instance.cfg", destination)).exists() && (name = this.CONFIGUTILITIES.updateDestinationFromInstanceCfg(new File(String.format("%s/instance.cfg", destination)))) != null) {
                        packName = name;
                    }
                }
                catch (IOException ex) {
                    LOG.error("Couldn't read instance.cfg.", (Throwable)ex);
                }
            }
        }
        return packName;
    }

    private String updatePackName(ConfigurationModel configurationModel, String ... childNodes) {
        try {
            return String.format("./work/modpacks/%s", this.UTILITIES.JsonUtilities().getNestedText(configurationModel.getModpackJson(), childNodes));
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    private int getIncrementation(String packName, String wouldBeServerPack) {
        int incrementation = 0;
        if (packName.matches(".*_\\d")) {
            if (wouldBeServerPack.matches(".*_\\d")) {
                while (new File(wouldBeServerPack.substring(0, wouldBeServerPack.length() - 1) + "_" + incrementation).isDirectory() || new File(packName.substring(0, packName.length() - 1) + "_" + incrementation).isDirectory()) {
                    ++incrementation;
                }
            } else {
                while (new File(wouldBeServerPack + "_" + incrementation).isDirectory() || new File(packName.substring(0, packName.length() - 1) + "_" + incrementation).isDirectory()) {
                    ++incrementation;
                }
            }
        } else if (wouldBeServerPack.matches(".*_\\d")) {
            while (new File(wouldBeServerPack.substring(0, wouldBeServerPack.length() - 1) + "_" + incrementation).isDirectory() || new File(packName + "_" + incrementation).isDirectory()) {
                ++incrementation;
            }
        } else {
            while (new File(wouldBeServerPack + "_" + incrementation).isDirectory() || new File(packName + "_" + incrementation).isDirectory()) {
                ++incrementation;
            }
        }
        return incrementation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkZipArchive(Path pathToZip, List<String> encounteredErrors) {
        ZipFile modpackZip;
        try (ZipFile zipFile = new ZipFile(pathToZip.toString());){
            if (!zipFile.isValidZipFile()) {
                boolean bl = true;
                return bl;
            }
            modpackZip = zipFile;
        }
        catch (IOException ex) {
            LOG.error("Could not validate ZIP-file " + pathToZip + ".", (Throwable)ex);
            return true;
        }
        try {
            List<String> foldersInModpackZip = this.CONFIGUTILITIES.getDirectoriesInModpackZipBaseDirectory(modpackZip);
            if (foldersInModpackZip.size() == 1) {
                LOG.error("The ZIP-file you specified only contains one directory: " + foldersInModpackZip.get(0) + ". ZIP-files for ServerPackCreator must be full modpacks, with all their contents being in the root of the ZIP-file.");
                encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.zip.overrides"), foldersInModpackZip.get(0)));
                return true;
            }
            if (foldersInModpackZip.contains("mods/")) {
                if (foldersInModpackZip.contains("config/")) return false;
            }
            LOG.error("The ZIP-file you specified does not contain the mods or config directories. What use is a modded server without mods and their configurations?");
            encounteredErrors.add(this.I18N.getMessage("configuration.log.error.zip.modsorconfig"));
            return true;
        }
        catch (IOException ex) {
            LOG.error("Couldn't acquire directories in ZIP-file.", (Throwable)ex);
            encounteredErrors.add(this.I18N.getMessage("configuration.log.error.zip.directories"));
            return true;
        }
    }

    private void ensureScriptSettingsDefaults(ConfigurationModel configurationModel) {
        HashMap<String, String> scriptSettings = configurationModel.getScriptSettings();
        if (!this.VERSIONMETA.minecraft().getServer(configurationModel.getMinecraftVersion()).isPresent() || !this.VERSIONMETA.minecraft().getServer(configurationModel.getMinecraftVersion()).get().url().isPresent()) {
            scriptSettings.put("SPC_MINECRAFT_SERVER_URL_SPC", "");
        } else {
            scriptSettings.put("SPC_MINECRAFT_SERVER_URL_SPC", this.VERSIONMETA.minecraft().getServer(configurationModel.getMinecraftVersion()).get().url().get().toString());
        }
        scriptSettings.put("SPC_SERVERPACKCREATOR_VERSION_SPC", this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION());
        scriptSettings.put("SPC_MINECRAFT_VERSION_SPC", configurationModel.getMinecraftVersion());
        scriptSettings.put("SPC_MODLOADER_SPC", configurationModel.getModLoader());
        scriptSettings.put("SPC_MODLOADER_VERSION_SPC", configurationModel.getModLoaderVersion());
        scriptSettings.put("SPC_JAVA_ARGS_SPC", configurationModel.getJavaArgs());
        scriptSettings.put("SPC_JAVA_SPC", "java");
        scriptSettings.put("SPC_FABRIC_INSTALLER_VERSION_SPC", this.VERSIONMETA.fabric().releaseInstaller());
        scriptSettings.put("SPC_QUILT_INSTALLER_VERSION_SPC", this.VERSIONMETA.quilt().releaseInstaller());
        scriptSettings.put("SPC_LEGACYFABRIC_INSTALLER_VERSION_SPC", this.VERSIONMETA.legacyFabric().releaseInstaller());
    }

    private void sanitizeLinks(ConfigurationModel configurationModel) {
        LOG.info("Checking configuration for links...");
        if (configurationModel.getModpackDir().length() > 0 && this.UTILITIES.FileUtils().isLink(configurationModel.getModpackDir())) {
            try {
                configurationModel.setModpackDir(this.UTILITIES.FileUtils().resolveLink(configurationModel.getModpackDir()));
                LOG.info("Resolved modpack directory link to: " + configurationModel.getModpackDir());
            }
            catch (InvalidFileTypeException | IOException ex) {
                LOG.error("Couldn't resolve link for modpack directory.", (Throwable)ex);
            }
        }
        if (configurationModel.getServerIconPath().length() > 0 && this.UTILITIES.FileUtils().isLink(configurationModel.getServerIconPath())) {
            try {
                configurationModel.setServerIconPath(this.UTILITIES.FileUtils().resolveLink(configurationModel.getServerIconPath()));
                LOG.info("Resolved server-icon link to: " + configurationModel.getServerIconPath());
            }
            catch (InvalidFileTypeException | IOException ex) {
                LOG.error("Couldn't resolve link for server-icon.", (Throwable)ex);
            }
        }
        if (configurationModel.getServerPropertiesPath().length() > 0 && this.UTILITIES.FileUtils().isLink(configurationModel.getServerPropertiesPath())) {
            try {
                configurationModel.setServerPropertiesPath(this.UTILITIES.FileUtils().resolveLink(configurationModel.getServerPropertiesPath()));
                LOG.info("Resolved server-properties link to: " + configurationModel.getServerPropertiesPath());
            }
            catch (InvalidFileTypeException | IOException ex) {
                LOG.error("Couldn't resolve link for server-properties.", (Throwable)ex);
            }
        }
        if (configurationModel.getJavaPath().length() > 0 && this.UTILITIES.FileUtils().isLink(configurationModel.getJavaPath())) {
            try {
                configurationModel.setJavaPath(this.UTILITIES.FileUtils().resolveLink(configurationModel.getJavaPath()));
                LOG.info("Resolved Java link to: " + configurationModel.getJavaPath());
            }
            catch (InvalidFileTypeException | IOException ex) {
                LOG.error("Couldn't resolve link for Java path.", (Throwable)ex);
            }
        }
        if (!configurationModel.getCopyDirs().isEmpty()) {
            ArrayList<String> copyDirs = new ArrayList<String>(configurationModel.getCopyDirs());
            boolean copyDirChanges = false;
            for (int i2 = 0; i2 < copyDirs.size(); ++i2) {
                if (((String)copyDirs.get(i2)).contains(";")) {
                    String[] entries = ((String)copyDirs.get(i2)).split(";");
                    if (this.UTILITIES.FileUtils().isLink(entries[0])) {
                        try {
                            copyDirs.set(i2, this.UTILITIES.FileUtils().resolveLink(entries[0]) + ";" + entries[1]);
                            LOG.info("Resolved copy-directories link to: " + (String)copyDirs.get(i2));
                            copyDirChanges = true;
                        }
                        catch (InvalidFileTypeException | IOException ex) {
                            LOG.error("Couldn't resolve link for copy-directories entry.", (Throwable)ex);
                        }
                        continue;
                    }
                    if (!this.UTILITIES.FileUtils().isLink(configurationModel.getModpackDir() + "/" + entries[0])) continue;
                    try {
                        copyDirs.set(i2, this.UTILITIES.FileUtils().resolveLink(configurationModel.getModpackDir() + "/" + entries[0]) + ";" + entries[1]);
                        LOG.info("Resolved copy-directories link to: " + (String)copyDirs.get(i2));
                        copyDirChanges = true;
                    }
                    catch (InvalidFileTypeException | IOException ex) {
                        LOG.error("Couldn't resolve link for copy-directories entry.", (Throwable)ex);
                    }
                    continue;
                }
                if (((String)copyDirs.get(i2)).startsWith("!")) {
                    if (this.UTILITIES.FileUtils().isLink(((String)copyDirs.get(i2)).substring(1))) {
                        try {
                            copyDirs.set(i2, "!" + this.UTILITIES.FileUtils().resolveLink(((String)copyDirs.get(i2)).substring(1)));
                            LOG.info("Resolved copy-directories link to: " + (String)copyDirs.get(i2));
                            copyDirChanges = true;
                        }
                        catch (InvalidFileTypeException | IOException ex) {
                            LOG.error("Couldn't resolve link for copy-directories entry.", (Throwable)ex);
                        }
                        continue;
                    }
                    if (!this.UTILITIES.FileUtils().isLink(configurationModel.getModpackDir() + "/" + ((String)copyDirs.get(i2)).substring(1))) continue;
                    try {
                        copyDirs.set(i2, this.UTILITIES.FileUtils().resolveLink("!" + configurationModel.getModpackDir() + "/" + ((String)copyDirs.get(i2)).substring(1)));
                        LOG.info("Resolved copy-directories link to: " + (String)copyDirs.get(i2));
                        copyDirChanges = true;
                    }
                    catch (InvalidFileTypeException | IOException ex) {
                        LOG.error("Couldn't resolve link for copy-directories entry.", (Throwable)ex);
                    }
                    continue;
                }
                if (this.UTILITIES.FileUtils().isLink((String)copyDirs.get(i2))) {
                    try {
                        copyDirs.set(i2, this.UTILITIES.FileUtils().resolveLink((String)copyDirs.get(i2)));
                        LOG.info("Resolved to: " + configurationModel.getModpackDir());
                        copyDirChanges = true;
                    }
                    catch (InvalidFileTypeException | IOException ex) {
                        LOG.error("Couldn't resolve link for modpack directory.", (Throwable)ex);
                    }
                    continue;
                }
                if (!this.UTILITIES.FileUtils().isLink(configurationModel.getModpackDir() + "/" + (String)copyDirs.get(i2))) continue;
                try {
                    copyDirs.set(i2, this.UTILITIES.FileUtils().resolveLink(configurationModel.getModpackDir() + "/" + (String)copyDirs.get(i2)));
                    LOG.info("Resolved copy-directories link to: " + (String)copyDirs.get(i2));
                    copyDirChanges = true;
                    continue;
                }
                catch (InvalidFileTypeException | IOException ex) {
                    LOG.error("Couldn't resolve link for copy-directories entry.", (Throwable)ex);
                }
            }
            if (copyDirChanges) {
                configurationModel.setCopyDirs(copyDirs);
            }
        }
    }

    private void printEncounteredErrors(List<String> encounteredErrors) {
        LOG.error("Encountered " + encounteredErrors.size() + " errors during the configuration check.");
        int encounteredErrorNumber = 0;
        for (int i2 = 0; i2 < encounteredErrors.size(); ++i2) {
            encounteredErrorNumber = i2 + 1;
            LOG.error("Error " + encounteredErrorNumber + ": " + encounteredErrors.get(i2));
        }
    }

    public boolean checkModpackDir(String modpackDir) {
        return this.checkModpackDir(modpackDir, new ArrayList<String>());
    }

    public boolean checkModpackDir(String modpackDir, List<String> encounteredErrors) {
        boolean configCorrect = false;
        if (modpackDir.isEmpty()) {
            LOG.error("Modpack directory not specified. Please specify an existing directory.");
            encounteredErrors.add(this.I18N.getMessage("configuration.log.error.checkmodpackdir"));
        } else if (!new File(modpackDir).isDirectory()) {
            LOG.warn("Couldn't find directory " + modpackDir + ".");
            encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.modpackdirectory"), modpackDir));
        } else {
            configCorrect = true;
        }
        return configCorrect;
    }

    public boolean checkCopyDirs(List<String> directoriesToCopy, String modpackDir) {
        return this.checkCopyDirs(directoriesToCopy, modpackDir, new ArrayList<String>());
    }

    public boolean checkCopyDirs(List<String> directoriesToCopy, String modpackDir, List<String> encounteredErrors) {
        boolean configCorrect = true;
        directoriesToCopy.removeIf(entry -> entry.matches("^\\s+$") || entry.length() == 0);
        if (directoriesToCopy.isEmpty()) {
            configCorrect = false;
            LOG.error("No directories or files specified for copying. This would result in an empty serverpack.");
            encounteredErrors.add(this.I18N.getMessage("configuration.log.error.checkcopydirs.empty"));
        } else if (directoriesToCopy.size() == 1 && directoriesToCopy.get(0).equals("lazy_mode")) {
            LOG.warn("!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!");
            LOG.warn("Lazy mode specified. This will copy the WHOLE modpack to the server pack. No exceptions.");
            LOG.warn("You will not receive support from me for a server pack generated this way.");
            LOG.warn("Do not open an issue on GitHub if this configuration errors or results in a broken server pack.");
            LOG.warn("!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!WARNING!!!");
        } else {
            if (directoriesToCopy.size() > 1 && directoriesToCopy.contains("lazy_mode")) {
                LOG.warn("You specified lazy mode in your configuration, but your copyDirs configuration contains other entries. To use the lazy mode, only specify \"lazy_mode\" and nothing else. Ignoring lazy mode.");
            }
            directoriesToCopy.removeIf(entry -> entry.equals("lazy_mode"));
            for (String directory : directoriesToCopy) {
                if (directory.contains(";")) {
                    File file;
                    int n;
                    int n2;
                    String[] sourceFileDestinationFileCombination = directory.split(";");
                    File sourceFileToCheck = new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0]));
                    if (!(new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).isFile() || new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).isDirectory() || new File(sourceFileDestinationFileCombination[0]).isFile() || new File(sourceFileDestinationFileCombination[0]).isDirectory())) {
                        configCorrect = false;
                        LOG.error("Copy-file " + sourceFileToCheck + " does not exist. Please specify existing files.");
                        encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.filenotfound"), sourceFileToCheck));
                        continue;
                    }
                    if (new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).exists() && !this.UTILITIES.FileUtils().checkReadPermission(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0]))) {
                        configCorrect = false;
                        LOG.error("No read-permission for " + String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0]));
                        encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])));
                    } else if (new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).exists() && !this.UTILITIES.FileUtils().checkReadPermission(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0]))) {
                        configCorrect = false;
                        LOG.error("No read-permission for " + String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0]));
                        encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])));
                    } else if (new File(sourceFileDestinationFileCombination[0]).exists() && !this.UTILITIES.FileUtils().checkReadPermission(sourceFileDestinationFileCombination[0])) {
                        configCorrect = false;
                        LOG.error("No read-permission for " + sourceFileDestinationFileCombination[0]);
                        encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), sourceFileDestinationFileCombination[0]));
                    }
                    if (new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).isDirectory()) {
                        File[] fileArray = new File(String.format("%s/%s", modpackDir, sourceFileDestinationFileCombination[0])).listFiles();
                        n2 = fileArray.length;
                        for (n = 0; n < n2; ++n) {
                            file = fileArray[n];
                            if (this.UTILITIES.FileUtils().checkReadPermission(file)) continue;
                            configCorrect = false;
                            LOG.error("No read-permission for " + file);
                            encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), file));
                        }
                        continue;
                    }
                    if (!new File(sourceFileDestinationFileCombination[0]).isDirectory()) continue;
                    File[] fileArray = new File(sourceFileDestinationFileCombination[0]).listFiles();
                    n2 = fileArray.length;
                    for (n = 0; n < n2; ++n) {
                        file = fileArray[n];
                        if (this.UTILITIES.FileUtils().checkReadPermission(file)) continue;
                        configCorrect = false;
                        LOG.error("No read-permission for " + file);
                        encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), file));
                    }
                    continue;
                }
                if (directory.startsWith("!")) {
                    File fileOrDirectory = new File(String.format("%s/%s", modpackDir, directory.substring(1)));
                    if (fileOrDirectory.isFile()) {
                        LOG.warn("File " + directory.substring(1) + " will be ignored.");
                        continue;
                    }
                    if (fileOrDirectory.isDirectory()) {
                        LOG.warn("Directory " + directory.substring(1) + " will be ignored.");
                        continue;
                    }
                    LOG.debug("What? " + fileOrDirectory + " is neither a file nor directory.");
                    continue;
                }
                File dirToCheck = new File(String.format("%s/%s", modpackDir, directory));
                if (!(dirToCheck.exists() || new File(directory).exists() || new File(directory).isFile() || new File(directory).isDirectory())) {
                    configCorrect = false;
                    LOG.error("Copy-file or copy-directory " + directory + " does not exist. Please specify existing directories or files.");
                    encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.notfound"), directory));
                    continue;
                }
                if (dirToCheck.exists() && !this.UTILITIES.FileUtils().checkReadPermission(dirToCheck)) {
                    configCorrect = false;
                    LOG.error("No read-permission for " + dirToCheck);
                    encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), dirToCheck));
                } else if (new File(directory).exists() && !this.UTILITIES.FileUtils().checkReadPermission(directory)) {
                    configCorrect = false;
                    LOG.error("No read-permission for " + directory);
                    encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), directory));
                }
                if (dirToCheck.isDirectory()) {
                    for (File file : dirToCheck.listFiles()) {
                        if (this.UTILITIES.FileUtils().checkReadPermission(file)) continue;
                        configCorrect = false;
                        LOG.error("No read-permission for " + file);
                        encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), file));
                    }
                    continue;
                }
                if (!new File(directory).isDirectory()) continue;
                for (File file : new File(directory).listFiles()) {
                    if (this.UTILITIES.FileUtils().checkReadPermission(file)) continue;
                    configCorrect = false;
                    LOG.error("No read-permission for " + file);
                    encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkcopydirs.read"), file));
                }
            }
        }
        return configCorrect;
    }

    public boolean checkIconAndProperties(String iconOrPropertiesPath) {
        if (iconOrPropertiesPath.isEmpty()) {
            return true;
        }
        return new File(iconOrPropertiesPath).exists();
    }

    public boolean checkJavaPath(String pathToJava) {
        if (pathToJava.length() == 0) {
            return false;
        }
        FileUtilities.FileType type = this.UTILITIES.FileUtils().checkFileType(pathToJava);
        switch (type) {
            case FILE: {
                return this.testJava(pathToJava);
            }
            case LINK: 
            case SYMLINK: {
                try {
                    return this.testJava(this.UTILITIES.FileUtils().resolveLink(new File(pathToJava)));
                }
                catch (InvalidFileTypeException | IOException ex) {
                    LOG.error("Could not read link/symlink.", (Throwable)ex);
                    return false;
                }
            }
            case DIRECTORY: {
                LOG.error("Directory specified. Path to Java must lead to a lnk, symlink or file.");
            }
        }
        return false;
    }

    public boolean testJava(String pathToJava) {
        boolean testSuccessful;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new ArrayList<String>(Arrays.asList(pathToJava, "-version")));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (bufferedReader.readLine() != null && !bufferedReader.readLine().equals("null")) {
                System.out.println(bufferedReader.readLine());
            }
            bufferedReader.close();
            process.destroyForcibly();
            testSuccessful = true;
        }
        catch (IOException e) {
            LOG.error("Invalid Java specified.");
            testSuccessful = false;
        }
        return testSuccessful;
    }

    public String getJavaPath(String pathToJava) {
        String checkedJavaPath;
        try {
            if (pathToJava.length() > 0) {
                if (this.checkJavaPath(pathToJava)) {
                    return pathToJava;
                }
                if (this.checkJavaPath(pathToJava + ".exe")) {
                    return pathToJava + ".exe";
                }
                if (this.checkJavaPath(pathToJava + ".lnk")) {
                    return this.UTILITIES.FileUtils().resolveLink(new File(pathToJava + ".lnk"));
                }
            }
            LOG.info("Java setting invalid or otherwise not usable. Using system default.");
            LOG.debug("Acquiring path to Java installation from system properties...");
            checkedJavaPath = this.UTILITIES.SystemUtils().acquireJavaPathFromSystem();
            LOG.debug("Automatically acquired path to Java installation: " + checkedJavaPath);
        }
        catch (InvalidFileTypeException | IOException | NullPointerException ex) {
            LOG.info("Java setting invalid or otherwise not usable. using system default.");
            checkedJavaPath = this.UTILITIES.SystemUtils().acquireJavaPathFromSystem();
            LOG.debug("Automatically acquired path to Java installation: " + checkedJavaPath, (Throwable)ex);
        }
        return checkedJavaPath;
    }

    public boolean checkModloader(String modloader) {
        if (modloader.toLowerCase().matches("^forge$") || modloader.toLowerCase().matches("^fabric$") || modloader.toLowerCase().matches("^quilt$") || modloader.toLowerCase().matches("^legacyfabric$")) {
            return true;
        }
        LOG.error("Invalid modloader specified. Modloader must be either Forge, Fabric or Quilt.");
        return false;
    }

    public boolean checkModloaderVersion(String modloader, String modloaderVersion, String minecraftVersion) {
        return this.checkModloaderVersion(modloader, modloaderVersion, minecraftVersion, new ArrayList<String>());
    }

    public boolean checkModloaderVersion(String modloader, String modloaderVersion, String minecraftVersion, List<String> encounteredErrors) {
        switch (modloader) {
            case "Forge": {
                if (this.VERSIONMETA.forge().checkForgeAndMinecraftVersion(minecraftVersion, modloaderVersion)) {
                    return true;
                }
                encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkmodloaderandversion"), minecraftVersion, modloader, modloaderVersion));
                return false;
            }
            case "Fabric": {
                if (this.VERSIONMETA.fabric().isVersionValid(modloaderVersion) && this.VERSIONMETA.fabric().getLoaderDetails(minecraftVersion, modloaderVersion).isPresent()) {
                    return true;
                }
                encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkmodloaderandversion"), minecraftVersion, modloader, modloaderVersion));
                return false;
            }
            case "Quilt": {
                if (this.VERSIONMETA.quilt().isVersionValid(modloaderVersion) && this.VERSIONMETA.fabric().isMinecraftSupported(minecraftVersion)) {
                    return true;
                }
                encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkmodloaderandversion"), minecraftVersion, modloader, modloaderVersion));
                return false;
            }
            case "LegacyFabric": {
                if (this.VERSIONMETA.legacyFabric().isVersionValid(modloaderVersion) && this.VERSIONMETA.legacyFabric().isMinecraftSupported(minecraftVersion)) {
                    return true;
                }
                encounteredErrors.add(String.format(this.I18N.getMessage("configuration.log.error.checkmodloaderandversion"), minecraftVersion, modloader, modloaderVersion));
                return false;
            }
        }
        LOG.error("Specified incorrect modloader version. Please check your modpack for the correct version and enter again.");
        return false;
    }
}

