/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import com.jhlabs.composite.RGBComposite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;

public final class ColorDodgeComposite
extends RGBComposite {
    public ColorDodgeComposite(float alpha) {
        super(alpha);
    }

    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new Context(this.extraAlpha, srcColorModel, dstColorModel);
    }

    static class Context
    extends RGBComposite.RGBCompositeContext {
        public Context(float alpha, ColorModel srcColorModel, ColorModel dstColorModel) {
            super(alpha, srcColorModel, dstColorModel);
        }

        public void composeRGB(int[] src, int[] dst, float alpha) {
            int w = src.length;
            for (int i2 = 0; i2 < w; i2 += 4) {
                int sr = src[i2];
                int dir = dst[i2];
                int sg = src[i2 + 1];
                int dig = dst[i2 + 1];
                int sb = src[i2 + 2];
                int dib = dst[i2 + 2];
                int sa = src[i2 + 3];
                int dia = dst[i2 + 3];
                int dor = sr != 255 ? Math.min((dir << 8) / (255 - sr), 255) : sr;
                int dog = sg != 255 ? Math.min((dig << 8) / (255 - sg), 255) : sg;
                int dob = sb != 255 ? Math.min((dib << 8) / (255 - sb), 255) : sb;
                float a = alpha * (float)sa / 255.0f;
                float ac = 1.0f - a;
                dst[i2] = (int)(a * (float)dor + ac * (float)dir);
                dst[i2 + 1] = (int)(a * (float)dog + ac * (float)dig);
                dst[i2 + 2] = (int)(a * (float)dob + ac * (float)dib);
                dst[i2 + 3] = (int)((float)sa * alpha + (float)dia * ac);
            }
        }
    }
}

