/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectanglePainter
extends AbstractAreaPainter<Object> {
    private boolean rounded = false;
    private int roundWidth = 20;
    private int roundHeight = 20;
    private int width = -1;
    private int height = -1;

    public RectanglePainter() {
        this(0, 0, 0, 0, 0, 0, false, Color.RED, 1.0f, Color.BLACK);
    }

    public RectanglePainter(Color fillPaint, Color borderPaint) {
        this(0, 0, 0, 0, 0, 0, false, fillPaint, 1.0f, borderPaint);
    }

    public RectanglePainter(Paint fillPaint, Paint borderPaint, float borderWidth, AbstractAreaPainter.Style style) {
        this();
        this.setFillPaint(fillPaint);
        this.setBorderPaint(borderPaint);
        this.setBorderWidth(borderWidth);
        this.setStyle(style);
    }

    public RectanglePainter(int top, int left, int bottom, int right) {
        this(top, left, bottom, right, 0, 0, false, Color.RED, 1.0f, Color.BLACK);
    }

    public RectanglePainter(int top, int left, int bottom, int right, int roundWidth, int roundHeight) {
        this(top, left, bottom, right, roundWidth, roundHeight, true, Color.RED, 1.0f, Color.BLACK);
    }

    public RectanglePainter(int width, int height, int cornerRadius, Paint fillPaint) {
        this(new Insets(0, 0, 0, 0), width, height, cornerRadius, cornerRadius, true, fillPaint, 1.0f, Color.BLACK);
    }

    public RectanglePainter(Insets insets, int width, int height, int roundWidth, int roundHeight, boolean rounded, Paint fillPaint, float strokeWidth, Paint borderPaint) {
        this.width = width;
        this.height = height;
        this.setFillHorizontal(false);
        this.setFillVertical(false);
        this.setInsets(insets);
        this.roundWidth = roundWidth;
        this.roundHeight = roundHeight;
        this.rounded = rounded;
        this.setFillPaint(fillPaint);
        this.setBorderWidth(strokeWidth);
        this.setBorderPaint(borderPaint);
    }

    public RectanglePainter(int top, int left, int bottom, int right, int roundWidth, int roundHeight, boolean rounded, Paint fillPaint, float strokeWidth, Paint borderPaint) {
        this.setInsets(new Insets(top, left, bottom, right));
        this.setFillVertical(true);
        this.setFillHorizontal(true);
        this.roundWidth = roundWidth;
        this.roundHeight = roundHeight;
        this.rounded = rounded;
        this.setFillPaint(fillPaint);
        this.setBorderWidth(strokeWidth);
        this.setBorderPaint(borderPaint);
    }

    public boolean isRounded() {
        return this.rounded;
    }

    public void setRounded(boolean rounded) {
        boolean oldRounded = this.isRounded();
        this.rounded = rounded;
        this.setDirty(true);
        this.firePropertyChange("rounded", oldRounded, rounded);
    }

    public int getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(int roundWidth) {
        int oldRoundWidth = this.getRoundWidth();
        this.roundWidth = roundWidth;
        this.setDirty(true);
        this.firePropertyChange("roundWidth", oldRoundWidth, roundWidth);
    }

    public int getRoundHeight() {
        return this.roundHeight;
    }

    public void setRoundHeight(int roundHeight) {
        int oldRoundHeight = this.getRoundHeight();
        this.roundHeight = roundHeight;
        this.setDirty(true);
        this.firePropertyChange("roundHeight", oldRoundHeight, roundHeight);
    }

    protected RectangularShape calculateShape(int width, int height) {
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        Rectangle bounds = this.calculateLayout(this.width, this.height, width, height);
        if (this.width != -1 && !this.isFillHorizontal()) {
            width = this.width;
            x = bounds.x;
        }
        if (this.height != -1 && !this.isFillVertical()) {
            height = this.height;
            y = bounds.y;
        }
        if (this.isFillHorizontal()) {
            width = width - insets.left - insets.right;
        }
        if (this.isFillVertical()) {
            height = height - insets.top - insets.bottom;
        }
        RectangularShape shape = new Rectangle2D.Double(x, y, width, height);
        if (this.rounded) {
            shape = new RoundRectangle2D.Double(x, y, width, height, this.roundWidth, this.roundHeight);
        }
        return shape;
    }

    @Override
    protected void doPaint(Graphics2D g2, Object component, int width, int height) {
        Shape shape = this.provideShape(g2, component, width, height);
        switch (this.getStyle()) {
            case BOTH: {
                this.drawBackground(g2, shape, width, height);
                this.drawBorder(g2, shape, width, height);
                break;
            }
            case FILLED: {
                this.drawBackground(g2, shape, width, height);
                break;
            }
            case OUTLINE: {
                this.drawBorder(g2, shape, width, height);
                break;
            }
        }
        GraphicsUtilities.mergeClip(g2, shape);
    }

    private void drawBorder(Graphics2D g2, Shape shape, int width, int height) {
        Paint p = this.getBorderPaint();
        if (this.isPaintStretched()) {
            p = this.calculateSnappedPaint(p, width, height);
        }
        g2.setPaint(p);
        g2.setStroke(new BasicStroke(this.getBorderWidth()));
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            g2.draw(new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth() - 1.0, rect.getHeight() - 1.0));
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D rect = (RoundRectangle2D)shape;
            g2.draw(new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth() - 1.0, rect.getHeight() - 1.0, rect.getArcWidth(), rect.getArcHeight()));
        } else {
            g2.draw(shape);
        }
    }

    private void drawBackground(Graphics2D g2, Shape shape, int width, int height) {
        Paint p = this.getFillPaint();
        if (this.isPaintStretched()) {
            p = this.calculateSnappedPaint(p, width, height);
        }
        g2.setPaint(p);
        g2.fill(shape);
        if (this.getAreaEffects() != null) {
            for (AreaEffect ef : this.getAreaEffects()) {
                ef.apply(g2, shape, width, height);
            }
        }
    }

    @Override
    protected Shape provideShape(Graphics2D g2, Object comp, int width, int height) {
        return this.calculateShape(width, height);
    }
}

