/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.spi.core.security.jaas.AuditLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.jboss.logging.Logger;

public class InVMLoginModule
implements AuditLoginModule {
    private static final Logger logger = Logger.getLogger(InVMLoginModule.class);
    public static final String CONFIG_PROP_NAME = "org.apache.activemq.jaas.invm.config";
    private SecurityConfiguration configuration;
    private Subject subject;
    private String user;
    private final Set<Principal> principals = new HashSet<Principal>();
    private CallbackHandler callbackHandler;
    private boolean loginSucceeded;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.configuration = (SecurityConfiguration)options.get(CONFIG_PROP_NAME);
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if (this.user == null) {
            if (this.configuration.getDefaultUser() == null) {
                throw new FailedLoginException("Both username and defaultUser are null");
            }
            this.user = this.configuration.getDefaultUser();
        } else {
            String password;
            String string = password = this.configuration.getUser(this.user) == null ? null : this.configuration.getUser(this.user).getPassword();
            if (password == null) {
                throw new FailedLoginException("User does not exist");
            }
            if (!password.equals(new String(tmpPassword))) {
                throw new FailedLoginException("Password does not match");
            }
        }
        this.loginSucceeded = true;
        logger.debug("login " + this.user);
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.loginSucceeded;
        if (result) {
            this.principals.add(new UserPrincipal(this.user));
            List<String> roles = this.configuration.getRole(this.user);
            if (roles != null) {
                for (String role : roles) {
                    this.principals.add(new RolePrincipal(role));
                }
            }
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.clear();
        logger.debug("commit, result: " + result);
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        this.registerFailureForAudit(this.user);
        this.clear();
        logger.debug("abort");
        return true;
    }

    private void clear() {
        this.user = null;
        this.loginSucceeded = false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        logger.debug("logout");
        return true;
    }
}

