/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.quilt;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;

final class QuiltInstaller {
    private final String URL_TEMPLATE_INSTALLER = "https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/%s/quilt-installer-%s.jar";
    private final List<String> installers = new ArrayList<String>();
    private String latestInstaller;
    private String releaseInstaller;
    private URL latestInstallerUrl;
    private URL releaseInstallerUrl;
    private HashMap<String, URL> installerUrlMeta;

    QuiltInstaller(Document installerManifest) {
        this.latestInstaller = installerManifest.getElementsByTagName("latest").item(0).getChildNodes().item(0).getNodeValue();
        this.releaseInstaller = installerManifest.getElementsByTagName("release").item(0).getChildNodes().item(0).getNodeValue();
        try {
            this.latestInstallerUrl = new URL(String.format("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/%s/quilt-installer-%s.jar", this.latestInstaller, this.latestInstaller));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            this.releaseInstallerUrl = new URL(String.format("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/%s/quilt-installer-%s.jar", this.releaseInstaller, this.releaseInstaller));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.installers.clear();
        for (int i2 = 0; i2 < installerManifest.getElementsByTagName("version").getLength(); ++i2) {
            this.installers.add(installerManifest.getElementsByTagName("version").item(i2).getChildNodes().item(0).getNodeValue());
        }
        this.installerUrlMeta = new HashMap();
        this.installers.forEach(version -> {
            try {
                this.installerUrlMeta.put((String)version, this.installerUrl((String)version));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        });
    }

    void update(Document installerManifest) {
        this.latestInstaller = installerManifest.getElementsByTagName("latest").item(0).getChildNodes().item(0).getNodeValue();
        this.releaseInstaller = installerManifest.getElementsByTagName("release").item(0).getChildNodes().item(0).getNodeValue();
        try {
            this.latestInstallerUrl = new URL(String.format("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/%s/quilt-installer-%s.jar", this.latestInstaller, this.latestInstaller));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            this.releaseInstallerUrl = new URL(String.format("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/%s/quilt-installer-%s.jar", this.releaseInstaller, this.releaseInstaller));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.installers.clear();
        for (int i2 = 0; i2 < installerManifest.getElementsByTagName("version").getLength(); ++i2) {
            this.installers.add(installerManifest.getElementsByTagName("version").item(i2).getChildNodes().item(0).getNodeValue());
        }
        this.installerUrlMeta = new HashMap();
        this.installers.forEach(version -> {
            try {
                this.installerUrlMeta.put((String)version, this.installerUrl((String)version));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        });
    }

    private URL installerUrl(String quiltInstallerVersion) throws MalformedURLException {
        return new URL(String.format("https://maven.quiltmc.org/repository/release/org/quiltmc/quilt-installer/%s/quilt-installer-%s.jar", quiltInstallerVersion, quiltInstallerVersion));
    }

    List<String> installers() {
        return this.installers;
    }

    HashMap<String, URL> meta() {
        return this.installerUrlMeta;
    }

    String latestInstallerVersion() {
        return this.latestInstaller;
    }

    String releaseInstallerVersion() {
        return this.releaseInstaller;
    }

    URL latestInstallerUrl() {
        return this.latestInstallerUrl;
    }

    URL releaseInstallerUrl() {
        return this.releaseInstallerUrl;
    }
}

