/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.minecraft;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.versionmeta.Type;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;

public final class MinecraftServer {
    private final ObjectMapper OBJECT_MAPPER;
    private final URL MANIFEST_URL;
    private final String VERSION;
    private final Type TYPE;
    private JsonNode serverJson = null;

    MinecraftServer(String mcVersion, Type mcType, URL mcUrl, ObjectMapper objectMapper) {
        this.MANIFEST_URL = mcUrl;
        this.VERSION = mcVersion;
        this.TYPE = mcType;
        this.OBJECT_MAPPER = objectMapper;
    }

    private void setServerJson() {
        try {
            this.serverJson = this.OBJECT_MAPPER.readTree(this.MANIFEST_URL.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String version() {
        return this.VERSION;
    }

    public Type type() {
        return this.TYPE;
    }

    public Optional<URL> url() {
        if (this.serverJson == null) {
            this.setServerJson();
        }
        try {
            return Optional.of(new URL(this.serverJson.get("downloads").get("server").get("url").asText()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<Byte> javaVersion() {
        if (this.serverJson == null) {
            this.setServerJson();
        }
        try {
            return Optional.of(Byte.parseByte(this.serverJson.get("javaVersion").get("majorVersion").asText()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

