/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultQueryEnhancer;
import org.springframework.data.jpa.repository.query.JSqlParserQueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancer;

public final class QueryEnhancerFactory {
    private static final Log LOG = LogFactory.getLog(QueryEnhancerFactory.class);
    private static final boolean JSQLPARSER_IN_CLASSPATH = QueryEnhancerFactory.isJSqlParserInClassPath();

    private QueryEnhancerFactory() {
    }

    public static QueryEnhancer forQuery(DeclaredQuery query2) {
        if (QueryEnhancerFactory.qualifiesForJSqlParserUsage(query2)) {
            return new JSqlParserQueryEnhancer(query2);
        }
        return new DefaultQueryEnhancer(query2);
    }

    private static boolean qualifiesForJSqlParserUsage(DeclaredQuery query2) {
        return JSQLPARSER_IN_CLASSPATH && query2.isNativeQuery();
    }

    private static boolean isJSqlParserInClassPath() {
        try {
            Class.forName("net.sf.jsqlparser.parser.JSqlParser", false, QueryEnhancerFactory.class.getClassLoader());
            LOG.info("JSqlParser is in classpath. If applicable JSqlParser will be used.");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

