/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.util.AsciiString;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SubmitToThreadPool;

public class MaxOneThreadPerSender
extends SubmitToThreadPool {
    protected final MessageTable mcasts = new MessageTable();
    protected final MessageTable ucasts = new MessageTable();
    @Property(description="Max number of messages buffered for consumption of the delivery thread in MaxOneThreadPerSender. 0 creates an unbounded buffer")
    protected int max_buffer_size;

    @ManagedOperation(description="Dumps unicast and multicast tables")
    public String dump() {
        return String.format("\nmcasts:\n%s\nucasts:\n%s", this.mcasts, this.ucasts);
    }

    @Override
    public void reset() {
        this.mcasts.map.values().forEach(Entry::reset);
        this.ucasts.map.values().forEach(Entry::reset);
    }

    @Override
    public void init(TP transport) {
        super.init(transport);
    }

    @Override
    public void destroy() {
        this.mcasts.clear();
        this.ucasts.clear();
    }

    @Override
    public boolean loopback(Message msg, boolean oob) {
        if (oob) {
            return super.loopback(msg, oob);
        }
        MessageTable table = msg.getDest() == null ? this.mcasts : this.ucasts;
        return table.process(msg, true);
    }

    @Override
    public boolean process(Message msg, boolean oob) {
        if (oob) {
            return super.process(msg, oob);
        }
        MessageTable table = msg.getDest() == null ? this.mcasts : this.ucasts;
        return table.process(msg, false);
    }

    @Override
    public boolean process(MessageBatch batch, boolean oob) {
        if (oob) {
            return super.process(batch, oob);
        }
        MessageTable table = batch.dest() == null ? this.mcasts : this.ucasts;
        return table.process(batch);
    }

    public void viewChange(List<Address> members) {
        this.mcasts.viewChange(members);
        this.ucasts.viewChange(members);
    }

    protected class MessageTable {
        protected final ConcurrentMap<Address, Entry> map = new ConcurrentHashMap<Address, Entry>();

        protected Entry get(Address sender, boolean multicast) {
            return this.map.computeIfAbsent(sender, s2 -> new Entry(sender, multicast, MaxOneThreadPerSender.this.tp.getClusterNameAscii()));
        }

        protected void clear() {
            this.map.clear();
        }

        protected boolean process(Message msg, boolean loopback) {
            Address dest = msg.getDest();
            Address sender = msg.getSrc();
            return this.get(sender, dest == null).process(msg, loopback);
        }

        protected boolean process(MessageBatch batch) {
            Address dest = batch.dest();
            Address sender = batch.sender();
            return this.get(sender, dest == null).process(batch);
        }

        protected void viewChange(List<Address> mbrs) {
            this.map.keySet().retainAll(mbrs);
        }

        public String toString() {
            return this.map.entrySet().stream().collect(StringBuilder::new, (sb, e) -> sb.append(e).append("\n"), (a, b) -> {}).toString();
        }
    }

    public class BatchHandlerLoop
    extends SubmitToThreadPool.BatchHandler {
        protected final Entry entry;
        protected final boolean loopback;

        public BatchHandlerLoop(MessageBatch batch, Entry entry, boolean loopback) {
            super(MaxOneThreadPerSender.this, batch);
            this.entry = entry;
            this.loopback = loopback;
        }

        @Override
        public void run() {
            do {
                try {
                    super.run();
                }
                catch (Throwable t) {
                    MaxOneThreadPerSender.this.log.error("failed processing batch", t);
                }
            } while (this.entry.workAvailable(this.batch));
        }

        @Override
        protected void passBatchUp() {
            MaxOneThreadPerSender.this.tp.passBatchUp(this.batch, !this.loopback, !this.loopback);
        }
    }

    protected class Entry {
        protected final Lock lock = new ReentrantLock();
        protected boolean running;
        protected final boolean mcast;
        protected final MessageBatch batch;
        protected final Address sender;
        protected final AsciiString cluster_name;
        protected long submitted_msgs;
        protected long submitted_batches;
        protected long queued_msgs;
        protected long queued_batches;

        protected Entry(Address sender, boolean mcast2, AsciiString cluster_name) {
            this.mcast = mcast2;
            this.sender = sender;
            this.cluster_name = cluster_name;
            int cap = MaxOneThreadPerSender.this.max_buffer_size > 0 ? MaxOneThreadPerSender.this.max_buffer_size : 16;
            this.batch = new MessageBatch(cap).dest(MaxOneThreadPerSender.this.tp.getAddress()).sender(sender).clusterName(cluster_name).multicast(mcast2);
        }

        public Entry reset() {
            this.queued_batches = 0L;
            this.queued_msgs = 0L;
            this.submitted_batches = 0L;
            this.submitted_msgs = 0L;
            return this;
        }

        protected boolean process(Message msg, boolean loopback) {
            if (!this.allowedToSubmitToThreadPool(msg)) {
                return false;
            }
            return this.submit(msg, loopback);
        }

        protected boolean process(MessageBatch batch) {
            if (!this.allowedToSubmitToThreadPool(batch)) {
                return false;
            }
            return this.submit(batch);
        }

        protected boolean submit(Message msg, boolean loopback) {
            try {
                ++this.submitted_msgs;
                MessageBatch mb = new MessageBatch(16).sender(this.sender).dest(this.mcast ? null : MaxOneThreadPerSender.this.tp.getAddress()).clusterName(this.cluster_name).multicast(this.mcast).add(msg);
                BatchHandlerLoop handler = new BatchHandlerLoop(mb, this, loopback);
                if (!MaxOneThreadPerSender.this.tp.getThreadPool().execute(handler)) {
                    this.setRunning(false);
                    return false;
                }
                return true;
            }
            catch (Throwable t) {
                this.setRunning(false);
                return false;
            }
        }

        protected boolean submit(MessageBatch batch) {
            try {
                ++this.submitted_batches;
                MessageBatch mb = new MessageBatch(batch.size()).sender(this.sender).dest(this.mcast ? null : MaxOneThreadPerSender.this.tp.getAddress()).clusterName(this.cluster_name).multicast(this.mcast);
                mb.add(batch);
                BatchHandlerLoop handler = new BatchHandlerLoop(mb, this, false);
                if (!MaxOneThreadPerSender.this.tp.getThreadPool().execute(handler)) {
                    this.setRunning(false);
                    return false;
                }
                return true;
            }
            catch (Throwable t) {
                this.setRunning(false);
                return false;
            }
        }

        protected boolean allowedToSubmitToThreadPool(Message msg) {
            this.lock.lock();
            try {
                if (!this.running) {
                    this.running = true;
                    boolean bl = true;
                    return bl;
                }
                this.batch.add(msg, MaxOneThreadPerSender.this.max_buffer_size == 0);
                ++this.queued_msgs;
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected boolean allowedToSubmitToThreadPool(MessageBatch msg_batch) {
            this.lock.lock();
            try {
                if (!this.running) {
                    this.running = true;
                    boolean bl = true;
                    return bl;
                }
                this.batch.add(msg_batch, MaxOneThreadPerSender.this.max_buffer_size == 0);
                ++this.queued_batches;
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean workAvailable(MessageBatch msg_batch) {
            this.lock.lock();
            try {
                boolean bl;
                int num_msgs = msg_batch.transferFrom(this.batch, true);
                if (num_msgs <= 0) {
                    this.running = false;
                    bl = false;
                } else {
                    bl = true;
                }
                boolean bl2 = bl;
                return bl2;
            }
            catch (Throwable t) {
                this.running = false;
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void setRunning(boolean flag) {
            this.lock.lock();
            try {
                this.running = flag;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return String.format("batch size=%d queued msgs=%d queued batches=%d submitted msgs=%d submitted batches=%d", this.batch.size(), this.queued_msgs, this.queued_batches, this.submitted_msgs, this.submitted_batches);
        }
    }
}

