/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class RouterStubManager
implements Runnable,
RouterStub.CloseListener {
    protected volatile List<RouterStub> stubs = new ArrayList<RouterStub>();
    protected final TimeScheduler timer;
    protected final String cluster_name;
    protected final Address local_addr;
    protected final String logical_name;
    protected final PhysicalAddress phys_addr;
    protected final long interval;
    protected boolean use_nio = true;
    protected Future<?> reconnector_task;
    protected final Log log;
    private SocketFactory socket_factory;

    public RouterStubManager(Protocol owner, String cluster_name, Address local_addr, String logical_name, PhysicalAddress phys_addr, long interval) {
        this.log = LogFactory.getLog(owner.getClass());
        this.timer = owner.getTransport().getTimer();
        this.cluster_name = cluster_name;
        this.local_addr = local_addr;
        this.logical_name = logical_name;
        this.phys_addr = phys_addr;
        this.interval = interval;
    }

    public static RouterStubManager emptyGossipClientStubManager(Protocol p) {
        return new RouterStubManager(p, null, null, null, null, 0L);
    }

    public RouterStubManager useNio(boolean flag) {
        this.use_nio = flag;
        return this;
    }

    public RouterStubManager socketFactory(SocketFactory socket_factory) {
        this.socket_factory = socket_factory;
        return this;
    }

    public void forEach(Consumer<RouterStub> action) {
        this.stubs.stream().filter(RouterStub::isConnected).forEach(action);
    }

    public void forAny(Consumer<RouterStub> action) {
        while (!this.stubs.isEmpty()) {
            RouterStub stub = Util.pickRandomElement(this.stubs);
            if (stub == null || !stub.isConnected()) continue;
            action.accept(stub);
            return;
        }
    }

    public RouterStub createAndRegisterStub(InetSocketAddress local, InetSocketAddress router_addr) {
        RouterStub stub = new RouterStub(local, router_addr, this.use_nio, this, this.socket_factory);
        this.stubs.add(stub);
        return stub;
    }

    public RouterStub unregisterStub(InetSocketAddress router_addr_sa) {
        RouterStub s2 = this.stubs.stream().filter(st -> Objects.equals(st.remote_sa, router_addr_sa)).findFirst().orElse(null);
        if (s2 != null) {
            s2.destroy();
            this.stubs.remove(s2);
        }
        return s2;
    }

    public void connectStubs() {
        boolean failed_connect_attempts = false;
        for (RouterStub stub : this.stubs) {
            if (stub.isConnected()) continue;
            try {
                stub.connect(this.cluster_name, this.local_addr, this.logical_name, this.phys_addr);
            }
            catch (Exception ex) {
                failed_connect_attempts = true;
            }
        }
        if (failed_connect_attempts) {
            this.startReconnector();
        }
    }

    public void disconnectStubs() {
        this.stopReconnector();
        for (RouterStub stub : this.stubs) {
            try {
                stub.disconnect(this.cluster_name, this.local_addr);
            }
            catch (Throwable throwable) {}
        }
        this.stopReconnector();
    }

    public void destroyStubs() {
        this.stopReconnector();
        this.stubs.forEach(RouterStub::destroy);
        this.stubs.clear();
    }

    public String printStubs() {
        return Util.printListWithDelimiter(this.stubs, ", ");
    }

    public String printReconnectList() {
        return this.stubs.stream().filter(s2 -> !s2.isConnected()).map(s2 -> String.format("%s:%d", s2.remote_sa.getHostString(), s2.remote_sa.getPort())).collect(Collectors.joining(", "));
    }

    public String print() {
        return String.format("Stubs: %s\nReconnect list: %s", this.printStubs(), this.printReconnectList());
    }

    @Override
    public void run() {
        int failed_reconnect_attempts = 0;
        for (RouterStub stub : this.stubs) {
            if (stub.isConnected()) continue;
            try {
                stub.connect(this.cluster_name, this.local_addr, this.logical_name, this.phys_addr);
                this.log.debug("%s: re-established connection to %s successfully for group %s", this.local_addr, stub.remote(), this.cluster_name);
            }
            catch (Exception ex) {
                ++failed_reconnect_attempts;
            }
        }
        if (failed_reconnect_attempts == 0) {
            this.stopReconnector();
        }
    }

    @Override
    public void closed(RouterStub stub) {
        try {
            stub.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startReconnector();
    }

    protected synchronized void startReconnector() {
        if (this.reconnector_task == null || this.reconnector_task.isDone()) {
            this.reconnector_task = this.timer.scheduleWithFixedDelay(this, this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopReconnector() {
        if (this.reconnector_task != null) {
            this.reconnector_task.cancel(true);
        }
    }
}

