/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.util.Arrays;

final class ByteStringBuilder {
    private static final int INVALID_US_ASCII_CODE_POINT = 63;
    private static final int INVALID_UTF_8_CODE_POINT = 65533;
    private byte[] content;
    private int length;

    public ByteStringBuilder(int len) {
        this.content = new byte[len];
    }

    public ByteStringBuilder append(boolean b) {
        this.appendLatin1(Boolean.toString(b));
        return this;
    }

    public ByteStringBuilder append(char c) {
        return this.appendUtf8Raw((byte)c);
    }

    public static int getUtf8LengthOf(int c) {
        if (c < 128) {
            return 1;
        }
        if (c < 2048) {
            return 2;
        }
        if (c < 65536) {
            return 3;
        }
        if (c < 0x110000) {
            return 4;
        }
        return 1;
    }

    public ByteStringBuilder appendUtf8Raw(int codePoint) {
        if (codePoint < 0) {
            this.appendUtf8Raw(65533);
        } else if (codePoint < 128) {
            this.doAppend((byte)codePoint);
        } else if (codePoint < 2048) {
            this.doAppend((byte)(0xC0 | 0x1F & codePoint >>> 6));
            this.doAppend((byte)(0x80 | 0x3F & codePoint));
        } else if (codePoint < 65536) {
            this.doAppend((byte)(0xE0 | 0xF & codePoint >>> 12));
            this.doAppend((byte)(0x80 | 0x3F & codePoint >>> 6));
            this.doAppend((byte)(0x80 | 0x3F & codePoint));
        } else if (codePoint < 0x110000) {
            this.doAppend((byte)(0xF0 | 7 & codePoint >>> 18));
            this.doAppend((byte)(0x80 | 0x3F & codePoint >>> 12));
            this.doAppend((byte)(0x80 | 0x3F & codePoint >>> 6));
            this.doAppend((byte)(0x80 | 0x3F & codePoint));
        } else {
            this.appendUtf8Raw(65533);
        }
        return this;
    }

    public ByteStringBuilder append(byte[] bytes) {
        int length = this.length;
        int bl = bytes.length;
        this.reserve(bl, false);
        System.arraycopy(bytes, 0, this.content, length, bl);
        this.length = length + bl;
        return this;
    }

    public ByteStringBuilder append(byte[] bytes, int offs, int len) {
        this.reserve(len, false);
        int length = this.length;
        System.arraycopy(bytes, offs, this.content, length, len);
        this.length = length + len;
        return this;
    }

    public ByteStringBuilder appendUSASCII(String s2) {
        return this.appendUSASCII(s2, 0, s2.length());
    }

    public ByteStringBuilder appendUSASCII(String s2, int maxLen) {
        return this.appendASCII(128, s2, 0, s2.length(), maxLen);
    }

    public ByteStringBuilder appendUSASCII(String s2, int offs, int len) {
        return this.appendASCII(128, s2, offs, len, Integer.MAX_VALUE);
    }

    public ByteStringBuilder appendPrintUSASCII(String s2) {
        return this.appendPrintUSASCII(s2, 0, s2.length());
    }

    public ByteStringBuilder appendPrintUSASCII(String s2, int maxLen) {
        return this.appendASCII(33, 126, s2, 0, s2.length(), maxLen);
    }

    public ByteStringBuilder appendPrintUSASCII(String s2, int offs, int len) {
        return this.appendASCII(33, 126, s2, offs, len, Integer.MAX_VALUE);
    }

    public ByteStringBuilder appendLatin1(String s2) {
        return this.appendLatin1(s2, 0, s2.length());
    }

    public ByteStringBuilder appendLatin1(String s2, int offs, int len) {
        return this.appendASCII(256, s2, offs, len, Integer.MAX_VALUE);
    }

    public ByteStringBuilder append(String s2) {
        return this.append(s2, 0, s2.length());
    }

    public ByteStringBuilder append(String s2, int offs, int len) {
        int i2 = offs;
        while (i2 < len) {
            int c;
            if (Character.isHighSurrogate((char)(c = s2.charAt(offs + i2++)))) {
                char t;
                c = i2 < len ? (!Character.isLowSurrogate(t = s2.charAt(offs + i2++)) ? 65533 : Character.toCodePoint((char)c, t)) : 65533;
            }
            this.appendUtf8Raw(c);
        }
        return this;
    }

    public int write(String s2, int limit) {
        int result = 0;
        int len = s2.length();
        int i2 = 0;
        while (i2 < len) {
            int byteLen;
            int c = s2.charAt(i2);
            if (Character.isHighSurrogate((char)c)) {
                char t;
                c = i2 < len ? (!Character.isLowSurrogate(t = s2.charAt(++i2)) ? 65533 : Character.toCodePoint((char)c, t)) : 65533;
            }
            if (this.length + (byteLen = ByteStringBuilder.getUtf8LengthOf(c)) > limit) break;
            result = i2++;
            this.appendUtf8Raw(c);
        }
        return result;
    }

    public ByteStringBuilder append(int i2) {
        this.appendLatin1(Integer.toString(i2));
        return this;
    }

    public ByteStringBuilder append(long l) {
        this.appendLatin1(Long.toString(l));
        return this;
    }

    public ByteStringBuilder append(ByteStringBuilder other) {
        this.append(other.content, 0, other.length);
        return this;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.content, this.length);
    }

    public byte byteAt(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.content[index];
    }

    public int capacity() {
        return this.content.length;
    }

    public int length() {
        return this.length;
    }

    public void setLength(int newLength) {
        if (newLength > this.length) {
            this.reserve(newLength - this.length, true);
        }
        this.length = newLength;
    }

    public boolean contentEquals(byte[] other) {
        return this.contentEquals(other, 0, other.length);
    }

    public boolean contentEquals(byte[] other, int offs, int length) {
        if (length != this.length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.content[i2] == other[offs + i2]) continue;
            return false;
        }
        return true;
    }

    private ByteStringBuilder appendASCII(int asciiLen, String s2, int offs, int len, int maxLen) {
        return this.appendASCII(0, asciiLen, s2, offs, len, maxLen);
    }

    private ByteStringBuilder appendASCII(int minChar, int maxChar, String s2, int offs, int len, int maxLen) {
        this.reserve(len, false);
        for (int i2 = 0; i2 < len && i2 < maxLen; ++i2) {
            char c = s2.charAt(i2 + offs);
            if (c < minChar || c > maxChar) {
                this.doAppendNoCheck((byte)63);
                continue;
            }
            this.doAppendNoCheck((byte)c);
        }
        return this;
    }

    private void reserve(int count, boolean clear) {
        byte[] content = this.content;
        int cl = content.length;
        int length = this.length;
        if (cl - length >= count) {
            if (clear) {
                Arrays.fill(content, length, length + count, (byte)0);
            }
            return;
        }
        if (clear) {
            Arrays.fill(content, length, cl, (byte)0);
        }
        do {
            if ((cl += cl + 1 >> 1) >= 0) continue;
            throw new IllegalStateException("Too large");
        } while (cl - length < count);
        this.content = Arrays.copyOf(content, cl);
    }

    private void doAppend(byte b) {
        int length = this.length;
        byte[] content = this.content;
        int cl = content.length;
        if (length == cl) {
            content = this.content = Arrays.copyOf(content, cl + (cl + 1 >> 1));
        }
        content[length] = b;
        this.length = length + 1;
    }

    private void doAppendNoCheck(byte b) {
        this.content[this.length++] = b;
    }
}

