/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.uri.AbstractCFSchema;
import org.apache.activemq.artemis.uri.JMSConnectionOptions;
import org.apache.activemq.artemis.uri.schema.serverLocator.UDPServerLocatorSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class UDPSchema
extends AbstractCFSchema {
    @Override
    public String getSchemaName() {
        return "udp";
    }

    @Override
    public ActiveMQConnectionFactory internalNewObject(URI uri, Map<String, String> query2, String name) throws Exception {
        JMSConnectionOptions options = this.newConectionOptions(uri, query2);
        DiscoveryGroupConfiguration dgc = UDPServerLocatorSchema.getDiscoveryGroupConfiguration(uri, query2, this.getHost(uri), this.getPort(uri), name);
        ActiveMQConnectionFactory factory = options.isHa() ? ActiveMQJMSClient.createConnectionFactoryWithHA(dgc, options.getFactoryTypeEnum()) : ActiveMQJMSClient.createConnectionFactoryWithoutHA(dgc, options.getFactoryTypeEnum());
        return this.setData(uri, query2, factory);
    }

    @Override
    protected URI internalNewURI(ActiveMQConnectionFactory bean2) throws Exception {
        DiscoveryGroupConfiguration dgc = bean2.getDiscoveryGroupConfiguration();
        UDPBroadcastEndpointFactory endpoint = (UDPBroadcastEndpointFactory)dgc.getBroadcastEndpointFactory();
        String query2 = BeanSupport.getData(UDPServerLocatorSchema.IGNORED, bean2, dgc, endpoint);
        dgc.setBroadcastEndpointFactory(endpoint);
        return new URI("udp", null, endpoint.getGroupAddress(), endpoint.getGroupPort(), null, query2, null);
    }
}

