/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.AuditLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.PrincipalsCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.jboss.logging.Logger;

public abstract class AbstractPrincipalLoginModule
implements AuditLoginModule {
    private final Logger logger = Logger.getLogger(this.getClass());
    private Subject subject;
    private final List<Principal> authenticatedPrincipals = new LinkedList<Principal>();
    private CallbackHandler callbackHandler;
    private boolean loginSucceeded;
    private Principal[] principals;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new PrincipalsCallback()};
        try {
            this.callbackHandler.handle(callbacks);
            this.principals = ((PrincipalsCallback)callbacks[0]).getPeerPrincipals();
            if (this.principals != null) {
                this.authenticatedPrincipals.addAll(Arrays.asList(this.principals));
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        if (!this.authenticatedPrincipals.isEmpty()) {
            this.loginSucceeded = true;
        }
        this.logger.debug("login " + this.authenticatedPrincipals);
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.loginSucceeded;
        if (result) {
            this.authenticatedPrincipals.add(new UserPrincipal(this.authenticatedPrincipals.get(0).getName()));
            this.subject.getPrincipals().addAll(this.authenticatedPrincipals);
        }
        this.clear();
        this.logger.debug("commit, result: " + result);
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principals != null) {
            for (Principal principal : this.authenticatedPrincipals) {
                this.registerFailureForAudit(principal.getName());
            }
        }
        this.clear();
        this.logger.debug("abort");
        return true;
    }

    private void clear() {
        this.principals = null;
        this.loginSucceeded = false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.authenticatedPrincipals);
        this.authenticatedPrincipals.clear();
        this.clear();
        this.logger.debug("logout");
        return true;
    }
}

