/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.logging.LoggingConnection;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.jboss.logging.Logger;

public class JDBCConnectionProvider {
    private static final Logger logger = Logger.getLogger(JDBCConnectionProvider.class);
    private DataSource dataSource;
    private Executor networkTimeoutExecutor;
    private int networkTimeoutMillis;
    private boolean supportNetworkTimeout;
    private final String user;
    private final String password;
    private static AtomicBoolean shutAdded = new AtomicBoolean(false);

    public JDBCConnectionProvider(DataSource dataSource) {
        this(dataSource, null, null);
    }

    public JDBCConnectionProvider(DataSource dataSource, String user, String password) {
        this.dataSource = dataSource;
        this.networkTimeoutExecutor = null;
        this.networkTimeoutMillis = -1;
        this.supportNetworkTimeout = true;
        this.user = user;
        this.password = password;
        this.addDerbyShutdownHook();
    }

    public synchronized Connection getConnection() throws SQLException {
        Connection connection;
        try {
            connection = this.user != null || this.password != null ? this.dataSource.getConnection(this.user, this.password) : this.dataSource.getConnection();
            if (logger.isTraceEnabled() && !(connection instanceof LoggingConnection)) {
                connection = new LoggingConnection(connection, logger);
            }
        }
        catch (SQLException e) {
            logger.error(JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
            throw e;
        }
        if (this.networkTimeoutMillis >= 0 && this.networkTimeoutExecutor == null) {
            logger.warn("Unable to set a network timeout on the JDBC connection: networkTimeoutExecutor is null");
        }
        if (this.networkTimeoutMillis >= 0 && this.networkTimeoutExecutor != null && this.supportNetworkTimeout) {
            try {
                connection.setNetworkTimeout(this.networkTimeoutExecutor, this.networkTimeoutMillis);
            }
            catch (SQLException e) {
                this.supportNetworkTimeout = false;
                logger.warn(JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
                ActiveMQJournalLogger.LOGGER.warn("Unable to set a network timeout on the JDBC connection: won't retry again in the future");
            }
            catch (Throwable throwable) {
                this.supportNetworkTimeout = false;
                logger.warn((Object)"Unable to set a network timeout on the JDBC connection: won't retry again in the future", throwable);
            }
        }
        return connection;
    }

    public void addDerbyShutdownHook() {
        try (Connection connection = this.getConnection();){
            PropertySQLProvider.Factory.SQLDialect sqlDialect = PropertySQLProvider.Factory.investigateDialect(connection);
            if (sqlDialect == PropertySQLProvider.Factory.SQLDialect.DERBY && shutAdded.compareAndSet(false, true)) {
                Runtime.getRuntime().addShutdownHook(new ShutdownDerby());
            }
        }
        catch (SQLException e) {
            logger.error(JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
        }
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) {
        this.networkTimeoutExecutor = executor;
        this.networkTimeoutMillis = milliseconds;
    }

    private static class ShutdownDerby
    extends Thread {
        private ShutdownDerby() {
        }

        @Override
        public void run() {
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

