/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.MessageGroups;

public class BucketMessageGroups<C>
implements MessageGroups<C> {
    private static SimpleString _AMQ_GROUP_BUCKET_INT_KEY = new SimpleString("_AMQ_GROUP_BUCKET_INT_KEY_");
    private final int bucketCount;
    private C[] buckets;
    private int size = 0;

    public BucketMessageGroups(int bucketCount) {
        if (bucketCount < 1) {
            throw new IllegalArgumentException("Bucket count must be greater than 0");
        }
        this.bucketCount = bucketCount;
    }

    private int getBucket(SimpleString key) {
        Object bucketKey = key;
        if (key.startsWith(_AMQ_GROUP_BUCKET_INT_KEY)) {
            bucketKey = BucketMessageGroups.retrieveBucketIntFromKey(key);
        }
        return BucketMessageGroups.getHashBucket(bucketKey, this.bucketCount);
    }

    private static int getHashBucket(Object key, int bucketCount) {
        return (key.hashCode() & Integer.MAX_VALUE) % bucketCount;
    }

    private static Object retrieveBucketIntFromKey(SimpleString key) {
        SimpleString bucket = key.subSeq(_AMQ_GROUP_BUCKET_INT_KEY.length(), key.length());
        try {
            return Integer.parseInt(bucket.toString());
        }
        catch (NumberFormatException nfe) {
            return key;
        }
    }

    @Override
    public void put(SimpleString key, C consumer) {
        if (this.buckets == null) {
            this.buckets = BucketMessageGroups.newBucketArray(this.bucketCount);
        }
        if (this.buckets[this.getBucket(key)] == null) {
            ++this.size;
        }
        this.buckets[this.getBucket((SimpleString)key)] = consumer;
    }

    private static <C> C[] newBucketArray(int capacity) {
        return new Object[capacity];
    }

    @Override
    public C get(SimpleString key) {
        if (this.buckets == null) {
            return null;
        }
        return this.buckets[this.getBucket(key)];
    }

    @Override
    public C remove(SimpleString key) {
        if (this.buckets == null) {
            return null;
        }
        return this.remove(this.getBucket(key));
    }

    private C remove(int bucket) {
        C existing = this.buckets[bucket];
        if (existing != null) {
            --this.size;
            this.buckets[bucket] = null;
        }
        return existing;
    }

    @Override
    public boolean removeIf(Predicate<? super C> filter2) {
        if (this.buckets != null && this.size > 0) {
            boolean removed = false;
            for (int bucket = 0; bucket < this.buckets.length; ++bucket) {
                if (!filter2.test(this.buckets[bucket])) continue;
                this.remove(bucket);
                removed = true;
            }
            return removed;
        }
        return false;
    }

    @Override
    public void removeAll() {
        if (this.buckets != null && this.size > 0) {
            Arrays.fill(this.buckets, null);
        }
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Map<SimpleString, C> toMap() {
        if (this.buckets != null && this.size > 0) {
            HashMap<SimpleString, C> map = new HashMap<SimpleString, C>(this.size);
            for (int bucket = 0; bucket < this.buckets.length; ++bucket) {
                C value = this.buckets[bucket];
                if (value == null) continue;
                map.put(BucketMessageGroups.toGroupBucketIntKey(bucket), value);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    static SimpleString toGroupBucketIntKey(int i2) {
        return _AMQ_GROUP_BUCKET_INT_KEY.concat(Integer.toString(i2));
    }
}

