/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.jboss.logging.Logger;

public class PageSubscriptionCounterImpl
implements PageSubscriptionCounter {
    private static final Logger logger = Logger.getLogger(PageSubscriptionCounterImpl.class);
    private static final int FLUSH_COUNTER = 1000;
    private final long subscriptionID;
    private long recordID = -1L;
    private boolean persistent;
    private final PageSubscription subscription;
    private final StorageManager storage;
    private final Executor executor;
    private final AtomicLong value = new AtomicLong(0L);
    private final AtomicLong persistentSize = new AtomicLong(0L);
    private final AtomicLong added = new AtomicLong(0L);
    private final AtomicLong addedPersistentSize = new AtomicLong(0L);
    private final AtomicLong pendingValue = new AtomicLong(0L);
    private final AtomicLong pendingPersistentSize = new AtomicLong(0L);
    private final LinkedList<Long> incrementRecords = new LinkedList();
    private final Map<Long, PendingCounter> pendingCounters = new HashMap<Long, PendingCounter>();
    private LinkedList<PendingCounter> loadList;
    private final Runnable cleanupCheck = new Runnable(){

        @Override
        public void run() {
            PageSubscriptionCounterImpl.this.cleanup();
        }
    };

    public PageSubscriptionCounterImpl(StorageManager storage, PageSubscription subscription, Executor executor, boolean persistent, long subscriptionID) {
        this.subscriptionID = subscriptionID;
        this.executor = executor;
        this.storage = storage;
        this.persistent = persistent;
        this.subscription = subscription;
    }

    @Override
    public long getValueAdded() {
        return this.added.get() + this.pendingValue.get();
    }

    @Override
    public long getValue() {
        return this.value.get() + this.pendingValue.get();
    }

    @Override
    public long getPersistentSizeAdded() {
        return this.addedPersistentSize.get() + this.pendingPersistentSize.get();
    }

    @Override
    public long getPersistentSize() {
        return this.persistentSize.get() + this.pendingPersistentSize.get();
    }

    @Override
    public synchronized void pendingCounter(Page page, int increment, long size) throws Exception {
        if (!this.persistent) {
            return;
        }
        PendingCounter pendingInfo = this.pendingCounters.get(page.getPageId());
        if (pendingInfo == null) {
            long id = this.storage.storePendingCounter(this.subscriptionID, page.getPageId());
            pendingInfo = new PendingCounter(id, increment, size);
            this.pendingCounters.put(Long.valueOf(page.getPageId()), pendingInfo);
        } else {
            pendingInfo.addAndGet(increment, size);
        }
        this.pendingValue.addAndGet(increment);
        this.pendingPersistentSize.addAndGet(size);
        page.addPendingCounter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupNonTXCounters(long pageID) throws Exception {
        PendingCounter pendingInfo;
        PageSubscriptionCounterImpl pageSubscriptionCounterImpl = this;
        synchronized (pageSubscriptionCounterImpl) {
            pendingInfo = this.pendingCounters.remove(pageID);
        }
        if (pendingInfo != null) {
            final int valueCleaned = pendingInfo.getCount();
            final long valueSizeCleaned = pendingInfo.getPersistentSize();
            TransactionImpl tx = new TransactionImpl(this.storage);
            this.storage.deletePendingPageCounter(tx.getID(), pendingInfo.getId());
            this.increment(tx, valueCleaned, valueSizeCleaned);
            tx.addOperation(new TransactionOperationAbstract(){

                @Override
                public void afterCommit(Transaction tx) {
                    PageSubscriptionCounterImpl.this.pendingValue.addAndGet(-valueCleaned);
                    PageSubscriptionCounterImpl.this.pendingPersistentSize.updateAndGet(val -> val >= valueSizeCleaned ? val - valueSizeCleaned : 0L);
                }
            });
            tx.commit();
        }
    }

    @Override
    public void increment(Transaction tx, int add, long size) throws Exception {
        if (tx == null) {
            if (this.persistent) {
                long id = this.storage.storePageCounterInc(this.subscriptionID, add, size);
                this.incrementProcessed(id, add, size);
            } else {
                this.incrementProcessed(-1L, add, size);
            }
        } else if (this.persistent) {
            tx.setContainsPersistent();
            long id = this.storage.storePageCounterInc(tx.getID(), this.subscriptionID, add, size);
            this.applyIncrementOnTX(tx, id, add, size);
        } else {
            this.applyIncrementOnTX(tx, -1L, add, size);
        }
    }

    @Override
    public void applyIncrementOnTX(Transaction tx, long recordID1, int add, long size) {
        CounterOperations oper = (CounterOperations)tx.getProperty(3);
        if (oper == null) {
            oper = new CounterOperations();
            tx.putProperty(3, oper);
            tx.addOperation(oper);
        }
        oper.operations.add(new ItemOper(this, recordID1, add, size));
    }

    @Override
    public synchronized void loadValue(long recordID1, long value1, long size) {
        if (this.subscription != null) {
            this.subscription.notEmpty();
        }
        this.value.set(value1);
        this.added.set(value1);
        this.persistentSize.set(size);
        this.addedPersistentSize.set(size);
        this.recordID = recordID1;
    }

    public synchronized void incrementProcessed(long id, int add, long size) {
        this.addInc(id, add, size);
        if (this.incrementRecords.size() > 1000) {
            this.executor.execute(this.cleanupCheck);
        }
    }

    @Override
    public void delete() throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storage);
        this.delete(tx);
        tx.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Transaction tx) throws Exception {
        try (ArtemisCloseable lock = this.storage.closeableReadLock();){
            PageSubscriptionCounterImpl pageSubscriptionCounterImpl = this;
            synchronized (pageSubscriptionCounterImpl) {
                for (Long record : this.incrementRecords) {
                    this.storage.deleteIncrementRecord(tx.getID(), record);
                    tx.setContainsPersistent();
                }
                if (this.recordID >= 0L) {
                    this.storage.deletePageCounter(tx.getID(), this.recordID);
                    tx.setContainsPersistent();
                }
                this.recordID = -1L;
                this.value.set(0L);
                this.incrementRecords.clear();
            }
        }
    }

    @Override
    public void loadInc(long id, int add, long size) {
        if (this.loadList == null) {
            this.loadList = new LinkedList();
        }
        this.loadList.add(new PendingCounter(id, add, size));
    }

    @Override
    public void processReload() {
        if (this.loadList != null) {
            if (this.subscription != null) {
                this.subscription.notEmpty();
            }
            for (PendingCounter incElement : this.loadList) {
                this.value.addAndGet(incElement.getCount());
                this.added.addAndGet(incElement.getCount());
                this.persistentSize.addAndGet(incElement.getPersistentSize());
                this.addedPersistentSize.addAndGet(incElement.getPersistentSize());
                this.incrementRecords.add(incElement.getId());
            }
            this.loadList.clear();
            this.loadList = null;
        }
    }

    @Override
    public synchronized void addInc(long id, int variance, long size) {
        this.value.addAndGet(variance);
        this.persistentSize.addAndGet(size);
        if (variance > 0) {
            this.added.addAndGet(variance);
        }
        if (size > 0L) {
            this.addedPersistentSize.addAndGet(size);
        }
        if (id >= 0L) {
            this.incrementRecords.add(id);
        }
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        ArrayList<Long> deleteList;
        long sizeReplace;
        long valueReplace;
        PageSubscriptionCounterImpl pageSubscriptionCounterImpl = this;
        synchronized (pageSubscriptionCounterImpl) {
            if (this.incrementRecords.size() <= 1000) {
                return;
            }
            valueReplace = this.value.get();
            sizeReplace = this.persistentSize.get();
            deleteList = new ArrayList<Long>(this.incrementRecords);
            this.incrementRecords.clear();
        }
        long newRecordID = -1L;
        long txCleanup = this.storage.generateID();
        try {
            for (Long value1 : deleteList) {
                this.storage.deleteIncrementRecord(txCleanup, value1);
            }
            if (this.recordID >= 0L) {
                this.storage.deletePageCounter(txCleanup, this.recordID);
            }
            newRecordID = this.storage.storePageCounter(txCleanup, this.subscriptionID, valueReplace, sizeReplace);
            if (logger.isTraceEnabled()) {
                logger.trace("Replacing page-counter record = " + this.recordID + " by record = " + newRecordID + " on subscriptionID = " + this.subscriptionID + " for queue = " + this.subscription.getQueue().getName());
            }
            this.storage.commit(txCleanup);
        }
        catch (Exception e) {
            newRecordID = this.recordID;
            ActiveMQServerLogger.LOGGER.problemCleaningPagesubscriptionCounter(e);
            try {
                this.storage.rollback(txCleanup);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.recordID = newRecordID;
        }
    }

    private static class PendingCounter {
        private static final AtomicIntegerFieldUpdater<PendingCounter> COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PendingCounter.class, "count");
        private static final AtomicLongFieldUpdater<PendingCounter> SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(PendingCounter.class, "persistentSize");
        private final long id;
        private volatile int count;
        private volatile long persistentSize;

        PendingCounter(long id, int count, long persistentSize) {
            this.id = id;
            this.count = count;
            this.persistentSize = persistentSize;
        }

        public long getId() {
            return this.id;
        }

        public int getCount() {
            return this.count;
        }

        public long getPersistentSize() {
            return this.persistentSize;
        }

        public void addAndGet(int count, long persistentSize) {
            COUNT_UPDATER.addAndGet(this, count);
            SIZE_UPDATER.addAndGet(this, persistentSize);
        }
    }

    private static class CounterOperations
    extends TransactionOperationAbstract
    implements TransactionOperation {
        LinkedList<ItemOper> operations = new LinkedList();

        private CounterOperations() {
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (ItemOper oper : this.operations) {
                oper.counter.incrementProcessed(oper.id, oper.amount, oper.persistentSize);
            }
        }
    }

    private static class ItemOper {
        PageSubscriptionCounterImpl counter;
        long id;
        int amount;
        long persistentSize;

        private ItemOper(PageSubscriptionCounterImpl counter, long id, int add, long persistentSize) {
            this.counter = counter;
            this.id = id;
            this.amount = add;
            this.persistentSize = persistentSize;
        }
    }
}

