/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.messagecounter;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.utils.JsonLoader;

public class MessageCounter {
    private final String destName;
    private final String destSubscription;
    private final boolean destTopic;
    private final boolean destDurable;
    private final Queue serverQueue;
    private long countTotal;
    private long countTotalLast;
    private long depthLast;
    private long timeLastUpdate;
    private long timeLastAdd;
    private long timeLastAck;
    private int dayCounterMax;
    private final List<DayCounter> dayCounters;
    private long lastMessagesAdded;
    private long lastMessagesAcked;
    private final Runnable onTimeExecutor = new Runnable(){

        @Override
        public void run() {
            long latestMessagesAdded = MessageCounter.this.serverQueue.getMessagesAdded();
            long latestMessagesAcked = MessageCounter.this.serverQueue.getMessagesAcknowledged();
            long newMessagesAdded = latestMessagesAdded - MessageCounter.this.lastMessagesAdded;
            long newMessagesAcked = latestMessagesAcked - MessageCounter.this.lastMessagesAcked;
            MessageCounter.this.countTotal = MessageCounter.this.countTotal + newMessagesAdded;
            MessageCounter.this.lastMessagesAdded = latestMessagesAdded;
            MessageCounter.this.lastMessagesAcked = latestMessagesAcked;
            long timestamp = System.currentTimeMillis();
            if (newMessagesAdded > 0L) {
                MessageCounter.this.timeLastAdd = timestamp;
            }
            if (newMessagesAcked > 0L) {
                MessageCounter.this.timeLastAck = timestamp;
            }
            MessageCounter.this.timeLastUpdate = timestamp;
            MessageCounter.this.updateHistory(newMessagesAdded);
        }
    };

    public MessageCounter(String name, String subscription, Queue serverQueue, boolean topic, boolean durable, int daycountmax) {
        this.destName = name;
        this.destSubscription = subscription;
        this.destTopic = topic;
        this.destDurable = durable;
        this.serverQueue = serverQueue;
        this.resetCounter();
        this.dayCounters = new ArrayList<DayCounter>();
        this.setHistoryLimit(daycountmax);
    }

    public synchronized void onTimer() {
        this.serverQueue.getExecutor().execute(this.onTimeExecutor);
    }

    public String getDestinationName() {
        return this.destName;
    }

    public String getDestinationSubscription() {
        return this.destSubscription;
    }

    public boolean isDestinationTopic() {
        return this.destTopic;
    }

    public boolean isDestinationDurable() {
        return this.destDurable;
    }

    public long getCount() {
        return this.countTotal;
    }

    public long getCountDelta() {
        long delta = this.countTotal - this.countTotalLast;
        this.countTotalLast = this.countTotal;
        return delta;
    }

    public long getMessageCount() {
        return this.serverQueue.getMessageCount();
    }

    public long getMessageCountDelta() {
        long current = this.serverQueue.getMessageCount();
        int delta = (int)(current - this.depthLast);
        this.depthLast = current;
        return delta;
    }

    public long getLastUpdate() {
        return this.timeLastUpdate;
    }

    public long getLastAddedMessageTime() {
        return this.timeLastAdd;
    }

    public long getLastAckedMessageTime() {
        return this.timeLastAck;
    }

    public void resetCounter() {
        this.countTotal = 0L;
        this.countTotalLast = 0L;
        this.depthLast = 0L;
        this.timeLastUpdate = 0L;
        this.timeLastAdd = 0L;
        this.timeLastAck = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHistoryLimit(int daycountmax) {
        boolean bInitialize = false;
        this.dayCounterMax = daycountmax;
        List<DayCounter> list = this.dayCounters;
        synchronized (list) {
            if (this.dayCounterMax > 0) {
                int delta = this.dayCounters.size() - this.dayCounterMax;
                for (int i2 = 0; i2 < delta; ++i2) {
                    this.dayCounters.remove(0);
                }
                bInitialize = this.dayCounters.isEmpty();
            } else if (this.dayCounterMax == 0) {
                this.dayCounters.clear();
            } else {
                bInitialize = this.dayCounters.isEmpty();
            }
            if (bInitialize) {
                this.dayCounters.add(new DayCounter(new GregorianCalendar(), true));
            }
        }
    }

    public void resetHistory() {
        int max = this.dayCounterMax;
        this.setHistoryLimit(0);
        this.setHistoryLimit(max);
    }

    public List<DayCounter> getHistory() {
        this.updateHistory(0L);
        return new ArrayList<DayCounter>(this.dayCounters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistoryAsString() {
        StringBuilder ret = new StringBuilder();
        this.updateHistory(0L);
        List<DayCounter> list = this.dayCounters;
        synchronized (list) {
            ret.append(this.dayCounters.size() + "\n");
            for (DayCounter counter : this.dayCounters) {
                ret.append(counter.getDayCounterAsString() + "\n");
            }
        }
        return ret.toString();
    }

    public String toString() {
        return "MessageCounter[destName" + this.destName + ", destSubscription=" + this.destSubscription + ", destTopic=" + this.destTopic + ", destDurable=" + this.destDurable + ", serverQueue =" + this.serverQueue + "]";
    }

    public String toJSon() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
        String lastAddTimestamp = dateFormat.format(new Date(this.getLastAddedMessageTime()));
        String lastAckTimestamp = dateFormat.format(new Date(this.getLastAckedMessageTime()));
        String updateTimestamp = dateFormat.format(new Date(this.getLastUpdate()));
        return JsonLoader.createObjectBuilder().add("destinationName", JsonUtil.nullSafe(this.getDestinationName())).add("destinationSubscription", JsonUtil.nullSafe(this.getDestinationSubscription())).add("destinationDurable", this.isDestinationDurable()).add("count", this.getCount()).add("countDelta", this.getCountDelta()).add("messageCount", this.getMessageCount()).add("messageCountDelta", this.getMessageCountDelta()).add("lastAddTimestamp", lastAddTimestamp).add("lastAckTimestamp", lastAckTimestamp).add("updateTimestamp", updateTimestamp).build().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHistory(long newMessages) {
        if (this.dayCounters.isEmpty()) {
            return;
        }
        List<DayCounter> list = this.dayCounters;
        synchronized (list) {
            DayCounter counterLast = this.dayCounters.get(this.dayCounters.size() - 1);
            GregorianCalendar calNow = new GregorianCalendar();
            GregorianCalendar calLast = counterLast.getDate();
            calNow.clear(9);
            calNow.clear(10);
            calNow.clear(11);
            calNow.clear(12);
            calNow.clear(13);
            calNow.clear(14);
            calLast.clear(9);
            calLast.clear(10);
            calLast.clear(11);
            calLast.clear(12);
            calLast.clear(13);
            calLast.clear(14);
            long millisPerDay = 86400000L;
            long millisDelta = calNow.getTime().getTime() - calLast.getTime().getTime();
            int dayDelta = (int)(millisDelta / millisPerDay);
            if (dayDelta > 0) {
                DayCounter counterNew;
                counterLast.finalizeDayCounter();
                for (int i2 = 1; i2 < dayDelta; ++i2) {
                    calLast.add(6, 1);
                    counterNew = new DayCounter(calLast, false);
                    counterNew.finalizeDayCounter();
                    this.dayCounters.add(counterNew);
                }
                counterNew = new DayCounter(calNow, false);
                this.dayCounters.add(counterNew);
                this.setHistoryLimit(this.dayCounterMax);
            }
            counterLast = this.dayCounters.get(this.dayCounters.size() - 1);
            counterLast.updateDayCounter(newMessages);
        }
    }

    public static final class DayCounter {
        static final int HOURS = 24;
        GregorianCalendar date = null;
        long[] counters = new long[24];

        DayCounter(GregorianCalendar date, boolean isStartDay) {
            this.date = (GregorianCalendar)date.clone();
            int hour = date.get(11);
            for (int i2 = 0; i2 < 24; ++i2) {
                if (i2 < hour) {
                    if (isStartDay) {
                        this.counters[i2] = -1L;
                        continue;
                    }
                    this.counters[i2] = 0L;
                    continue;
                }
                this.counters[i2] = -1L;
            }
            this.counters[hour] = 0L;
        }

        public GregorianCalendar getDate() {
            return (GregorianCalendar)this.date.clone();
        }

        public long[] getCounters() {
            return this.counters;
        }

        void updateDayCounter(long newMessages) {
            GregorianCalendar cal = new GregorianCalendar();
            int currentIndex = cal.get(11);
            boolean bUpdate = false;
            for (int i2 = 0; i2 <= currentIndex; ++i2) {
                if (this.counters[i2] > -1L) {
                    bUpdate = true;
                }
                if (!bUpdate || this.counters[i2] != -1L) continue;
                this.counters[i2] = 0L;
            }
            int n = currentIndex;
            this.counters[n] = this.counters[n] + newMessages;
        }

        private void finalizeDayCounter() {
            boolean bFinalize = false;
            for (int i2 = 0; i2 < 24; ++i2) {
                if (this.counters[i2] > -1L) {
                    bFinalize = true;
                }
                if (!bFinalize || this.counters[i2] != -1L) continue;
                this.counters[i2] = 0L;
            }
        }

        private String getDayCounterAsString() {
            DateFormat dateFormat = DateFormat.getDateInstance(3);
            StringBuilder strData = new StringBuilder(dateFormat.format(this.date.getTime()));
            for (int i2 = 0; i2 < 24; ++i2) {
                strData.append("," + this.counters[i2]);
            }
            return strData.toString();
        }
    }
}

