/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.radiobutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import mdlaf.animation.MaterialMouseHover;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialRadioButtonUI
extends MetalRadioButtonUI {
    protected JRadioButton radioButton;
    protected Boolean mouseHoverEnable;
    protected Color mouseHoverColor;
    protected boolean isHover;
    protected MaterialMouseHover mouseHover;

    public static ComponentUI createUI(JComponent c) {
        return new MaterialRadioButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.radioButton = (JRadioButton)c;
        c.setCursor(Cursor.getPredefinedCursor(12));
        this.mouseHoverColor = UIManager.getColor("RadioButton.mouseHoverColor");
        this.icon = new MaterialRadioButtonIcon(this.getPropertyPrefix());
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.mouseHoverEnable = UIManager.getBoolean("RadioButton.mouseHoverEnabled");
        if (this.mouseHoverEnable.booleanValue()) {
            this.mouseHover = new MouseHoverEvent();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setCursor(Cursor.getDefaultCursor());
        super.uninstallUI(c);
    }

    @Override
    public synchronized void paint(Graphics g2, JComponent c) {
        super.paint(g2, c);
    }

    @Override
    protected void paintFocus(Graphics g2, Rectangle t, Dimension d) {
    }

    protected void paintFocusEffect(Graphics g2) {
        Color color = this.radioButton.isSelected() ? this.mouseHoverColor : this.radioButton.getForeground();
        MaterialDrawingUtils.drawCircle(g2, 0, 0, 14, color);
    }

    @Override
    protected void installListeners(AbstractButton button) {
        super.installListeners(button);
        if (this.mouseHoverEnable.booleanValue()) {
            button.addMouseListener(this.mouseHover);
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        super.uninstallListeners(button);
        if (this.mouseHoverEnable.booleanValue()) {
            button.removeMouseListener(this.mouseHover);
        }
    }

    protected class AnimatedIconAdapter
    implements Icon,
    UIResource {
        private Icon adapter;
        private Color color;

        public AnimatedIconAdapter(Icon adapter, Color color) {
            this.adapter = adapter;
            this.color = color;
        }

        @Override
        public void paintIcon(Component c, Graphics g2, int x, int y) {
            this.adapter.paintIcon(c, g2, x, y);
            if (MaterialRadioButtonUI.this.mouseHoverEnable.booleanValue() && (MaterialRadioButtonUI.this.isHover || c.hasFocus())) {
                Graphics g22 = g2.create();
                MaterialDrawingUtils.drawCircle(g22, x, y, 12, this.color);
                g22.dispose();
            }
        }

        @Override
        public int getIconWidth() {
            return this.adapter.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.adapter.getIconHeight();
        }
    }

    protected class MaterialRadioButtonIcon
    implements Icon,
    UIResource {
        protected Icon unselectedIcon;
        protected Icon selectedIcon;
        protected Icon disabledIcon;
        protected Icon disabledSelectedIcon;

        public MaterialRadioButtonIcon(String componentPrefix) {
            this.unselectedIcon = UIManager.getIcon(componentPrefix + "icon");
            this.selectedIcon = UIManager.getIcon(componentPrefix + "selectedIcon");
            this.disabledIcon = UIManager.getIcon(componentPrefix + "disabledIcon");
            this.disabledSelectedIcon = UIManager.getIcon(componentPrefix + "disabledSelectedIcon");
        }

        @Override
        public void paintIcon(Component c, Graphics g2, int x, int y) {
            if (MaterialRadioButtonUI.this.radioButton.isEnabled()) {
                if (MaterialRadioButtonUI.this.radioButton.isSelected()) {
                    this.selectedIcon.paintIcon(c, g2, x, y);
                } else {
                    this.unselectedIcon.paintIcon(c, g2, x, y);
                }
            } else if (MaterialRadioButtonUI.this.radioButton.isSelected()) {
                this.disabledSelectedIcon.paintIcon(c, g2, x, y);
            } else {
                this.disabledIcon.paintIcon(c, g2, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.selectedIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.selectedIcon.getIconHeight();
        }
    }

    protected class MouseHoverEvent
    implements MaterialMouseHover {
        protected MouseHoverEvent() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MaterialRadioButtonUI.this.isHover = true;
            MaterialRadioButtonUI.this.radioButton.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MaterialRadioButtonUI.this.isHover = false;
            MaterialRadioButtonUI.this.radioButton.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public boolean isRunning() {
            return MaterialRadioButtonUI.this.isHover;
        }
    }
}

