/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.quilt;

import com.google.common.collect.Lists;
import de.griefed.serverpackcreator.versionmeta.quilt.QuiltInstaller;
import de.griefed.serverpackcreator.versionmeta.quilt.QuiltLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class QuiltMeta {
    private static final Logger LOG = LogManager.getLogger(QuiltMeta.class);
    private final File QUILT_MANIFEST;
    private final File QUILT_INSTALLER_MANIFEST;
    private final QuiltLoader QUILT_LOADER;
    private final QuiltInstaller QUILT_INSTALLER;

    public QuiltMeta(File quiltManifest, File quiltInstallerManifest) {
        this.QUILT_MANIFEST = quiltManifest;
        this.QUILT_INSTALLER_MANIFEST = quiltInstallerManifest;
        this.QUILT_LOADER = new QuiltLoader(this.getXml(this.QUILT_MANIFEST));
        this.QUILT_INSTALLER = new QuiltInstaller(this.getXml(this.QUILT_INSTALLER_MANIFEST));
    }

    public void update() throws MalformedURLException {
        this.QUILT_LOADER.update(this.getXml(this.QUILT_MANIFEST));
        this.QUILT_INSTALLER.update(this.getXml(this.QUILT_INSTALLER_MANIFEST));
    }

    private Document getXml(File manifest) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document xml = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOG.error("Couldn't read document.", (Throwable)ex);
        }
        try {
            assert (documentBuilder != null);
            xml = documentBuilder.parse(manifest);
        }
        catch (IOException | SAXException ex) {
            LOG.error("Couldn't read document.", (Throwable)ex);
        }
        assert (xml != null);
        xml.normalize();
        return xml;
    }

    public String latestLoaderVersion() {
        return this.QUILT_LOADER.latestLoaderVersion();
    }

    public String releaseLoaderVersion() {
        return this.QUILT_LOADER.releaseLoaderVersion();
    }

    public List<String> loaderVersionsAscending() {
        return this.QUILT_LOADER.loaders();
    }

    public List<String> loaderVersionsDescending() {
        return Lists.reverse(this.QUILT_LOADER.loaders());
    }

    public String[] loaderVersionsArrayAscending() {
        return this.QUILT_LOADER.loaders().toArray(new String[0]);
    }

    public String[] loaderVersionsArrayDescending() {
        return Lists.reverse(this.QUILT_LOADER.loaders()).toArray(new String[0]);
    }

    public String latestInstallerVersion() {
        return this.QUILT_INSTALLER.latestInstallerVersion();
    }

    public String releaseInstallerVersion() {
        return this.QUILT_INSTALLER.releaseInstallerVersion();
    }

    public List<String> installerVersionsAscending() {
        return this.QUILT_INSTALLER.installers();
    }

    public List<String> installerVersionsDescending() {
        return Lists.reverse(this.QUILT_INSTALLER.installers());
    }

    public String[] installerVersionsArrayAscending() {
        return this.QUILT_INSTALLER.installers().toArray(new String[0]);
    }

    public String[] installerVersionsArrayDescending() {
        return Lists.reverse(this.QUILT_INSTALLER.installers()).toArray(new String[0]);
    }

    public URL latestInstallerUrl() {
        return this.QUILT_INSTALLER.latestInstallerUrl();
    }

    public URL releaseInstallerUrl() {
        return this.QUILT_INSTALLER.releaseInstallerUrl();
    }

    public boolean isInstallerUrlAvailable(String quiltVersion) {
        return Optional.ofNullable(this.QUILT_INSTALLER.meta().get(quiltVersion)).isPresent();
    }

    public Optional<URL> installerUrl(String quiltVersion) {
        return Optional.ofNullable(this.QUILT_INSTALLER.meta().get(quiltVersion));
    }

    public boolean checkQuiltVersion(String quiltVersion) {
        return this.QUILT_LOADER.loaders().contains(quiltVersion);
    }
}

