/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.minecraft;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.versionmeta.Type;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeInstance;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeMeta;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftServer;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public final class MinecraftClient {
    private final String VERSION;
    private final Type TYPE;
    private final URL URL;
    private final MinecraftServer MINECRAFT_SERVER;
    private final ForgeMeta FORGE_META;

    MinecraftClient(String version, Type type, URL url, ForgeMeta forgeMeta, ObjectMapper objectMapper) {
        this.VERSION = version;
        this.TYPE = type;
        this.URL = url;
        this.FORGE_META = forgeMeta;
        this.MINECRAFT_SERVER = new MinecraftServer(version, type, url, objectMapper);
    }

    MinecraftClient(String version, Type type, URL url, MinecraftServer server, ForgeMeta forgeMeta) {
        this.VERSION = version;
        this.TYPE = type;
        this.URL = url;
        this.MINECRAFT_SERVER = server;
        this.FORGE_META = forgeMeta;
    }

    public String version() {
        return this.VERSION;
    }

    public Type type() {
        return this.TYPE;
    }

    public URL url() {
        return this.URL;
    }

    public MinecraftServer server() {
        return this.MINECRAFT_SERVER;
    }

    public Optional<List<ForgeInstance>> forge() {
        return this.FORGE_META.getForgeInstances(this.VERSION);
    }
}

