/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.fabric;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricDetails;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricInstaller;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricIntermediaries;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricIntermediary;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricLoader;
import de.griefed.serverpackcreator.versionmeta.fabric.FabricLoaderDetails;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class FabricMeta {
    private static final Logger LOG = LogManager.getLogger(FabricMeta.class);
    private final File FABRIC_MANIFEST;
    private final File FABRIC_INSTALLER_MANIFEST;
    private final FabricLoader FABRIC_LOADER;
    private final FabricLoaderDetails FABRIC_LOADER_DETAILS;
    private final FabricInstaller FABRIC_INSTALLER;
    private final FabricIntermediaries FABRIC_INTERMEDIARIES;
    private final HashMap<String, FabricDetails> LOADER_DETAILS = new HashMap();

    public FabricMeta(File fabricManifest, File fabricInstallerManifest, File fabricIntermediaryManifest, ObjectMapper objectMapper) throws IOException {
        this.FABRIC_LOADER_DETAILS = new FabricLoaderDetails(objectMapper);
        this.FABRIC_MANIFEST = fabricManifest;
        this.FABRIC_INSTALLER_MANIFEST = fabricInstallerManifest;
        this.FABRIC_LOADER = new FabricLoader(this.getXml(this.FABRIC_MANIFEST));
        this.FABRIC_INTERMEDIARIES = new FabricIntermediaries(fabricIntermediaryManifest, objectMapper);
        this.FABRIC_INSTALLER = new FabricInstaller(this.getXml(this.FABRIC_INSTALLER_MANIFEST));
    }

    public void update() {
        this.FABRIC_LOADER.update(this.getXml(this.FABRIC_MANIFEST));
        this.FABRIC_INSTALLER.update(this.getXml(this.FABRIC_INSTALLER_MANIFEST));
    }

    private Document getXml(File manifest) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        Document xml = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOG.error("Couldn't read document.", (Throwable)ex);
        }
        try {
            assert (documentBuilder != null);
            xml = documentBuilder.parse(manifest);
        }
        catch (IOException | SAXException ex) {
            LOG.error("Couldn't read document.", (Throwable)ex);
        }
        assert (xml != null);
        xml.normalize();
        return xml;
    }

    public String latestLoaderVersion() {
        return this.FABRIC_LOADER.latestLoaderVersion();
    }

    public String releaseLoaderVersion() {
        return this.FABRIC_LOADER.releaseLoaderVersion();
    }

    public List<String> loaderVersionsAscending() {
        return this.FABRIC_LOADER.loaders();
    }

    public List<String> loaderVersionsDescending() {
        return Lists.reverse(this.FABRIC_LOADER.loaders());
    }

    public String[] loaderVersionsArrayAscending() {
        return this.FABRIC_LOADER.loaders().toArray(new String[0]);
    }

    public String[] loaderVersionsArrayDescending() {
        return Lists.reverse(this.FABRIC_LOADER.loaders()).toArray(new String[0]);
    }

    public String latestInstallerVersion() {
        return this.FABRIC_INSTALLER.latestInstallerVersion();
    }

    public String releaseInstallerVersion() {
        return this.FABRIC_INSTALLER.releaseInstallerVersion();
    }

    public List<String> installerVersionsAscending() {
        return this.FABRIC_INSTALLER.installers();
    }

    public List<String> installerVersionsDescending() {
        return Lists.reverse(this.FABRIC_INSTALLER.installers());
    }

    public String[] installerVersionsArrayAscending() {
        return this.FABRIC_INSTALLER.installers().toArray(new String[0]);
    }

    public String[] installerVersionsArrayDescending() {
        return Lists.reverse(this.FABRIC_INSTALLER.installers()).toArray(new String[0]);
    }

    public URL latestInstallerUrl() {
        return this.FABRIC_INSTALLER.latestInstallerUrl();
    }

    public URL releaseInstallerUrl() {
        return this.FABRIC_INSTALLER.releaseInstallerUrl();
    }

    public boolean isInstallerUrlAvailable(String fabricVersion) {
        return Optional.ofNullable(this.FABRIC_INSTALLER.meta().get(fabricVersion)).isPresent();
    }

    public Optional<URL> installerUrl(String fabricVersion) {
        return Optional.ofNullable(this.FABRIC_INSTALLER.meta().get(fabricVersion));
    }

    public Optional<URL> improvedLauncherUrl(String minecraftVersion, String fabricVersion) {
        return this.FABRIC_INSTALLER.improvedLauncherUrl(minecraftVersion, fabricVersion);
    }

    public boolean checkFabricVersion(String fabricVersion) {
        return this.FABRIC_LOADER.loaders().contains(fabricVersion);
    }

    public Optional<FabricDetails> getLoaderDetails(String minecraftVersion, String fabricVersion) {
        String key = minecraftVersion + "-" + fabricVersion;
        if (this.LOADER_DETAILS.containsKey(key)) {
            return Optional.of(this.LOADER_DETAILS.get(key));
        }
        if (this.FABRIC_LOADER_DETAILS.getDetails(minecraftVersion, fabricVersion).isPresent()) {
            this.LOADER_DETAILS.put(key, this.FABRIC_LOADER_DETAILS.getDetails(minecraftVersion, fabricVersion).get());
            return Optional.of(this.LOADER_DETAILS.get(key));
        }
        return Optional.empty();
    }

    public HashMap<String, FabricIntermediary> getFabricIntermediaries() {
        return this.FABRIC_INTERMEDIARIES.getIntermediaries();
    }

    public Optional<FabricIntermediary> getFabricIntermediary(String minecraftVersion) {
        return this.FABRIC_INTERMEDIARIES.getIntermediary(minecraftVersion);
    }
}

