/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities;

import com.electronwill.nightconfig.core.file.NoFormatFoundException;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigurationEditor {
    private static final Logger LOG = LogManager.getLogger(ConfigurationEditor.class);
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final VersionMeta VERSIONMETA;
    private final Utilities UTILITIES;
    private final ConfigUtilities CONFIGUTILITIES;
    private final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
    private File logFile;

    public ConfigurationEditor(ConfigurationHandler injectedConfigurationHandler, ApplicationProperties injectedApplicationProperties, Utilities injectedUtilities, VersionMeta injectedVersionMeta, ConfigUtilities injectedConfigUtilities) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.VERSIONMETA = injectedVersionMeta;
        this.UTILITIES = injectedUtilities;
        this.CONFIGUTILITIES = injectedConfigUtilities;
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler;
    }

    public void continuedRunOptions() {
        int selection;
        LocalDateTime currentTime = LocalDateTime.now();
        this.logFile = new File("logs/configurationCreator-" + this.DATE_TIME_FORMATTER.format(currentTime) + ".log");
        this.checkLogFile();
        Scanner scanner = new Scanner(System.in);
        do {
            this.printMenu();
            selection = this.getDecision(scanner, 0, 2);
            switch (selection) {
                case 1: {
                    this.createConfigurationFile(scanner);
                    break;
                }
                case 2: {
                    this.loadAndEdit(scanner);
                    break;
                }
                case 0: {
                    this.printToFileAndConsole("Exiting Configuration Editor.");
                }
            }
        } while (selection != 0);
        scanner.close();
    }

    private void printMenu() {
        this.printToFileAndConsole();
        this.printToFileAndConsole("What would you like to do?");
        this.printToFileAndConsole("(1) : Create new configuration");
        this.printToFileAndConsole("(2) : Load and edit configuration");
        this.printToFileAndConsole("(0) : Exit");
        this.printToFileAndConsole("-------------------------------------------");
        this.printToFileAndConsole("Enter the number of your selection: ", false);
    }

    private void loadAndEdit(Scanner scanner) {
        int selection;
        ConfigurationModel configurationModel = new ConfigurationModel();
        boolean configLoaded = false;
        do {
            try {
                this.printToFileAndConsole("Please enter the path to the configuration file you want to edit:");
                String fileName = this.getNextLine(scanner);
                configurationModel = new ConfigurationModel(this.UTILITIES, new File(fileName));
                configLoaded = true;
            }
            catch (NoFormatFoundException | FileNotFoundException e) {
                this.printToFileAndConsole("The specified file could not be loaded. " + e.getMessage());
            }
        } while (!configLoaded);
        this.printToFileAndConsole("Configuration successfully loaded.");
        this.printToFileAndConsole();
        do {
            this.CONFIGUTILITIES.printConfigurationModel(configurationModel);
            this.printEditMenu();
            selection = this.getDecision(scanner, 0, 18);
            switch (selection) {
                case 1: {
                    configurationModel.setModpackDir(this.getModpackDirectory(scanner));
                    break;
                }
                case 2: {
                    this.getClientSideMods(scanner, configurationModel.getClientMods());
                    break;
                }
                case 3: {
                    this.getDirsAndFilesToCopy(scanner, configurationModel.getModpackDir(), configurationModel.getCopyDirs());
                    break;
                }
                case 4: {
                    configurationModel.setServerIconPath(this.getServerIcon(scanner));
                    break;
                }
                case 5: {
                    configurationModel.setServerPropertiesPath(this.getServerProperties(scanner));
                    break;
                }
                case 6: {
                    configurationModel.setIncludeServerInstallation(this.installModloaderServer(scanner));
                    break;
                }
                case 7: {
                    configurationModel.setMinecraftVersion(this.getMinecraftVersion(scanner));
                    break;
                }
                case 8: {
                    configurationModel.setModLoader(this.getModloader(scanner));
                    break;
                }
                case 9: {
                    configurationModel.setModLoaderVersion(this.getModloaderVersion(scanner, configurationModel.getMinecraftVersion(), configurationModel.getModLoader()));
                    break;
                }
                case 10: {
                    configurationModel.setJavaPath(this.getJavaPath(scanner));
                    break;
                }
                case 11: {
                    configurationModel.setIncludeServerIcon(this.includeServerIcon(scanner));
                    break;
                }
                case 12: {
                    configurationModel.setIncludeServerProperties(this.includeServerProperties(scanner));
                    break;
                }
                case 13: {
                    configurationModel.setIncludeZipCreation(this.includeZipCreation(scanner));
                    break;
                }
                case 14: {
                    configurationModel.setJavaArgs(this.getJavaArgs(scanner));
                    break;
                }
                case 15: {
                    configurationModel.setServerPackSuffix(this.getServerPackSuffix(scanner));
                    break;
                }
                case 16: {
                    this.saveConfiguration(scanner, configurationModel);
                    break;
                }
                case 17: {
                    this.CONFIGUTILITIES.printConfigurationModel(configurationModel);
                    break;
                }
                case 18: {
                    this.checkConfig(configurationModel);
                    break;
                }
                case 0: {
                    this.printToFileAndConsole("Exiting Configuration Editor.");
                }
            }
        } while (selection != 0);
    }

    private void checkConfig(ConfigurationModel configurationModel) {
        ArrayList<String> errors = new ArrayList<String>();
        this.CONFIGURATIONHANDLER.checkConfiguration(configurationModel, errors, false);
        if (!errors.isEmpty()) {
            this.printToFileAndConsole("Encountered the following errors:");
            for (int i2 = 0; i2 < errors.size(); ++i2) {
                this.printToFileAndConsole("  (" + i2 + "): " + (String)errors.get(i2));
            }
        } else {
            this.printToFileAndConsole("No errors encountered.");
        }
    }

    private void printEditMenu() {
        this.printToFileAndConsole();
        this.printToFileAndConsole("What would you like to edit?");
        this.printToFileAndConsole("(1)  : Path to the modpack directory");
        this.printToFileAndConsole("(2)  : List of clientside-only mods");
        this.printToFileAndConsole("(3)  : List of files and/or folders to include in the server pack");
        this.printToFileAndConsole("(4)  : Path to a custom server-icon.png");
        this.printToFileAndConsole("(5)  : Path to a custom server.properties");
        this.printToFileAndConsole("(6)  : Whether to install the modloader server during server pack generation");
        this.printToFileAndConsole("(7)  : Minecraft version");
        this.printToFileAndConsole("(8)  : Modloader");
        this.printToFileAndConsole("(9)  : Modloader version");
        this.printToFileAndConsole("(10) : Path to Java installation for modloader server installation");
        this.printToFileAndConsole("     - Only relevant if you set (6) to yes/true");
        this.printToFileAndConsole("(11) : Whether to include a server-icon.png in the server pack");
        this.printToFileAndConsole("     - Only relevant if you set (4) to a valid path");
        this.printToFileAndConsole("(12) : Whether to include a server.properties in the server pack");
        this.printToFileAndConsole("     - Only relevant if you set (5) to a valid path");
        this.printToFileAndConsole("(13) : Whether to create a ZIP-archive of the generated server pack");
        this.printToFileAndConsole("(14) : JVM flags / Java Args to run the server of the generated server pack with");
        this.printToFileAndConsole("     - These will be used by the start scripts");
        this.printToFileAndConsole("(15) : Server pack suffix");
        this.printToFileAndConsole("(16) : Save config to file");
        this.printToFileAndConsole("(17) : Print current config");
        this.printToFileAndConsole("(18) : Check configuration");
        this.printToFileAndConsole("(0)  : Exit");
        this.printToFileAndConsole("---------------------------------------------------------------------------------");
        this.printToFileAndConsole("Enter the number of your selection: ", false);
    }

    public void createConfigurationFile(Scanner scanner) {
        ConfigurationModel configurationModel = new ConfigurationModel();
        do {
            configurationModel.setModpackDir(this.getModpackDirectory(scanner));
            this.getClientSideMods(scanner, configurationModel.getClientMods());
            this.getDirsAndFilesToCopy(scanner, configurationModel.getModpackDir(), configurationModel.getCopyDirs());
            configurationModel.setServerIconPath(this.getServerIcon(scanner));
            configurationModel.setServerPropertiesPath(this.getServerProperties(scanner));
            configurationModel.setIncludeServerInstallation(this.installModloaderServer(scanner));
            configurationModel.setMinecraftVersion(this.getMinecraftVersion(scanner));
            configurationModel.setModLoader(this.getModloader(scanner));
            configurationModel.setModLoaderVersion(this.getModloaderVersion(scanner, configurationModel.getMinecraftVersion(), configurationModel.getModLoader()));
            if (configurationModel.getIncludeServerInstallation()) {
                configurationModel.setJavaPath(this.getJavaPath(scanner));
            } else {
                this.printToFileAndConsole("Skipping Java installation path acquisition, as the modloader server installation is deactivated as per your input.");
            }
            if (new File(configurationModel.getServerIconPath()).isFile()) {
                configurationModel.setIncludeServerIcon(this.includeServerIcon(scanner));
            } else {
                this.printToFileAndConsole("You did not specify a server-icon. Setting server-icon inclusion to false.");
            }
            if (new File(configurationModel.getServerPropertiesPath()).isFile()) {
                configurationModel.setIncludeServerProperties(this.includeServerProperties(scanner));
            } else {
                this.printToFileAndConsole("You did not specify the server.properties. Setting server.properties inclusion to false.");
            }
            configurationModel.setIncludeZipCreation(this.includeZipCreation(scanner));
            configurationModel.setJavaArgs(this.getJavaArgs(scanner));
            configurationModel.setServerPackSuffix(this.getServerPackSuffix(scanner));
            this.CONFIGUTILITIES.printConfigurationModel(configurationModel);
            this.printToFileAndConsole("Are you satisfied with this config?");
            this.printToFileAndConsole("Answer: ", false);
        } while (!this.UTILITIES.BooleanUtils().readBoolean(scanner));
        this.printToFileAndConsole("Would you like to check your new configuration for errors?");
        this.printToFileAndConsole("Answer: ", false);
        if (this.UTILITIES.BooleanUtils().readBoolean(scanner)) {
            this.checkConfig(configurationModel);
        }
        this.saveConfiguration(scanner, configurationModel);
    }

    private String getModpackDirectory(Scanner scanner) {
        String modpackDir;
        this.printToFileAndConsole("Please enter your modpack path. This path can be relative to ServerPackCreator, or absolute.");
        this.printToFileAndConsole("Example: \"./Some Modpack\" or \"C:/Minecraft/Some Modpack\"");
        while (true) {
            this.printToFileAndConsole("Path to modpack directory: ", false);
            modpackDir = this.getNextLine(scanner);
            if (!this.CONFIGURATIONHANDLER.checkModpackDir(modpackDir)) continue;
            this.printToFileAndConsole("You entered: " + modpackDir);
            this.printToFileAndConsole("Are you satisfied with this modpack directory?");
            this.printToFileAndConsole("Answer: ", false);
            if (this.UTILITIES.BooleanUtils().readBoolean(scanner)) break;
        }
        modpackDir = modpackDir.replace("\\", "/");
        this.printToFileAndConsole("You entered: " + modpackDir);
        this.printToFileAndConsole();
        return modpackDir;
    }

    private void getClientSideMods(Scanner scanner, List<String> clientMods) {
        int selection = 2;
        do {
            if (!clientMods.isEmpty()) {
                this.printToFileAndConsole("You have entries in your list of clientside-only mods.");
                this.printToFileAndConsole("Would you like to edit (1) that list, or start over (2)?");
                selection = this.getDecision(scanner, 1, 2);
            }
            switch (selection) {
                case 1: {
                    this.editList(scanner, clientMods);
                    break;
                }
                case 2: {
                    clientMods.clear();
                    clientMods.addAll(this.newClientModsList());
                }
            }
            this.printToFileAndConsole("Are you satisfied with this list?");
            this.printToFileAndConsole("Answer: ", false);
        } while (!this.UTILITIES.BooleanUtils().readBoolean(scanner));
        this.printToFileAndConsole("Your list:");
        this.UTILITIES.ListUtils().printListToConsoleChunked(clientMods, 5, "    ", false);
        this.printToFileAndConsole();
    }

    private int getDecision(Scanner scanner, int min2, int max) {
        int selection;
        do {
            try {
                selection = Integer.parseInt(this.getNextLine(scanner));
            }
            catch (Exception ex) {
                this.printToFileAndConsole("Not a valid number. Please pick between " + min2 + " and " + max + ".");
                selection = min2 - 1;
            }
        } while (selection < min2 && selection > max);
        return selection;
    }

    private void editList(Scanner scanner, List<String> list) {
        this.printToFileAndConsole("Available entries in list:");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.printToFileAndConsole("(" + i2 + ") : " + list.get(i2));
        }
        int max = list.size() - 1;
        do {
            this.printToFileAndConsole("Which entry would you like to edit?");
            this.printToFileAndConsole("Enter a number between 0 and " + max);
            int selection = this.getDecision(scanner, 0, max);
            this.printToFileAndConsole("(" + selection + ") of " + max + " = " + list.get(selection));
            this.printToFileAndConsole("Do you want to edit(1) that entry, or delete(2) it?");
            int decision = this.getDecision(scanner, 1, 2);
            switch (decision) {
                case 1: {
                    this.printToFileAndConsole("Enter the new text for this entry:", false);
                    list.set(selection, this.getNextLine(scanner));
                    break;
                }
                case 2: {
                    this.printToFileAndConsole("Deleted " + list.remove(selection) + " from the list.");
                }
            }
            for (int i3 = 0; i3 < list.size(); ++i3) {
                this.printToFileAndConsole("(" + i3 + ") : " + list.get(i3));
            }
            this.printToFileAndConsole("--------------------------------------------------------------------------------");
            this.printToFileAndConsole("Are you satisfied with this list?");
            this.printToFileAndConsole("Answer: ", false);
        } while (!this.UTILITIES.BooleanUtils().readBoolean(scanner));
        this.UTILITIES.ListUtils().printListToConsoleChunked(list, 5, "    ", false);
        this.printToFileAndConsole("List successfully edited.");
    }

    private List<String> newClientModsList() {
        this.printToFileAndConsole("Enter filenames of clientside-only mods, one per line. When you are done, simply press enter with empty input.");
        this.printToFileAndConsole("If you do not specify any clientside-only mods, a default list will be used.");
        List<String> clientMods = this.newCustomList();
        if (clientMods.isEmpty()) {
            clientMods = this.APPLICATIONPROPERTIES.getDefaultListFallbackMods();
            this.printToFileAndConsole("No clientside-only mods specified. Using fallback list.");
            for (String mod : clientMods) {
                this.printToFileAndConsole("    " + mod);
            }
        }
        return clientMods;
    }

    private List<String> newCustomList() {
        ArrayList<String> custom = new ArrayList<String>(this.UTILITIES.ListUtils().readStringList());
        this.printToFileAndConsole("You entered:");
        for (int i2 = 0; i2 < custom.size(); ++i2) {
            this.printToFileAndConsole("  " + i2 + 1 + ". " + (String)custom.get(i2));
        }
        return custom;
    }

    private void getDirsAndFilesToCopy(Scanner scanner, String modpackDir, List<String> copyDirs) {
        this.printToFileAndConsole("Which directories or files should be copied to the server pack? These are folder- or filenames inside your modpack directory or explicit source/file;destination/file-combinations.");
        this.listModpackFilesAndFolders(modpackDir);
        int selection = 2;
        do {
            if (!copyDirs.isEmpty()) {
                this.printToFileAndConsole("You have entries in your list of files/folder to include in the server pack.");
                this.printToFileAndConsole();
                this.UTILITIES.ListUtils().printListToConsoleChunked(copyDirs, 1, "    ", true);
                this.printToFileAndConsole();
                this.printToFileAndConsole("Would you like to edit (1) that list, start over (2), or list the files in your modpack directory (3) again?");
                selection = this.getDecision(scanner, 1, 3);
            }
            switch (selection) {
                case 1: {
                    this.editList(scanner, copyDirs);
                    break;
                }
                case 2: {
                    copyDirs.clear();
                    copyDirs.addAll(this.newCustomList());
                    break;
                }
                case 3: {
                    this.listModpackFilesAndFolders(modpackDir);
                }
            }
            this.printToFileAndConsole("Are you satisfied with this list?");
            this.printToFileAndConsole("Answer: ", false);
        } while (!this.UTILITIES.BooleanUtils().readBoolean(scanner));
        this.printToFileAndConsole("Your list:");
        for (int i2 = 0; i2 < copyDirs.size(); ++i2) {
            this.printToFileAndConsole("  " + i2 + 1 + ". " + copyDirs.get(i2));
        }
        this.printToFileAndConsole();
    }

    private void listModpackFilesAndFolders(String modpackDir) {
        try {
            ArrayList<File> dirList = new ArrayList<File>(FileUtils.listFiles(new File(modpackDir), null, false));
            if (dirList.size() > 0) {
                this.printToFileAndConsole("The modpack directory you specified contains the following directories:");
                for (int i2 = 0; i2 < dirList.size(); ++i2) {
                    this.printToFileAndConsole("  " + (i2 + 1) + ". " + dirList.get(i2));
                }
            } else {
                this.printToFileAndConsole("No files or directories found in " + modpackDir);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getServerIcon(Scanner scanner) {
        String serverIconPath;
        this.printToFileAndConsole("Enter the path to your custom server-icon.png-file, if you want to include one. Leave blank if you are fine with the default.");
        while (true) {
            this.printToFileAndConsole("Path to your server-icon.png: ", false);
            serverIconPath = this.getNextLine(scanner);
            if (!this.CONFIGURATIONHANDLER.checkIconAndProperties(serverIconPath)) continue;
            this.printToFileAndConsole("You entered: " + serverIconPath);
            this.printToFileAndConsole("Are you satisfied with this setting?");
            this.printToFileAndConsole("Answer: ", false);
            if (this.UTILITIES.BooleanUtils().readBoolean(scanner)) break;
        }
        serverIconPath = serverIconPath.replace("\\", "/");
        this.printToFileAndConsole("You entered: " + serverIconPath);
        this.printToFileAndConsole();
        return serverIconPath;
    }

    private String getServerProperties(Scanner scanner) {
        String serverPropertiesPath;
        this.printToFileAndConsole("Enter the path to your custom server.properties-file, if you want to include one. Leave blank if you are fine with the default.");
        while (true) {
            this.printToFileAndConsole("Path to your server.properties: ", false);
            serverPropertiesPath = this.getNextLine(scanner);
            if (!this.CONFIGURATIONHANDLER.checkIconAndProperties(serverPropertiesPath)) continue;
            this.printToFileAndConsole("You entered: " + serverPropertiesPath);
            this.printToFileAndConsole("Are you satisfied with this setting?");
            this.printToFileAndConsole("Answer: ", false);
            if (this.UTILITIES.BooleanUtils().readBoolean(scanner)) break;
        }
        serverPropertiesPath = serverPropertiesPath.replace("\\", "/");
        this.printToFileAndConsole("You entered: " + serverPropertiesPath);
        this.printToFileAndConsole();
        return serverPropertiesPath;
    }

    private boolean installModloaderServer(Scanner scanner) {
        this.printToFileAndConsole("Do you want ServerPackCreator to install the modloader server for your server pack? Must be true or false.");
        this.printToFileAndConsole("Include modloader server installation: ", false);
        boolean includeServerInstallation = this.UTILITIES.BooleanUtils().readBoolean(scanner);
        this.printToFileAndConsole("You entered: " + includeServerInstallation);
        return includeServerInstallation;
    }

    private String getMinecraftVersion(Scanner scanner) {
        String minecraftVersion;
        this.printToFileAndConsole("Which version of Minecraft does your modpack use?");
        do {
            this.printToFileAndConsole("Minecraft version: ", false);
            minecraftVersion = this.getNextLine(scanner);
        } while (!this.VERSIONMETA.minecraft().checkMinecraftVersion(minecraftVersion));
        this.printToFileAndConsole("You entered: " + minecraftVersion);
        this.printToFileAndConsole();
        return minecraftVersion;
    }

    private String getModloader(Scanner scanner) {
        String modLoader;
        this.printToFileAndConsole("What modloader does your modpack use?");
        do {
            this.printToFileAndConsole("Modloader: ", false);
        } while (!this.CONFIGURATIONHANDLER.checkModloader(modLoader = this.getNextLine(scanner)));
        modLoader = this.CONFIGUTILITIES.getModLoaderCase(modLoader);
        this.printToFileAndConsole("You entered: " + modLoader);
        this.printToFileAndConsole();
        return modLoader;
    }

    private String getModloaderVersion(Scanner scanner, String minecraftVersion, String modLoader) {
        String modLoaderVersion;
        this.printToFileAndConsole("What version of " + modLoader + " does your modpack use?");
        do {
            this.printToFileAndConsole("Modloader version: ", false);
        } while (!this.CONFIGURATIONHANDLER.checkModloaderVersion(modLoader, modLoaderVersion = this.getNextLine(scanner), minecraftVersion));
        this.printToFileAndConsole("You entered: " + modLoaderVersion);
        this.printToFileAndConsole();
        return modLoaderVersion;
    }

    private String getJavaPath(Scanner scanner) {
        this.printToFileAndConsole("Specify the path to your Java installation. Must end with \"java\" on Linux, or \"java.exe\" on Windows.");
        this.printToFileAndConsole("If you leave this empty, ServerPackCreator will try to determine the path for you.");
        this.printToFileAndConsole("Example Linux: /usr/bin/java | Example Windows: C:/Program Files/AdoptOpenJDK/jdk-8.0.275.1-hotspot/jre/bin/java.exe");
        this.printToFileAndConsole("Path to your Java installation: ", false);
        String javaPath = this.CONFIGURATIONHANDLER.getJavaPath(this.getNextLine(scanner));
        this.printToFileAndConsole("Automatically acquired path to Java installation: " + javaPath);
        this.printToFileAndConsole();
        return javaPath;
    }

    private boolean includeServerIcon(Scanner scanner) {
        this.printToFileAndConsole("Do you want ServerPackCreator to include a server-icon in your server pack? Must be true or false.");
        this.printToFileAndConsole("Include server-icon.png: ", false);
        boolean includeServerIcon = this.UTILITIES.BooleanUtils().readBoolean(scanner);
        this.printToFileAndConsole("You entered: " + includeServerIcon);
        this.printToFileAndConsole();
        return includeServerIcon;
    }

    private boolean includeServerProperties(Scanner scanner) {
        this.printToFileAndConsole("Do you want ServerPackCreator to include a server.properties in your server pack? Must be true or false.");
        this.printToFileAndConsole("Include server.properties: ", false);
        boolean includeServerProperties = this.UTILITIES.BooleanUtils().readBoolean(scanner);
        this.printToFileAndConsole("You entered: " + includeServerProperties);
        this.printToFileAndConsole();
        return includeServerProperties;
    }

    private boolean includeZipCreation(Scanner scanner) {
        this.printToFileAndConsole("Do you want ServerPackCreator to create a ZIP-archive of your server pack? Must be true or false.");
        this.printToFileAndConsole("Create ZIP-archive: ", false);
        boolean includeZipCreation = this.UTILITIES.BooleanUtils().readBoolean(scanner);
        this.printToFileAndConsole("You entered: " + includeZipCreation);
        this.printToFileAndConsole();
        return includeZipCreation;
    }

    private String getJavaArgs(Scanner scanner) {
        this.printToFileAndConsole("Specify the Java arguments, if any, to execute the server with. Can be left blank.");
        this.printToFileAndConsole("Java args: ", false);
        String javaArgs = this.getNextLine(scanner);
        if (javaArgs.isEmpty()) {
            javaArgs = "";
        }
        this.printToFileAndConsole("Java arguments for start-scripts: " + javaArgs);
        this.printToFileAndConsole();
        return javaArgs;
    }

    private String getServerPackSuffix(Scanner scanner) {
        this.printToFileAndConsole("Enter the suffix you want to append to your server pack. Can be left empty.");
        this.printToFileAndConsole("Server pack suffix: ", false);
        return this.getNextLine(scanner);
    }

    private void saveConfiguration(Scanner scanner, ConfigurationModel configurationModel) {
        this.printToFileAndConsole("Would you like to save this configuration as an additional, separate, configuration file?");
        if (this.UTILITIES.BooleanUtils().readBoolean(scanner)) {
            this.printToFileAndConsole("Enter the name under which you want to additionally store the above configuration:");
            File customFileName = new File(this.UTILITIES.StringUtils().pathSecureText(this.getNextLine(scanner)));
            if (this.CONFIGUTILITIES.writeConfigToFile(configurationModel, customFileName)) {
                this.printToFileAndConsole("Your configuration has been saved as '" + customFileName + "'.");
                this.printToFileAndConsole("Please note that running ServerPackCreator in CLI mode requires a valid 'serverpackcreator.conf'-file to be present.");
                this.printToFileAndConsole("You may load the previous configuration, saved as '" + customFileName + "' and save it as 'serverpackcreator.conf'");
            }
        } else if (this.CONFIGUTILITIES.writeConfigToFile(configurationModel, this.APPLICATIONPROPERTIES.DEFAULT_CONFIG())) {
            this.printToFileAndConsole("Your configuration has been saved as 'serverpackcreator.conf'.");
        }
    }

    private String getNextLine(Scanner scanner) {
        String text = scanner.nextLine();
        this.printToFile(text, true);
        return text;
    }

    private void printToFileAndConsole() {
        this.printToFileAndConsole("");
    }

    private void printToFileAndConsole(String text) {
        this.printToFileAndConsole(text, true);
    }

    private void printToFileAndConsole(String text, boolean newLine) {
        if (newLine) {
            System.out.println(text);
        } else {
            System.out.print(text);
        }
        this.printToFile(text, newLine);
    }

    private void printToFile(String text, boolean newLine) {
        block5: {
            if (this.logFile.exists()) {
                try {
                    if (newLine) {
                        FileUtils.writeStringToFile(this.logFile, text + "\n", StandardCharsets.UTF_8, true);
                        break block5;
                    }
                    FileUtils.writeStringToFile(this.logFile, text, StandardCharsets.UTF_8, true);
                }
                catch (IOException ex) {
                    LOG.error("Could not write to logfile " + this.logFile.getName(), (Throwable)ex);
                }
            } else {
                LOG.error("Logfile " + this.logFile.getName() + " does not exist.");
            }
        }
    }

    private void checkLogFile() {
        ArrayList<File> files = new ArrayList<File>(FileUtils.listFiles(new File("logs"), null, false));
        for (File file : files) {
            if (!file.getName().contains("configurationCreator")) continue;
            try {
                FileUtils.moveFile(file, new File("logs/archive/" + file.getName()));
            }
            catch (IOException ex) {
                LOG.error("Could not move " + file.getName() + " to archive.", (Throwable)ex);
            }
        }
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException ex) {
                LOG.error("Could not create logfile " + this.logFile.getName(), (Throwable)ex);
            }
        }
    }
}

