/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing;

import de.griefed.larsonscanner.LarsonScanner;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.ServerPackHandler;
import de.griefed.serverpackcreator.i18n.I18n;
import de.griefed.serverpackcreator.swing.ServerPackCreatorGui;
import de.griefed.serverpackcreator.swing.themes.DarkTheme;
import de.griefed.serverpackcreator.swing.themes.LightTheme;
import de.griefed.serverpackcreator.swing.utilities.CompoundIcon;
import de.griefed.serverpackcreator.swing.utilities.IconTextArea;
import de.griefed.serverpackcreator.swing.utilities.IconTextField;
import de.griefed.serverpackcreator.swing.utilities.RotatedIcon;
import de.griefed.serverpackcreator.swing.utilities.TextIcon;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.ReticulatingSplines;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import mdlaf.components.textpane.MaterialTextPaneUI;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TabCreateServerPack
extends JPanel {
    private static final Logger LOG = LogManager.getLogger(TabCreateServerPack.class);
    private final JFrame FRAME_SERVERPACKCREATOR;
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final I18n I18N;
    private final ServerPackHandler SERVERPACKHANDLER;
    private final VersionMeta VERSIONMETA;
    private final Utilities UTILITIES;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ConfigUtilities CONFIGUTILITIES;
    private final DarkTheme DARKTHEME;
    private final LightTheme LIGHTTHEME;
    private final StyledDocument SERVERPACKGENERATEDDOCUMENT = new DefaultStyledDocument();
    private final SimpleAttributeSet SERVERPACKGENERATEDATTRIBUTESET = new SimpleAttributeSet();
    private final JTextPane SERVERPACKGENERATEDTEXTPANE = new JTextPane(this.SERVERPACKGENERATEDDOCUMENT);
    private final StyledDocument LAZYMODEDOCUMENT = new DefaultStyledDocument();
    private final JTextPane LAZYMODETEXTPANE = new JTextPane(this.LAZYMODEDOCUMENT);
    private final int ERROR_ICON_SIZE = 18;
    private final BufferedImage ERROR_ICON_BASE = ImageIO.read(Objects.requireNonNull(ServerPackCreatorGui.class.getResource("/de/griefed/resources/gui/error.png")));
    private final ImageIcon ERROR_ICON_MODPACKDIRECTORY = new ImageIcon(this.ERROR_ICON_BASE.getScaledInstance(18, 18, 4));
    private final ImageIcon ERROR_ICON_SERVERPACK_SUFFIX = new ImageIcon(this.ERROR_ICON_BASE.getScaledInstance(18, 18, 4));
    private final ImageIcon ERROR_ICON_CLIENTSIDE_MODS = new ImageIcon(this.ERROR_ICON_BASE.getScaledInstance(18, 18, 4));
    private final ImageIcon ERROR_ICON_COPYDIRECTORIES = new ImageIcon(this.ERROR_ICON_BASE.getScaledInstance(18, 18, 4));
    private final ImageIcon ERROR_ICON_JAVAPATH = new ImageIcon(this.ERROR_ICON_BASE.getScaledInstance(18, 18, 4));
    private final ImageIcon ERROR_ICON_SERVERICON = new ImageIcon(this.ERROR_ICON_BASE.getScaledInstance(18, 18, 4));
    private final ImageIcon ERROR_ICON_SERVERPROPERTIES = new ImageIcon(this.ERROR_ICON_BASE.getScaledInstance(18, 18, 4));
    private final Dimension CHOOSERDIMENSION = new Dimension(750, 450);
    private final JButton BUTTON_GENERATESERVERPACK = new JButton();
    private final JPanel CREATESERVERPACKPANEL = new JPanel();
    private final LarsonScanner STATUS_BAR = new LarsonScanner();
    private final LarsonScanner.ScannerConfig IDLE_CONFIG = new LarsonScanner.ScannerConfig(2, new short[]{25, 50, 75, 100, 150, 200, 255}, 50, 50, 7, new float[]{0.4f, 1.0f}, 50.0f, 5.0, false, false, true, false, false, new Color[]{new Color(50, 83, 88), new Color(50, 83, 88), new Color(50, 83, 88), new Color(50, 83, 88), new Color(50, 83, 88), new Color(50, 83, 88), new Color(50, 83, 88)}, new Color(49, 47, 47), new Color(49, 47, 47));
    private final LarsonScanner.ScannerConfig BUSY_CONFIG = new LarsonScanner.ScannerConfig(2, new short[]{25, 50, 75, 100, 150, 200, 255}, 100, 25, 7, new float[]{0.4f, 1.0f}, 25.0f, 5.0, false, false, true, true, false, new Color[]{new Color(192, 255, 238), new Color(192, 255, 238), new Color(192, 255, 238), new Color(192, 255, 238), new Color(192, 255, 238), new Color(192, 255, 238), new Color(192, 255, 238)}, new Color(49, 47, 47), new Color(49, 47, 47));
    private final MaterialTextPaneUI MATERIALTEXTPANEUI = new MaterialTextPaneUI();
    private final JComboBox<String> COMBOBOX_MINECRAFTVERSIONS = new JComboBox();
    private final JComboBox<String> COMBOBOX_MODLOADERS = new JComboBox();
    private final JComboBox<String> COMBOBOX_MODLOADER_VERSIONS = new JComboBox();
    private final DefaultComboBoxModel<String> FABRIC_VERSIONS;
    private final DefaultComboBoxModel<String> QUILT_VERSIONS;
    private final IconTextArea TEXTAREA_CLIENTSIDEMODS = new IconTextArea("");
    private final IconTextArea TEXTAREA_JAVAARGS = new IconTextArea("");
    private final IconTextArea TEXTAREA_COPYDIRECTORIES = new IconTextArea("");
    private final IconTextField TEXTFIELD_MODPACKDIRECTORY = new IconTextField("");
    private final IconTextField TEXTFIELD_JAVAPATH = new IconTextField("");
    private final IconTextField TEXTFIELD_SERVERPACKSUFFIX = new IconTextField("");
    private final IconTextField TEXTFIELD_SERVERICONPATH = new IconTextField("");
    private final IconTextField TEXTFIELD_SERVERPROPERTIESPATH = new IconTextField("");
    private final File DIRECTORY_CHOOSER = new File(".");
    private final String[] NONE;
    private final JLabel STATUS_LABEL_LINE_0;
    private final JLabel STATUS_LABEL_LINE_1;
    private final JLabel STATUS_LABEL_LINE_2;
    private final JLabel STATUS_LABEL_LINE_3;
    private final JLabel STATUS_LABEL_LINE_4;
    private final JLabel STATUS_LABEL_LINE_5;
    private final JCheckBox CHECKBOX_SERVER;
    private final JCheckBox CHECKBOX_ICON;
    private final JCheckBox CHECKBOX_PROPERTIES;
    private final JCheckBox CHECKBOX_ZIP;
    private String chosenModloader = "Fabric";
    private String chosenModloaderVersion;
    private String chosenMinecraftVersion = "1.18.2";
    private String javaArgs = "";

    public TabCreateServerPack(I18n injectedI18n, ConfigurationHandler injectedConfigurationHandler, ServerPackHandler injectedServerPackHandler, VersionMeta injectedVersionMeta, ApplicationProperties injectedApplicationProperties, JFrame injectedServerPackCreatorFrame, Utilities injectedUtilities, ConfigUtilities injectedConfigUtilities, DarkTheme injectedDarkTheme, LightTheme injectedLightTheme) throws IOException {
        Insets ZERO_TEN_ZERO_TEN;
        Insets ZERO_TEN_ZERO_ZERO;
        Insets TWENTY_TEN_ZERO_ZERO;
        this.DARKTHEME = injectedDarkTheme;
        this.LIGHTTHEME = injectedLightTheme;
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.I18N = injectedI18n;
        this.VERSIONMETA = injectedVersionMeta;
        this.UTILITIES = injectedUtilities;
        this.CONFIGUTILITIES = injectedConfigUtilities;
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler;
        this.SERVERPACKHANDLER = injectedServerPackHandler;
        this.FRAME_SERVERPACKCREATOR = injectedServerPackCreatorFrame;
        this.SERVERPACKGENERATEDTEXTPANE.setOpaque(false);
        this.SERVERPACKGENERATEDTEXTPANE.setEditable(false);
        StyleConstants.setBold(this.SERVERPACKGENERATEDATTRIBUTESET, true);
        StyleConstants.setFontSize(this.SERVERPACKGENERATEDATTRIBUTESET, 14);
        this.SERVERPACKGENERATEDTEXTPANE.setCharacterAttributes(this.SERVERPACKGENERATEDATTRIBUTESET, true);
        StyleConstants.setAlignment(this.SERVERPACKGENERATEDATTRIBUTESET, 0);
        try {
            this.SERVERPACKGENERATEDDOCUMENT.insertString(0, this.I18N.getMessage("createserverpack.gui.createserverpack.openfolder.browse"), this.SERVERPACKGENERATEDATTRIBUTESET);
        }
        catch (BadLocationException ex) {
            LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
        }
        this.LAZYMODETEXTPANE.setOpaque(false);
        this.LAZYMODETEXTPANE.setEditable(false);
        SimpleAttributeSet LAZYMODEATTRIBUTESET = new SimpleAttributeSet();
        StyleConstants.setBold(LAZYMODEATTRIBUTESET, true);
        StyleConstants.setFontSize(LAZYMODEATTRIBUTESET, 14);
        this.LAZYMODETEXTPANE.setCharacterAttributes(LAZYMODEATTRIBUTESET, true);
        StyleConstants.setAlignment(LAZYMODEATTRIBUTESET, 0);
        try {
            this.LAZYMODEDOCUMENT.insertString(0, this.I18N.getMessage("configuration.log.warn.checkconfig.copydirs.lazymode0") + "\n\n" + this.I18N.getMessage("configuration.log.warn.checkconfig.copydirs.lazymode1") + "\n" + this.I18N.getMessage("configuration.log.warn.checkconfig.copydirs.lazymode2") + "\n" + this.I18N.getMessage("configuration.log.warn.checkconfig.copydirs.lazymode3") + "\n\n" + this.I18N.getMessage("configuration.log.warn.checkconfig.copydirs.lazymode0"), LAZYMODEATTRIBUTESET);
        }
        catch (BadLocationException ex) {
            LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
        }
        this.NONE = new String[]{this.I18N.getMessage("createserverpack.gui.createserverpack.forge.none")};
        this.FABRIC_VERSIONS = new DefaultComboBoxModel<String>(this.VERSIONMETA.fabric().loaderVersionsArrayDescending());
        this.QUILT_VERSIONS = new DefaultComboBoxModel<String>(this.VERSIONMETA.quilt().loaderVersionsArrayDescending());
        this.CREATESERVERPACKPANEL.setLayout(new GridBagLayout());
        GridBagConstraints GRIDBAGCONSTRAINTS = new GridBagConstraints();
        GRIDBAGCONSTRAINTS.fill = 2;
        GRIDBAGCONSTRAINTS.gridwidth = 3;
        GRIDBAGCONSTRAINTS.weightx = 1.0;
        JLabel labelModpackDir = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labelmodpackdir"));
        labelModpackDir.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelmodpackdir.tip"));
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 0;
        GRIDBAGCONSTRAINTS.insets = TWENTY_TEN_ZERO_ZERO = new Insets(20, 10, 0, 0);
        this.CREATESERVERPACKPANEL.add((Component)labelModpackDir, GRIDBAGCONSTRAINTS);
        this.TEXTFIELD_MODPACKDIRECTORY.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelmodpackdir.tip"));
        this.TEXTFIELD_MODPACKDIRECTORY.addDocumentListener(e -> this.validateModpackDir());
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 1;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_ZERO = new Insets(0, 10, 0, 0);
        this.CREATESERVERPACKPANEL.add((Component)this.TEXTFIELD_MODPACKDIRECTORY, GRIDBAGCONSTRAINTS);
        JLabel labelServerPackSuffix = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labelsuffix"));
        labelServerPackSuffix.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelsuffix.tip"));
        GRIDBAGCONSTRAINTS.gridwidth = 2;
        GRIDBAGCONSTRAINTS.gridx = 4;
        GRIDBAGCONSTRAINTS.gridy = 0;
        GRIDBAGCONSTRAINTS.insets = new Insets(20, -140, 0, 0);
        this.CREATESERVERPACKPANEL.add((Component)labelServerPackSuffix, GRIDBAGCONSTRAINTS);
        this.TEXTFIELD_SERVERPACKSUFFIX.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelsuffix.tip"));
        this.ERROR_ICON_SERVERPACK_SUFFIX.setDescription(this.I18N.getMessage("createserverpack.gui.createserverpack.textsuffix.error"));
        this.TEXTFIELD_SERVERPACKSUFFIX.addDocumentListener(e -> this.validateSuffix());
        GRIDBAGCONSTRAINTS.gridwidth = 1;
        GRIDBAGCONSTRAINTS.gridx = 4;
        GRIDBAGCONSTRAINTS.gridy = 1;
        GRIDBAGCONSTRAINTS.insets = new Insets(0, -140, 0, 0);
        this.CREATESERVERPACKPANEL.add((Component)this.TEXTFIELD_SERVERPACKSUFFIX, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.gridwidth = 5;
        JLabel labelClientMods = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labelclientmods"));
        labelClientMods.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelclientmods.tip"));
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 2;
        GRIDBAGCONSTRAINTS.insets = TWENTY_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)labelClientMods, GRIDBAGCONSTRAINTS);
        this.TEXTAREA_CLIENTSIDEMODS.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelclientmods.tip"));
        this.TEXTAREA_CLIENTSIDEMODS.setFont(new Font("Noto Sans Display Regular", 0, 15));
        this.ERROR_ICON_CLIENTSIDE_MODS.setDescription(this.I18N.getMessage("createserverpack.gui.createserverpack.textclientmods.error"));
        this.TEXTAREA_CLIENTSIDEMODS.addDocumentListener(e -> this.validateClientMods());
        JPanel CLIENTSIDEMODS_JPANEL = new JPanel();
        CLIENTSIDEMODS_JPANEL.setLayout(new GridBagLayout());
        GridBagConstraints TEXTAREA_CLIENTSIDEMODS_JPANEL_CONSTRAINTS = new GridBagConstraints();
        TEXTAREA_CLIENTSIDEMODS_JPANEL_CONSTRAINTS.anchor = 10;
        TEXTAREA_CLIENTSIDEMODS_JPANEL_CONSTRAINTS.fill = 1;
        TEXTAREA_CLIENTSIDEMODS_JPANEL_CONSTRAINTS.gridx = 0;
        TEXTAREA_CLIENTSIDEMODS_JPANEL_CONSTRAINTS.gridy = 0;
        TEXTAREA_CLIENTSIDEMODS_JPANEL_CONSTRAINTS.weighty = 1.0;
        TEXTAREA_CLIENTSIDEMODS_JPANEL_CONSTRAINTS.weightx = 1.0;
        JScrollPane SCROLL_PANEL_CLIENTSIDEMODS = new JScrollPane(this.TEXTAREA_CLIENTSIDEMODS, 22, 30);
        CLIENTSIDEMODS_JPANEL.add((Component)SCROLL_PANEL_CLIENTSIDEMODS, TEXTAREA_CLIENTSIDEMODS_JPANEL_CONSTRAINTS);
        CLIENTSIDEMODS_JPANEL.setSize(100, 100);
        CLIENTSIDEMODS_JPANEL.setPreferredSize(new Dimension(100, 100));
        CLIENTSIDEMODS_JPANEL.setMaximumSize(new Dimension(100, 100));
        CLIENTSIDEMODS_JPANEL.setMinimumSize(new Dimension(100, 100));
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 3;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)CLIENTSIDEMODS_JPANEL, GRIDBAGCONSTRAINTS);
        JLabel labelCopyDirs = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labelcopydirs"));
        labelCopyDirs.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelcopydirs.tip"));
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 4;
        GRIDBAGCONSTRAINTS.insets = TWENTY_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)labelCopyDirs, GRIDBAGCONSTRAINTS);
        this.TEXTAREA_COPYDIRECTORIES.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelcopydirs.tip"));
        this.TEXTAREA_COPYDIRECTORIES.setFont(new Font("Noto Sans Display Regular", 0, 15));
        this.ERROR_ICON_COPYDIRECTORIES.setDescription(this.I18N.getMessage("createserverpack.gui.createserverpack.textclientmods.error"));
        this.TEXTAREA_COPYDIRECTORIES.addDocumentListener(e -> this.validateCopyDirs());
        JPanel COPYDIRECTORIES_JPANEL = new JPanel();
        COPYDIRECTORIES_JPANEL.setLayout(new GridBagLayout());
        GridBagConstraints TEXTAREA_COPYDIRECTORIES_JPANEL_CONSTRAINTS = new GridBagConstraints();
        TEXTAREA_COPYDIRECTORIES_JPANEL_CONSTRAINTS.anchor = 10;
        TEXTAREA_COPYDIRECTORIES_JPANEL_CONSTRAINTS.fill = 1;
        TEXTAREA_COPYDIRECTORIES_JPANEL_CONSTRAINTS.gridx = 0;
        TEXTAREA_COPYDIRECTORIES_JPANEL_CONSTRAINTS.gridy = 0;
        TEXTAREA_COPYDIRECTORIES_JPANEL_CONSTRAINTS.weighty = 1.0;
        TEXTAREA_COPYDIRECTORIES_JPANEL_CONSTRAINTS.weightx = 1.0;
        JScrollPane SCROLL_PANEL_COPYDIRECTORIES = new JScrollPane(this.TEXTAREA_COPYDIRECTORIES, 22, 30);
        COPYDIRECTORIES_JPANEL.add((Component)SCROLL_PANEL_COPYDIRECTORIES, TEXTAREA_COPYDIRECTORIES_JPANEL_CONSTRAINTS);
        COPYDIRECTORIES_JPANEL.setSize(100, 100);
        COPYDIRECTORIES_JPANEL.setPreferredSize(new Dimension(100, 100));
        COPYDIRECTORIES_JPANEL.setMaximumSize(new Dimension(100, 100));
        COPYDIRECTORIES_JPANEL.setMinimumSize(new Dimension(100, 100));
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 5;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)COPYDIRECTORIES_JPANEL, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.fill = 2;
        GRIDBAGCONSTRAINTS.gridwidth = 2;
        JLabel labelServerIconPath = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labeliconpath"));
        labelServerIconPath.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labeliconpath.tip"));
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 6;
        GRIDBAGCONSTRAINTS.insets = TWENTY_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)labelServerIconPath, GRIDBAGCONSTRAINTS);
        this.TEXTFIELD_SERVERICONPATH.setText("");
        this.TEXTFIELD_SERVERICONPATH.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.textfield.iconpath"));
        this.ERROR_ICON_SERVERICON.setDescription(this.I18N.getMessage("createserverpack.gui.createserverpack.textfield.iconpath.error"));
        this.TEXTFIELD_SERVERICONPATH.addDocumentListener(e -> this.validateServerIcon());
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 7;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)this.TEXTFIELD_SERVERICONPATH, GRIDBAGCONSTRAINTS);
        JLabel labelServerPropertiesPath = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labelpropertiespath"));
        labelServerPropertiesPath.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelpropertiespath.tip"));
        GRIDBAGCONSTRAINTS.gridx = 3;
        GRIDBAGCONSTRAINTS.gridy = 6;
        GRIDBAGCONSTRAINTS.insets = new Insets(20, -190, 0, 0);
        this.CREATESERVERPACKPANEL.add((Component)labelServerPropertiesPath, GRIDBAGCONSTRAINTS);
        this.TEXTFIELD_SERVERPROPERTIESPATH.setText("");
        this.TEXTFIELD_SERVERPROPERTIESPATH.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.textfield.propertiespath"));
        this.ERROR_ICON_SERVERPROPERTIES.setDescription(this.I18N.getMessage("createserverpack.gui.createserverpack.textfield.propertiespath.error"));
        this.TEXTFIELD_SERVERPROPERTIESPATH.addDocumentListener(e -> this.validateServerProperties());
        GRIDBAGCONSTRAINTS.gridx = 3;
        GRIDBAGCONSTRAINTS.gridy = 7;
        GRIDBAGCONSTRAINTS.insets = new Insets(0, -190, 0, 0);
        this.CREATESERVERPACKPANEL.add((Component)this.TEXTFIELD_SERVERPROPERTIESPATH, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.fill = 2;
        GRIDBAGCONSTRAINTS.gridwidth = 5;
        JLabel labelJavaPath = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labeljavapath"));
        labelJavaPath.setToolTipText("<html>" + this.I18N.getMessage("createserverpack.gui.createserverpack.labeljavapath.tip") + "</html>");
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 8;
        GRIDBAGCONSTRAINTS.insets = TWENTY_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)labelJavaPath, GRIDBAGCONSTRAINTS);
        this.TEXTFIELD_JAVAPATH.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labeljavapath.tip"));
        this.ERROR_ICON_JAVAPATH.setDescription(this.I18N.getMessage("createserverpack.gui.createserverpack.textjavapath.error"));
        this.TEXTFIELD_JAVAPATH.addDocumentListener(e -> this.validateJavaPath());
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 9;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)this.TEXTFIELD_JAVAPATH, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.gridwidth = 1;
        JLabel labelMinecraftVersion = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labelminecraft"));
        labelMinecraftVersion.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelminecraft.tip"));
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 10;
        GRIDBAGCONSTRAINTS.insets = TWENTY_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)labelMinecraftVersion, GRIDBAGCONSTRAINTS);
        if (this.APPLICATIONPROPERTIES.enableMinecraftPreReleases()) {
            this.COMBOBOX_MINECRAFTVERSIONS.setModel(new DefaultComboBoxModel<String>(this.VERSIONMETA.minecraft().allVersionsArrayDescending()));
        } else {
            this.COMBOBOX_MINECRAFTVERSIONS.setModel(new DefaultComboBoxModel<String>(this.VERSIONMETA.minecraft().releaseVersionsArrayDescending()));
        }
        if (this.COMBOBOX_MINECRAFTVERSIONS.getSelectedItem() == null) {
            this.COMBOBOX_MINECRAFTVERSIONS.setSelectedIndex(0);
        }
        this.COMBOBOX_MINECRAFTVERSIONS.addActionListener(this::actionEventComboBoxMinecraftVersion);
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 11;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add(this.COMBOBOX_MINECRAFTVERSIONS, GRIDBAGCONSTRAINTS);
        JLabel labelModloader = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labelmodloader"));
        labelModloader.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelmodloader.tip"));
        GRIDBAGCONSTRAINTS.gridx = 1;
        GRIDBAGCONSTRAINTS.gridy = 10;
        GRIDBAGCONSTRAINTS.insets = TWENTY_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)labelModloader, GRIDBAGCONSTRAINTS);
        this.COMBOBOX_MODLOADERS.setModel(new DefaultComboBoxModel<String>(this.APPLICATIONPROPERTIES.SUPPORTED_MODLOADERS()));
        if (this.COMBOBOX_MODLOADERS.getSelectedItem() == null) {
            this.COMBOBOX_MODLOADERS.setSelectedIndex(0);
        }
        this.COMBOBOX_MODLOADERS.addActionListener(this::actionEventComboBoxModloaders);
        GRIDBAGCONSTRAINTS.fill = 2;
        GRIDBAGCONSTRAINTS.anchor = 17;
        GRIDBAGCONSTRAINTS.gridx = 1;
        GRIDBAGCONSTRAINTS.gridy = 11;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add(this.COMBOBOX_MODLOADERS, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.fill = 2;
        GRIDBAGCONSTRAINTS.gridwidth = 2;
        JLabel labelModloaderVersion = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.labelmodloaderversion"));
        labelModloaderVersion.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelmodloaderversion.tip"));
        GRIDBAGCONSTRAINTS.gridx = 2;
        GRIDBAGCONSTRAINTS.gridy = 10;
        GRIDBAGCONSTRAINTS.insets = TWENTY_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)labelModloaderVersion, GRIDBAGCONSTRAINTS);
        this.COMBOBOX_MODLOADER_VERSIONS.setModel(this.FABRIC_VERSIONS);
        this.COMBOBOX_MODLOADER_VERSIONS.setSelectedIndex(0);
        this.COMBOBOX_MODLOADER_VERSIONS.addActionListener(this::actionEventComboBoxModloaderVersions);
        this.COMBOBOX_MODLOADER_VERSIONS.setVisible(true);
        GRIDBAGCONSTRAINTS.gridx = 2;
        GRIDBAGCONSTRAINTS.gridy = 11;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add(this.COMBOBOX_MODLOADER_VERSIONS, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.insets = new Insets(10, 10, 0, 0);
        GRIDBAGCONSTRAINTS.gridwidth = 1;
        GRIDBAGCONSTRAINTS.anchor = 16;
        GRIDBAGCONSTRAINTS.fill = 0;
        this.CHECKBOX_SERVER = new JCheckBox(this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver"), true);
        this.CHECKBOX_SERVER.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver.tip"));
        this.CHECKBOX_SERVER.addActionListener(this::actionEventCheckBoxServer);
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 14;
        this.CREATESERVERPACKPANEL.add((Component)this.CHECKBOX_SERVER, GRIDBAGCONSTRAINTS);
        this.CHECKBOX_ICON = new JCheckBox(this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxicon"), true);
        this.CHECKBOX_ICON.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxicon.tip"));
        GRIDBAGCONSTRAINTS.gridx = 1;
        GRIDBAGCONSTRAINTS.gridy = 14;
        this.CREATESERVERPACKPANEL.add((Component)this.CHECKBOX_ICON, GRIDBAGCONSTRAINTS);
        this.CHECKBOX_PROPERTIES = new JCheckBox(this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxproperties"), true);
        this.CHECKBOX_PROPERTIES.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxproperties.tip"));
        GRIDBAGCONSTRAINTS.gridx = 2;
        GRIDBAGCONSTRAINTS.gridy = 14;
        this.CREATESERVERPACKPANEL.add((Component)this.CHECKBOX_PROPERTIES, GRIDBAGCONSTRAINTS);
        this.CHECKBOX_ZIP = new JCheckBox(this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxzip"), true);
        this.CHECKBOX_ZIP.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxzip.tip"));
        GRIDBAGCONSTRAINTS.gridx = 3;
        GRIDBAGCONSTRAINTS.gridy = 14;
        this.CREATESERVERPACKPANEL.add((Component)this.CHECKBOX_ZIP, GRIDBAGCONSTRAINTS);
        JLabel labelJavaArgs = new JLabel(this.I18N.getMessage("createserverpack.gui.createserverpack.javaargs"));
        labelJavaArgs.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.javaargs.tip"));
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 15;
        GRIDBAGCONSTRAINTS.gridwidth = 5;
        GRIDBAGCONSTRAINTS.insets = new Insets(20, 10, -19, 0);
        this.CREATESERVERPACKPANEL.add((Component)labelJavaArgs, GRIDBAGCONSTRAINTS);
        this.TEXTAREA_JAVAARGS.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.javaargs.tip"));
        this.TEXTAREA_JAVAARGS.setFont(new Font("Noto Sans Display Regular", 0, 15));
        JPanel JAVAARGS_JPANEL = new JPanel();
        JAVAARGS_JPANEL.setLayout(new GridBagLayout());
        GridBagConstraints TEXTAREA_JAVAARGS_JPANEL_CONSTRAINTS = new GridBagConstraints();
        TEXTAREA_JAVAARGS_JPANEL_CONSTRAINTS.anchor = 10;
        TEXTAREA_JAVAARGS_JPANEL_CONSTRAINTS.fill = 1;
        TEXTAREA_JAVAARGS_JPANEL_CONSTRAINTS.gridx = 0;
        TEXTAREA_JAVAARGS_JPANEL_CONSTRAINTS.gridy = 0;
        TEXTAREA_JAVAARGS_JPANEL_CONSTRAINTS.weighty = 1.0;
        TEXTAREA_JAVAARGS_JPANEL_CONSTRAINTS.weightx = 1.0;
        JScrollPane SCROLL_PANEL_JAVAARGS = new JScrollPane(this.TEXTAREA_JAVAARGS, 22, 30);
        JAVAARGS_JPANEL.add((Component)SCROLL_PANEL_JAVAARGS, TEXTAREA_JAVAARGS_JPANEL_CONSTRAINTS);
        JAVAARGS_JPANEL.setSize(100, 100);
        JAVAARGS_JPANEL.setPreferredSize(new Dimension(100, 100));
        JAVAARGS_JPANEL.setMaximumSize(new Dimension(100, 100));
        JAVAARGS_JPANEL.setMinimumSize(new Dimension(100, 100));
        GRIDBAGCONSTRAINTS.fill = 2;
        GRIDBAGCONSTRAINTS.gridwidth = 4;
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 16;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_ZERO;
        this.CREATESERVERPACKPANEL.add((Component)JAVAARGS_JPANEL, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.gridwidth = 1;
        GRIDBAGCONSTRAINTS.fill = 0;
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_TEN = new Insets(0, 10, 0, 10);
        GRIDBAGCONSTRAINTS.weightx = 0.0;
        GRIDBAGCONSTRAINTS.weighty = 0.0;
        JButton BUTTON_MODPACKDIRECTORY = new JButton();
        BUTTON_MODPACKDIRECTORY.setToolTipText(this.I18N.getMessage("createserverpack.gui.buttonmodpackdir"));
        BUTTON_MODPACKDIRECTORY.setContentAreaFilled(false);
        BUTTON_MODPACKDIRECTORY.setMultiClickThreshhold(1000L);
        ImageIcon FOLDERICON = new ImageIcon(Objects.requireNonNull(ServerPackCreatorGui.class.getResource("/de/griefed/resources/gui/folder.png")));
        BUTTON_MODPACKDIRECTORY.setIcon(FOLDERICON);
        Dimension FOLDERBUTTONDIMENSION = new Dimension(24, 24);
        BUTTON_MODPACKDIRECTORY.setMinimumSize(FOLDERBUTTONDIMENSION);
        BUTTON_MODPACKDIRECTORY.setPreferredSize(FOLDERBUTTONDIMENSION);
        BUTTON_MODPACKDIRECTORY.setMaximumSize(FOLDERBUTTONDIMENSION);
        BUTTON_MODPACKDIRECTORY.addActionListener(this::selectModpackDirectory);
        this.addMouseListenerContentAreaFilledToButton(BUTTON_MODPACKDIRECTORY);
        GRIDBAGCONSTRAINTS.gridx = 3;
        GRIDBAGCONSTRAINTS.gridy = 1;
        this.CREATESERVERPACKPANEL.add((Component)BUTTON_MODPACKDIRECTORY, GRIDBAGCONSTRAINTS);
        JButton BUTTON_CLIENTSIDEMODS = new JButton();
        BUTTON_CLIENTSIDEMODS.setToolTipText(this.I18N.getMessage("createserverpack.gui.buttonclientmods"));
        BUTTON_CLIENTSIDEMODS.setContentAreaFilled(false);
        BUTTON_CLIENTSIDEMODS.setMultiClickThreshhold(1000L);
        BUTTON_CLIENTSIDEMODS.setIcon(FOLDERICON);
        BUTTON_CLIENTSIDEMODS.setMinimumSize(FOLDERBUTTONDIMENSION);
        BUTTON_CLIENTSIDEMODS.setPreferredSize(FOLDERBUTTONDIMENSION);
        BUTTON_CLIENTSIDEMODS.setMaximumSize(FOLDERBUTTONDIMENSION);
        BUTTON_CLIENTSIDEMODS.addActionListener(this::selectClientMods);
        this.addMouseListenerContentAreaFilledToButton(BUTTON_CLIENTSIDEMODS);
        GRIDBAGCONSTRAINTS.gridx = 5;
        GRIDBAGCONSTRAINTS.gridy = 3;
        this.CREATESERVERPACKPANEL.add((Component)BUTTON_CLIENTSIDEMODS, GRIDBAGCONSTRAINTS);
        JButton BUTTON_COPYDIRECTORIES = new JButton();
        BUTTON_COPYDIRECTORIES.setToolTipText(this.I18N.getMessage("createserverpack.gui.buttoncopydirs"));
        BUTTON_COPYDIRECTORIES.setContentAreaFilled(false);
        BUTTON_COPYDIRECTORIES.setIcon(FOLDERICON);
        BUTTON_COPYDIRECTORIES.setMultiClickThreshhold(1000L);
        BUTTON_COPYDIRECTORIES.setMinimumSize(FOLDERBUTTONDIMENSION);
        BUTTON_COPYDIRECTORIES.setPreferredSize(FOLDERBUTTONDIMENSION);
        BUTTON_COPYDIRECTORIES.setMaximumSize(FOLDERBUTTONDIMENSION);
        BUTTON_COPYDIRECTORIES.addActionListener(this::selectCopyDirs);
        this.addMouseListenerContentAreaFilledToButton(BUTTON_COPYDIRECTORIES);
        GRIDBAGCONSTRAINTS.gridx = 5;
        GRIDBAGCONSTRAINTS.gridy = 5;
        this.CREATESERVERPACKPANEL.add((Component)BUTTON_COPYDIRECTORIES, GRIDBAGCONSTRAINTS);
        JButton BUTTON_JAVAPATH = new JButton();
        BUTTON_JAVAPATH.setToolTipText(this.I18N.getMessage("createserverpack.gui.buttonjavapath"));
        BUTTON_JAVAPATH.setContentAreaFilled(false);
        BUTTON_JAVAPATH.setIcon(FOLDERICON);
        BUTTON_JAVAPATH.setMultiClickThreshhold(1000L);
        BUTTON_JAVAPATH.setMinimumSize(FOLDERBUTTONDIMENSION);
        BUTTON_JAVAPATH.setPreferredSize(FOLDERBUTTONDIMENSION);
        BUTTON_JAVAPATH.setMaximumSize(FOLDERBUTTONDIMENSION);
        BUTTON_JAVAPATH.addActionListener(this::selectJavaInstallation);
        this.addMouseListenerContentAreaFilledToButton(BUTTON_JAVAPATH);
        GRIDBAGCONSTRAINTS.gridx = 5;
        GRIDBAGCONSTRAINTS.gridy = 9;
        this.CREATESERVERPACKPANEL.add((Component)BUTTON_JAVAPATH, GRIDBAGCONSTRAINTS);
        JButton BUTTON_SERVERICON = new JButton();
        BUTTON_SERVERICON.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.button.icon"));
        BUTTON_SERVERICON.setContentAreaFilled(false);
        BUTTON_SERVERICON.setIcon(FOLDERICON);
        BUTTON_SERVERICON.setMultiClickThreshhold(1000L);
        BUTTON_SERVERICON.setMinimumSize(FOLDERBUTTONDIMENSION);
        BUTTON_SERVERICON.setPreferredSize(FOLDERBUTTONDIMENSION);
        BUTTON_SERVERICON.setMaximumSize(FOLDERBUTTONDIMENSION);
        BUTTON_SERVERICON.addActionListener(this::selectServerIcon);
        this.addMouseListenerContentAreaFilledToButton(BUTTON_SERVERICON);
        GRIDBAGCONSTRAINTS.fill = 0;
        GRIDBAGCONSTRAINTS.anchor = 21;
        GRIDBAGCONSTRAINTS.weightx = 0.0;
        GRIDBAGCONSTRAINTS.gridx = 2;
        GRIDBAGCONSTRAINTS.gridy = 7;
        this.CREATESERVERPACKPANEL.add((Component)BUTTON_SERVERICON, GRIDBAGCONSTRAINTS);
        JButton BUTTON_SERVERPROPERTIES = new JButton();
        BUTTON_SERVERPROPERTIES.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.button.properties"));
        BUTTON_SERVERPROPERTIES.setContentAreaFilled(false);
        BUTTON_SERVERPROPERTIES.setIcon(FOLDERICON);
        BUTTON_SERVERPROPERTIES.setMultiClickThreshhold(1000L);
        BUTTON_SERVERPROPERTIES.setMinimumSize(FOLDERBUTTONDIMENSION);
        BUTTON_SERVERPROPERTIES.setPreferredSize(FOLDERBUTTONDIMENSION);
        BUTTON_SERVERPROPERTIES.setMaximumSize(FOLDERBUTTONDIMENSION);
        BUTTON_SERVERPROPERTIES.addActionListener(this::selectServerProperties);
        this.addMouseListenerContentAreaFilledToButton(BUTTON_SERVERPROPERTIES);
        GRIDBAGCONSTRAINTS.gridx = 5;
        GRIDBAGCONSTRAINTS.gridy = 7;
        this.CREATESERVERPACKPANEL.add((Component)BUTTON_SERVERPROPERTIES, GRIDBAGCONSTRAINTS);
        JButton BUTTON_AIKARS_FLAGS = new JButton();
        BUTTON_AIKARS_FLAGS.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.button.properties"));
        BUTTON_AIKARS_FLAGS.setContentAreaFilled(false);
        BUTTON_AIKARS_FLAGS.setIcon(new RotatedIcon((Icon)new TextIcon(BUTTON_AIKARS_FLAGS, this.I18N.getMessage("createserverpack.gui.createserverpack.javaargs.aikar"), TextIcon.Layout.HORIZONTAL), RotatedIcon.Rotate.UP));
        BUTTON_AIKARS_FLAGS.setMultiClickThreshhold(1000L);
        BUTTON_AIKARS_FLAGS.setMargin(new Insets(20, 20, 20, 20));
        BUTTON_AIKARS_FLAGS.addActionListener(this::setAikarsFlags);
        this.addMouseListenerContentAreaFilledToButton(BUTTON_AIKARS_FLAGS);
        GRIDBAGCONSTRAINTS.fill = 2;
        GRIDBAGCONSTRAINTS.gridx = 5;
        GRIDBAGCONSTRAINTS.gridy = 16;
        this.CREATESERVERPACKPANEL.add((Component)BUTTON_AIKARS_FLAGS, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.weightx = 0.0;
        GRIDBAGCONSTRAINTS.fill = 0;
        GRIDBAGCONSTRAINTS.insets = new Insets(5, 0, 5, 0);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 1));
        ReticulatingSplines RETICULATOR = new ReticulatingSplines();
        this.STATUS_LABEL_LINE_0 = new JLabel("..." + RETICULATOR.reticulate() + "   ");
        this.STATUS_LABEL_LINE_1 = new JLabel("..." + RETICULATOR.reticulate() + "   ");
        this.STATUS_LABEL_LINE_2 = new JLabel("..." + RETICULATOR.reticulate() + "   ");
        this.STATUS_LABEL_LINE_3 = new JLabel("..." + RETICULATOR.reticulate() + "   ");
        this.STATUS_LABEL_LINE_4 = new JLabel("..." + RETICULATOR.reticulate() + "   ");
        this.STATUS_LABEL_LINE_5 = new JLabel(this.I18N.getMessage("createserverpack.gui.buttongenerateserverpack.ready") + "   ");
        this.STATUS_LABEL_LINE_0.setHorizontalAlignment(2);
        this.STATUS_LABEL_LINE_1.setHorizontalAlignment(2);
        this.STATUS_LABEL_LINE_2.setHorizontalAlignment(2);
        this.STATUS_LABEL_LINE_3.setHorizontalAlignment(2);
        this.STATUS_LABEL_LINE_4.setHorizontalAlignment(2);
        this.STATUS_LABEL_LINE_5.setHorizontalAlignment(2);
        Dimension labelDimension = new Dimension(700, 30);
        this.STATUS_LABEL_LINE_0.setPreferredSize(labelDimension);
        this.STATUS_LABEL_LINE_1.setPreferredSize(labelDimension);
        this.STATUS_LABEL_LINE_2.setPreferredSize(labelDimension);
        this.STATUS_LABEL_LINE_3.setPreferredSize(labelDimension);
        this.STATUS_LABEL_LINE_4.setPreferredSize(labelDimension);
        this.STATUS_LABEL_LINE_5.setPreferredSize(labelDimension);
        this.updatePanelTheme();
        statusPanel.add(this.STATUS_LABEL_LINE_0);
        statusPanel.add(this.STATUS_LABEL_LINE_1);
        statusPanel.add(this.STATUS_LABEL_LINE_2);
        statusPanel.add(this.STATUS_LABEL_LINE_3);
        statusPanel.add(this.STATUS_LABEL_LINE_4);
        statusPanel.add(this.STATUS_LABEL_LINE_5);
        statusPanel.setPreferredSize(new Dimension(700, 140));
        GRIDBAGCONSTRAINTS.fill = 0;
        GRIDBAGCONSTRAINTS.gridx = 1;
        GRIDBAGCONSTRAINTS.gridy = 19;
        GRIDBAGCONSTRAINTS.gridwidth = 5;
        GRIDBAGCONSTRAINTS.gridheight = 2;
        GRIDBAGCONSTRAINTS.weightx = 1.0;
        GRIDBAGCONSTRAINTS.weighty = 1.0;
        GRIDBAGCONSTRAINTS.anchor = 17;
        this.CREATESERVERPACKPANEL.add((Component)statusPanel, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.insets = ZERO_TEN_ZERO_TEN;
        BufferedImage GENERATE = ImageIO.read(Objects.requireNonNull(ServerPackCreatorGui.class.getResource("/de/griefed/resources/gui/start_generation.png")));
        this.BUTTON_GENERATESERVERPACK.setIcon(new CompoundIcon(CompoundIcon.Axis.X_AXIS, 12, new ImageIcon(GENERATE.getScaledInstance(32, 32, 4)), new TextIcon(this.BUTTON_GENERATESERVERPACK, this.I18N.getMessage("createserverpack.gui.buttongenerateserverpack"))));
        this.BUTTON_GENERATESERVERPACK.addActionListener(this::generateServerpack);
        this.BUTTON_GENERATESERVERPACK.setMultiClickThreshhold(1000L);
        this.BUTTON_GENERATESERVERPACK.setToolTipText(this.I18N.getMessage("createserverpack.gui.buttongenerateserverpack.tip"));
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 19;
        GRIDBAGCONSTRAINTS.gridwidth = 1;
        GRIDBAGCONSTRAINTS.gridheight = 1;
        GRIDBAGCONSTRAINTS.weightx = 1.0;
        GRIDBAGCONSTRAINTS.weighty = 1.0;
        GRIDBAGCONSTRAINTS.anchor = 17;
        GRIDBAGCONSTRAINTS.fill = 2;
        this.CREATESERVERPACKPANEL.add((Component)this.BUTTON_GENERATESERVERPACK, GRIDBAGCONSTRAINTS);
        JButton BUTTON_SERVER_PACKS = new JButton();
        BUTTON_SERVER_PACKS.setIcon(new CompoundIcon(CompoundIcon.Axis.X_AXIS, 8, FOLDERICON, new TextIcon(BUTTON_SERVER_PACKS, this.I18N.getMessage("createserverpack.gui.buttonserverpacks"))));
        BUTTON_SERVER_PACKS.addActionListener(this::openServerPacksFolder);
        BUTTON_SERVER_PACKS.setMultiClickThreshhold(1000L);
        BUTTON_SERVER_PACKS.setToolTipText(this.I18N.getMessage("createserverpack.gui.buttonserverpacks.tip"));
        GRIDBAGCONSTRAINTS.gridy = 20;
        GRIDBAGCONSTRAINTS.anchor = 17;
        GRIDBAGCONSTRAINTS.fill = 2;
        this.CREATESERVERPACKPANEL.add((Component)BUTTON_SERVER_PACKS, GRIDBAGCONSTRAINTS);
        GRIDBAGCONSTRAINTS.gridx = 0;
        GRIDBAGCONSTRAINTS.gridy = 21;
        GRIDBAGCONSTRAINTS.gridwidth = 6;
        GRIDBAGCONSTRAINTS.weightx = 1.0;
        GRIDBAGCONSTRAINTS.weighty = 1.0;
        GRIDBAGCONSTRAINTS.anchor = 11;
        GRIDBAGCONSTRAINTS.fill = 2;
        this.STATUS_BAR.setPreferredSize(new Dimension(700, 40));
        this.STATUS_BAR.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.CREATESERVERPACKPANEL.add((Component)this.STATUS_BAR, GRIDBAGCONSTRAINTS);
        this.STATUS_BAR.loadConfig(this.IDLE_CONFIG);
        this.STATUS_BAR.play();
        GRIDBAGCONSTRAINTS.fill = 0;
        JScrollPane TAB_CREATESERVERPACKTAB_SCROLL_PANEL = new JScrollPane(this.CREATESERVERPACKPANEL);
        TAB_CREATESERVERPACKTAB_SCROLL_PANEL.getVerticalScrollBar().setUnitIncrement(16);
        this.setLayout(new BorderLayout());
        this.add((Component)TAB_CREATESERVERPACKTAB_SCROLL_PANEL, "Center");
        this.loadConfig(new File("serverpackcreator.conf"));
    }

    protected void updatePanelTheme() {
        this.STATUS_LABEL_LINE_0.setForeground(new Color(this.getThemeTextColor().getRed(), this.getThemeTextColor().getGreen(), this.getThemeTextColor().getBlue(), 20));
        this.STATUS_LABEL_LINE_1.setForeground(new Color(this.getThemeTextColor().getRed(), this.getThemeTextColor().getGreen(), this.getThemeTextColor().getBlue(), 50));
        this.STATUS_LABEL_LINE_2.setForeground(new Color(this.getThemeTextColor().getRed(), this.getThemeTextColor().getGreen(), this.getThemeTextColor().getBlue(), 100));
        this.STATUS_LABEL_LINE_3.setForeground(new Color(this.getThemeTextColor().getRed(), this.getThemeTextColor().getGreen(), this.getThemeTextColor().getBlue(), 150));
        this.STATUS_LABEL_LINE_4.setForeground(new Color(this.getThemeTextColor().getRed(), this.getThemeTextColor().getGreen(), this.getThemeTextColor().getBlue(), 200));
        this.IDLE_CONFIG.setScannerBackgroundColour(this.getBackground());
        this.IDLE_CONFIG.setEyeBackgroundColour(this.getBackground());
        this.BUSY_CONFIG.setScannerBackgroundColour(this.getBackground());
        this.BUSY_CONFIG.setEyeBackgroundColour(this.getBackground());
        this.STATUS_BAR.setBackground(this.getBackground());
        this.STATUS_BAR.setEyeBackground(this.getBackground());
    }

    private void updateStatus(String text) {
        this.STATUS_LABEL_LINE_0.setText(this.STATUS_LABEL_LINE_1.getText() + "   ");
        this.STATUS_LABEL_LINE_1.setText(this.STATUS_LABEL_LINE_2.getText() + "   ");
        this.STATUS_LABEL_LINE_2.setText(this.STATUS_LABEL_LINE_3.getText() + "   ");
        this.STATUS_LABEL_LINE_3.setText(this.STATUS_LABEL_LINE_4.getText() + "   ");
        this.STATUS_LABEL_LINE_4.setText(this.STATUS_LABEL_LINE_5.getText() + "   ");
        this.STATUS_LABEL_LINE_5.setText(text + "   ");
    }

    protected void openServerPacksFolder(ActionEvent actionEvent) {
        this.UTILITIES.FileUtils().openFolder(this.APPLICATIONPROPERTIES.getDirectoryServerPacks());
    }

    public void validateInputFields() {
        this.validateModpackDir();
        this.validateSuffix();
        this.validateClientMods();
        this.validateCopyDirs();
        this.validateServerIcon();
        this.validateServerProperties();
        this.validateJavaPath();
    }

    private void validateModpackDir() {
        ArrayList<String> errorsTEXTFIELD_MODPACKDIRECTORY = new ArrayList<String>();
        if (this.CONFIGURATIONHANDLER.checkModpackDir(this.TEXTFIELD_MODPACKDIRECTORY.getText(), errorsTEXTFIELD_MODPACKDIRECTORY)) {
            this.TEXTFIELD_MODPACKDIRECTORY.setIcon(null);
            this.TEXTFIELD_MODPACKDIRECTORY.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelmodpackdir.tip"));
            this.TEXTFIELD_MODPACKDIRECTORY.setForeground(this.getThemeTextColor());
        } else {
            this.TEXTFIELD_MODPACKDIRECTORY.setForeground(this.getThemeErrorColor());
            this.TEXTFIELD_MODPACKDIRECTORY.setIcon(this.ERROR_ICON_MODPACKDIRECTORY);
            this.ERROR_ICON_MODPACKDIRECTORY.setDescription(String.join((CharSequence)",", errorsTEXTFIELD_MODPACKDIRECTORY));
            this.TEXTFIELD_MODPACKDIRECTORY.setToolTipText(String.join((CharSequence)",", errorsTEXTFIELD_MODPACKDIRECTORY));
        }
        this.validateCopyDirs();
    }

    private void validateSuffix() {
        if (this.UTILITIES.StringUtils().checkForIllegalCharacters(this.TEXTFIELD_SERVERPACKSUFFIX.getText())) {
            this.TEXTFIELD_SERVERPACKSUFFIX.setIcon(null);
            this.TEXTFIELD_SERVERPACKSUFFIX.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelsuffix.tip"));
            this.TEXTFIELD_SERVERPACKSUFFIX.setForeground(this.getThemeTextColor());
        } else {
            this.TEXTFIELD_SERVERPACKSUFFIX.setForeground(this.getThemeErrorColor());
            this.TEXTFIELD_SERVERPACKSUFFIX.setIcon(this.ERROR_ICON_SERVERPACK_SUFFIX);
            this.TEXTFIELD_SERVERPACKSUFFIX.setToolTipText(this.ERROR_ICON_SERVERPACK_SUFFIX.getDescription());
        }
    }

    private void validateClientMods() {
        if (!this.TEXTAREA_CLIENTSIDEMODS.getText().matches("^.*,\\s*\\\\*$")) {
            this.TEXTAREA_CLIENTSIDEMODS.setIcon(null);
            this.TEXTAREA_CLIENTSIDEMODS.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelclientmods.tip"));
            this.TEXTAREA_CLIENTSIDEMODS.setForeground(this.getThemeTextColor());
        } else {
            this.TEXTAREA_CLIENTSIDEMODS.setForeground(this.getThemeErrorColor());
            this.TEXTAREA_CLIENTSIDEMODS.setIcon(this.ERROR_ICON_CLIENTSIDE_MODS);
            this.TEXTAREA_CLIENTSIDEMODS.setToolTipText(this.ERROR_ICON_CLIENTSIDE_MODS.getDescription());
        }
    }

    private void validateCopyDirs() {
        if (this.CONFIGURATIONHANDLER.checkModpackDir(this.TEXTFIELD_MODPACKDIRECTORY.getText())) {
            ArrayList<String> errorsTEXTFIELD_COPYDIRECTORIES = new ArrayList<String>();
            if (!this.TEXTAREA_COPYDIRECTORIES.getText().matches("^.*,\\s*\\\\*$") && this.CONFIGURATIONHANDLER.checkCopyDirs(this.UTILITIES.ListUtils().cleanList(new ArrayList<String>(Arrays.asList(this.TEXTAREA_COPYDIRECTORIES.getText().replace(", ", ",").split(",")))), this.TEXTFIELD_MODPACKDIRECTORY.getText(), errorsTEXTFIELD_COPYDIRECTORIES)) {
                this.TEXTAREA_COPYDIRECTORIES.setIcon(null);
                this.TEXTAREA_COPYDIRECTORIES.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labelcopydirs.tip"));
                this.TEXTAREA_COPYDIRECTORIES.setForeground(this.getThemeTextColor());
            } else {
                this.TEXTAREA_COPYDIRECTORIES.setForeground(this.getThemeErrorColor());
                this.TEXTAREA_COPYDIRECTORIES.setIcon(this.ERROR_ICON_COPYDIRECTORIES);
                this.ERROR_ICON_COPYDIRECTORIES.setDescription(String.join((CharSequence)",", errorsTEXTFIELD_COPYDIRECTORIES));
                this.TEXTAREA_COPYDIRECTORIES.setToolTipText(String.join((CharSequence)",", errorsTEXTFIELD_COPYDIRECTORIES));
            }
        }
    }

    private void validateServerIcon() {
        if (this.CONFIGURATIONHANDLER.checkIconAndProperties(this.TEXTFIELD_SERVERICONPATH.getText())) {
            this.TEXTFIELD_SERVERICONPATH.setIcon(null);
            this.TEXTFIELD_SERVERICONPATH.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.textfield.iconpath"));
            this.TEXTFIELD_SERVERICONPATH.setForeground(this.getThemeTextColor());
        } else {
            this.TEXTFIELD_SERVERICONPATH.setForeground(this.getThemeErrorColor());
            this.TEXTFIELD_SERVERICONPATH.setIcon(this.ERROR_ICON_SERVERICON);
            this.TEXTFIELD_SERVERICONPATH.setToolTipText(this.ERROR_ICON_SERVERICON.getDescription());
        }
    }

    private void validateServerProperties() {
        if (this.CONFIGURATIONHANDLER.checkIconAndProperties(this.TEXTFIELD_SERVERPROPERTIESPATH.getText())) {
            this.TEXTFIELD_SERVERPROPERTIESPATH.setIcon(null);
            this.TEXTFIELD_SERVERPROPERTIESPATH.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.textfield.propertiespath"));
            this.TEXTFIELD_SERVERPROPERTIESPATH.setForeground(this.getThemeTextColor());
        } else {
            this.TEXTFIELD_SERVERPROPERTIESPATH.setForeground(this.getThemeErrorColor());
            this.TEXTFIELD_SERVERPROPERTIESPATH.setIcon(this.ERROR_ICON_SERVERPROPERTIES);
            this.TEXTFIELD_SERVERPROPERTIESPATH.setToolTipText(this.ERROR_ICON_SERVERPROPERTIES.getDescription());
        }
    }

    private void validateJavaPath() {
        if (this.CONFIGURATIONHANDLER.checkJavaPath(this.TEXTFIELD_JAVAPATH.getText())) {
            this.TEXTFIELD_JAVAPATH.setIcon(null);
            this.TEXTFIELD_JAVAPATH.setToolTipText(this.I18N.getMessage("createserverpack.gui.createserverpack.labeljavapath.tip"));
            this.TEXTFIELD_JAVAPATH.setForeground(this.getThemeTextColor());
        } else {
            this.TEXTFIELD_JAVAPATH.setForeground(this.getThemeErrorColor());
            this.TEXTFIELD_JAVAPATH.setIcon(this.ERROR_ICON_JAVAPATH);
            this.TEXTFIELD_JAVAPATH.setToolTipText(this.ERROR_ICON_JAVAPATH.getDescription());
        }
    }

    private void setAikarsFlags(ActionEvent actionEvent) {
        if (!this.TEXTAREA_JAVAARGS.getText().isEmpty()) {
            switch (JOptionPane.showConfirmDialog(this.CREATESERVERPACKPANEL, this.I18N.getMessage("createserverpack.gui.createserverpack.javaargs.confirm.message"), this.I18N.getMessage("createserverpack.gui.createserverpack.javaargs.confirm.title"), 0, 2)) {
                case 0: {
                    this.setAikarsFlags();
                }
            }
        } else {
            this.setAikarsFlags();
        }
    }

    private void setAikarsFlags() {
        this.TEXTAREA_JAVAARGS.setText(this.APPLICATIONPROPERTIES.getAikarsFlags());
    }

    private void actionEventCheckBoxServer(ActionEvent actionEvent) {
        if (this.CHECKBOX_SERVER.isSelected() && this.TEXTFIELD_JAVAPATH.getText().isEmpty()) {
            switch (JOptionPane.showConfirmDialog(this.CREATESERVERPACKPANEL, this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver.confirm.message"), this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver.confirm.title"), 0, 2)) {
                case 0: {
                    this.chooseJava();
                    break;
                }
                case 1: {
                    JOptionPane.showMessageDialog(this.CREATESERVERPACKPANEL, this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver.message.message"), this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver.message.title"), 0, null);
                    break;
                }
            }
        }
    }

    private void addMouseListenerContentAreaFilledToButton(final JButton buttonToAddMouseListenerTo) {
        buttonToAddMouseListenerTo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                buttonToAddMouseListenerTo.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                buttonToAddMouseListenerTo.setContentAreaFilled(false);
            }
        });
    }

    private DefaultComboBoxModel<String> updateForgeComboBoxVersions(@Nullable String chosenMinecraftVersion) {
        if (chosenMinecraftVersion != null && this.VERSIONMETA.forge().availableForgeVersionsArrayDescending(chosenMinecraftVersion).isPresent()) {
            return new DefaultComboBoxModel<Object>((Object[])this.VERSIONMETA.forge().availableForgeVersionsArrayDescending(chosenMinecraftVersion).get());
        }
        return new DefaultComboBoxModel<String>(this.NONE);
    }

    private DefaultComboBoxModel<String> updateFabricComboBoxVersions(@Nullable String chosenMinecraftVersion) {
        if (chosenMinecraftVersion != null && this.VERSIONMETA.fabric().getFabricIntermediary(chosenMinecraftVersion).isPresent()) {
            return this.FABRIC_VERSIONS;
        }
        return new DefaultComboBoxModel<String>(this.NONE);
    }

    private DefaultComboBoxModel<String> updateQuiltComboBoxVersions(@Nullable String chosenMinecraftVersion) {
        if (chosenMinecraftVersion != null && this.VERSIONMETA.fabric().getFabricIntermediary(chosenMinecraftVersion).isPresent()) {
            return this.QUILT_VERSIONS;
        }
        return new DefaultComboBoxModel<String>(this.NONE);
    }

    private void actionEventComboBoxMinecraftVersion(ActionEvent event) {
        this.chosenMinecraftVersion = Objects.requireNonNull(this.COMBOBOX_MINECRAFTVERSIONS.getSelectedItem()).toString();
        this.updateModloaderGuiComponents(Objects.requireNonNull(this.COMBOBOX_MODLOADERS.getSelectedItem()).toString());
    }

    private void actionEventComboBoxModloaderVersions(ActionEvent event) {
        this.chosenModloaderVersion = Objects.requireNonNull(this.COMBOBOX_MODLOADER_VERSIONS.getSelectedItem()).toString();
    }

    private void actionEventComboBoxModloaders(ActionEvent event) {
        String modloader = this.COMBOBOX_MODLOADERS.getSelectedItem() != null ? this.COMBOBOX_MODLOADERS.getSelectedItem().toString() : "Forge";
        this.updateModloaderGuiComponents(modloader);
    }

    private void updateModloaderGuiComponents(String modloader) {
        switch (modloader) {
            case "Fabric": {
                this.COMBOBOX_MODLOADERS.setSelectedIndex(0);
                this.COMBOBOX_MODLOADER_VERSIONS.setModel(this.updateFabricComboBoxVersions(this.COMBOBOX_MINECRAFTVERSIONS.getSelectedItem().toString()));
                break;
            }
            case "Forge": {
                this.COMBOBOX_MODLOADERS.setSelectedIndex(1);
                this.COMBOBOX_MODLOADER_VERSIONS.setModel(this.updateForgeComboBoxVersions(this.COMBOBOX_MINECRAFTVERSIONS.getSelectedItem().toString()));
                break;
            }
            case "Quilt": {
                this.COMBOBOX_MODLOADERS.setSelectedIndex(2);
                this.COMBOBOX_MODLOADER_VERSIONS.setModel(this.updateQuiltComboBoxVersions(this.COMBOBOX_MINECRAFTVERSIONS.getSelectedItem().toString()));
            }
        }
        this.COMBOBOX_MODLOADER_VERSIONS.setSelectedIndex(0);
        this.chosenModloaderVersion = this.COMBOBOX_MODLOADER_VERSIONS.getSelectedItem().toString();
        this.chosenModloader = modloader;
        LOG.debug("Minecraft version: " + this.COMBOBOX_MINECRAFTVERSIONS.getSelectedItem().toString() + "; Modloader: " + this.COMBOBOX_MODLOADERS.getSelectedItem().toString() + "; Modloader version " + this.COMBOBOX_MODLOADER_VERSIONS.getSelectedItem().toString());
    }

    private void selectModpackDirectory(ActionEvent event) {
        JFileChooser modpackDirChooser = new JFileChooser();
        if (new File(this.TEXTFIELD_MODPACKDIRECTORY.getText()).isDirectory()) {
            modpackDirChooser.setCurrentDirectory(new File(this.TEXTFIELD_MODPACKDIRECTORY.getText()));
        } else if (new File(this.TEXTFIELD_MODPACKDIRECTORY.getText()).isFile()) {
            modpackDirChooser.setCurrentDirectory(new File(new File(this.TEXTFIELD_MODPACKDIRECTORY.getText()).getParent()));
        } else {
            modpackDirChooser.setCurrentDirectory(this.DIRECTORY_CHOOSER);
        }
        modpackDirChooser.setDialogTitle(this.I18N.getMessage("createserverpack.gui.buttonmodpackdir.title"));
        modpackDirChooser.setFileSelectionMode(2);
        modpackDirChooser.setFileFilter(new FileNameExtensionFilter(this.I18N.getMessage("createserverpack.gui.createserverpack.chooser.modpack.filter"), "zip"));
        modpackDirChooser.setAcceptAllFileFilterUsed(false);
        modpackDirChooser.setMultiSelectionEnabled(false);
        modpackDirChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (modpackDirChooser.showOpenDialog(this.FRAME_SERVERPACKCREATOR) == 0) {
            try {
                this.TEXTFIELD_MODPACKDIRECTORY.setText(modpackDirChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
                LOG.debug("Selected modpack directory: " + modpackDirChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
            }
            catch (IOException ex) {
                LOG.error("Error getting directory from modpack directory chooser.", (Throwable)ex);
            }
        }
    }

    private void selectServerIcon(ActionEvent event) {
        JFileChooser serverIconChooser = new JFileChooser();
        serverIconChooser.setCurrentDirectory(this.DIRECTORY_CHOOSER);
        serverIconChooser.setDialogTitle(this.I18N.getMessage("createserverpack.gui.createserverpack.chooser.icon.title"));
        serverIconChooser.setFileSelectionMode(0);
        serverIconChooser.setFileFilter(new FileNameExtensionFilter(this.I18N.getMessage("createserverpack.gui.createserverpack.chooser.icon.filter"), "png", "jpg", "jpeg", "bmp"));
        serverIconChooser.setAcceptAllFileFilterUsed(false);
        serverIconChooser.setMultiSelectionEnabled(false);
        serverIconChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (serverIconChooser.showOpenDialog(this.FRAME_SERVERPACKCREATOR) == 0) {
            try {
                this.TEXTFIELD_SERVERICONPATH.setText(serverIconChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
            }
            catch (IOException ex) {
                LOG.error("Error getting the icon-file for the server pack.", (Throwable)ex);
            }
        }
    }

    private void selectServerProperties(ActionEvent event) {
        JFileChooser serverPropertiesChooser = new JFileChooser();
        serverPropertiesChooser.setCurrentDirectory(this.DIRECTORY_CHOOSER);
        serverPropertiesChooser.setDialogTitle(this.I18N.getMessage("createserverpack.gui.createserverpack.chooser.properties.title"));
        serverPropertiesChooser.setFileSelectionMode(0);
        serverPropertiesChooser.setFileFilter(new FileNameExtensionFilter(this.I18N.getMessage("createserverpack.gui.createserverpack.chooser.properties.filter"), "properties"));
        serverPropertiesChooser.setAcceptAllFileFilterUsed(false);
        serverPropertiesChooser.setMultiSelectionEnabled(false);
        serverPropertiesChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (serverPropertiesChooser.showOpenDialog(this.FRAME_SERVERPACKCREATOR) == 0) {
            try {
                this.TEXTFIELD_SERVERPROPERTIESPATH.setText(serverPropertiesChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
            }
            catch (IOException ex) {
                LOG.error("Error getting the properties-file for the server pack.", (Throwable)ex);
            }
        }
    }

    private void selectClientMods(ActionEvent event) {
        JFileChooser clientModsChooser = new JFileChooser();
        if (this.TEXTFIELD_MODPACKDIRECTORY.getText().length() > 0 && new File(this.TEXTFIELD_MODPACKDIRECTORY.getText()).isDirectory() && new File(String.format("%s/mods", this.TEXTFIELD_MODPACKDIRECTORY.getText())).isDirectory()) {
            clientModsChooser.setCurrentDirectory(new File(String.format("%s/mods", this.TEXTFIELD_MODPACKDIRECTORY.getText())));
        } else {
            clientModsChooser.setCurrentDirectory(this.DIRECTORY_CHOOSER);
        }
        clientModsChooser.setDialogTitle(this.I18N.getMessage("createserverpack.gui.buttonclientmods.title"));
        clientModsChooser.setFileSelectionMode(0);
        clientModsChooser.setFileFilter(new FileNameExtensionFilter(this.I18N.getMessage("createserverpack.gui.buttonclientmods.filter"), "jar"));
        clientModsChooser.setAcceptAllFileFilterUsed(false);
        clientModsChooser.setMultiSelectionEnabled(true);
        clientModsChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (clientModsChooser.showOpenDialog(this.FRAME_SERVERPACKCREATOR) == 0) {
            File[] clientMods = clientModsChooser.getSelectedFiles();
            ArrayList<String> clientModsFilenames = new ArrayList<String>(100);
            for (File mod : clientMods) {
                clientModsFilenames.add(mod.getName());
            }
            this.TEXTAREA_CLIENTSIDEMODS.setText(this.UTILITIES.StringUtils().buildString(clientModsFilenames));
            LOG.debug("Selected mods: " + clientModsFilenames);
        }
    }

    private void selectCopyDirs(ActionEvent event) {
        JFileChooser copyDirsChooser = new JFileChooser();
        if (this.TEXTFIELD_MODPACKDIRECTORY.getText().length() > 0 && new File(this.TEXTFIELD_MODPACKDIRECTORY.getText()).isDirectory()) {
            copyDirsChooser.setCurrentDirectory(new File(this.TEXTFIELD_MODPACKDIRECTORY.getText()));
        } else {
            copyDirsChooser.setCurrentDirectory(this.DIRECTORY_CHOOSER);
        }
        copyDirsChooser.setDialogTitle(this.I18N.getMessage("createserverpack.gui.buttoncopydirs.title"));
        copyDirsChooser.setFileSelectionMode(1);
        copyDirsChooser.setAcceptAllFileFilterUsed(false);
        copyDirsChooser.setMultiSelectionEnabled(true);
        copyDirsChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (copyDirsChooser.showOpenDialog(this.FRAME_SERVERPACKCREATOR) == 0) {
            File[] directoriesToCopy = copyDirsChooser.getSelectedFiles();
            ArrayList<String> copyDirsNames = new ArrayList<String>(100);
            for (File directory : directoriesToCopy) {
                copyDirsNames.add(directory.getName());
            }
            this.TEXTAREA_COPYDIRECTORIES.setText(this.UTILITIES.StringUtils().buildString(copyDirsNames));
            LOG.debug("Selected directories: " + copyDirsNames);
        }
    }

    private void selectJavaInstallation(ActionEvent event) {
        this.chooseJava();
    }

    void chooseJava() {
        JFileChooser javaChooser = new JFileChooser();
        if (new File(String.format("%s/bin/", System.getProperty("java.home").replace("\\", "/"))).isDirectory()) {
            javaChooser.setCurrentDirectory(new File(String.format("%s/bin/", System.getProperty("java.home").replace("\\", "/"))));
        } else {
            javaChooser.setCurrentDirectory(this.DIRECTORY_CHOOSER);
        }
        javaChooser.setDialogTitle(this.I18N.getMessage("createserverpack.gui.buttonjavapath.tile"));
        javaChooser.setFileSelectionMode(0);
        javaChooser.setAcceptAllFileFilterUsed(true);
        javaChooser.setMultiSelectionEnabled(false);
        javaChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (javaChooser.showOpenDialog(this.FRAME_SERVERPACKCREATOR) == 0) {
            try {
                this.TEXTFIELD_JAVAPATH.setText(javaChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
                LOG.debug("Set path to Java executable to: " + javaChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
            }
            catch (IOException ex) {
                LOG.error("Couldn't set java executable path.", (Throwable)ex);
            }
        }
    }

    private void generateServerpack(ActionEvent event) {
        this.BUTTON_GENERATESERVERPACK.setEnabled(false);
        this.STATUS_BAR.loadConfig(this.BUSY_CONFIG);
        int decision = 0;
        this.MATERIALTEXTPANEUI.installUI(this.LAZYMODETEXTPANE);
        if (this.TEXTAREA_COPYDIRECTORIES.getText().equals("lazy_mode")) {
            decision = JOptionPane.showConfirmDialog(this.FRAME_SERVERPACKCREATOR, this.LAZYMODETEXTPANE, this.I18N.getMessage("createserverpack.gui.createserverpack.lazymode"), 0, 1);
        }
        LOG.debug("Case " + decision);
        switch (decision) {
            case 0: {
                this.generate();
                break;
            }
            default: {
                this.ready();
            }
        }
    }

    private ConfigurationModel currentConfigAsModel() {
        HashMap<String, String> scriptSettings = new HashMap<String, String>();
        return new ConfigurationModel(this.UTILITIES.ListUtils().cleanList(new ArrayList<String>(Arrays.asList(this.TEXTAREA_CLIENTSIDEMODS.getText().replace(", ", ",").split(",")))), this.UTILITIES.ListUtils().cleanList(new ArrayList<String>(Arrays.asList(this.TEXTAREA_COPYDIRECTORIES.getText().replace(", ", ",").split(",")))), this.TEXTFIELD_MODPACKDIRECTORY.getText().replace("\\", "/"), this.TEXTFIELD_JAVAPATH.getText().replace("\\", "/"), this.chosenMinecraftVersion, this.chosenModloader, this.chosenModloaderVersion, this.TEXTAREA_JAVAARGS.getText(), this.UTILITIES.StringUtils().pathSecureText(this.TEXTFIELD_SERVERPACKSUFFIX.getText()), this.TEXTFIELD_SERVERICONPATH.getText().replace("\\", "/"), this.TEXTFIELD_SERVERPROPERTIESPATH.getText().replace("\\", "/"), this.CHECKBOX_SERVER.isSelected(), this.CHECKBOX_ICON.isSelected(), this.CHECKBOX_PROPERTIES.isSelected(), this.CHECKBOX_ZIP.isSelected(), scriptSettings);
    }

    private void generate() {
        Tailer tailer = Tailer.create(new File("./logs/serverpackcreator.log"), new TailerListenerAdapter(){

            @Override
            public void handle(String line) {
                if (!line.contains("DEBUG")) {
                    TabCreateServerPack.this.updateStatus(line.substring(line.indexOf(") - ") + 4));
                }
            }
        }, 100L, false);
        LOG.info("Checking entered configuration.");
        this.updateStatus(this.I18N.getMessage("createserverpack.log.info.buttoncreateserverpack.start"));
        ArrayList encounteredErrors = new ArrayList(100);
        ConfigurationModel configurationModel = this.currentConfigAsModel();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(() -> {
            block8: {
                if (!this.CONFIGURATIONHANDLER.checkConfiguration(configurationModel, (List<String>)encounteredErrors, true)) {
                    LOG.info("Configuration checked successfully.");
                    this.updateStatus(this.I18N.getMessage("createserverpack.log.info.buttoncreateserverpack.checked"));
                    this.saveConfig(this.APPLICATIONPROPERTIES.DEFAULT_CONFIG());
                    LOG.info("Starting ServerPackCreator run.");
                    this.updateStatus(this.I18N.getMessage("createserverpack.log.info.buttoncreateserverpack.generating"));
                    try {
                        this.SERVERPACKHANDLER.run(configurationModel);
                        this.loadConfig(new File("serverpackcreator.conf"));
                        this.updateStatus(this.I18N.getMessage("createserverpack.log.info.buttoncreateserverpack.ready"));
                        this.SERVERPACKGENERATEDDOCUMENT.setParagraphAttributes(0, this.SERVERPACKGENERATEDDOCUMENT.getLength(), this.SERVERPACKGENERATEDATTRIBUTESET, false);
                        this.MATERIALTEXTPANEUI.installUI(this.SERVERPACKGENERATEDTEXTPANE);
                        this.ready();
                        if (JOptionPane.showConfirmDialog(this.FRAME_SERVERPACKCREATOR, this.SERVERPACKGENERATEDTEXTPANE, this.I18N.getMessage("createserverpack.gui.createserverpack.openfolder.title"), 0, 1) != 0) break block8;
                        try {
                            Desktop.getDesktop().open(new File(this.SERVERPACKHANDLER.getServerPackDestination(configurationModel)));
                        }
                        catch (IOException ex) {
                            LOG.error("Error opening file explorer for server pack.", (Throwable)ex);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error("An error occurred when generating the server pack.", (Throwable)ex);
                    }
                } else {
                    this.updateStatus(this.I18N.getMessage("createserverpack.gui.buttongenerateserverpack.fail"));
                    if (encounteredErrors.size() > 0) {
                        StringBuilder errors = new StringBuilder();
                        for (int i2 = 0; i2 < encounteredErrors.size(); ++i2) {
                            errors.append(i2 + 1).append(": ").append((String)encounteredErrors.get(i2)).append("\n");
                        }
                        this.ready();
                        JOptionPane.showMessageDialog(this.FRAME_SERVERPACKCREATOR, errors, String.format(this.I18N.getMessage("createserverpack.gui.createserverpack.errors.encountered"), encounteredErrors.size()), 0, UIManager.getIcon("OptionPane.errorIcon"));
                    }
                }
            }
            tailer.stop();
            this.ready();
            System.gc();
            System.runFinalization();
            executorService.shutdownNow();
        });
    }

    private void ready() {
        this.BUTTON_GENERATESERVERPACK.setEnabled(true);
        this.STATUS_BAR.loadConfig(this.IDLE_CONFIG);
    }

    void saveConfig(File configFile) {
        List<String> tempClientMods = this.UTILITIES.ListUtils().cleanList(new ArrayList<String>(Arrays.asList(this.TEXTAREA_CLIENTSIDEMODS.getText().replace(", ", ",").split(","))));
        List<String> tempCopyDirs = this.UTILITIES.ListUtils().cleanList(new ArrayList<String>(Arrays.asList(this.TEXTAREA_COPYDIRECTORIES.getText().replace(", ", ",").split(","))));
        this.CONFIGUTILITIES.writeConfigToFile(this.TEXTFIELD_MODPACKDIRECTORY.getText().replace("\\", "/"), tempClientMods, tempCopyDirs, this.TEXTFIELD_SERVERICONPATH.getText().replace("\\", "/"), this.TEXTFIELD_SERVERPROPERTIESPATH.getText().replace("\\", "/"), this.CHECKBOX_SERVER.isSelected(), this.TEXTFIELD_JAVAPATH.getText().replace("\\", "/"), this.chosenMinecraftVersion, this.chosenModloader, this.chosenModloaderVersion, this.CHECKBOX_ICON.isSelected(), this.CHECKBOX_PROPERTIES.isSelected(), this.CHECKBOX_ZIP.isSelected(), this.TEXTAREA_JAVAARGS.getText(), this.UTILITIES.StringUtils().pathSecureText(this.TEXTFIELD_SERVERPACKSUFFIX.getText()), configFile);
    }

    protected void loadConfig(File configFile) {
        try {
            ConfigurationModel configurationModel = new ConfigurationModel(this.UTILITIES, configFile);
            this.TEXTFIELD_MODPACKDIRECTORY.setText(configurationModel.getModpackDir().replace("\\", "/"));
            if (configurationModel.getClientMods().isEmpty()) {
                this.TEXTAREA_CLIENTSIDEMODS.setText(this.UTILITIES.StringUtils().buildString(this.APPLICATIONPROPERTIES.getListFallbackMods()));
                LOG.debug("Set clientMods with fallback list.");
            } else {
                this.TEXTAREA_CLIENTSIDEMODS.setText(this.UTILITIES.StringUtils().buildString(configurationModel.getClientMods()));
            }
            if (configurationModel.getCopyDirs().isEmpty()) {
                this.TEXTAREA_COPYDIRECTORIES.setText(this.UTILITIES.StringUtils().buildString(this.APPLICATIONPROPERTIES.getDirectoriesToInclude()));
            } else {
                this.TEXTAREA_COPYDIRECTORIES.setText(this.UTILITIES.StringUtils().buildString(configurationModel.getCopyDirs().toString().replace("\\", "/")));
            }
            this.TEXTFIELD_SERVERICONPATH.setText(configurationModel.getServerIconPath().replace("\\", "/"));
            this.TEXTFIELD_SERVERPROPERTIESPATH.setText(configurationModel.getServerPropertiesPath().replace("\\", "/"));
            this.TEXTFIELD_JAVAPATH.setText(this.UTILITIES.SystemUtils().acquireJavaPathFromSystem());
            this.chosenMinecraftVersion = configurationModel.getMinecraftVersion().isEmpty() ? this.VERSIONMETA.minecraft().latestRelease().version() : configurationModel.getMinecraftVersion();
            for (int i2 = 0; i2 < this.COMBOBOX_MINECRAFTVERSIONS.getModel().getSize(); ++i2) {
                if (!((String)this.COMBOBOX_MINECRAFTVERSIONS.getModel().getElementAt(i2)).equals(this.chosenMinecraftVersion)) continue;
                this.COMBOBOX_MINECRAFTVERSIONS.setSelectedIndex(i2);
                break;
            }
            switch (configurationModel.getModLoader().toLowerCase()) {
                case "fabric": {
                    if (!configurationModel.getModLoaderVersion().isEmpty()) {
                        for (int i3 = 0; i3 < this.VERSIONMETA.fabric().loaderVersionsArrayDescending().length; ++i3) {
                            if (!this.VERSIONMETA.fabric().loaderVersionsArrayDescending()[i3].equals(configurationModel.getModLoaderVersion())) continue;
                            this.COMBOBOX_MODLOADER_VERSIONS.setSelectedIndex(i3);
                            this.chosenModloaderVersion = configurationModel.getModLoaderVersion();
                            break;
                        }
                    }
                    this.updateModloaderGuiComponents("Fabric");
                    break;
                }
                case "forge": {
                    String[] forgever = this.VERSIONMETA.forge().availableForgeVersionsArrayDescending(this.chosenMinecraftVersion).isPresent() ? this.VERSIONMETA.forge().availableForgeVersionsArrayDescending(this.chosenMinecraftVersion).get() : this.NONE;
                    if (!configurationModel.getModLoaderVersion().isEmpty()) {
                        for (int i4 = 0; i4 < forgever.length; ++i4) {
                            if (!forgever[i4].equals(configurationModel.getModLoaderVersion())) continue;
                            this.COMBOBOX_MODLOADER_VERSIONS.setSelectedIndex(i4);
                            this.chosenModloaderVersion = configurationModel.getModLoaderVersion();
                            break;
                        }
                    }
                    this.updateModloaderGuiComponents("Forge");
                    break;
                }
                case "quilt": {
                    if (!configurationModel.getModLoaderVersion().isEmpty()) {
                        for (int i5 = 0; i5 < this.VERSIONMETA.quilt().loaderVersionsArrayDescending().length; ++i5) {
                            if (!this.VERSIONMETA.quilt().loaderVersionsArrayDescending()[i5].equals(configurationModel.getModLoaderVersion())) continue;
                            this.COMBOBOX_MODLOADER_VERSIONS.setSelectedIndex(i5);
                            this.chosenModloaderVersion = configurationModel.getModLoaderVersion();
                            break;
                        }
                    }
                    this.updateModloaderGuiComponents("Quilt");
                }
            }
            this.CHECKBOX_SERVER.setSelected(configurationModel.getIncludeServerInstallation());
            this.CHECKBOX_ICON.setSelected(configurationModel.getIncludeServerIcon());
            this.CHECKBOX_PROPERTIES.setSelected(configurationModel.getIncludeServerProperties());
            this.CHECKBOX_ZIP.setSelected(configurationModel.getIncludeZipCreation());
            this.TEXTAREA_JAVAARGS.setText(configurationModel.getJavaArgs());
            this.TEXTFIELD_SERVERPACKSUFFIX.setText(this.UTILITIES.StringUtils().pathSecureText(configurationModel.getServerPackSuffix()));
        }
        catch (Exception ex) {
            LOG.error("Couldn't load configuration file.", (Throwable)ex);
            JOptionPane.showMessageDialog(this, "Couldn't load configuration file. " + ex.getCause());
        }
    }

    protected void clearInterface() {
        this.TEXTFIELD_MODPACKDIRECTORY.setText("");
        this.TEXTFIELD_SERVERPACKSUFFIX.setText("");
        this.TEXTAREA_CLIENTSIDEMODS.setText(this.UTILITIES.StringUtils().buildString(this.APPLICATIONPROPERTIES.getDefaultListFallbackMods()));
        this.TEXTAREA_COPYDIRECTORIES.setText(this.UTILITIES.StringUtils().buildString(this.APPLICATIONPROPERTIES.getDirectoriesToInclude()));
        this.TEXTFIELD_SERVERICONPATH.setText("");
        this.TEXTFIELD_SERVERPROPERTIESPATH.setText("");
        this.TEXTFIELD_JAVAPATH.setText(this.UTILITIES.SystemUtils().acquireJavaPathFromSystem());
        for (int i2 = 0; i2 < this.VERSIONMETA.minecraft().releaseVersionsArrayDescending().length; ++i2) {
            if (!this.VERSIONMETA.minecraft().releaseVersionsArrayDescending()[i2].equals(this.VERSIONMETA.minecraft().latestRelease().version())) continue;
            this.COMBOBOX_MINECRAFTVERSIONS.setSelectedIndex(i2);
            this.chosenMinecraftVersion = this.VERSIONMETA.minecraft().latestRelease().version();
        }
        this.updateModloaderGuiComponents("Forge");
        this.CHECKBOX_SERVER.setSelected(false);
        this.CHECKBOX_ICON.setSelected(false);
        this.CHECKBOX_PROPERTIES.setSelected(false);
        this.CHECKBOX_ZIP.setSelected(false);
        this.setJavaArgs("");
        this.validateInputFields();
    }

    private Color getThemeErrorColor() {
        if (this.APPLICATIONPROPERTIES.isDarkTheme()) {
            return this.DARKTHEME.getTextErrorColour();
        }
        return this.LIGHTTHEME.getTextErrorColour();
    }

    private Color getThemeTextColor() {
        if (this.APPLICATIONPROPERTIES.isDarkTheme()) {
            return this.DARKTHEME.getTextColor();
        }
        return this.LIGHTTHEME.getTextColor();
    }

    public String getChosenModloader() {
        return this.chosenModloader;
    }

    private String getSelectedModloaderVersion() {
        return this.chosenModloaderVersion;
    }

    public String getJavaArgs() {
        return this.javaArgs;
    }

    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    public String getJavaPath() {
        return this.TEXTFIELD_JAVAPATH.getText();
    }

    public String getServerIconPath() {
        return this.TEXTFIELD_SERVERICONPATH.getText();
    }

    public String getServerPropertiesPath() {
        return this.TEXTFIELD_SERVERPROPERTIESPATH.getText();
    }
}

