/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring;

import de.griefed.serverpackcreator.spring.serverpack.ServerPackModel;
import de.griefed.serverpackcreator.spring.serverpack.ServerPackService;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class Schedules {
    private static final Logger LOG = LogManager.getLogger(Schedules.class);
    private final ServerPackService SERVERPACKSERVICE;
    private final VersionMeta VERSIONMETA;

    @Autowired
    public Schedules(ServerPackService injectedServerPackService, VersionMeta injectedVersionMeta) {
        this.SERVERPACKSERVICE = injectedServerPackService;
        this.VERSIONMETA = injectedVersionMeta;
    }

    private void deletePack(ServerPackModel pack) {
        LOG.info("Deleting archive " + pack.getPath().replace("\\", "/"));
        FileUtils.deleteQuietly(new File(pack.getPath().replace("\\", "/")));
        LOG.info("Deleting folder " + pack.getPath().replace("\\", "/").replace("_server_pack-zip", ""));
        FileUtils.deleteQuietly(new File(pack.getPath().replace("\\", "/").replace("_server_pack-zip", "")));
        LOG.info("Cleaned server pack " + pack.getId() + " from database.");
        this.SERVERPACKSERVICE.deleteServerPack(pack.getId());
    }

    @Scheduled(cron="${de.griefed.serverpackcreator.spring.schedules.database.cleanup}")
    private void cleanDatabase() {
        if (!this.SERVERPACKSERVICE.getServerPacks().isEmpty()) {
            LOG.info("Cleaning database...");
            for (ServerPackModel pack : this.SERVERPACKSERVICE.getServerPacks()) {
                if (new Timestamp(new Date().getTime()).getTime() - pack.getLastModified().getTime() >= 604800000L && pack.getDownloads() == 0) {
                    this.deletePack(pack);
                    continue;
                }
                if (pack.getStatus().equals("Available") && !new File(pack.getPath()).isFile()) {
                    this.deletePack(pack);
                    continue;
                }
                if (pack.getStatus().equals("Generating") && new Timestamp(new Date().getTime()).getTime() - pack.getLastModified().getTime() >= 86400000L) {
                    this.deletePack(pack);
                    continue;
                }
                LOG.info("No database entries to clean up.");
            }
            LOG.info("Database cleanup completed.");
        }
    }

    @Scheduled(cron="${de.griefed.serverpackcreator.spring.schedules.files.cleanup}")
    private void cleanFiles() {
        if (!this.SERVERPACKSERVICE.getServerPacks().isEmpty()) {
            LOG.info("Cleaning files...");
            for (ServerPackModel pack : this.SERVERPACKSERVICE.getServerPacks()) {
                if (new File(pack.getPath()).isFile() && new File(pack.getPath().replace("_server_pack-zip", "")).isDirectory()) {
                    LOG.info("Deleting folder " + pack.getPath().replace("_server_pack-zip", "").replace("\\", "/"));
                    FileUtils.deleteQuietly(new File(pack.getPath().replace("_server_pack-zip", "").replace("\\", "/")));
                    continue;
                }
                LOG.info("No files to clean up.");
            }
            LOG.info("File cleanup completed.");
        }
    }

    @Scheduled(cron="${de.griefed.serverpackcreator.spring.schedules.versions.refresh}")
    private void refreshVersionLister() {
        try {
            this.VERSIONMETA.update();
        }
        catch (IOException ex) {
            LOG.error("Could not update VersionMeta.", (Throwable)ex);
        }
    }
}

