/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v1/settings"})
public class ApplicationPropertiesController {
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final Utilities UTILITIES;

    @Autowired
    public ApplicationPropertiesController(ApplicationProperties injectedApplicationProperties, Utilities injectedUtilities) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.UTILITIES = injectedUtilities;
    }

    @GetMapping(produces={"application/json"})
    public String getConfiguration() {
        return "{\"listFallbackMods\":" + this.UTILITIES.ListUtils().encapsulateListElements(this.APPLICATIONPROPERTIES.getDefaultListFallbackMods()) + ",\"listDirectoriesExclude\":" + this.UTILITIES.ListUtils().encapsulateListElements(this.APPLICATIONPROPERTIES.getDirectoriesToExclude()) + ",\"serverPackCreatorVersion\":\"" + this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION() + "\",\"supportedModloaders\":" + this.UTILITIES.ListUtils().encapsulateListElements(Arrays.asList(this.APPLICATIONPROPERTIES.SUPPORTED_MODLOADERS())) + "}";
    }
}

