/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.modscanning;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import de.griefed.serverpackcreator.modscanning.Scanner;
import de.griefed.serverpackcreator.modscanning.ScanningException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TomlScanner
implements Scanner<TreeSet<File>, Collection<File>> {
    private static final Logger LOG = LogManager.getLogger(TomlScanner.class);
    private final TomlParser PARSER;
    private final String FORGE_MC = "^(forge|minecraft)$";
    private final String BOTH_SERVER = "^(BOTH|SERVER)$";

    @Autowired
    public TomlScanner(TomlParser tomlParser) {
        this.PARSER = tomlParser;
    }

    @Override
    public TreeSet<File> scan(Collection<File> filesInModsDir) {
        CommentedConfig config;
        TreeSet<File> serverMods = new TreeSet<File>();
        TreeSet<String> idsRequiredOnServer = new TreeSet<String>();
        for (File modJar : filesInModsDir) {
            try {
                config = this.getConfig(modJar);
                idsRequiredOnServer.addAll(this.getModDependencyIdsRequiredOnServer(config));
                idsRequiredOnServer.addAll(this.getModIdsRequiredOnServer(config));
            }
            catch (Exception e) {
                LOG.debug("Could not fully scan " + modJar.getName() + ". " + e.getMessage());
                serverMods.add(modJar);
            }
        }
        for (File modJar : filesInModsDir) {
            try {
                config = this.getConfig(modJar);
                TreeSet<String> idsInMod = this.getModIdsInJar(config);
                for (String id : idsInMod) {
                    if (!idsRequiredOnServer.contains(id)) continue;
                    serverMods.add(modJar);
                }
            }
            catch (Exception e) {
                LOG.debug("Could not fully scan " + modJar.getName() + ". " + e.getMessage());
                serverMods.add(modJar);
            }
        }
        TreeSet<File> excluded = new TreeSet<File>(filesInModsDir);
        excluded.removeAll(serverMods);
        return excluded;
    }

    private TreeSet<String> getModIdsRequiredOnServer(CommentedConfig config) throws ScanningException {
        ArrayList<Map<String, Object>> configs = new ArrayList<Map<String, Object>>();
        TreeSet<String> ids = new TreeSet<String>();
        if (config.valueMap().get("mods") == null) {
            throw new ScanningException("No mods specified.");
        }
        for (CommentedConfig commentedConfig : (ArrayList)config.valueMap().get("mods")) {
            configs.add(commentedConfig.valueMap());
        }
        Map<String, ArrayList<CommentedConfig>> dependencies = this.getMapOfDependencyLists(config);
        boolean containedForgeOrMinecraft = false;
        for (Map map : configs) {
            String modId = map.get("modId").toString();
            if (dependencies.containsKey(modId)) {
                for (CommentedConfig dependency : dependencies.get(modId)) {
                    try {
                        if (!this.getModId(dependency).matches("^(forge|minecraft)$")) continue;
                        containedForgeOrMinecraft = true;
                        try {
                            if (!this.getSide(dependency).matches("^(BOTH|SERVER)$")) continue;
                            ids.add(modId);
                        }
                        catch (NullPointerException ex) {
                            ids.add(modId);
                        }
                    }
                    catch (NullPointerException e) {
                        containedForgeOrMinecraft = true;
                        ids.add(modId);
                    }
                }
            } else {
                ids.add(modId);
            }
            if (containedForgeOrMinecraft) continue;
            ids.add(modId);
        }
        return ids;
    }

    private TreeSet<String> getModDependencyIdsRequiredOnServer(CommentedConfig config) throws ScanningException {
        TreeSet<String> ids = new TreeSet<String>();
        Map<String, ArrayList<CommentedConfig>> dependencies = this.getMapOfDependencyLists(config);
        TreeSet<String> idsInMod = this.getModIdsInJar(config);
        try {
            boolean confidentOnClientSide = true;
            for (String modId : idsInMod) {
                if (dependencies.containsKey(modId)) {
                    for (CommentedConfig dependency : dependencies.get(modId)) {
                        if (!this.getModId(dependency).matches("^(forge|minecraft)$") || !this.getSide(dependency).matches("^(BOTH|SERVER)$")) continue;
                        confidentOnClientSide = false;
                    }
                    continue;
                }
                confidentOnClientSide = false;
                break;
            }
            if (confidentOnClientSide) {
                return ids;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (Map.Entry<String, ArrayList<CommentedConfig>> entry : dependencies.entrySet()) {
            for (CommentedConfig commentedConfig : entry.getValue()) {
                try {
                    if (this.getModId(commentedConfig).matches("^(forge|minecraft)$")) continue;
                    try {
                        if (!this.getSide(commentedConfig).matches("^(BOTH|SERVER)$")) continue;
                        ids.add(this.getModId(commentedConfig));
                    }
                    catch (NullPointerException ex) {
                        ids.add(this.getModId(commentedConfig));
                    }
                }
                catch (NullPointerException e) {
                    if (entry.getKey().toLowerCase().matches("^(forge|minecraft)$")) continue;
                    ids.add(entry.getKey());
                }
            }
        }
        return ids;
    }

    private TreeSet<String> getModIdsInJar(CommentedConfig config) throws ScanningException {
        TreeSet<String> ids = new TreeSet<String>();
        if (config.valueMap().get("mods") == null) {
            throw new ScanningException("No mods specified.");
        }
        for (CommentedConfig commentedConfig : (ArrayList)config.valueMap().get("mods")) {
            ids.add(this.getModId(commentedConfig));
        }
        return ids;
    }

    private CommentedConfig getConfig(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        InputStream tomlStream = jarFile.getInputStream(jarFile.getJarEntry("META-INF/mods.toml"));
        CommentedConfig config = (CommentedConfig)this.PARSER.parse(tomlStream);
        jarFile.close();
        tomlStream.close();
        return config;
    }

    private Map<String, ArrayList<CommentedConfig>> getMapOfDependencyLists(CommentedConfig config) throws ScanningException {
        if (config.valueMap().get("dependencies") == null) {
            throw new ScanningException("No dependencies specified.");
        }
        HashMap<String, ArrayList<CommentedConfig>> dependencies = new HashMap<String, ArrayList<CommentedConfig>>();
        if (config.valueMap().get("dependencies") instanceof ArrayList) {
            dependencies.put(this.getModId((CommentedConfig)((ArrayList)config.valueMap().get("mods")).get(0)), (ArrayList)config.valueMap().get("dependencies"));
        } else {
            for (Map.Entry<String, Object> entry : ((CommentedConfig)config.valueMap().get("dependencies")).valueMap().entrySet()) {
                dependencies.put(entry.getKey().toLowerCase(), (ArrayList)entry.getValue());
            }
        }
        return dependencies;
    }

    private String getModId(CommentedConfig config) {
        return config.valueMap().get("modId").toString().toLowerCase();
    }

    private String getSide(CommentedConfig config) {
        return config.valueMap().get("side").toString().toUpperCase();
    }
}

