/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.modscanning;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.modscanning.JsonBasedScanner;
import de.griefed.serverpackcreator.modscanning.Scanner;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import java.io.File;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class FabricScanner
extends JsonBasedScanner
implements Scanner<TreeSet<File>, Collection<File>> {
    private static final Logger LOG = LogManager.getLogger(FabricScanner.class);
    private final ObjectMapper OBJECT_MAPPER;
    private final Utilities UTILITIES;

    @Autowired
    public FabricScanner(ObjectMapper objectMapper, Utilities utilities) {
        this.OBJECT_MAPPER = objectMapper.enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature());
        this.UTILITIES = utilities;
    }

    @Override
    public TreeSet<File> scan(Collection<File> filesInModsDir) {
        LOG.info("Scanning Fabric mods for sideness...");
        TreeSet<String> modDependencies = new TreeSet<String>();
        TreeSet<String> clientMods = new TreeSet<String>();
        this.checkForClientModsAndDeps(filesInModsDir, clientMods, modDependencies);
        this.cleanupClientMods(modDependencies, clientMods);
        return this.getModsDelta(filesInModsDir, clientMods);
    }

    @Override
    void checkForClientModsAndDeps(Collection<File> filesInModsDir, TreeSet<String> clientMods, TreeSet<String> modDependencies) {
        for (File mod : filesInModsDir) {
            if (!mod.toString().endsWith("jar")) continue;
            try {
                JsonNode modJson = this.getJarJson(mod, "fabric.mod.json", this.OBJECT_MAPPER);
                String modId = this.UTILITIES.JsonUtilities().getNestedText(modJson, "id");
                try {
                    if (this.UTILITIES.JsonUtilities().nestedTextEqualsIgnoreCase(modJson, "client", "environment")) {
                        clientMods.add(modId);
                        LOG.debug("Added clientMod: " + modId);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    this.UTILITIES.JsonUtilities().getFieldNames(modJson, "depends").forEachRemaining(modDependencies::add);
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            catch (Exception ex) {
                LOG.error("Couldn't scan " + mod, (Throwable)ex);
            }
        }
    }

    @Override
    TreeSet<File> getModsDelta(Collection<File> filesInModsDir, TreeSet<String> clientMods) {
        TreeSet<File> modsDelta = new TreeSet<File>();
        for (File mod : filesInModsDir) {
            boolean addToDelta = false;
            try {
                JsonNode modJson = this.getJarJson(mod, "fabric.mod.json", this.OBJECT_MAPPER);
                String modIdTocheck = this.UTILITIES.JsonUtilities().getNestedText(modJson, "id");
                try {
                    if (this.UTILITIES.JsonUtilities().nestedTextEqualsIgnoreCase(modJson, "client", "environment") && clientMods.contains(modIdTocheck)) {
                        addToDelta = true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (!addToDelta) continue;
                modsDelta.add(mod);
            }
            catch (Exception exception) {}
        }
        return modsDelta;
    }
}

