/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.modscanning;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.modscanning.JsonBasedScanner;
import de.griefed.serverpackcreator.modscanning.Scanner;
import de.griefed.serverpackcreator.utilities.common.JsonException;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class AnnotationScanner
extends JsonBasedScanner
implements Scanner<TreeSet<File>, Collection<File>> {
    private static final Logger LOG = LogManager.getLogger(AnnotationScanner.class);
    private final ObjectMapper OBJECT_MAPPER;
    private final Utilities UTILITIES;
    private final String DEPENDENCY_REPLACE_REGEX = "(@.*|\\[.*)";
    private final String DEPENDENCY_CHECK_REGEX = "(before:.*|after:.*|required-after:.*|)";

    @Autowired
    public AnnotationScanner(ObjectMapper objectMapper, Utilities utilities) {
        this.OBJECT_MAPPER = objectMapper;
        this.UTILITIES = utilities;
    }

    @Override
    public TreeSet<File> scan(Collection<File> filesInModsDir) {
        LOG.info("Scanning Minecraft 1.12.x and older mods for sideness...");
        TreeSet<String> modDependencies = new TreeSet<String>();
        TreeSet<String> clientMods = new TreeSet<String>();
        this.checkForClientModsAndDeps(filesInModsDir, clientMods, modDependencies);
        this.cleanupClientMods(modDependencies, clientMods);
        return this.getModsDelta(filesInModsDir, clientMods);
    }

    @Override
    void checkForClientModsAndDeps(Collection<File> filesInModsDir, TreeSet<String> clientMods, TreeSet<String> modDependencies) {
        for (File mod : filesInModsDir) {
            if (!mod.toString().endsWith("jar")) continue;
            String modId = null;
            TreeSet<String> additionalMods = new TreeSet<String>();
            try {
                JsonNode modJson = this.getJarJson(mod, "META-INF/fml_cache_annotation.json", this.OBJECT_MAPPER);
                for (JsonNode node : modJson) {
                    try {
                        for (JsonNode child : node.get("annotations")) {
                            if (modId == null) {
                                try {
                                    modId = this.getModId(child);
                                    this.checkForClientSide(child, modId, clientMods);
                                }
                                catch (JsonException | NullPointerException exception) {}
                            } else {
                                try {
                                    this.checkAdditionalId(child, modId, clientMods, additionalMods);
                                }
                                catch (NullPointerException nullPointerException) {
                                    // empty catch block
                                }
                            }
                            this.checkDependencies(child, modDependencies);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                if (additionalMods.isEmpty()) continue;
                this.checkAdditionalMods(modId, additionalMods, modJson, clientMods);
            }
            catch (Exception ex) {
                LOG.error("Couldn't scan " + mod, (Throwable)ex);
            }
        }
    }

    private String getModId(JsonNode jsonNode) throws NullPointerException {
        if (!this.UTILITIES.JsonUtilities().nestedTextIsEmpty(jsonNode, "values", "modid", "value")) {
            return this.UTILITIES.JsonUtilities().getNestedText(jsonNode, "values", "modid", "value");
        }
        throw new NullPointerException("No modId present.");
    }

    private void checkForClientSide(JsonNode jsonNode, String modId, TreeSet<String> clientMods) throws NullPointerException, JsonException {
        if (this.UTILITIES.JsonUtilities().getNestedBoolean(jsonNode, "values", "clientSideOnly", "value")) {
            clientMods.add(modId);
            LOG.debug("Added clientMod: " + modId);
        }
    }

    private void checkAdditionalId(JsonNode child, String modId, TreeSet<String> clientMods, TreeSet<String> additionalMods) throws NullPointerException {
        if (!this.UTILITIES.JsonUtilities().nestedTextIsEmpty(child, "values", "modid", "value")) {
            if (this.UTILITIES.JsonUtilities().nestedTextEqualsIgnoreCase(child, modId, "values", "modid", "value")) {
                try {
                    if (this.UTILITIES.JsonUtilities().getNestedBoolean(child, "values", "clientSideOnly", "value")) {
                        clientMods.add(modId);
                        LOG.debug("Added clientMod: " + modId);
                    }
                }
                catch (JsonException | NullPointerException exception) {}
            } else {
                additionalMods.add(this.UTILITIES.JsonUtilities().getNestedText(child, "values", "modid", "value"));
            }
        }
    }

    private void checkDependencies(JsonNode child, TreeSet<String> modDependencies) {
        try {
            if (!this.UTILITIES.JsonUtilities().nestedTextIsEmpty(child, "values", "dependencies", "value")) {
                String dependencies;
                String dependency;
                if (this.UTILITIES.JsonUtilities().nestedTextContains(child, ";", "values", "dependencies", "value")) {
                    String[] dependencies2;
                    for (String dependency2 : dependencies2 = this.UTILITIES.JsonUtilities().getNestedTexts(child, ";", "values", "dependencies", "value")) {
                        if (!dependency2.matches("(before:.*|after:.*|required-after:.*|)") || (dependency2 = this.getDependency(dependency2)).equalsIgnoreCase("forge") || dependency2.equals("*")) continue;
                        modDependencies.add(dependency2);
                        LOG.debug("Added dependency " + dependency2);
                    }
                } else if (this.UTILITIES.JsonUtilities().nestedTextMatches(child, "(before:.*|after:.*|required-after:.*|)", "values", "dependencies", "value") && !(dependency = this.getDependency(dependencies = this.UTILITIES.JsonUtilities().getNestedText(child, "values", "dependencies", "value"))).equalsIgnoreCase("forge") && !dependency.equals("*")) {
                    modDependencies.add(dependency);
                    LOG.debug("Added dependency " + dependency);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private String getDependency(String dependency) {
        return dependency.substring(dependency.lastIndexOf(":") + 1).replaceAll("(@.*|\\[.*)", "");
    }

    private void checkAdditionalMods(String modId, TreeSet<String> additionalMods, JsonNode modJson, TreeSet<String> clientMods) {
        for (String additionalModId : additionalMods) {
            for (JsonNode node : modJson) {
                try {
                    for (JsonNode child : node.get("annotations")) {
                        boolean additionalModDependsOnFirst = false;
                        try {
                            if (this.UTILITIES.JsonUtilities().nestedTextEqualsIgnoreCase(child, additionalModId, "values", "modid", "value") && !this.UTILITIES.JsonUtilities().nestedTextIsEmpty(child, "values", "dependencies", "value")) {
                                if (this.UTILITIES.JsonUtilities().nestedTextContains(child, ";", "values", "dependencies", "value")) {
                                    if (this.additionalDepsDepend(child, modId)) {
                                        additionalModDependsOnFirst = true;
                                    }
                                } else if (this.additionalDepDepends(child, modId)) {
                                    additionalModDependsOnFirst = true;
                                }
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        if (!additionalModDependsOnFirst || this.isAdditionalModClientSide(node, additionalModId) || !clientMods.removeIf(n -> n.equals(modId))) continue;
                        LOG.info("Removing " + modId + " from list of clientside-only mods. It contains multiple mods at once, and one of them is NOT clientside-only.");
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
            }
        }
    }

    private boolean additionalDepsDepend(JsonNode child, String modId) {
        String[] dependencies;
        boolean depends = false;
        for (String dependency : dependencies = this.UTILITIES.JsonUtilities().getNestedTexts(child, ";", "values", "dependencies", "value")) {
            if (!dependency.matches("(before:.*|after:.*|required-after:.*|)") || !(dependency = dependency.substring(dependency.lastIndexOf(":") + 1).replaceAll("(@.*|\\[.*)", "")).equals(modId)) continue;
            depends = true;
        }
        return depends;
    }

    private boolean additionalDepDepends(JsonNode child, String modId) {
        String dependencies;
        String dependency;
        boolean depends = false;
        if (this.UTILITIES.JsonUtilities().nestedTextMatches(child, "(before:.*|after:.*|required-after:.*|)", "values", "dependencies", "value") && (dependency = (dependencies = this.UTILITIES.JsonUtilities().getNestedText(child, "values", "dependencies", "value")).substring(dependencies.lastIndexOf(":") + 1).replaceAll("(@.*|\\[.*)", "")).equals(modId)) {
            depends = true;
        }
        return depends;
    }

    private boolean isAdditionalModClientSide(JsonNode node, String additionalModId) {
        boolean clientSide = false;
        try {
            for (JsonNode children : node.get("annotations")) {
                try {
                    if (!this.UTILITIES.JsonUtilities().nestedTextEqualsIgnoreCase(children, additionalModId, "values", "modid", "value") || !this.UTILITIES.JsonUtilities().getNestedBoolean(children, "values", "clientSideOnly", "value")) continue;
                    clientSide = true;
                }
                catch (JsonException | NullPointerException exception) {}
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return clientSide;
    }

    @Override
    TreeSet<File> getModsDelta(Collection<File> filesInModsDir, TreeSet<String> clientMods) {
        TreeSet<File> modsDelta = new TreeSet<File>();
        for (File mod : filesInModsDir) {
            try {
                if (!this.addToDelta(mod, clientMods)) continue;
                modsDelta.add(mod);
            }
            catch (Exception exception) {}
        }
        return modsDelta;
    }

    private boolean addToDelta(File file, TreeSet<String> clientMods) throws IOException {
        JsonNode modJson = this.getJarJson(file, "META-INF/fml_cache_annotation.json", this.OBJECT_MAPPER);
        boolean addToDelta = false;
        for (JsonNode node : modJson) {
            try {
                for (JsonNode child : node.get("annotations")) {
                    try {
                        String modIdTocheck = this.getModId(child);
                        if (modIdTocheck == null || !this.UTILITIES.JsonUtilities().getNestedBoolean(child, "values", "clientSideOnly", "value") || !clientMods.contains(modIdTocheck)) continue;
                        addToDelta = true;
                    }
                    catch (JsonException | NullPointerException exception) {}
                }
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return addToDelta;
    }
}

