/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.NoFormatFoundException;
import com.fasterxml.jackson.databind.JsonNode;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ConfigurationModel {
    private final List<String> clientMods = new ArrayList<String>();
    private final List<String> copyDirs = new ArrayList<String>();
    private final HashMap<String, String> scriptSettings = new HashMap();
    private String modpackDir = "";
    private String javaPath = "";
    private String minecraftVersion = "";
    private String modLoader = "";
    private String modLoaderVersion = "";
    private String javaArgs = "";
    private String serverPackSuffix = "";
    private String serverIconPath = "";
    private String serverPropertiesPath = "";
    private Boolean includeServerInstallation = true;
    private Boolean includeServerIcon = true;
    private Boolean includeServerProperties = true;
    private Boolean includeZipCreation = true;
    private JsonNode modpackJson = null;
    private String projectName;
    private String fileName;
    private String fileDiskName;

    public ConfigurationModel() {
    }

    public ConfigurationModel(List<String> clientMods, List<String> copyDirs, String modpackDir, String javaPath, String minecraftVersion, String modLoader, String modLoaderVersion, String javaArgs, String serverPackSuffix, String serverIconPath, String serverPropertiesPath, boolean includeServerInstallation, boolean includeServerIcon, boolean includeServerProperties, boolean includeZipCreation, HashMap<String, String> scriptSettings) {
        this.clientMods.addAll(clientMods);
        this.copyDirs.addAll(copyDirs);
        this.modpackDir = modpackDir;
        this.javaPath = javaPath;
        this.minecraftVersion = minecraftVersion;
        this.modLoader = modLoader;
        this.modLoaderVersion = modLoaderVersion;
        this.javaArgs = javaArgs;
        this.serverPackSuffix = serverPackSuffix;
        this.serverIconPath = serverIconPath;
        this.serverPropertiesPath = serverPropertiesPath;
        this.includeServerInstallation = includeServerInstallation;
        this.includeServerIcon = includeServerIcon;
        this.includeServerProperties = includeServerProperties;
        this.includeZipCreation = includeZipCreation;
        this.scriptSettings.putAll(scriptSettings);
    }

    public ConfigurationModel(Utilities utilities, File configFile) throws FileNotFoundException, NoFormatFoundException {
        if (!configFile.exists()) {
            throw new FileNotFoundException("Couldn't find file: " + configFile);
        }
        FileConfig config = FileConfig.of(configFile);
        config.load();
        this.setClientMods(config.getOrElse("clientMods", Collections.singletonList("")));
        this.setCopyDirs(config.getOrElse("copyDirs", Collections.singletonList("")));
        this.setModpackDir(config.getOrElse("modpackDir", "").replace("\\", "/"));
        this.setJavaPath(config.getOrElse("javaPath", "").replace("\\", "/"));
        this.setMinecraftVersion(config.getOrElse("minecraftVersion", ""));
        this.setModLoader(config.getOrElse("modLoader", ""));
        this.setModLoaderVersion(config.getOrElse("modLoaderVersion", ""));
        this.setJavaArgs(config.getOrElse("javaArgs", "empty"));
        this.setServerPackSuffix(utilities.StringUtils().pathSecureText(config.getOrElse("serverPackSuffix", "")));
        this.setServerIconPath(config.getOrElse("serverIconPath", "").replace("\\", "/"));
        this.setServerPropertiesPath(config.getOrElse("serverPropertiesPath", "").replace("\\", "/"));
        this.setIncludeServerInstallation(utilities.BooleanUtils().convert(String.valueOf(config.getOrElse("includeServerInstallation", "False"))));
        this.setIncludeServerIcon(utilities.BooleanUtils().convert(String.valueOf(config.getOrElse("includeServerIcon", "False"))));
        this.setIncludeServerProperties(utilities.BooleanUtils().convert(String.valueOf(config.getOrElse("includeServerProperties", "False"))));
        this.setIncludeZipCreation(utilities.BooleanUtils().convert(String.valueOf(config.getOrElse("includeZipCreation", "False"))));
    }

    public String getServerPackSuffix() {
        return this.serverPackSuffix;
    }

    public void setServerPackSuffix(String serverPackSuffix) {
        this.serverPackSuffix = serverPackSuffix;
    }

    public List<String> getClientMods() {
        return this.clientMods;
    }

    public void setClientMods(List<String> newClientMods) {
        this.clientMods.clear();
        newClientMods.removeIf(entry -> entry.matches("\\s+") || entry.length() == 0);
        this.clientMods.addAll(newClientMods);
    }

    public List<String> getCopyDirs() {
        return this.copyDirs;
    }

    public void setCopyDirs(List<String> newCopyDirs) {
        this.copyDirs.clear();
        newCopyDirs.removeIf(entry -> entry.equalsIgnoreCase("server_pack") || entry.matches("\\s+") || entry.length() == 0);
        newCopyDirs.replaceAll(entry -> entry.replace("\\", "/"));
        this.copyDirs.addAll(newCopyDirs);
    }

    public String getModpackDir() {
        return this.modpackDir;
    }

    public void setModpackDir(String newModpackDir) {
        this.modpackDir = newModpackDir.replace("\\", "/");
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String newJavaPath) {
        this.javaPath = newJavaPath.replace("\\", "/");
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public void setMinecraftVersion(String newMinecraftVersion) {
        this.minecraftVersion = newMinecraftVersion;
    }

    public String getModLoader() {
        return this.modLoader;
    }

    public void setModLoader(String newModLoader) {
        if (newModLoader.toLowerCase().contains("forge")) {
            this.modLoader = "Forge";
        } else if (newModLoader.toLowerCase().contains("fabric")) {
            this.modLoader = "Fabric";
        } else if (newModLoader.toLowerCase().contains("quilt")) {
            this.modLoader = "Quilt";
        }
    }

    public String getModLoaderVersion() {
        return this.modLoaderVersion;
    }

    public void setModLoaderVersion(String newModLoaderVersion) {
        this.modLoaderVersion = newModLoaderVersion;
    }

    public boolean getIncludeServerInstallation() {
        return this.includeServerInstallation;
    }

    public void setIncludeServerInstallation(boolean newIncludeServerInstallation) {
        this.includeServerInstallation = newIncludeServerInstallation;
    }

    public boolean getIncludeServerIcon() {
        return this.includeServerIcon;
    }

    public void setIncludeServerIcon(boolean newIncludeServerIcon) {
        this.includeServerIcon = newIncludeServerIcon;
    }

    public boolean getIncludeServerProperties() {
        return this.includeServerProperties;
    }

    public void setIncludeServerProperties(boolean newIncludeServerProperties) {
        this.includeServerProperties = newIncludeServerProperties;
    }

    public boolean getIncludeZipCreation() {
        return this.includeZipCreation;
    }

    public void setIncludeZipCreation(boolean newIncludeZipCreation) {
        this.includeZipCreation = newIncludeZipCreation;
    }

    public String getJavaArgs() {
        return this.javaArgs;
    }

    public void setJavaArgs(String javaArgs) {
        this.javaArgs = javaArgs;
    }

    public JsonNode getModpackJson() {
        return this.modpackJson;
    }

    public void setModpackJson(JsonNode modpackJson) {
        this.modpackJson = modpackJson;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileDiskName() {
        return this.fileDiskName;
    }

    public void setFileDiskName(String fileName) {
        this.fileDiskName = fileName;
    }

    public String getServerIconPath() {
        return this.serverIconPath;
    }

    public void setServerIconPath(String serverIconPath) {
        this.serverIconPath = serverIconPath.replace("\\", "/");
    }

    public String getServerPropertiesPath() {
        return this.serverPropertiesPath;
    }

    public void setServerPropertiesPath(String serverPropertiesPath) {
        this.serverPropertiesPath = serverPropertiesPath.replace("\\", "/");
    }

    public HashMap<String, String> getScriptSettings() {
        return this.scriptSettings;
    }

    public void setScriptSettings(HashMap<String, String> scriptSettings) {
        this.scriptSettings.clear();
        this.scriptSettings.putAll(scriptSettings);
    }

    public String toString() {
        return "ConfigurationModel{clientMods=" + this.clientMods + ", copyDirs=" + this.copyDirs + ", scriptSettings=" + this.scriptSettings + ", modpackDir='" + this.modpackDir + '\'' + ", javaPath='" + this.javaPath + '\'' + ", minecraftVersion='" + this.minecraftVersion + '\'' + ", modLoader='" + this.modLoader + '\'' + ", modLoaderVersion='" + this.modLoaderVersion + '\'' + ", javaArgs='" + this.javaArgs + '\'' + ", serverPackSuffix='" + this.serverPackSuffix + '\'' + ", serverIconPath='" + this.serverIconPath + '\'' + ", serverPropertiesPath='" + this.serverPropertiesPath + '\'' + ", includeServerInstallation=" + this.includeServerInstallation + ", includeServerIcon=" + this.includeServerIcon + ", includeServerProperties=" + this.includeServerProperties + ", includeZipCreation=" + this.includeZipCreation + ", modpackJson=" + this.modpackJson + ", projectName='" + this.projectName + '\'' + ", fileName='" + this.fileName + '\'' + ", fileDiskName='" + this.fileDiskName + '\'' + '}';
    }
}

