[![banner](https://i.griefed.de/images/2021/03/03/serverpackcreator_banner.png)](https://github.com/Griefed/ServerPackCreator)

[![Homepage](https://img.shields.io/badge/Griefed.de-Homepage-c0ffee?style=for-the-badge&labelColor=325358&logo=data:image/png;base64,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)](https://www.griefed.de)
[![Blog](https://img.shields.io/badge/Griefed.de-Blog-c0ffee?style=for-the-badge&labelColor=325358&logo=wordpress)](https://blog.griefed.de)
[![Fleet](https://img.shields.io/badge/Griefed.de-Fleet-c0ffee?style=for-the-badge&labelColor=325358&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAABiVBMVEUAAAD///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////8XJWL///8gNCTuAAAAgXRSTlMAAgMEBQYHCAkLDA4PEBESFhgZGh0eISIlKC8zNDU3OT0+P0BBQkhKS01QU1RVVltcXWJjZGlrbG1wcnN0eHl6e4CBhYyOkJWWmZ6foaKkqaqsrrKztLe8vsHExcbHy8zNz9DT1NXX2Nna293e3+Tm5+nq7O3u7/Hy9fb4+fr7/f4zgtRAAAABWklEQVR42mKgHhCFMbg0dHW1xNGlBcw5wTS7tkcJoNV5UJItBoMA3GPjcm3btm3btq1+8s1JxijuV0p+X5NzVcfNRoT4O26ClEZykdydI5ddCHDt+EfqthiwYoXfRH++yb9r8IZ+o/CpeB1hE/zMtXf0KYKkP9p8ZSaCfq1S2ddDU84zrsuXYXZjYy0VcBxQKYVmgQ9slS8HhUbxSP+kNAPB+kIyO1ggr5mn9GoX70wKydA4/RNQQSVPvGspZEHQ5ZKHK5lu8UymUi/enRQuxYjcN5LPH+RTQfcVlQ4AbfJ1n4JKRusG0ErpzCn3vjFMe8g9/eUU2himHEAilc+Vq6XJ4Zyx6eXTk3f6/IOww7i2oOliXNXQ/H5kHBcWSO2MowyKJc4VU/BLOGcMm04EJF3FyHsQImkvMj/tQBhrz0to+rwSUf70XvjT23VWxKLLaBkYGuqr+Y8f9Q3q0fzzGED8cgAAAABJRU5ErkJggg==)](https://fleet.griefed.de)
[![GitHub](https://img.shields.io/badge/Griefed.de-Github-c0ffee?style=for-the-badge&labelColor=325358&logo=github)](https://github.com/Griefed)
[![DockerHub](https://img.shields.io/badge/Griefed.de-DockerHub-c0ffee?style=for-the-badge&labelColor=325358&logo=docker&logoColor=white)](https://hub.docker.com/u/griefed)
[![Discord](https://img.shields.io/badge/Griefed.de-Discord-c0ffee?style=for-the-badge&labelColor=325358&logo=discord&logoColor=white)](https://discord.griefed.de)

---

# Sources, GitHub, GitLab and Mirroring and all that good stuff

Repositories on GitHub are now for issues only. I've set up my own installation of GitLab and moved all my repositories over to [Git.Griefed.de](https://git.griefed.de/users/Griefed/projects). Make sure to check there first for the latest code before opening an issue on GitHub.

For questions, you can always join my [Discord server](https://discord.griefed.de) and talk to me there.

###### This repository is available at:

- Source: https://git.griefed.de/Griefed/ServerPackCreator
- Mirror: https://gitlab.com/Griefed/ServerPackCreator
- Mirror: https://github.com/Griefed/ServerPackCreator
- Mirror: https://gitea.com/Griefed/ServerPackCreator

---

[![Docker Pulls](https://img.shields.io/docker/pulls/griefed/serverpackcreator?style=for-the-badge&logo=Docker&labelColor=325358&color=c0ffee&logoColor=white)](https://hub.docker.com/r/griefed/serverpackcreator)
[![Docker Image Size (latest by date)](https://img.shields.io/docker/image-size/griefed/serverpackcreator?label=Image%20size&sort=date&style=for-the-badge&logo=Docker&labelColor=325358&color=c0ffee&logoColor=white)](https://hub.docker.com/r/griefed/serverpackcreator)
[![Docker Cloud Automated build](https://img.shields.io/docker/cloud/automated/griefed/serverpackcreator?label=Docker%20build&style=for-the-badge&logo=Docker&labelColor=325358&color=c0ffee&logoColor=white)](https://hub.docker.com/r/griefed/serverpackcreator)

[![GitHub release (latest by date including pre-releases)](https://img.shields.io/github/v/release/Griefed/ServerPackCreator?include_prereleases&label=Latest%20Release&logo=Github&style=for-the-badge&color=c0ffee&labelColor=325358)](https://github.com/Griefed/ServerPackCreator/releases/latest)
[![GitHub](https://img.shields.io/github/license/Griefed/ServerPackCreator?logo=GitHub&style=for-the-badge&color=c0ffee&labelColor=325358)](https://github.com/Griefed/ServerPackCreator/blob/main/LICENSE)

[![GitLab Pipeline Status](https://img.shields.io/gitlab/pipeline/Griefed/ServerPackCreator/main?gitlab_url=https%3A%2F%2Fgit.griefed.de&label=GitLab%20CI/CD%20Status&color=c0ffee&logo=GitHub&logoColor=white&labelColor=325358&&style=for-the-badge)](https://git.griefed.de/Griefed/ServerPackCreator)
[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/Griefed/ServerPackCreator/Deploy%20javadocs%20to%20GitHub%20pages?color=c0ffee&labelColor=325358&label=GitHub%20Pages%20Deploy&logo=GitHub&logoColor=white&style=for-the-badge)](https://griefed.github.io/ServerPackCreator)

[![GitHub Repo stars](https://img.shields.io/github/stars/Griefed/serverpackcreator?label=GitHub%20Stars&style=for-the-badge&logo=Github&labelColor=325358&color=c0ffee)](https://github.com/Griefed/ServerPackCreator)
[![GitHub forks](https://img.shields.io/github/forks/Griefed/serverpackcreator?label=GitHub%20Forks&style=for-the-badge&logo=Github&labelColor=325358&color=c0ffee)](https://github.com/Griefed/ServerPackCreator)
[![GitHub contributors](https://img.shields.io/github/contributors/Griefed/ServerPackCreator?color=c0ffee&label=Contributors&logo=GitHub&logoColor=white&style=for-the-badge&labelColor=325358)](https://github.com/Griefed/ServerPackCreator/graphs/contributors)
[![GitHub all releases](https://img.shields.io/github/downloads/Griefed/ServerPackCreator/total?color=c0ffee&logo=GitHub&logoColor=white&labelColor=325358&style=for-the-badge)](https://github.com/Griefed/ServerPackCreator/releases)

**ServerPackCreator is a Java-program which creates a server pack from any given Forge or Fabric modpack. Customize the configuration to your liking and off you go.**
**Whenever you are working on an update to your modpack, you simply run ServerPackCreator and BAM! You've got yourself a server pack for your new modpack version.**

I am making this in my spare time, therefore progress is slow. I started getting into Java programming in february 2021, and I'm using ServerPackCreator as a way to teach myself Java, but also to create something useful for the Minecraft community.

Use at your own risk! Be aware that data loss is possible.

[[_TOC_]]

# Screenshots

## Commandline Interface (CLI)

| Windows                                                            | Linux                                                              | Mac                                                            |
|--------------------------------------------------------------------|--------------------------------------------------------------------|----------------------------------------------------------------|
| ![CLI Win](https://i.griefed.de/images/2021/11/20/cli_windows.png) | ![CLI Linux](https://i.griefed.de/images/2021/11/20/cli_linux.png) | ![CLI Mac](https://i.griefed.de/images/2021/11/20/cli_mac.png) |

## Graphical User Interface (GUI)

| Windows                                                                    | Linux                                                                    | Mac                                                                    |
|----------------------------------------------------------------------------|--------------------------------------------------------------------------|------------------------------------------------------------------------|
| ![GUI Light](https://i.griefed.de/images/2021/11/20/gui_windows_light.png) | ![GUI Light](https://i.griefed.de/images/2021/11/20/gui_linux_light.png) | ![GUI Light](https://i.griefed.de/images/2021/11/20/gui_mac_light.png) |
| ![GUI Dark](https://i.griefed.de/images/2021/11/20/gui_windows_dark.png)   | ![GUI Dark](https://i.griefed.de/images/2021/11/20/gui_linux_dark.png)   | ![GUI Dark](https://i.griefed.de/images/2021/11/20/gui_mac_dark.png)   |

## Webservice

| Light mode                                                                                 | Dark mode                                                                                |
|--------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|
| ![Light Configuration](https://i.griefed.de/images/2022/02/10/web_configuration_light.png) | ![Dark Configuration](https://i.griefed.de/images/2022/02/10/web_configuration_dark.png) |
| ![Light Downloads](https://i.griefed.de/images/2022/02/10/web_downloads_light.png)         | ![Dark Downloads](https://i.griefed.de/images/2022/02/10/web_downloads_dark.png)         |

# Advantages/Disadvantages of CLI, GUI and Webservice:

Each way of using ServerPackCreator has its advantages and disadvantages. Depending on your environment, it may be better to use one way over the other. This section highlights some of the
advantages and disadvantages of each version to help you decide which way you are going to use.
Note: All three ways are supported by the **.jar**-file. Which one is started depends on the CLI arguments used and your environment.

## CLI:

| Advantages                                                                                                                                  | Disadvantages                                                                                                         |
|:--------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------|
| No need for a graphical environment. Can be used on a server to generate a server pack for immediate use.                                   | Gathering of information for a configuration file is tedious.                                                         |
| Step-by-Step generation of a configuration-file with the use of the `-cgen` argument. Generated config will be used immediately afterwards. | No convenience features file folder-browsing or jumping to the generated server pack after generation.                |
|                                                                                                                                             | Debugging in case of a broken/erroring configuration file can be time consuming. Careful reading of logs is required. |
|                                                                                                                                             | Manual editing of the configuration-file in case you want to change it.                                               |

## GUI:

| Advantages                                                                                                             | Disadvantages                     |
|:-----------------------------------------------------------------------------------------------------------------------|:----------------------------------|
| Browse the filesystem for folders and file required by the configuration.                                              | Requires a graphical environment. |
| Setting up a configuration by browsing the filesystem and selecting your Minecraft and modloader versions from a list. |                                   |
| Browsing the generated server pack after generation has finished.                                                      |                                   |
| Loading and saving different configurations for quick generation of multiple server packs in short succession.         |                                   |
| Edit the configuration in the GUI. No manual file-editing required.                                                    |                                   |

## Webservice:

| Advantages                                                                                                                                           | Disadvantages                                             |
|:-----------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------|
| No installation/setup required if a public instance is available somewhere.                                                                          | Requires someone to setup a publicly accessible instance. |
| Voting system to let users indicate whether a generated server pack works.                                                                           | Requires somewhat modern browser versions.                |
| Open REST API. Interaction with the webservice does not *require* a browser. You can request a server pack generation and/or download from the CLI.  | Not all browers may be supported.                         |

---

# Awesomesauce!

**None of this would have been possible without the excellent IDEs by JetBrains. They have kindly provided this open source project with an All Products Pack license.**
**Additionally, ej-Technologies has provided an open-source license for JProfiler for ServerPackCreator, which allows me to resolve performance bottlenecks, pin down memory leaks and understand threading issues.
Huge shoutout and thank you!**

| [JetBrains](https://www.jetbrains.com/)                                                             | [IntelliJ IDEA](https://www.jetbrains.com/idea/)                                                                      | [WebStorm](https://www.jetbrains.com/webstorm/)                                                                 | [JProfiler](https://www.ej-technologies.com/products/jprofiler/overview.html)                                                                                                                                                                                                                                                              |
|-----------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [![JetBrains](https://i.griefed.de/images/2021/05/11/jetbrains.th.png)](https://www.jetbrains.com/) | [![IntelliJ IDEA](https://i.griefed.de/images/2021/05/11/icon-intellij-idea.th.png)](https://www.jetbrains.com/idea/) | [![WebStorm](https://i.griefed.de/images/2021/05/11/icon-webstorm.th.png)](https://www.jetbrains.com/webstorm/) | [![ej-Technologies](https://www.ej-technologies.com/assets/logo-18cdc16334888781eb17378d82e5b1bb.png)](https://www.ej-technologies.com/products/jprofiler/overview.html) <br> [![JProfiler](https://www.ej-technologies.com/images/product_banners/jprofiler_large.png)](https://www.ej-technologies.com/products/jprofiler/overview.html) |

---

# ✨ Thanks to all of my Supporters and Sponsors ✨

<!-- sponsors --><a href="https://github.com/kreezxil"><img src="https://github.com/kreezxil.png" width="60px" alt="" /></a><!-- sponsors -->

---
# 1. Known issues

A list of known issues can be found in [Known Issues](https://github.com/Griefed/ServerPackCreator/issues/55).

# 2. Features

1. **Generate a config step-by-step by running with argument**`-cgen`
2. **Install a Forge or Fabric modloader server in your server pack**
3. **Configurable list of clientside-only mods to not include your server pack**
   1. Allow ServerPackCreator to automatically detect clientside-only mods by setting `de.griefed.serverpackcreator.serverpack.autodiscoverenabled=true` in `serverpackcreator.properties`.
4. **Configurable list of directories from your modpack to include in your server pack**
   1. Copy saves. Specify `saves/world` and it will result in the world being copied to `your_server_pack/world`.
   2. Copy specific files. Specify `source/path/to/some.file;some/folder/destination.file` and `source/path/to/some.file` will be copied to `some/folder/destination.file` inside the server pack.
   3. Exclude files and directories. Prefixing an entry with `!` or adding it to `de.griefed.serverpackcreator.configuration.copydirs.exclude=` in `serverpackcreator.properties` will result in that file or directory not being copied to the server pack.
   4. Lazy-Mode. Only specify `lazy_mode` and **nothing** else, and the whole modpack you specified will be copied to the server pack. Be warned though that configurations using this will receive no support from me. If the generated server pack errors, it is up to you to fix it.
5. **Generate Forge or Fabric start-scripts in your server pack**
   1. Specify JVM flags / Java Args for your start scripts!
6. **Include a server-icon.png-file in your server pack**
   1. Replace the file in `server-files` with your own!
7. **Include a server.properties-file in your server pack**
   1. Replace the file in `server-files` with your own!
8. **Create a ZIP-archive of your server pack**
9. **GUI to fully configure and run ServerPackCreator**
   1. Load existing config.
   2. Browse local filesystem to select modpack directory, clientside-only mods, directories to include in server pack, Java executable/binary.
   3. Logs from last run in separate tabs.
   4. Set a suffix for the server pack to be generated.
   5. And much more!
10. **Webservice**
   1. Generate a server pack from zipped up modpacks.
   2. All generated server packs available for download to everyone.
11. **Addons!**
   1. Users can provide addons which will be executed after the generation of a server pack. Add them to the `addons`-directory.
   2. Example addon at [ServerPackCreatorExampleAddon](https://github.com/Griefed/ServerPackCreatorExampleAddon)

# 3. Versions

Consider major version incompatible to each other. Meaning, configs from 1.x.x are incompatible with version 2.x.x etc.

| Version mask | Description                                                                                                                                                                                            |
|--------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **1.x.x**    | CLI only                                                                                                                                                                                               |
| **2.x.x**    | CLI and GUI. To continue to use it in CLI-mode, start it with the `-cli` argument. Note that `-cgen` is exclusive to CLI and not supported by the GUI. **The** ´.exe` **executable is GUI exclusive.** |
| **3.x.x**    | CLI, GUI, Webservice. Same as with 2.x.x but with `-web`-argument added. Use `-web` to start ServerPackCreator as a webservice which will be available at `http://localhost:8080`                      |

# 4. Addons

## 4.1 Why

There are things which people want to do with their server packs which could most certainly be automated. Some of those
things so special, or maybe out of place, that they would not warrant a separate feature for ServerPackCreator itself.

It may also be that it is such a niche feature, that I either don't have the time to code it in, or simply don't want to.
Maybe it doesn't fit into the overall design of ServerPackCreator, too. Who knows, it could be any of those reasons or another.

**Hence, the addon functionality!**

This allows people to write their own addons to expand the functionality of ServerPackCreator with their own features as
they see fit or want.

For documentation about Pf4j, visit the [Pf4j documentation](https://pf4j.org/)

## 4.2 Adding your own

How to get your own addon into this list:

If you have written your own addon or plugin for ServerPackCreator and you would like to see it added here, please open an issue over at ServerPackCreatoron GitHub, using the Documentation template.

For an addon to be accepted, you must at least provide:
- The name of the repository, and therefore the addon.
- The owner of the repository, and therefore the addon.
- The branch of the repository where the main code resides in.
- A description of the plugin or addon.

A curated list of officially acknowledged addons/plugins can be found at [addons.griefed.de](https://addons.griefed.de) (redirects to [GitHub Pages](https://griefed.github.io/ServerPackCreator-Addons-Overview/#/))

## 4.3 Examples for potential addons

Some examples for potential addons can be found [in this discussion thread](https://github.com/Griefed/ServerPackCreator/discussions/201).

Some excerpts:
1. Changelog generator, by @TheButterbrotMan at [Feature request]: Changelog generator #198
   - A changelog generator that checks the differences to the previous version and generates a changelog.

2. Bundle Adoptium Java with server packs, by @kreezxil at [Feature request]: Bundle Adoptium Java #199
   - Because modpacks need one of the either Java 8, 16, or 17, it would be nice to have the corresponding https://adoptium.net java prebundled with the server pack.

3. Automatic setup of a server pack for [BlueMap](https://www.curseforge.com/minecraft/mc-mods/bluemap)
   - Check all mods in the specified modpacks mods-directory for textures, and if any are found, add the mod to
     BlueMap's resourcepack folder `config/bluemap/resourcepacks`, install BlueMap for the specified Minecraft and Forge/Fabric
     version and voilà!

# 5. Configuration

After the first run, ServerPackCreator will generate a couple of template-files in a directory called `server_files` in the directory the ServerPackCreator resides in.
Inside it are files you can customize, so they suit your modpack and server pack:
2. server-icon.png
3. server.properties

If you wish to re-generate the default-files, simply delete any one of the previously mentioned files, run ServerPackCreator again, and the new template-file(s) will be generated in `server_files`

Running ServerPackCreator.jar with the `-cli`-argument will guide you through the generation of a config-file, should none exist. Alternatively, run ServerPackCreator with the `-cgen` argument to create a new config file.
Should you be using ServerPackCreator.exe, the default/template-files will be generated automatically, if they do not exist yet.
An example for a fully configured `serverpackcreator.conf` can be viewed [here](https://github.com/Griefed/ServerPackCreator/blob/338dbc0054aa632faecd58748e9f9fa1431b2dcb/src/main/resources/de/griefed/resources/examples/serverpackcreator.example).
Detailed list of all template files:

| File                   | Description                                                                                                                                                                                                                                         |
|------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| serverpackcreator.conf | Configuration file for customization. See [serverpackcreator.conf](https://github.com/Griefed/ServerPackCreator/blob/338dbc0054aa632faecd58748e9f9fa1431b2dcb/src/main/resources/de/griefed/resources/serverpackcreator.conf).                      |
| server.properties      | Configuration file for the Minecraft server. See [server.properties](https://github.com/Griefed/ServerPackCreator/blob/338dbc0054aa632faecd58748e9f9fa1431b2dcb/src/main/resources/de/griefed/resources/server_files/server.properties).            |
| server-icon.png        | Icon which is displayed in the server browser in Minecraft. See [server-icon.png](https://github.com/Griefed/ServerPackCreator/blob/338dbc0054aa632faecd58748e9f9fa1431b2dcb/src/main/resources/de/griefed/resources/server_files/server-icon.png). |

The serverpackcreator.conf file allows you to customize a couple of different things:

| Variable                  | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
|---------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| modpackDir                | The path to the directory/ZIP-archive where your modpack resides in.                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| clientMods                | List of client-side only mods which are to be deleted from the serverpack. You only need to specify the beginning of the filename up, but excluding, the version number. ServerPackCreator checks whether any of the mods which are copied from the modpack to the serverpack start with any strings in this list and, if there's a match, deletes that file from the serverpack. Check out the [example](https://gist.github.com/Griefed/090cc7c1c2b283daa4b46f6cb85e5e00) for an idea of how it's supposed to look. |
| copyDirs                  | List for directories which are to be copied to the serverpack. If you specify a world from the `saves`-directory, ServerPackCreator will copy the the specified world to the base directory of the serverpack. In other words, `/saves/MyAwesomeWorld` becomes `/MyAwesomeWorld`.                                                                                                                                                                                                                                     |
| includeServerInstallation | Whether to install a Forge/Fabric server for the serverpack. Must be `true` or `false`.                                                                                                                                                                                                                                                                                                                                                                                                                               |
| javaPath                  | Path to the Java Installation. On Linux systems use `which java` to find the location of your Java install. On Windows use `where java` and exclude the `.exe`-part.                                                                                                                                                                                                                                                                                                                                                  |
| minecraftVersion          | The version of Minecraft for which to install the modloader server. The same version of Minecraft your modpack uses.                                                                                                                                                                                                                                                                                                                                                                                                  |
| modLoader                 | Which modloader to install. Must be either "Forge" or "Fabric". The same modloader your modpack uses.                                                                                                                                                                                                                                                                                                                                                                                                                 |
| modLoaderVersion          | Specific Modloader version to install the server in the serverpack. The same version your modpack uses.                                                                                                                                                                                                                                                                                                                                                                                                               |
| includeServerIcon         | Whether to include server-icon.png in your serverpack. Must be `true` or `false`.                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| includeServerProperties   | Whether to include server.properties in your serverpack. Must be `true` or `false`.                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| includeZipCreation        | Whether to create a zip-file of your serverpack, saved in the directory you specified with `modpackDir`. Must be `true` or `false`.                                                                                                                                                                                                                                                                                                                                                                                   |
| javaArgs                  | JVM flags / Java Args to add to the generated start-scripts. Set to "empty" to not use any in your start-scripts.                                                                                                                                                                                                                                                                                                                                                                                                     |
| serverPackSuffix          | A suffix to append to the name of the server pack directory and server pack ZIP-archive. Illegal characters are / < > : " \ &#124; ? * # % & { } $ ! ' @ + ´ ` = and must not end with a SPACE<code>&#32;&#32;</code> or a DOT<code>&#32;.&#32;&#32;</code>                                                                                                                                                                                                                                                           |                                                                                                                                                                                                                                                                                                                                                                                           |
| serverIconPath            | Path to a custom server-icon.png-file to include in the server pack.                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| serverPropertiesPath      | Path to a custom server.properties-file to include in the server pack.                                                                                                                                                                                                                                                                                                                                                                                                                                                |

After checking the configuration, run ServerPackCreator again, and it'll do it's magic.

# 5.1 Properties

# 5.1.1 Default `serverpackcreator.properties`

```properties
de.griefed.serverpackcreator.versioncheck.prerelease=false
de.griefed.serverpackcreator.language=en_us
de.griefed.serverpackcreator.configuration.fallbackmodslist=3dSkinLayers-,AdvancementPlaques-,AmbientSounds_,armorchroma-,backtools-,BetterAdvancements-,BetterAnimationsCollection-,BetterDarkMode-,BetterF3-,BetterF3-,BetterFoliage-,BetterPingDisplay-,BetterPlacement-,Blur-,catalogue-,cherishedworlds-,classicbar-,clickadv-,ClientTweaks_,configured-,Controlling-,CraftPresence-,CTM-,customdiscordrpc-,CustomMainMenu-,DefaultOptions_,defaultoptions-,desiredservers-,Ding-,drippyloadingscreen_,drippyloadingscreen-,Durability101-,dynamic-music-,DynamicSurroundings-,DynamicSurroundingsHuds-,dynmus-,EiraMoticons_,eiramoticons-,EnchantmentDescriptions-,EquipmentCompare-,extremesoundmuffler-,extremeSoundMuffler-,Fallingleaves-,fallingleaves-,fancymenu_,findme-,flickerfix-,FpsReducer-,FullscreenWindowed-,InventoryEssentials_,InventorySpam-,InventoryTweaks-,invtweaks-,ItemBorders-,itemzoom,itlt-,jeed-,jehc-,jeiintegration_,JEITweaker-,just-enough-harvestcraft-,justenoughbeacons-,JustEnoughCalculation-,JustEnoughProfessions-,JustEnoughProfessions-,JustEnoughResources-,keywizard-,konkrete_,lazydfu-,LegendaryTooltips-,light-overlay-,LightOverlay-,LLOverlayReloaded-,loadmyresources_,lootbeams-,mcbindtype-,medievalmusic-,modnametooltip_,modnametooltip-,moreoverlays-,MouseTweaks-,multihotbar-,MyServerIsCompatible-,Neat ,NotifMod-,OldJavaWarning-,OptiFine,OptiForge,ornaments-,overloadedarmorbar-,PackMenu-,PickUpNotifier-,Ping-,preciseblockplacing-,presencefootsteps-,PresenceFootsteps-,ReAuth-,ResourceLoader-,shutupexperimentalsettings-,SimpleDiscordRichPresence-,smoothboot-,sounddeviceoptions-,SpawnerFix-,spoticraft-,tconplanner-,timestamps-,Tips-,TipTheScales-,Toast Control-,Toast-Control-,ToastControl-,torchoptimizer-,torohealth-,toughnessbar-,TravelersTitles-,WindowedFullscreen-,WorldNameRandomizer-,yisthereautojump-
de.griefed.serverpackcreator.configuration.hastebinserver=https://haste.zneix.eu/documents
de.griefed.serverpackcreator.serverpack.autodiscoverenabled=true
de.griefed.serverpackcreator.gui.darkmode=true
de.griefed.serverpackcreator.configuration.directories.serverpacks=server-packs
de.griefed.serverpackcreator.curseforge.cleanup.enabled=true
de.griefed.serverpackcreator.serverpack.cleanup.enabled=true
de.griefed.serverpackcreator.serverpack.overwrite.enabled=true
de.griefed.serverpackcreator.configuration.directories.shouldexclude=overrides,packmenu,resourcepacks,server_pack,fancymenu
de.griefed.serverpackcreator.spring.cursecontroller.regenerate.enabled=false
de.griefed.serverpackcreator.spring.schedules.database.cleanup=0 0 0 * * *
de.griefed.serverpackcreator.spring.schedules.files.cleanup=0 0 0 * * *
de.griefed.serverpackcreator.spring.schedules.versions.refresh=0 0 0 * * *
de.griefed.serverpackcreator.spring.artemis.queue.max_disk_usage=90
de.griefed.serverpackcreator.configuration.saveloadedconfig=false
de.griefed.serverpackcreator.configuration.directories.mustinclude=mods,config,defaultconfigs,scripts,saves,seeds,libraries
de.griefed.serverpackcreator.curseforge.api.token=
```

| Property                                                              | Description                                                                                                                  |
|-----------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------|
| de.griefed.serverpackcreator.versioncheck.prerelease                  | `true` or `false`. Whether to check for available pre-releases, too, when checking for updates.                              |
| de.griefed.serverpackcreator.language                                 | The language in which ServerPackCreator should run.                                                                          |
| de.griefed.serverpackcreator.configuration.fallbackmodslist           | Comma separated fallback-list of clientside-only mods.                                                                       |
| de.griefed.serverpackcreator.configuration.hastebinserver             | Address of a HasteBin server to use for config and logs uploading.                                                           |
| de.griefed.serverpackcreator.serverpack.autodiscoverenabled           | `true` or `false`. Whether to try and determine sideness of mods in a modpack automatically.                                 |
| de.griefed.serverpackcreator.gui.darkmode                             | GUI-only. `true` or `false`. Whether to use dark-mode in the GUI.                                                            |
| de.griefed.serverpackcreator.configuration.directories.serverpacks    | The directory in which server packs will be generated and stored in.                                                         |
| de.griefed.serverpackcreator.curseforge.cleanup.enabled               | `true` or `false`. Whether to cleanup files after generating a server pack from a CurseForge project.                        |
| de.griefed.serverpackcreator.serverpack.cleanup.enabled               | `true` or `false`. Whether to cleanup files after generating a server pack.                                                  |
| de.griefed.serverpackcreator.serverpack.overwrite.enabled             | `true` or `false`. Whether an already existing server pack should be overwritten.                                            |
| de.griefed.serverpackcreator.configuration.directories.shouldexclude  | List of directories which should not be in a server pack.                                                                    |
| de.griefed.serverpackcreator.spring.cursecontroller.regenerate.enabled | `true` or `false`. Web only. Whether regeneration of an already available CurseForge project server pack is allowed/enabled. |
| de.griefed.serverpackcreator.spring.schedules.database.cleanup        | Web-only. Cron-schedule at which checks are run and server packs cleaned up.                                                 |
| de.griefed.serverpackcreator.spring.schedules.files.cleanup           | Web-only. Cron-schedule at which checks are run and files from server pack generations are cleaned up.                       |
| de.griefed.serverpackcreator.spring.schedules.versions.refresh        | Web-only. Cron-schedule at which the available Minecraft, Forge and Fabric versions are refreshed.                           |
| de.griefed.serverpackcreator.spring.artemis.queue.max_disk_usage      | Web-only. Maximum disk usage in percent at which no new tasks are accepted, preventing the generation of new server packs.   |
| de.griefed.serverpackcreator.configuration.saveloadedconfig           | GUI-only. `true` or `false`. Whether to overwrite the last manually loaded configuration file, too.                          |
| de.griefed.serverpackcreator.configuration.directories.mustinclude    | List of directories which must be included in a server pack.                                                                 |
| de.griefed.serverpackcreator.curseforge.api.token                     | CurseAPI token used for generating server packs from CurseForge projects.                                                    |

# 5.1.2 Default `application.properties` 

`application.properties`
```properties
server.port=8080
server.error.whitelabel.enabled=false
server.tomcat.basedir=.
server.tomcat.accesslog.enabled=true
server.tomcat.accesslog.directory=logs
server.tomcat.accesslog.file-date-format=_yyyy-MM-dd
server.tomcat.accesslog.prefix=tomcat_access
server.tomcat.accesslog.suffix=.log
server.tomcat.accesslog.pattern=common
spring.output.ansi.enabled=ALWAYS
server.error.include-message=ALWAYS
server.error.include-stacktrace=ALWAYS
spring.application.name=ServerPackCreator
spring.datasource.url=jdbc:sqlite:serverpackcreator.db
spring.datasource.driver-class-name=org.sqlite.JDBC
spring.jpa.hibernate.ddl-auto=update
spring.jpa.database-platform=org.sqlite.hibernate.dialect.SQLiteDialect
spring.jpa.open-in-view=false
spring.jdbc.template.query-timeout=3600
spring.transaction.default-timeout=3600
spring.artemis.mode=embedded
spring.artemis.embedded.persistent=true
spring.artemis.embedded.data-directory=work/artemis
spring.datasource.tomcat.max-active=50
spring.datasource.tomcat.max-idle=15
spring.datasource.tomcat.min-idle=8
spring.servlet.multipart.max-file-size=500MB
spring.servlet.multipart.max-request-size=500MB
spring.config.import=optional:file:./serverpackcreator.properties
```

If a property above has no description in the table below, it is not to be touched. Changing any of these can break ServerPackCreator or cause otherwise unwanted behaviour.
Changes to properties not described below are not supported. If you changed a property you were not meant to fiddle around with, do not report an issue. Such issues will be closed without further comment.

| Property | Description                                                                                            |
| -------- |--------------------------------------------------------------------------------------------------------|
| server.port | The port at which ServerPackCreator as a webservice will be available at.                              |
| spring.datasource.url | Path to and name of the SQLite database which the webservice will use.                                 |
| spring.artemis.embedded.data-directory | The path to and name of the directory in which Artemis will store queues and task related information. |
| spring.servlet.multipart.max-file-size | Maximum filesize for uploads.                                                                          |
| spring.servlet.multipart.max-request-size | Maximum request size for file uploads.                                                                 |
| spring.config.import | Additional properties-file to import properties from.                                                  |

---

# 6. Running

In every situation, the `.jar`-file needs to be run from the commandline. Executing it via "Open with..." and selecting Java will not work. To use the GUI, for example, simply run `java -jar ServerPackCreator-2.x.x.jar`.
The `.exe` can be executed as usual by simply double-clicking it and is GUI exclusive. It only works in Windows, though. Please keep that in mind.

## 6.1 Localization

If you wish to run ServerPackCreator with your locale (if it is already supported), you can either:
1. Run `java -jar ServerPackCreator-X.X.X.jar -lang your_locale` for example `java -jar ServerPackCreator-X.X.X.jar -lang en_us`. This will create the lang.properties-file with your specified locale.
2. Running `java -jar ServerPackCreator-x.x.x.jar` without `-lang en_us` or any other language will set the locale to en_us by default and create the lang.properties-file.
3. Modify the `serverpackcreator.properties`-file in the same directory as ServerPackCreator-X-X-X.jar and set your locale like this `lang=your_locale` for example `lang=en_us`

## 6.2 Using the GUI

You want to create a server pack for your modpack, right?

There are a couple of things you need to do in order to create a server pack for your modpack:

**1:** Find out whether any mod in your modpack is a clientside-only mod. Those are often mods which only add things to Minecraft which are of a graphical nature, like UI stuff. You need to know whether any mod in your modpack is a clientside-only mod, because having clientside-only mods in your server pack could crash your server unexpectedly.

**2:** Find the modloader, the modloader version and which Minecraft version your modpack is for.

**3:** Consider the folders in your modpack directory which you must inlcude in server pack in order for your server to work. Usually folders like `config` ,`mods` ,`scripts` and so on.

Those are the most important parts in making a server pack, I find.

If you're on Windows, go to <https://github.com/Griefed/ServerPackCreator/releases/latest> and download `serverpackcreator-X.X.X.exe` and place it somewhere you will remember. If you're on Linux or Mac, download the `serverpackcreator-X.X.X.jar`

The .exe can be started with a regular double click. The .jar needs to be started from the CLI with `java -jar serverpackcreator-X.X.X.jar`.

The first run of ServerPackCreator will create a couple of default files in the directory you started it in. If you plan on including any of these in your server pack, make sure you've customized them to your needs. They're in a directory called `server_files` in the same directory in which you executed `ServerPackCreator-X.X.X.jar` or `ServerPackCreator-X.X.X.exe` and will contain the following files which you can customize to your hearts content:

- `server.properties`

- `server-icon.png`

Once the ServerPackCreator window opened, you need to fill in all the information you gathered in the previously mentioned steps 1 to 3 into the designated textfields.
From top to bottom:

**Enter the path to your modpack directory:** You will also need to configure ServerPackCreator to point at the directory your modpack files are in. Click the folder icon on the right hand side to the first textfield, which will open your file explorer so you can browse to and select your modpack directory.

**Enter the list of clientside-only mods in your modpack:** Enter the list of clientside-only mods for your modpack into the second textfield.Every entry must be separated by a "," and NOT contain special characters such as [ \] ( ) \ / ;

**Enter the list of directories or files in your modpack to include in the server pack:** Enter the list of folders of your modpack which need to be included in your server pack. Every entry must be separated by a "," and NOT contain special characters such as [ \] ( ) \ / ;

**Enter the path to your Java executable/binary (optional):** If you are not sure where your java installation is located at, you can leave it blank and ServerPackCreator will try to determine said path by itself.

**Enter the Minecraft version your modpack uses:** Enter the Minecraft version your modpack runs in

**Enter the modloader your modpack uses:** Enter the modloader your modpack runs with. Must be either Forge or Fabric. Other modloaders are not supported.

**Enter the version of the modloader your modpack uses:** Enter the version of the modloader your modpack uses.

Last but not least, checkboxes:

**"Install modloader server in server pack?"** Does what it says on the tin. Whehter to install the Forge/Fabric server for the version you specified.

**"Include server-icon.png in server pack?"** Whether to include a custom server-icon.png in your server pack.

**"Include server.properties in server pack"** Whether to include a custom server.properties in your server pack.

**"Include start scripts in server pack?"** Whether to include custom start scripts for your server pack.

**"Create ZIP-archive of server pack?"** Whether ServerPackCreator should create a zipped archive of your server pack.

**Edit JVM flags** Open the dialog for editing of your JVM flags / Java Args via Menu->Edit->Edit Start-Scripts Java Args.

After you've customized and configured everything to your liking, click the button on the bottom. ServerPackCreator will check your configuration for errors and start generating your server pack should no errors be detected. When the server pack is finished, a prompt will open which will ask you whether you want to browse your newly created server pack in your file explorer.

That's pretty much it! Sounds like a lot, but honestly, all the stuff you need to do in order to configure ServerPackCreator you pretty much need to do anyway if you want to create a server pack.

Have fun!

## 6.3 Using the Command-line Interface

### 6.3.1 Windows

**1.** Download the latest version of ServerPackCreator from the Releases page: https://github.com/Griefed/ServerPackCreator/releases

**2.** Copy the .jar file to the partent directory of your modpack. Example:

![location](https://i.griefed.de/images/2021/03/03/run_windows1.png)

**3.** Open a command prompt by Shift-Right-Clicking into a free space of the explorer window, followed by a click on "Open command prompt here":

![command](https://i.griefed.de/images/2021/03/03/run_windows2.png)

**4.** Start the initial setup of ServerPackCreator by running it with the command: `java -jar ServerPackCreator-X.X.X.jar` (X.X.X corresponds to the version you downloaded. It will probably be different to the version used in these screenshots.)

This will generate the default files of ServerpackCreator and tell you to customize these files before running again. Example for the directory above:
```console
.
├── serverpackcreator.conf
├── serverpackcreator.properties
├── log4j2.xml
├── logs
│   ├── serverpackcreator.log
│   └── modloader_installer.log
├── server_files
│   ├── server-icon.png
│   ├── server.properties
└── ServerPackCreator.jar
```

With the example above, the settings would look exactly like they are already set in the serverpackcreator.conf (or creator.conf if using older version). Note that modpackDir points at a directory *relative* to the ServerPackCreator.jar. Absolute paths *should* be usable, but are currently untested.

Configure the config file to your liking. Double check the path to your Java installation if you intend on having SPC install the modloader-server.

For a detailed explanation of the configuration, check chapter 5. Configuration

**5.** After you double checked that you've set up your serverpackcreator.conf it is time to run ServerPackCreator again. Simply run `java -jar ServerPackCreator-X.X.X.jar` again (X.X.X corresponds to the version you downloaded. It will probably be different to the version used in these screenshots.)

**6.** ServerPackCreator should now start telling you what it is currently doing. Logging of these actions may be very verbose, depending on which part SPC is currently working on. Should you have configured your config file correctly and should I have released a bug-free version of SPC, it will run until the console says "Done!".  (Depending on the hardware you are running on, this may take some time.)

Included in one of the last messages by SPC is the location of your newly generated serverpack.

If you've set `includeZipCreation` to true, there will also be a zip-file called `server_pack.zip` in your modpack folder.

Please note: The zip file **does not** contain Mojang's minecraft-server.jar. Distributing Mojang's software is against their Terms of Service and End User License Agreement. The zip file *does* however, contain scripts for both Windows and Linux, to download the minecraft-server.jar for your serverpack. That means that Users who download your serverpack simply need to run either of those two scripts and it will download the needed file for their modded Minecraft server.

Enjoy!

Example after successfully running SPC:

```console
.
├── serverpackcreator.conf
├── serverpackcreator.properties
├── log4j2.xml
├── logs
│   ├── serverpackcreator.log
│   ├── addons.log
│   └── modloader_installer.log
├── server_files
│   ├── server-icon.png
│   └── server.properties
├── ServerPackCreator-1.1.0.jar
└── server-packs
    └── Survive Create Prosper 4
        └── ...
    └── Survive Create Prosper 4_server_pack.zip
```

### 6.3.2 Linux

**1.** Switch to a directory where you want ServerPackCreator to be stored in and where it can save and deploy all of its files.

**2.** Create and save the following script to download the latest version of ServerPackCreator:
```bash
#!/bin/bash
# Retrieve the latest version of ServerPackCreator

VERSION=$(curl --silent "https://api.github.com/repos/Griefed/ServerPackCreator/releases/latest" | grep '"tag_name":' | sed -E 's/.*"([^"]+)".*/\1/')

echo "Latest ServerPackCreator  version is: $VERSION"

echo ""

echo "Retrieving..."

curl -o ServerPackCreator-$VERSION.jar -L https://github.com/Griefed/ServerPackCreator/releases/download/$VERSION/serverpackcreator-$VERSION.jar

if [ -f ServerPackCreator-$VERSION.jar ]; then
  echo "Successfully retrieved ServerPackCreator version $VERSION"
else
  echo "Something seems to have gone wrong..."
  echo "ServerPackCreator-$VERSION could not be found..."
fi
```

Save it, `chmod +x` it, and run it.

This script will download the latest version of ServerPackCreator from GitHub and safe it to a file called ServerPackCreator-(version).jar.

**3.** Start the initial setup of ServerPackCreator by running it with the command: java -jar ServerPackCreator-X.X.X.jar (X.X.X corresponds to the version you downloaded.)

This will generate the default files of ServerpackCreator and tell you to customize these files before running again. Example:

```console
.
├── serverpackcreator.conf
├── serverpackcreator.properties
├── log4j2.xml
├── logs
│   ├── serverpackcreator.log
│   ├── addons.log
│   └── modloader_installer.log
├── server_files
│   ├── server-icon.png
│   └── server.properties
└── ServerPackCreator-X.X.X.jar
```

With the example above, the settings would look exactly like they are already set in the serverpackcreator.conf.

Configure the config file to your liking. Double check the path to your Java installation if you intend on having SPC install the modloader-server.

For a detailed explanation of the configuration, check chapter 5. Configuration.

**6.** After you double checked that you've set up your serverpackcreator.conf (or creator.conf if using older version) it is time to run ServerPackCreator again. Simply run `java -jar ServerPackCreator-X.X.X.jar` again (X.X.X corresponds to the version you downloaded. It will probably be different to the version used in these screenshots.)

**7.** ServerPackCreator should now start telling you what it is currently doing. Logging of these actions may be very verbose, depending on which part SPC is currently working on. Should you have configured your config file correctly and should I have released a bug-free version of SPC, it will run until the console says "Done!".  (Depending on the hardware you are running on, this may take some time.)

Included in one of the last messages by SPC is the location of your newly generated serverpack.

If you've set `includeZipCreation` to true, there will also be a zip-file called `server_pack.zip` in your modpack folder.

Please note: The zip file **does not** contain Mojang's minecraft-server.jar. Distributing Mojang's software is against their Terms of Service and End User License Agreement. The zip file *does* however, contain scripts for both Windows and Linux, to download the minecraft-server.jar for your serverpack. That means that Users who download your serverpack simply need to run either of those two scripts and it will download the needed file for their modded Minecraft server.

Enjoy!

Example after successfully running SPC:

```console
.
├── serverpackcreator.conf
├── serverpackcreator.properties
├── log4j2.xml
├── logs
│   ├── serverpackcreator.log
│   ├── addons.log
│   └── modloader_installer.log
├── server_files
│   ├── server-icon.png
│   └── server.properties
├── ServerPackCreator-1.1.0.jar
└── server-packs
    └── Survive Create Prosper 4
        └── ...
    └── Survive Create Prosper 4_server_pack.zip
```

### 6.3.3 Mac

(By user [whitebear60](https://github.com/whitebear60))

**1.** Download the latest version of ServerPackCreator from the Releases page: https://github.com/Griefed/ServerPackCreator/releases

**2.** Copy the .jar file to the partent directory of your modpack. Example:

![location](https://i.griefed.de/images/2021/03/05/3biap1.png)

**3.** Open Terminal using Spotlight, Launchpad or by running `Terminal.app` from `/Applications/Utilities` folder

**4.** Change the active directory to the one with ServerPackCreator jar and your modpacks.
![command](https://i.griefed.de/images/2021/03/05/3bi9y1.png)

**5.** Start the initial setup of ServerPackCreator by running it with the command: `java -jar ServerPackCreator-X.X.X.jar` (X.X.X corresponds to the version you downloaded. It will probably be different to the version used in these screenshots.)

This will generate the default files of ServerpackCreator and tell you to customize these files before running again. Example for the directory above:

```console
.
├── serverpackcreator.conf
├── serverpackcreator.properties
├── log4j2.xml
├── logs
│   ├── serverpackcreator.log
│   ├── addons.log
│   └── modloader_installer.log
├── server_files
│   ├── server-icon.png
│   └── server.properties
├── ServerPackCreator-1.1.0.jar
└── server-packs
    └── Survive Create Prosper 4
        └── ...
    └── Survive Create Prosper 4_server_pack.zip
```

With the example above, the settings would look exactly like they are already set in the serverpackcreator.conf. Note that modpackDir points at a directory *relative* to the ServerPackCreator.jar. Absolute paths *should* be usable, but are currently untested.

Configure the config file to your liking. Double check the path to your Java installation if you intend on having SPC install the modloader-server.

For a detailed explanation of the configuration, check chapter 5. Configuration

**6.** After you double checked that you've set up your serverpackcreator.conf (or creator.conf if using older version) it is time to run ServerPackCreator again. Simply run `java -jar ServerPackCreator-X.X.X.jar` again (X.X.X corresponds to the version you downloaded. It will probably be different to the version used in these screenshots.)

**7.** ServerPackCreator should now start telling you what it is currently doing. Logging of these actions may be very verbose, depending on which part SPC is currently working on. Should you have configured your config file correctly and should I have released a bug-free version of SPC, it will run until the console says "Done!".  (Depending on the hardware you are running on, this may take some time.)

Included in one of the last messages by SPC is the location of your newly generated serverpack.

If you've set `includeZipCreation` to true, there will also be a zip-file called `server_pack.zip` in your modpack folder.

Please note: The zip file **does not** contain Mojang's minecraft-server.jar. Distributing Mojang's software is against their Terms of Service and End User License Agreement. The zip file *does* however, contain scripts for both Windows and Linux, to download the minecraft-server.jar for your serverpack. That means that Users who download your serverpack simply need to run either of those two scripts and it will download the needed file for their modded Minecraft server.

Enjoy!

Example after successfully running SPC:

```console
.
├── serverpackcreator.conf
├── serverpackcreator.properties
├── log4j2.xml
├── logs
│   ├── serverpackcreator.log
│   ├── addons.log
│   └── modloader_installer.log
├── server_files
│   ├── server-icon.png
│   └── server.properties
├── ServerPackCreator-1.1.0.jar
└── server-packs
    └── Survive Create Prosper 4
        └── ...
    └── Survive Create Prosper 4_server_pack.zip
```

## 6.4 Docker

| Tags      | Description                                                                                   |
|-----------|-----------------------------------------------------------------------------------------------|
| `latest`  | Using the `latest` tag will pull the latest image for linux/amd64,linux/arm/v7,linux/arm64.   |
| `develop` | The latest image of, if existent, the in-dev version of this container. Use at your own risk! |

When running as a docker container, there are a couple more settings you need to be aware of:

| Variable                  | Description                                                                                                                                                                                                                                     |
|---------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| TZ                        | The timezone your system operates in. Default "Europe/Berlin"                                                                                                                                                                                   |
| PUID                      | The userID under which this container is run as. Important for file access and permissions. Run **cat /etc/passwd &#124; grep -i $(whoami)** to find your userID.                                                                               |
| PGID                      | The groupID under which this container is run as. Important for file access and permissions. Run **cat /etc/passwd &#124; grep -i $(whoami)** to find your groupID.                                                                             |
| STARTUP_PARAMETER         | Decides which mode ServerPackCreator will start in. `cli` for commandline interface, which will generate a server pack from the given config. `web` for starting ServerPackCreator as a webservice.                                             |                                                                                                                                                                               |

### 6.4.1 Using docker-compose:

```docker-compose.yml
version: "2"
services:
  serverpackcreator:
    image: griefed/serverpackcreator:latest
    container_name: serverpackcreator
    restart: unless-stopped
    environment:
      - STARTUP_PARAMETER=web
      - TZ=Europe/Berlin
      - PUID=1000
      - PGID=1000
    volumes:
      - /host/path/todata:/data # ServerPackCreator files like configuration files are here
    ports:
      - 8080:8080 # Port at which ServerPackCreator will be accessible at. Only needed when setting STARTUP_PARAMETER to web. 
```

---

# 7. Contributing

Java documentation available at:
- https://griefed.pages.griefed.de/ServerPackCreator/ or
- https://griefed.github.io/ServerPackCreator/ or
- https://griefed.gitlab.io/ServerPackCreator/

**Read [contributions](https://github.com/Griefed/ServerPackCreator/blob/main/CONTRIBUTING.md) before considering contributing to ServerPackCreator.**

A short excerpt:

> If you want to contribute to ServerPackCreator, then the following procedure **must** be adhered to:
>
> 1. Fork ServerPackCreator
> 2. Create a new branch in your fork, following one of the following naming schemes:
>     1. The end of each branch name bust be suffixed with a one-word description fitting the changes made. Examples:
>         - griefed_chore_readme
>         - griefed_perf_curseforgemodpack
>         - griefed_feat_ziparchive
>     2. For more details on what the naming scheme entails, see `.releaserc.yml` in the base directory of the repository or scroll down to the **Commits**-section.
>     3. Schemes:
>         1. your_username_breaking_
>         2. your_username_build_
>         3. your_username_chore_
>         4. your_username_ci_
>         5. your_username_docs_
>         6. your_username_feat_
>         7. your_username_fix_
>         8. your_username_perf_
>         9. your_username_refactor_
>         10. your_username_revert_
>         11. your_username_style_
>         12. your_username_test_
>         13. your_username_other_
> 3. Make your changes to your new branch:
>     1. Try to keep the changes atomic, so they best fit the name of the branch.
>     2. Follow conventional commit messages. See **Commits**-section for more details. Example:
>         - feat: Allow upload of modpack-export zip-archive to web-frontend
>         - refactor: Use apache commons-io for copying, instead of Files
> 4. Open an issue on the main repository, using the **Pull Request** template:
>     1. Issue title: Your Username - Branch type (e.g. feat) - Short description of your changes. Example:
>         - Griefed - feat - Allow upload of modpack-export zip-archive to web-frontend
>     2. Issue description: Fill in the sections the template provide.
>     3. Submit the new issue
> 5. I will then create a new branch in the main repository, with the same name as your branch, to which you will **then** create a pull request to.
> 6. If checks and tests pass, or any changes necessary have been made, the pull request is ready to be merged etc., I will merge it to your main repository branch.
> 7. I can then merge your main repository branch into main/master/whatever locally, push these changes to my GitLab instance, which will in turn push these changes to GitHub.
> 8. Done!
>
> This is the only way to ensure that any changes made to ServerPackCreator always arrive on my GitLab instance first, then on GitHub.
> Since I want to stay independent of GitHub and their architecture, I have to make use of my own GitLab installation. Hence this procedure. So, if one day, GitHub vanishes, we still can provide people with ServerPackCreator from my GitLab instance.


# 8. Building ServerPackCreator locally

Clone the webservice branch of the repository:

`git clone -b $BRANCH https://git.griefed.de/Griefed/ServerPackCreator.git`

Where `$BRANCH` represents the branch you want to clone.

If you are on linux, run `chmod +x gradlew` first.

Build with:

`about installQuasar cleanFrontend assembleFrontend copyDist build createExe --info --stacktrace`

Build without tests:

`about installQuasar cleanFrontend assembleFrontend copyDist build createExe --info --stacktrace -x test`

Build with custom version:

`about installQuasar cleanFrontend assembleFrontend copyDist build createExe -Pversion=6.6.6-alpha.666 --info --stacktrace`